/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.opensourcephysics.controls.ConsoleLevel;
import org.opensourcephysics.controls.OSPLog;

class ConsoleFormatter
extends SimpleFormatter {
    ConsoleFormatter() {
    }

    public String format(LogRecord logRecord) {
        String string = this.formatMessage(logRecord);
        if (logRecord.getLevel().intValue() == ConsoleLevel.OUT_CONSOLE.intValue() || logRecord.getLevel().intValue() == ConsoleLevel.ERR_CONSOLE.intValue()) {
            StringBuffer stringBuffer = new StringBuffer();
            if (string.length() > 0 && string.charAt(0) == '\t') {
                string = string.replaceFirst("\t", "    ");
            } else {
                stringBuffer.append("CONSOLE: ");
            }
            stringBuffer.append(string);
            stringBuffer.append(OSPLog.eol);
            if (logRecord.getThrown() != null) {
                try {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    logRecord.getThrown().printStackTrace(printWriter);
                    printWriter.close();
                    stringBuffer.append(stringWriter.toString());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return stringBuffer.toString();
        }
        return super.format(logRecord);
    }
}

