/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.displayejs.AbstractInteractiveElement;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.InteractionTargetElementPosition;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Object3D;

public class InteractiveImage
extends AbstractInteractiveElement {
    private double a1 = 0.0;
    private double b1 = 0.0;
    private double[] coordinates = new double[6];
    private double[] pixelOrigin = new double[5];
    private Object3D[] objects = new Object3D[]{new Object3D(this, 0)};
    private AffineTransform transform = new AffineTransform();
    private boolean trueSize = false;
    private Image currentImage = null;

    public void copyFrom(InteractiveElement interactiveElement) {
        super.copyFrom(interactiveElement);
        if (interactiveElement instanceof InteractiveImage) {
            this.setTrueSize(((InteractiveImage)interactiveElement).getTrueSize());
        }
    }

    public void setTrueSize(boolean bl) {
        this.trueSize = bl;
    }

    public boolean getTrueSize() {
        return this.trueSize;
    }

    public void needsToProject(DrawingPanel drawingPanel) {
        super.needsToProject(drawingPanel);
        if (this.style.displayObject != this.currentImage && this.style.displayObject instanceof Image) {
            this.currentImage = (Image)this.style.displayObject;
            Toolkit.getDefaultToolkit().prepareImage(this.currentImage, -1, -1, drawingPanel);
        }
        this.panelWithValidProjection = null;
    }

    public void setSensitivity(int n) {
        this.actualSensitivity = n;
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!this.visible) {
            return null;
        }
        if (this.hasChanged || drawingPanel != this.panelWithValidProjection) {
            this.projectPoints(drawingPanel);
        }
        if (this.positionEnabled) {
            if (this.actualSensitivity <= 0) {
                double d = this.pixelOrigin[0] - (double)n;
                double d2 = this.pixelOrigin[1] - (double)n2;
                if (this.style.angle != 0.0) {
                    double d3 = d * this.style.cosAngle - d2 * this.style.sinAngle;
                    d2 = d * this.style.sinAngle + d2 * this.style.cosAngle;
                    d = d3;
                }
                if (Math.abs(d) < this.pixelOrigin[2] / 2.0 && Math.abs(d2) < this.pixelOrigin[3] / 2.0) {
                    return new InteractionTargetElementPosition(this);
                }
            } else if (Math.abs(this.pixelOrigin[0] - (double)n) < (double)this.actualSensitivity && Math.abs(this.pixelOrigin[1] - (double)n2) < (double)this.actualSensitivity) {
                return new InteractionTargetElementPosition(this);
            }
        }
        return null;
    }

    public Object3D[] getObjects3D(DrawingPanel3D drawingPanel3D) {
        if (!this.visible) {
            return null;
        }
        if (this.hasChanged || drawingPanel3D != this.panelWithValidProjection) {
            this.projectPoints(drawingPanel3D);
        }
        return this.objects;
    }

    public void draw(DrawingPanel3D drawingPanel3D, Graphics2D graphics2D, int n) {
        this.drawIt(drawingPanel3D, graphics2D);
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.visible) {
            return;
        }
        this.projectPoints(drawingPanel);
        this.drawIt(drawingPanel, (Graphics2D)graphics);
    }

    protected void projectPoints(DrawingPanel drawingPanel) {
        if (this.group != null) {
            this.coordinates[0] = this.group.x + this.x * this.group.sizex;
            this.coordinates[1] = this.group.y + this.y * this.group.sizey;
            this.coordinates[2] = this.group.z + this.z * this.group.sizez;
            this.coordinates[3] = this.sizex * this.group.sizex;
            this.coordinates[4] = this.sizey * this.group.sizey;
            this.coordinates[5] = this.sizez * this.group.sizez;
        } else {
            this.coordinates[0] = this.x;
            this.coordinates[1] = this.y;
            this.coordinates[2] = this.z;
            this.coordinates[3] = this.sizex;
            this.coordinates[4] = this.sizey;
            this.coordinates[5] = this.sizez;
        }
        drawingPanel.project(this.coordinates, this.pixelOrigin);
        this.objects[0].distance = this.pixelOrigin[4];
        this.a1 = this.pixelOrigin[0];
        this.b1 = this.pixelOrigin[1];
        double d = this.pixelOrigin[2];
        double d2 = this.pixelOrigin[3];
        if (this.trueSize && this.style.displayObject instanceof Image) {
            d = ((Image)this.style.displayObject).getWidth(null);
            d2 = ((Image)this.style.displayObject).getHeight(null);
        }
        switch (this.style.position) {
            default: {
                this.a1 -= d / 2.0;
                this.b1 -= d2 / 2.0;
                break;
            }
            case 1: {
                this.a1 -= d / 2.0;
                break;
            }
            case 2: {
                this.a1 -= d / 2.0;
                this.b1 -= d2;
                break;
            }
            case 3: {
                this.a1 -= d;
                this.b1 -= d2 / 2.0;
                break;
            }
            case 7: {
                this.a1 -= d;
                this.b1 -= d2;
                break;
            }
            case 5: {
                this.a1 -= d;
                break;
            }
            case 4: {
                this.b1 -= d2 / 2.0;
                break;
            }
            case 8: {
                this.b1 -= d2;
            }
            case 6: 
        }
        this.hasChanged = false;
        this.panelWithValidProjection = drawingPanel;
    }

    private void drawIt(DrawingPanel drawingPanel, Graphics2D graphics2D) {
        if (!(this.style.displayObject instanceof Image)) {
            return;
        }
        AffineTransform affineTransform = graphics2D.getTransform();
        this.transform.setTransform(affineTransform);
        this.transform.rotate(-this.style.angle, this.pixelOrigin[0], this.pixelOrigin[1]);
        graphics2D.setTransform(this.transform);
        if (this.trueSize) {
            graphics2D.drawImage((Image)this.style.displayObject, (int)this.a1, (int)this.b1, null);
        } else {
            graphics2D.drawImage((Image)this.style.displayObject, (int)this.a1, (int)this.b1, (int)this.pixelOrigin[2], (int)this.pixelOrigin[3], null);
        }
        graphics2D.setTransform(affineTransform);
    }
}

