/*
 * Decompiled with CFR 0.152.
 */
package com.calerga.sysquake;

import com.calerga.sysquake.SQLinkConnectionException;
import com.calerga.sysquake.SQLinkInstanceIDException;
import com.calerga.sysquake.SQLinkUnsupportedDataTypeException;
import com.calerga.sysquake.SQLinkVariableException;
import com.calerga.sysquake.SQLinkVariableListener;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketTimeoutException;

public class SysquakeLink
implements Runnable {
    private static boolean initialized = false;
    private static int notificationPort = -1;
    private static VarListeners varListeners = null;
    private static volatile Thread varChangedThread = null;

    public SysquakeLink(String _dll) {
        if (!initialized && _dll != null) {
            try {
                System.load(_dll);
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
                System.err.println("ERROR: Could not load the SysquakeLink library. This error occures if");
                System.err.println("       Sysquake is not installed in the system.");
                System.err.println("       Or if SysquakeLink.dll (for Windows) in the right directory!");
            }
            initialized = true;
        }
    }

    public static native void connect() throws SQLinkConnectionException;

    public static native void disconnect();

    public static native boolean isConnected();

    public static native String version() throws SQLinkConnectionException, SQLinkInstanceIDException;

    public static native void execute(String var0) throws SQLinkConnectionException;

    public static native int open(String var0) throws SQLinkConnectionException;

    public static native void reload(int var0) throws SQLinkConnectionException, SQLinkInstanceIDException;

    public static native void maximize() throws SQLinkConnectionException;

    public static native void minimize() throws SQLinkConnectionException;

    public static native void restoreSize() throws SQLinkConnectionException;

    public static native void show() throws SQLinkConnectionException;

    public static native void quit() throws SQLinkConnectionException;

    public static native String[] variableNames(int var0) throws SQLinkConnectionException, SQLinkInstanceIDException;

    public static native Object variableValue(int var0, String var1) throws SQLinkConnectionException, SQLinkInstanceIDException, SQLinkUnsupportedDataTypeException, SQLinkVariableException;

    public static native Object variableValue(int var0, int var1) throws SQLinkConnectionException, SQLinkInstanceIDException, SQLinkUnsupportedDataTypeException, SQLinkVariableException;

    public static native Object[] variableValue(int var0, String[] var1) throws SQLinkConnectionException, SQLinkInstanceIDException, SQLinkUnsupportedDataTypeException, SQLinkVariableException;

    public static native Object[] variableValue(int var0, int[] var1) throws SQLinkConnectionException, SQLinkInstanceIDException, SQLinkUnsupportedDataTypeException, SQLinkVariableException;

    public static native void setVariableValue(int var0, String var1, Object var2) throws SQLinkConnectionException, SQLinkInstanceIDException, SQLinkVariableException;

    public static native void setVariableValue(int var0, int var1, Object var2) throws SQLinkConnectionException, SQLinkInstanceIDException, SQLinkVariableException;

    public static native void setVariableValue(int var0, String[] var1, Object[] var2) throws SQLinkConnectionException, SQLinkInstanceIDException, SQLinkVariableException;

    public static native void setVariableValue(int var0, int[] var1, Object[] var2) throws SQLinkConnectionException, SQLinkInstanceIDException, SQLinkVariableException;

    public static native void setVariableChangeNotification(int var0, String var1) throws SQLinkConnectionException, SQLinkInstanceIDException;

    public static native String[] lmeVariableNames() throws SQLinkConnectionException;

    public static native Object lmeVariableValue(String var0) throws SQLinkConnectionException, SQLinkUnsupportedDataTypeException, SQLinkVariableException;

    public static native Object lmeVariableValue(int var0) throws SQLinkConnectionException, SQLinkUnsupportedDataTypeException, SQLinkVariableException;

    public static native Object[] lmeVariableValue(String[] var0) throws SQLinkConnectionException, SQLinkUnsupportedDataTypeException, SQLinkVariableException;

    public static native Object[] lmeVariableValue(int[] var0) throws SQLinkConnectionException, SQLinkUnsupportedDataTypeException, SQLinkVariableException;

    public static void setVariableChangeNotification(int instanceId, SQLinkVariableListener vcl) throws SQLinkConnectionException, SQLinkInstanceIDException {
        if (varChangedThread == null) {
            varListeners = new VarListeners();
            varListeners.add(instanceId, vcl);
            varChangedThread = new Thread(new SysquakeLink(null));
            varChangedThread.start();
        }
        while (notificationPort < 0) {
            try {
                Thread.currentThread();
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
        SysquakeLink.setVariableChangeNotification(instanceId, "_fd_varChangedSQLinkNot=socketnew('localhost'," + notificationPort + ",socketset('Proto','udp'));" + "fprintf(_fd_varChangedSQLinkNot,'%d'," + instanceId + ");" + "fclose(_fd_varChangedSQLinkNot);");
    }

    public static void resetVariableChangeNotification(int instanceId) throws SQLinkConnectionException, SQLinkInstanceIDException {
        if (varListeners != null) {
            varListeners.remove(instanceId);
        }
        SysquakeLink.setVariableChangeNotification(instanceId, "");
        if (varListeners != null && varListeners.count() == 0) {
            Thread moribund = varChangedThread;
            varChangedThread = null;
            moribund.interrupt();
            varListeners = null;
        }
    }

    public void run() {
        try {
            DatagramSocket socket = new DatagramSocket();
            socket.setSoTimeout(100);
            notificationPort = socket.getLocalPort();
            byte[] buffer = new byte[256];
            while (varChangedThread != null) {
                int instanceId;
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                while (varChangedThread != null) {
                    try {
                        socket.receive(packet);
                        break;
                    }
                    catch (SocketTimeoutException socketTimeoutException) {}
                }
                if (varChangedThread == null) break;
                try {
                    String datagram = new String(packet.getData(), 0, packet.getLength(), "UTF-8");
                    instanceId = Integer.decode(datagram);
                }
                catch (Exception exception) {
                    instanceId = -1;
                }
                SQLinkVariableListener listener = varListeners.getListener(instanceId);
                if (listener == null) continue;
                listener.variableChange(instanceId);
            }
            socket.close();
            notificationPort = -1;
        }
        catch (Exception exception) {}
    }

    private static class VarListeners {
        private SQLinkVariableListener[] listeners = null;
        private int[] instanceId = null;
        private int n = 0;

        private VarListeners() {
        }

        public synchronized int count() {
            return this.n;
        }

        public synchronized void add(int id, SQLinkVariableListener listener) {
            if (this.instanceId == null) {
                this.listeners = new SQLinkVariableListener[16];
                this.instanceId = new int[16];
            } else if (this.n >= this.instanceId.length) {
                int count = this.instanceId.length;
                SQLinkVariableListener[] vtmp = new SQLinkVariableListener[count + 16];
                int i = 0;
                while (i < count) {
                    vtmp[i] = this.listeners[i];
                    ++i;
                }
                this.listeners = vtmp;
                int[] itmp = new int[count + 16];
                int i2 = 0;
                while (i2 < count) {
                    itmp[i2] = this.instanceId[i2];
                    ++i2;
                }
                this.instanceId = itmp;
            }
            this.instanceId[this.n] = id;
            this.listeners[this.n] = listener;
            ++this.n;
        }

        private int findById(int id) {
            if (this.instanceId == null) {
                return -1;
            }
            int i = 0;
            while (i < this.n) {
                if (this.instanceId[i] == id) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public synchronized void remove(int id) {
            int i;
            int j = i = this.findById(id);
            while (j + 1 < this.n) {
                this.instanceId[j] = this.instanceId[j + 1];
                this.listeners[j] = this.listeners[j + 1];
                ++j;
            }
            --this.n;
        }

        public synchronized SQLinkVariableListener getListener(int id) {
            int i = this.findById(id);
            return i >= 0 ? this.listeners[i] : null;
        }
    }
}

