/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.PrintWriter;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import org.colos.ejs.library.Input;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Memory;
import org.colos.ejs.library.Model;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.colos.ejs.library.external.ExternalAppsHandler;
import org.colos.ejs.library.external.ExternalClient;
import org.colos.ejs.library.utils.HardcopyWriter;

public abstract class AbstractModel
implements Model,
ExternalClient {
    protected String[] __theArguments = null;
    protected LauncherApplet __theApplet = null;
    protected ExternalAppsHandler _external = new ExternalAppsHandler(this);
    public Memory _memory = new Memory();
    protected Input _input = new Input();
    protected ArrayList _scheduledConditionsList = new ArrayList();
    protected Hashtable _scheduledEventsList = new Hashtable();
    private _ControlSimulationExperimentClass _cSE = new _ControlSimulationExperimentClass();

    public static void _printerJob(String title, String output, int fontSize) {
        AbstractModel._printerJob(title, output, fontSize, 0.5, 0.5, 0.5, 0.5);
    }

    public static void _printerJob(String title, String output, int fontSize, double top, double left, double bottom, double right) {
        Frame frame = new Frame("Printing " + title);
        frame.setSize(200, 50);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((d.width - frame.getSize().width) / 2, (d.height - frame.getSize().height) / 2);
        frame.setVisible(true);
        try {
            HardcopyWriter hw = new HardcopyWriter(frame, title, fontSize, left, right, top, bottom);
            PrintWriter out = new PrintWriter(hw);
            out.println(output);
            out.close();
        }
        catch (HardcopyWriter.PrintCanceledException printCanceledException) {}
        frame.setVisible(false);
        frame.dispose();
    }

    public abstract View getView();

    public abstract Simulation getSimulation();

    public LauncherApplet _getApplet() {
        return this.__theApplet;
    }

    public void _play() {
        this.getSimulation().play();
    }

    public void _playAndWait() {
        this._play();
        this._cSE._controlForSimulation();
    }

    public void _pause() {
        this.getSimulation().pause();
        this._cSE._controlForExperiment();
    }

    public void _step() {
        this._pause();
        this.getSimulation().step();
    }

    public void _setFPS(int _fps) {
        this.getSimulation().setFPS(_fps);
    }

    public void _setDelay(int _delay) {
        this.getSimulation().setDelay(_delay);
    }

    public int _getDelay() {
        if (this.getSimulation() != null) {
            return this.getSimulation().getDelay();
        }
        return 0;
    }

    public void _setStepsPerDisplay(int _steps) {
        this.getSimulation().setStepsPerDisplay(_steps);
    }

    public void _setUpdateView(boolean _update) {
        this.getSimulation().setUpdateView(_update);
    }

    public void _reset() {
        this._external.reset();
        this.getSimulation().reset();
    }

    public void _initialize() {
        this._external.reset();
        this.getSimulation().initialize();
    }

    public void _alert(String _panel, String _title, String _message) {
        if (this.getView() != null) {
            JOptionPane.showMessageDialog(this.getView().getComponent(_panel), _message, _title, 1);
        } else {
            JOptionPane.showMessageDialog(this.getSimulation().getParentComponent(), _message, _title, 1);
        }
    }

    public void _print(String _txt) {
        if (this.getView() != null) {
            this.getView().print(_txt);
        } else {
            System.out.print(_txt);
        }
    }

    public void _println(String _txt) {
        if (this.getView() != null) {
            this.getView().println(_txt);
        } else {
            System.out.print(_txt);
        }
    }

    public void _println() {
        if (this.getView() != null) {
            this.getView().println();
        } else {
            System.out.println();
        }
    }

    public void _clearMessages() {
        if (this.getView() != null) {
            this.getView().clearMessages();
        }
    }

    public String _format(double _value, String _pattern) {
        DecimalFormat _tmp_format = new DecimalFormat(_pattern);
        return _tmp_format.format(_value);
    }

    public String _getParameter(String _name) {
        if (this.__theApplet != null) {
            return this.__theApplet.getParameter(_name);
        }
        if (this.__theArguments == null) {
            return null;
        }
        int i = 0;
        while (i < this.__theArguments.length) {
            if (this.__theArguments[i].equals("-" + _name) && i + 1 < this.__theArguments.length) {
                return this.__theArguments[i + 1];
            }
            ++i;
        }
        return null;
    }

    public String[] _getArguments() {
        return this.__theArguments;
    }

    public boolean _isPlaying() {
        return this.getSimulation().isPlaying();
    }

    public boolean _isPaused() {
        return this.getSimulation().isPaused();
    }

    public boolean _isApplet() {
        return this.__theApplet != null;
    }

    public void _setParentComponent(String _parent) {
        this.getSimulation().setParentComponent(_parent);
    }

    public boolean _saveImage(String _filename, String _element) {
        return this.getSimulation().saveImage(_filename, _element);
    }

    public boolean _saveState(String _filename) {
        return this.getSimulation().saveState(_filename);
    }

    public boolean _saveVariables(String _filename, String _varList) {
        return this.getSimulation().saveVariables(_filename, _varList);
    }

    public boolean _saveVariables(String _filename, ArrayList _varList) {
        return this.getSimulation().saveVariables(_filename, _varList);
    }

    public boolean _saveText(String _filename, String _text) {
        return this.getSimulation().saveText(_filename, _text);
    }

    public boolean _saveText(String _filename, StringBuffer _text) {
        return this.getSimulation().saveText(_filename, _text);
    }

    public boolean _readState(String _filename) {
        return this.getSimulation().readState(_filename);
    }

    public boolean _readVariables(String _filename, String _varList) {
        return this.getSimulation().readVariables(_filename, null, _varList);
    }

    public boolean _readVariables(String _filename, ArrayList _varList) {
        URL codebase = null;
        if (this.__theApplet != null) {
            codebase = this.__theApplet.getCodeBase();
        }
        return this.getSimulation().readVariables(_filename, codebase, _varList);
    }

    public String _readText(String _filename) {
        return this.getSimulation().readText(_filename);
    }

    public boolean _setVariables(String _command, String _delim, String _arrayDelim) {
        return this.getSimulation().setVariables(_command, _delim, _arrayDelim);
    }

    public boolean _setVariables(String _command) {
        return this.getSimulation().setVariables(_command);
    }

    public String _getVariables(String _varName) {
        return this.getSimulation().getVariable(_varName);
    }

    public void _clearView() {
        if (this.getView() != null) {
            this.getView().initialize();
        }
    }

    public void _resetView() {
        if (this.getView() != null) {
            this.getView().reset();
            this.getView().initialize();
        }
    }

    public void _onExit() {
        this.getSimulation().onExit();
        this._external.quit();
    }

    public abstract void _resetSolvers();

    public void _resetIC() {
        this._resetSolvers();
    }

    public abstract String _externalInitCommand(String var1);

    public abstract void _externalSetValues(boolean var1, ExternalApp var2);

    public abstract void _externalGetValues(boolean var1, ExternalApp var2);

    public synchronized void _externalGetValuesAndUpdate(boolean _any, ExternalApp _application) {
        this._externalGetValues(_any, _application);
        this.getSimulation().update();
    }

    private class _ControlSimulationExperimentClass {
        private _ControlSimulationExperimentClass() {
        }

        public synchronized void _controlForSimulation() {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }

        public synchronized void _controlForExperiment() {
            this.notify();
        }
    }
}

