/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Timer;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Model;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;

public abstract class Animation
implements Runnable {
    public static int MAXIMUM_FPS = 25;
    public static final int MINIMUM_FPS = 1;
    public static final int MINIMUM_DELAY = 10;
    private volatile Thread animationThread = null;
    private volatile boolean loopEnabled = true;
    private boolean autoplay = false;
    protected boolean isPlaying = false;
    protected boolean updateView = true;
    private int stepsPerDisplay = 1;
    private long delay = 10L;
    protected String resetFile = null;
    protected Model model = null;
    protected View view = null;
    protected Animation master = null;
    protected ArrayList<Model> slaveList = new ArrayList();

    public final Model getModel() {
        return this.model;
    }

    public final void setModel(Model _aModel) {
        this.model = _aModel;
        LauncherApplet applet = this.model._getApplet();
        if (applet != null && applet.getParameter("_initialState") != null) {
            this.resetFile = applet.getParameter("_initialState");
        }
    }

    public final View getView() {
        return this.view;
    }

    public final void setView(View _aView) {
        this.view = _aView;
    }

    public final void setFPS(int _fps) {
        this.delay = _fps <= 1 ? 1000L : (_fps >= MAXIMUM_FPS ? 10L : Math.max((long)(1000.0 / (double)_fps), 10L));
    }

    public final void setDelay(int _aDelay) {
        this.delay = Math.max((long)_aDelay, 0L);
    }

    public final int getDelay() {
        return (int)this.delay;
    }

    public final void setStepsPerDisplay(int _steps) {
        if (_steps >= 1) {
            this.stepsPerDisplay = _steps;
        }
    }

    public final void setUpdateView(boolean _update) {
        this.updateView = _update;
    }

    public final void setAutoplay(boolean _play) {
        this.autoplay = _play;
    }

    public final boolean isPlaying() {
        return this.isPlaying && this.animationThread != null;
    }

    public final boolean isPaused() {
        return !this.isPlaying();
    }

    public void disableLoop() {
        this.loopEnabled = false;
        if (Thread.currentThread() == this.animationThread) {
            return;
        }
        try {
            this.animationThread.interrupt();
            this.animationThread.join(100L);
        }
        catch (Exception exception) {}
    }

    public void enableLoop() {
        this.loopEnabled = true;
    }

    public synchronized void play() {
        if (this.master != null) {
            this.getTopMaster().play();
            return;
        }
        if (this.animationThread != null) {
            return;
        }
        this.animationThread = new Thread(this);
        this.animationThread.setPriority(1);
        this.animationThread.setDaemon(true);
        this.animationThread.start();
        this.isPlaying = true;
        for (Model slave : this.slaveList) {
            slave.getSimulation().isPlaying = true;
        }
    }

    public synchronized void pause() {
        if (this.master != null) {
            this.getTopMaster().pause();
            return;
        }
        if (this.animationThread == null) {
            return;
        }
        Thread tempThread = this.animationThread;
        this.animationThread = null;
        this.isPlaying = false;
        for (Model slave : this.slaveList) {
            slave.getSimulation().isPlaying = false;
        }
        if (Thread.currentThread() == tempThread) {
            return;
        }
        try {
            tempThread.interrupt();
            tempThread.join(100L);
        }
        catch (Exception exception) {}
    }

    public void run() {
        long sleepTime = this.delay;
        while (this.animationThread == Thread.currentThread()) {
            long currentTime = System.currentTimeMillis();
            if (this.loopEnabled) {
                this.step();
                for (Model slave : this.slaveList) {
                    slave.getSimulation().step();
                }
            }
            if ((sleepTime = this.delay - (System.currentTimeMillis() - currentTime)) < 10L) {
                Thread.yield();
                continue;
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void onExit() {
        this.animationThread = null;
        this.isPlaying = false;
        Timer timer = new Timer(500, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Animation.this.view.onExit();
                Animation.this.model._freeMemory();
                System.gc();
            }
        });
        timer.setRepeats(false);
        timer.setCoalesce(true);
        timer.start();
    }

    protected abstract void userDefinedReset();

    protected abstract void userDefinedViewUpdate();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void reset() {
        this.pause();
        if (this.model != null) {
            this.model.reset();
        }
        if (this.view != null) {
            this.view.setUpdateSimulation(false);
            this.view.reset();
            this.view.initialize();
        }
        if (this.model != null) {
            this.model.initialize();
            this.model.update();
            this.userDefinedReset();
        }
        if (this.view != null) {
            if (this.updateView) {
                this.view.update();
                this.userDefinedViewUpdate();
            } else {
                this.view.collectData();
            }
            this.view.setUpdateSimulation(true);
        }
        System.gc();
        ArrayList<Model> arrayList = this.slaveList;
        synchronized (arrayList) {
            this.killAllSimulations();
        }
        if (this.autoplay) {
            this.play();
        }
    }

    public final void initialize() {
        if (this.view != null) {
            this.view.read();
        }
        if (this.model != null) {
            this.model.initialize();
            this.model.update();
        }
        if (this.view != null) {
            this.view.initialize();
            if (this.updateView) {
                this.view.update();
                this.userDefinedViewUpdate();
            } else {
                this.view.collectData();
            }
        }
    }

    public final void apply() {
        if (this.view != null) {
            this.view.read();
        }
        this.update();
    }

    public final void applyAll() {
        this.view.read();
        this.update();
    }

    public final void apply(String _variable) {
        if (this.view != null) {
            this.view.read(_variable);
        }
    }

    public final void update() {
        if (this.model != null) {
            this.model.update();
        }
        if (this.view != null) {
            if (this.updateView) {
                this.view.update();
            } else {
                this.view.collectData();
            }
        }
    }

    public final void step() {
        if (this.stepsPerDisplay > 1) {
            int i = 1;
            while (i < this.stepsPerDisplay) {
                this.model.step();
                this.model.update();
                this.view.collectData();
                ++i;
            }
        }
        this.model.step();
        this.update();
        if (this.updateView) {
            this.userDefinedViewUpdate();
        }
    }

    public final void updateAfterModelAction() {
        if (this.master != null) {
            this.getTopMaster().updateAfterModelAction();
            return;
        }
        this.update();
        for (Model slave : this.slaveList) {
            slave.getSimulation().update();
        }
        this.loopEnabled = true;
    }

    public final Model runSimulation() {
        return this.runSimulation(null);
    }

    public final Model runSimulation(String _classname) {
        try {
            Animation top;
            Class<?> theClass = _classname == null ? this.getModel().getClass() : Class.forName(_classname);
            Model simModel = (Model)theClass.newInstance();
            simModel.getSimulation().master = top = this.getTopMaster();
            simModel.getSimulation().isPlaying = this.isPlaying;
            simModel.getSimulation().update();
            top.slaveList.add(simModel);
            return simModel;
        }
        catch (Exception _exc) {
            _exc.printStackTrace();
            return null;
        }
    }

    public final void freeSimulation(Model _simulationModel) {
        if (_simulationModel == null) {
            return;
        }
        try {
            Animation top = this.getTopMaster();
            top.slaveList.remove(_simulationModel);
            _simulationModel.getSimulation().master = null;
            if (_simulationModel.getView() instanceof EjsControl) {
                ((EjsControl)((Object)_simulationModel.getView())).undoReparenting();
            }
            if (top.isPlaying) {
                _simulationModel.getSimulation().play();
            } else {
                _simulationModel.getSimulation().isPlaying = false;
            }
            _simulationModel.getSimulation().update();
        }
        catch (Exception _exc) {
            _exc.printStackTrace();
        }
    }

    public final void killSimulation(Model _simulationModel) {
        if (_simulationModel == null) {
            return;
        }
        this.freeSimulation(_simulationModel);
        _simulationModel.getSimulation().pause();
        if (_simulationModel.getView() instanceof EjsControl) {
            ((EjsControl)((Object)_simulationModel.getView())).dispose();
        }
    }

    public final synchronized void killAllSimulations() {
        ArrayList<Model> list = this.slaveList;
        this.slaveList = new ArrayList();
        for (Model simModel : list) {
            simModel.getSimulation().pause();
            simModel.getSimulation().master = null;
            if (!(simModel.getView() instanceof EjsControl)) continue;
            ((EjsControl)((Object)simModel.getView())).undoReparenting();
            ((EjsControl)((Object)simModel.getView())).dispose();
        }
    }

    public final Model getTopSimulation() {
        return this.getTopMaster().getModel();
    }

    private final Animation getTopMaster() {
        if (this.master == null) {
            return this;
        }
        Animation topMaster = this.master;
        while (topMaster.master != null) {
            topMaster = topMaster.master;
        }
        return topMaster;
    }
}

