/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library;

import ch.epfl.cockpit.communication.DatasFile;
import ch.epfl.cockpit.communication.GraphicsFile;
import ch.epfl.cockpit.communication.HashTableMessage;
import ch.epfl.cockpit.communication.Message;
import ch.epfl.cockpit.communication.ParamsFileXML;
import ch.epfl.cockpit.communication.Request;
import ch.epfl.cockpit.communication.ServletMessenger;
import ch.epfl.cockpit.communication.TextFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.colos.ejs.library.Simulation;

public class EmersionLink {
    private URL eMersionURL = null;
    private String eMersionSessionID = null;
    private Component parentComponent = null;
    private Simulation simulation = null;
    private SavePanel savePanel = new SavePanel();
    private ReadPanel readPanel = new ReadPanel();

    public EmersionLink(JApplet _applet, Simulation _simulation) {
        this.simulation = _simulation;
        String urlStr = _applet.getParameter("eMersionURL");
        try {
            this.eMersionURL = new URL(urlStr);
            this.eMersionSessionID = _applet.getParameter("eMersionSessionID");
        }
        catch (MalformedURLException malformedURLException) {
            if (urlStr != null) {
                System.out.println("Malformed URL exception for URL = <" + urlStr + ">");
            }
            this.eMersionURL = null;
            this.eMersionSessionID = null;
        }
    }

    public boolean isConnected() {
        return this.eMersionURL != null && this.eMersionSessionID != null;
    }

    public void setParentComponent(Component _component) {
        this.parentComponent = _component;
    }

    public void setNameLabel(String _label) {
        this.savePanel.nameLabel.setText(_label);
    }

    public void setAnnotationLabel(String _label) {
        this.savePanel.annotationLabel.setText(_label);
    }

    public String saveBinary(String _filename, String _annotation, byte[] _data) {
        if (!this.isConnected()) {
            return null;
        }
        if (!this.savePanel.showSaveOptions(_filename, _annotation)) {
            return null;
        }
        _filename = this.savePanel.nameField.getText().trim();
        if (_filename.length() <= 0) {
            return null;
        }
        _annotation = this.savePanel.annotationField.getText();
        try {
            ServletMessenger messenger = new ServletMessenger(this.eMersionURL);
            DatasFile df = new DatasFile(this.eMersionSessionID, _filename, _annotation, _data);
            messenger.send(df);
        }
        catch (Exception e) {
            this.showException(e);
            return null;
        }
        return _filename;
    }

    public String saveImage(String _filename, String _annotation, Image _image) {
        if (!this.isConnected()) {
            return null;
        }
        if (!_filename.toLowerCase().endsWith(".gif")) {
            _filename = String.valueOf(_filename) + ".gif";
        }
        if (!this.savePanel.showSaveOptions(_filename, _annotation)) {
            return null;
        }
        _filename = this.savePanel.nameField.getText().trim();
        if (_filename.length() <= 0) {
            return null;
        }
        _annotation = this.savePanel.annotationField.getText();
        if (_filename.toLowerCase().endsWith(".gif")) {
            _filename = _filename.substring(0, _filename.length() - 4);
        }
        try {
            ServletMessenger messenger = new ServletMessenger(this.eMersionURL);
            GraphicsFile im = new GraphicsFile(this.eMersionSessionID, _filename, _image);
            im.setAnnotation(_annotation);
            messenger.send(im);
        }
        catch (Exception e) {
            this.showException(e);
            return null;
        }
        return _filename;
    }

    public String saveText(String _filename, String _annotation, String _text) {
        if (!this.isConnected()) {
            return null;
        }
        if (!this.savePanel.showSaveOptions(_filename, _annotation)) {
            return null;
        }
        _filename = this.savePanel.nameField.getText().trim();
        if (_filename.length() <= 0) {
            return null;
        }
        _annotation = this.savePanel.annotationField.getText();
        try {
            ServletMessenger messenger = new ServletMessenger(this.eMersionURL);
            TextFile file = new TextFile(this.eMersionSessionID, _filename, _annotation, _text);
            messenger.send(file);
        }
        catch (Exception e) {
            this.showException(e);
            return null;
        }
        return _filename;
    }

    public String saveXML(String _filename, String _annotation, String _xml) {
        if (!this.isConnected()) {
            return null;
        }
        if (!this.savePanel.showSaveOptions(_filename, _annotation)) {
            return null;
        }
        _filename = this.savePanel.nameField.getText().trim();
        if (_filename.length() <= 0) {
            return null;
        }
        _annotation = this.savePanel.annotationField.getText();
        try {
            ServletMessenger messenger = new ServletMessenger(this.eMersionURL);
            ParamsFileXML file = new ParamsFileXML(this.eMersionSessionID, _filename, _annotation, _xml);
            messenger.send(file);
        }
        catch (Exception e) {
            this.showException(e);
            return null;
        }
        return _filename;
    }

    public byte[] readBinary(String _ext) {
        if (!this.isConnected()) {
            return null;
        }
        String fragID = this.readPanel.chooseFragment("type_binary_set");
        if (fragID == null) {
            return null;
        }
        ServletMessenger messenger = new ServletMessenger(this.eMersionURL);
        Request request = new Request(this.eMersionSessionID, "fragment", "type_binary_set");
        request.setFragID(fragID);
        try {
            messenger.send(request);
            Message feedback = (Message)messenger.getFeedback();
            System.out.println("Response:" + feedback.toString());
            System.out.println("Response feedback:" + feedback.getStatus());
            DatasFile file = (DatasFile)feedback;
            return file.getContent();
        }
        catch (Exception e) {
            this.showException(e);
            return null;
        }
    }

    public String readText(String _filename) {
        if (!this.isConnected()) {
            return null;
        }
        String fragID = this.readPanel.chooseFragment("type_text_set");
        if (fragID == null) {
            return null;
        }
        ServletMessenger messenger = new ServletMessenger(this.eMersionURL);
        Request request = new Request(this.eMersionSessionID, "fragment", "type_text_set");
        request.setFragID(fragID);
        try {
            messenger.send(request);
            Message feedback = (Message)messenger.getFeedback();
            System.out.println("Response:" + feedback.toString());
            System.out.println("Response feedback:" + feedback.getStatus());
            TextFile file = (TextFile)feedback;
            String text = file.getText();
            return text;
        }
        catch (Exception e) {
            this.showException(e);
            return null;
        }
    }

    public String readXML(String _filename) {
        if (!this.isConnected()) {
            return null;
        }
        String fragID = this.readPanel.chooseFragment("type_params_set");
        if (fragID == null) {
            return null;
        }
        ServletMessenger messenger = new ServletMessenger(this.eMersionURL);
        Request request = new Request(this.eMersionSessionID, "fragment", "type_params_set");
        request.setFragID(fragID);
        try {
            messenger.send(request);
            Message feedback = (Message)messenger.getFeedback();
            System.out.println("Response:" + feedback.toString());
            System.out.println("Response feedback:" + feedback.getStatus());
            ParamsFileXML xmlFile = (ParamsFileXML)feedback;
            String text = xmlFile.getParamsXML();
            return text;
        }
        catch (Exception e) {
            this.showException(e);
            return null;
        }
    }

    public Image readImage(String _ext) {
        if (!this.isConnected()) {
            return null;
        }
        String fragId = this.readPanel.chooseFragment("type_binary_set");
        System.out.println("File for reading image from eMersion is " + fragId);
        return null;
    }

    private Component getParentComponent() {
        if (this.simulation != null) {
            return this.simulation.getParentComponent();
        }
        return this.parentComponent;
    }

    private void showException(Exception _exc) {
        _exc.printStackTrace();
        System.out.println("A dialog should appear now");
        JOptionPane.showMessageDialog(this.getParentComponent(), _exc.getLocalizedMessage());
    }

    private String chooseFragment(String _type) {
        Enumeration en;
        Hashtable fragList;
        block5: {
            ServletMessenger messenger = new ServletMessenger(this.eMersionURL);
            Request request = new Request(this.eMersionSessionID, "list", _type, true);
            messenger.send(request);
            Message feedback = (Message)messenger.getFeedback();
            HashTableMessage hashtable = (HashTableMessage)feedback;
            fragList = hashtable.getContent();
            en = fragList.keys();
            if (fragList.size() != 0) break block5;
            JOptionPane.showMessageDialog(this.getParentComponent(), "No fragments available of type:" + _type, "Emersion", 0);
            return null;
        }
        try {
            Object[] files = new Object[fragList.size()];
            int i = 0;
            while (en.hasMoreElements()) {
                files[i] = en.nextElement().toString();
                ++i;
            }
            Object selected = JOptionPane.showInputDialog(this.getParentComponent(), "Choose one", "Input", 1, null, files, files[0]);
            if (selected != null) {
                return (String)fragList.get(selected);
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return null;
    }

    private class ReadPanel
    extends JPanel {
        JLabel nameLabel;
        JLabel annotationLabel;
        JTextField nameField;
        JTextField annotationField;
        DefaultListModel listModel = new DefaultListModel();
        JList list = new JList(this.listModel);

        ReadPanel() {
            this.list.setSelectionMode(0);
            JScrollPane scrollPanel = new JScrollPane(this.list);
            this.setLayout(new BorderLayout());
            this.add((Component)scrollPanel, "Center");
        }

        String chooseFragment(String _type) {
            ServletMessenger messenger = new ServletMessenger(EmersionLink.this.eMersionURL);
            Request request = new Request(EmersionLink.this.eMersionSessionID, "list", _type, true);
            try {
                int option;
                messenger.send(request);
                Message feedback = (Message)messenger.getFeedback();
                HashTableMessage hashtable = (HashTableMessage)feedback;
                Hashtable fragList = hashtable.getContent();
                this.listModel.removeAllElements();
                Enumeration en = fragList.keys();
                while (en.hasMoreElements()) {
                    this.listModel.addElement(en.nextElement());
                }
                if (fragList.size() > 0) {
                    this.list.setSelectedIndex(0);
                }
                if ((option = JOptionPane.showConfirmDialog(EmersionLink.this.getParentComponent(), this, "eMersion", 2)) == 0) {
                    return (String)fragList.get(this.list.getSelectedValue());
                }
            }
            catch (Exception exc) {
                EmersionLink.this.showException(exc);
            }
            return null;
        }
    }

    private class SavePanel
    extends JPanel {
        JLabel nameLabel = new JLabel("Name");
        JLabel annotationLabel;
        JTextField nameField;
        JTextField annotationField;

        SavePanel() {
            this.nameLabel.setHorizontalAlignment(0);
            this.nameLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
            this.nameField = new JTextField();
            this.nameField.setColumns(10);
            this.annotationLabel = new JLabel("Annotation");
            this.annotationLabel.setHorizontalAlignment(0);
            this.annotationLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
            this.annotationField = new JTextField();
            this.annotationField.setColumns(10);
            JPanel leftPanel = new JPanel(new GridLayout(0, 1));
            leftPanel.add(this.nameLabel);
            leftPanel.add(this.annotationLabel);
            JPanel rightPanel = new JPanel(new GridLayout(0, 1));
            rightPanel.add(this.nameField);
            rightPanel.add(this.annotationField);
            this.setLayout(new BorderLayout());
            this.add((Component)leftPanel, "West");
            this.add((Component)rightPanel, "Center");
        }

        boolean showSaveOptions(String _name, String _ann) {
            int option;
            if (_name != null) {
                this.nameField.setText(_name);
            }
            if (_ann != null) {
                this.annotationField.setText(_ann);
            }
            return (option = JOptionPane.showConfirmDialog(EmersionLink.this.getParentComponent(), this, "eMersion", 2)) == 0;
        }
    }
}

