/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.colos.ejs.library.Memory;

public class Input
extends Memory {
    public static final int CONFIRM = 0;
    public static final int YES_NO = 1;
    public static final int YES_NO_CANCEL = 2;
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int CANCEL = 2;
    public static final int CLOSED = -1;
    public static final int OK = 0;
    private boolean ok = true;

    public boolean inputVariables(String message, String variables) {
        String[] varListArray = variables.split(",");
        int varNumber = varListArray.length;
        Object[] _headerTitle = new String[]{Input.getResource("Experiment.InputDialog.Variable"), Input.getResource("Experiment.InputDialog.Value")};
        Object[][] _dataTable = new Object[varNumber][2];
        int i = 0;
        while (i < varNumber) {
            _dataTable[i][0] = varListArray[i];
            _dataTable[i][1] = this.hashTable.get(varListArray[i]);
            ++i;
        }
        JTable inputTable = new JTable(_dataTable, _headerTitle);
        inputTable.setPreferredScrollableViewportSize(new Dimension(400, 16 * varNumber));
        inputTable.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        JScrollPane scrollPane = new JScrollPane(inputTable);
        final JDialog inputDialog = new JDialog(null, message, true);
        JButton okButton = new JButton(Input.getResource("Ok"));
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Input.this.ok = true;
                inputDialog.setVisible(false);
            }
        });
        JButton cancelButton = new JButton(Input.getResource("Cancel"));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Input.this.ok = false;
                inputDialog.setVisible(false);
            }
        });
        JPanel buttonsPanel = new JPanel(new FlowLayout(1));
        buttonsPanel.add(okButton);
        buttonsPanel.add(cancelButton);
        inputDialog.getContentPane().add((Component)scrollPane, "North");
        inputDialog.getContentPane().add((Component)buttonsPanel, "Center");
        inputDialog.pack();
        this.ok = false;
        inputDialog.setVisible(true);
        if (this.ok) {
            int i2 = 0;
            while (i2 < inputTable.getRowCount()) {
                Object value = inputTable.getValueAt(i2, 1);
                if (value != null) {
                    this.readInput((String)inputTable.getValueAt(i2, 0), value.toString());
                }
                ++i2;
            }
        }
        inputDialog.dispose();
        return this.ok;
    }

    public void readInput(String variable, String value) {
        if (value.equals("true")) {
            this.setValue(variable, true);
            return;
        }
        if (value.equals("false")) {
            this.setValue(variable, false);
            return;
        }
        try {
            Integer test = new Integer(value);
            this.setValue(variable, test);
            return;
        }
        catch (Exception exception) {
            try {
                Double test = new Double(value);
                this.setValue(variable, test);
                return;
            }
            catch (Exception exception2) {
                this.setValue(variable, value);
                return;
            }
        }
    }

    public int confirmMessage(String message, int type) {
        switch (type) {
            case 1: {
                return JOptionPane.showConfirmDialog(null, message, Input.getResource("Experiment.Title"), 0);
            }
            case 2: {
                return JOptionPane.showConfirmDialog(null, message, Input.getResource("Experiment.Title"), 1);
            }
        }
        JOptionPane.showMessageDialog(null, message, Input.getResource("Experiment.Title"), 1);
        return 0;
    }

    public int selectOption(String message, String options) {
        Object[] optionListArray = options.split(",");
        String selectedValue = (String)JOptionPane.showInputDialog(null, message, Input.getResource("Experiment.Title"), 1, null, optionListArray, optionListArray[0]);
        int i = 0;
        i = 0;
        while (i < optionListArray.length) {
            if (((String)optionListArray[i]).equals(selectedValue)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

