/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileSystemView;
import org.colos.ejs.library.Animation;
import org.colos.ejs.library.EmersionLink;
import org.colos.ejs.library.Experiment;
import org.colos.ejs.library.Input;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.MethodWithOneParameter;
import org.colos.ejs.library.control.SpecialRender;
import org.colos.ejs.library.utils.GIFEncoder;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.PrintUtils;
import org.opensourcephysics.display.dialogs.DialogsRes;
import org.opensourcephysics.media.core.VideoGrabber;
import org.opensourcephysics.tools.EjsTool;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.SnapshotTool;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.TranslatorTool;
import org.opensourcephysics.tools.VideoCaptureTool;

public abstract class Simulation
extends Animation {
    static ResourceBundle launcherRes = ResourceBundle.getBundle("org.opensourcephysics.resources.tools.launcher", Locale.getDefault());
    static ResourceBundle ejsRes = ResourceBundle.getBundle("org.opensourcephysics.resources.ejs.ejs_res", Locale.getDefault());
    private static String pathToLibrary = "";
    private static AWTEventListener focusListener = null;
    private static ArrayList resourcesExtracted = new ArrayList();
    private static String homeDir = null;
    private static String userDir = null;
    private boolean isUnderEjs = false;
    private Component parentComponent = null;
    private String parentComponentName = null;
    private URL codebase = null;
    private ArrayList<String> stateVariablesList = null;
    protected VideoCaptureTool videoTool = null;
    protected Component videoComponent;
    protected BufferedImage videoImage = null;
    protected SpecialRender videoSpecialRender = null;
    private JFrame descriptionDialog = null;
    private JTabbedPane descriptionPanel = null;
    private static final String dummy = "";
    private static final Class strClass = "".getClass();
    private static Hashtable memory = new Hashtable();
    private EmersionLink eMersion = null;
    private MethodWithOneParameter _init_ = null;
    private LauncherApplet javascriptControledApplet = null;
    private JPopupMenu popupMenu = null;
    private JMenu langMenu = null;
    private JMenu elementsMenu = null;
    private AbstractList popupMenuExtraEntries = null;
    private Component popupTriggeredBy = null;
    private Experiment currentExperiment = null;

    public static String getEjsString(String key) {
        return ejsRes.getString(key);
    }

    public static String getPathToLibrary() {
        return pathToLibrary;
    }

    public static void setPathToLibrary(String _path) {
        try {
            File libDir = new File(_path);
            if (libDir.exists() && libDir.isDirectory()) {
                pathToLibrary = _path;
            }
        }
        catch (Exception exception) {}
    }

    public static String getUserDir() {
        if (userDir == null) {
            try {
                userDir = System.getProperty("user.dir").replace('\\', '/');
                if (!userDir.endsWith("/")) {
                    userDir = String.valueOf(userDir) + "/";
                }
            }
            catch (Exception exception) {
                return dummy;
            }
        }
        return userDir;
    }

    public static String getHomeDir() {
        if (homeDir == null) {
            try {
                homeDir = System.getProperty("user.home").replace('\\', '/');
                if (!homeDir.endsWith("/")) {
                    homeDir = String.valueOf(homeDir) + "/";
                }
            }
            catch (Exception exception) {
                return dummy;
            }
        }
        return homeDir;
    }

    public static String getTemporaryDir() {
        try {
            return String.valueOf(Simulation.getHomeDir()) + "Ejs.tmp/";
        }
        catch (Exception exception) {
            return dummy;
        }
    }

    public static File requiresResourceFile(String _resource) {
        return Simulation.requiresResourceFile(_resource, _resource);
    }

    public static File requiresResourceFile(String _resource, String _destination) {
        File file = null;
        Resource res = ResourceLoader.getResource(_resource);
        if (res != null) {
            file = res.getFile();
        }
        if (file != null && file.exists()) {
            return file;
        }
        return Simulation.extractResource(_resource, String.valueOf(Simulation.getTemporaryDir()) + _destination);
    }

    public static File extractResource(String _source, String _destination) {
        File destFile = new File(_destination);
        try {
            int c;
            InputStream inputStream = ResourceLoader.openInputStream(_source);
            destFile.getParentFile().mkdirs();
            FileOutputStream fout = new FileOutputStream(destFile);
            BufferedInputStream in = new BufferedInputStream(inputStream);
            while ((c = in.read()) != -1) {
                fout.write(c);
            }
            in.close();
            fout.close();
            resourcesExtracted.add(destFile);
            System.out.println("Ejs simulation: resource " + _source + " extracted into " + _destination);
            return destFile;
        }
        catch (Exception exc) {
            System.out.println("Ejs simulation: resource " + _source + " could NOT be extracted into " + _destination);
            exc.printStackTrace();
            return null;
        }
    }

    private static void cleanExtractedResources() {
        if (resourcesExtracted.size() <= 0) {
            return;
        }
        System.out.println("Ejs simulation: Cleaning extracted files.");
        for (File file : resourcesExtracted) {
            System.out.println("Ejs simulation: wants to delete " + file.getPath());
            if (!file.exists()) continue;
            System.out.println("Ejs simulation: Removing extracted resource " + file.getPath());
            file.delete();
        }
        resourcesExtracted.clear();
        Simulation.removeEmptyDirs(new File(Simulation.getTemporaryDir()), true);
    }

    public static void removeEmptyDirs(File _directory, boolean _thisIncluded) {
        if (!_directory.isDirectory() || !_directory.exists()) {
            return;
        }
        FileSystemView fsView = FileSystemView.getFileSystemView();
        if (_thisIncluded) {
            Simulation.recursiveRemoveEmptyDirs(_directory, fsView);
        } else {
            File[] files = fsView.getFiles(_directory, false);
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    Simulation.recursiveRemoveEmptyDirs(files[i], fsView);
                }
                ++i;
            }
        }
    }

    private static void recursiveRemoveEmptyDirs(File directory, FileSystemView fsView) {
        File[] files = fsView.getFiles(directory, false);
        if (files.length == 0) {
            directory.delete();
            return;
        }
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                Simulation.recursiveRemoveEmptyDirs(files[i], fsView);
            }
            ++i;
        }
        files = fsView.getFiles(directory, false);
        if (files.length == 0) {
            directory.delete();
        }
    }

    protected void userDefinedReset() {
        if (this.resetFile != null) {
            this.readState(this.resetFile);
        }
    }

    protected void userDefinedViewUpdate() {
        if (this.videoImage != null) {
            this.captureVideoImage();
        }
    }

    private String getClassname() {
        String classname = this.getClass().getName();
        int index = classname.lastIndexOf(46);
        if (index >= 0) {
            classname = classname.substring(index + 1);
        }
        return classname;
    }

    private String getModelClassname() {
        String classname = this.model.getClass().getName();
        int index = classname.lastIndexOf(46);
        if (index >= 0) {
            classname = classname.substring(index + 1);
        }
        return classname;
    }

    private void errorMessage(String _text) {
        System.err.println(String.valueOf(this.getClassname()) + ": " + _text);
    }

    private void errorMessage(Exception _exc) {
        System.err.println(String.valueOf(this.getClassname()) + ": Exception caught! Text follows:");
        _exc.printStackTrace(System.err);
    }

    public void setParentComponent(Component _component) {
        this.parentComponent = _component;
    }

    public void setParentComponent(String _componentName) {
        this.parentComponentName = _componentName;
        this.parentComponent = null;
    }

    public Component getParentComponent() {
        if (this.parentComponent == null && this.view != null) {
            this.parentComponent = this.view.getComponent(this.parentComponentName);
        }
        return this.parentComponent;
    }

    public void setCodebase(URL _codebase) {
        this.codebase = _codebase;
    }

    public URL getCodebase() {
        return this.codebase;
    }

    public void translate() {
        TranslatorTool tool = TranslatorTool.getTool();
        tool.showProperties(this.model.getClass());
        tool.setKeepHidden(false);
        tool.setVisible(true);
    }

    public String translateString(String _property, String _default) {
        boolean hadQuotes = false;
        if (_property.startsWith("\"") && _property.endsWith("\"")) {
            hadQuotes = true;
            _property = _property.substring(1, _property.length() - 1);
        }
        String text = TranslatorTool.getTool().getProperty(this.model.getClass(), _property, _default);
        if (hadQuotes) {
            text = "\"" + text + "\"";
        }
        return text;
    }

    public String translateString(String _property) {
        boolean hadQuotes = false;
        if (_property.startsWith("\"") && _property.endsWith("\"")) {
            hadQuotes = true;
            _property = _property.substring(1, _property.length() - 1);
        }
        String text = TranslatorTool.getTool().getProperty(this.model.getClass(), _property);
        if (hadQuotes) {
            text = "\"" + text + "\"";
        }
        return text;
    }

    public void setLocale(String language) {
        Locale locale = new Locale(language);
        TranslatorTool.getTool().setLocale(locale);
        ToolsRes.setLocale(locale);
        DisplayRes.setLocale(locale);
        DialogsRes.setLocale(locale);
        launcherRes = ResourceBundle.getBundle("org.opensourcephysics.resources.tools.launcher", locale);
        ejsRes = ResourceBundle.getBundle("org.opensourcephysics.resources.ejs.ejs_res", locale);
        this.setViewLocale();
        this.popupMenu = null;
    }

    protected void setViewLocale() {
        this.elementsMenu = null;
        this.popupMenuExtraEntries = null;
        if (this.view instanceof EjsControl) {
            ((EjsControl)((Object)this.view)).addElementsMenuEntries();
        }
    }

    public void onExit() {
        Simulation.cleanExtractedResources();
        super.onExit();
    }

    public void addDescriptionPage(String _title, String _htmlPage, int width, int height) {
        if (this.isUnderEjs) {
            return;
        }
        if (this.descriptionDialog == null) {
            String title = String.valueOf(Input.getResource("DescriptionFor")) + " " + this.getModelClassname();
            this.descriptionDialog = new JFrame(title);
            this.descriptionPanel = new JTabbedPane();
            if (width <= 0) {
                width = 600;
            }
            if (height <= 0) {
                height = 400;
            }
            this.descriptionDialog.getContentPane().add((Component)this.descriptionPanel, "Center");
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            this.descriptionDialog.setLocation((d.width - width) / 2, (d.height - height) / 2);
        }
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        Resource htmlRes = ResourceLoader.getResource(_htmlPage);
        if (htmlRes != null) {
            try {
                editorPane.setPage(htmlRes.getURL());
                JScrollPane editorScrollPane = new JScrollPane(editorPane);
                editorScrollPane.setPreferredSize(new Dimension(width, height));
                this.descriptionPanel.add(_title, editorScrollPane);
                this.descriptionDialog.pack();
            }
            catch (IOException iOException) {
                System.err.println("Attempted to read a bad URL: " + htmlRes.getURL());
            }
        } else {
            System.err.println("Couldn't find description file: " + _htmlPage);
        }
    }

    public void showDescription() {
        if (this.descriptionDialog != null) {
            this.descriptionDialog.setVisible(true);
        }
    }

    public String getVariable(String _name) {
        return this.getVariable(_name, ",");
    }

    public String getVariable(String _name, String _sep) {
        if (this.model == null) {
            return null;
        }
        try {
            Field field = this.model.getClass().getField(_name);
            if (field.getType().isArray()) {
                String txt = dummy;
                Object array = field.get(this.model);
                int l = Array.getLength(array);
                int i = 0;
                while (i < l) {
                    txt = i > 0 ? String.valueOf(txt) + _sep + Array.get(array, i).toString() : String.valueOf(txt) + Array.get(array, i).toString();
                    ++i;
                }
                return txt;
            }
            return field.get(this.model).toString();
        }
        catch (Exception exc) {
            this.errorMessage(exc);
            return null;
        }
    }

    public boolean setVariable(String _name, String _value) {
        return this.setVariable(_name, _value, ",");
    }

    public boolean setVariable(String _variable, String _value, String _sep) {
        if (this.model == null) {
            return false;
        }
        try {
            Field field = this.model.getClass().getField(_variable);
            if (field.getType().isArray()) {
                boolean result = true;
                Object array = field.get(this.model);
                int i = 0;
                int l = Array.getLength(array);
                Class<?> type = field.getType().getComponentType();
                StringTokenizer line = new StringTokenizer(_value, _sep);
                if (l < line.countTokens()) {
                    this.errorMessage("Warning: there are less elements in the array than values provided!");
                } else if (l > line.countTokens()) {
                    this.errorMessage("Warning: there are more elements in the array than values provided!");
                }
                while (line.hasMoreTokens() && i < l) {
                    String token = line.nextToken();
                    if (type.equals(Double.TYPE)) {
                        Array.setDouble(array, i, Double.parseDouble(token));
                    } else if (type.equals(Float.TYPE)) {
                        Array.setFloat(array, i, Float.parseFloat(token));
                    } else if (type.equals(Byte.TYPE)) {
                        Array.setByte(array, i, Byte.parseByte(token));
                    } else if (type.equals(Short.TYPE)) {
                        Array.setShort(array, i, Short.parseShort(token));
                    } else if (type.equals(Integer.TYPE)) {
                        Array.setInt(array, i, Integer.parseInt(token));
                    } else if (type.equals(Long.TYPE)) {
                        Array.setLong(array, i, Long.parseLong(token));
                    } else if (type.equals(Boolean.TYPE)) {
                        if (token.trim().toLowerCase().equals("true")) {
                            Array.setBoolean(array, i, true);
                        } else {
                            Array.setBoolean(array, i, false);
                        }
                    } else if (type.equals(Character.TYPE)) {
                        Array.setChar(array, i, token.charAt(0));
                    } else if (type.equals(strClass)) {
                        Array.set(array, i, token);
                    } else {
                        result = false;
                    }
                    ++i;
                }
                return result;
            }
            Class<?> type = field.getType();
            if (type.equals(Double.TYPE)) {
                field.setDouble(this.model, Double.parseDouble(_value));
            } else if (type.equals(Float.TYPE)) {
                field.setFloat(this.model, Float.parseFloat(_value));
            } else if (type.equals(Byte.TYPE)) {
                field.setByte(this.model, Byte.parseByte(_value));
            } else if (type.equals(Short.TYPE)) {
                field.setShort(this.model, Short.parseShort(_value));
            } else if (type.equals(Integer.TYPE)) {
                field.setInt(this.model, Integer.parseInt(_value));
            } else if (type.equals(Long.TYPE)) {
                field.setLong(this.model, Long.parseLong(_value));
            } else if (type.equals(Boolean.TYPE)) {
                if (_value.trim().toLowerCase().equals("true")) {
                    field.setBoolean(this.model, true);
                } else {
                    field.setBoolean(this.model, false);
                }
            } else if (type.equals(Character.TYPE)) {
                field.setChar(this.model, _value.charAt(0));
            } else if (type.equals(strClass)) {
                field.set(this.model, _value);
            } else {
                return false;
            }
            return true;
        }
        catch (Exception exc) {
            this.errorMessage(exc);
            return false;
        }
    }

    public boolean setVariables(String _valueList) {
        return this.setVariables(_valueList, ";", ",");
    }

    public boolean setVariables(String _valueList, String _sep, String _arraySep) {
        boolean result = true;
        String name = dummy;
        String value = dummy;
        StringTokenizer line = new StringTokenizer(_valueList, _sep);
        while (line.hasMoreTokens()) {
            String token = line.nextToken();
            int index = token.indexOf(61);
            if (index < 0) {
                result = false;
                continue;
            }
            name = token.substring(0, index).trim();
            boolean partial = this.setVariable(name, value = token.substring(index + 1).trim(), _arraySep);
            if (partial) continue;
            result = false;
        }
        this.update();
        return result;
    }

    public void initEmersion() {
        LauncherApplet applet = this.model._getApplet();
        if (applet == null) {
            return;
        }
        try {
            String s = applet.getParameter("init");
            if (s != null) {
                this._init_ = new MethodWithOneParameter(0, applet._model, s, null, null, applet);
                this._init_.invoke(0, applet);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (applet.getParameter("eMersionURL") == null) {
            return;
        }
        this.eMersion = new EmersionLink(applet, this);
    }

    public boolean isEmersionConnected() {
        if (this.eMersion == null) {
            return false;
        }
        return this.eMersion.isConnected();
    }

    private boolean javascriptControlMode() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isImageFormatSupported(String _format) {
        try {
            String[] names = ImageIO.getWriterFormatNames();
            int i = 0;
            while (true) {
                if (i >= names.length) {
                    return false;
                }
                if (names[i].equalsIgnoreCase(_format)) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    protected void setUnderEjs(boolean value) {
        this.isUnderEjs = value;
    }

    public AbstractList getExperiments() {
        return null;
    }

    public Experiment createExperiment(String _experimentName) {
        return null;
    }

    public void runExperiment(Experiment _experiment) {
        if (_experiment == null) {
            return;
        }
        if (this.currentExperiment != null) {
            this.currentExperiment._abortExperiment();
        }
        this.currentExperiment = _experiment;
        _experiment._runExperiment();
    }

    public void runExperiment(String _experimentClassname) {
        this.runExperiment(this.createExperiment(_experimentClassname));
    }

    public void killExperiment() {
        if (this.currentExperiment != null) {
            this.currentExperiment._abortExperiment();
        }
        this.currentExperiment = null;
    }

    public void addMenuEntries(AbstractList _entries) {
        if (this.popupMenuExtraEntries == null) {
            this.popupMenuExtraEntries = new ArrayList();
        }
        this.popupMenuExtraEntries.addAll(_entries);
        this.popupMenu = null;
    }

    public void addElementMenuEntries(String elementName, AbstractList _entries) {
        if (this.elementsMenu == null) {
            this.elementsMenu = new JMenu(this.getMenuText("ejs_res:MenuItem.Elements"));
            ArrayList<JMenu> list = new ArrayList<JMenu>();
            list.add(this.elementsMenu);
            this.addMenuEntries(list);
        }
        JMenu menu = new JMenu(elementName);
        Iterator it = _entries.iterator();
        while (it.hasNext()) {
            this.addMenuItem(menu, it.next());
        }
        this.addMenuItem(this.elementsMenu, menu);
    }

    public Component getTopLevelComponent(Component _component) {
        Component c = _component;
        while (c.getParent() != null) {
            c = c.getParent();
        }
        return c;
    }

    public void getPopupMenu(Component _component, String _element) {
        this.getPopupMenu(_component, -1, -1, _element);
    }

    public void getPopupMenu(final Component _component, int _x, int _y, final String _element) {
        boolean appletMode;
        boolean bl = appletMode = this.model._getApplet() != null;
        if (this.popupMenu == null) {
            boolean canAccessDisk = true;
            try {
                System.getProperty("user.home");
            }
            catch (Exception exception) {
                canAccessDisk = false;
            }
            this.popupMenu = new JPopupMenu();
            AbstractList customActions = this.getExperiments();
            if (customActions != null) {
                JMenu experimentsMenu = new JMenu(this.getMenuText("tools_res:MenuItem.Experiments"));
                for (final Experiment experiment : customActions) {
                    String name = this.translateString(experiment._getName());
                    String desc = this.translateString(experiment._getDescription());
                    AbstractAction action = new AbstractAction(name){

                        public void actionPerformed(ActionEvent evt) {
                            Simulation.this.runExperiment(experiment);
                        }
                    };
                    action.putValue("ShortDescription", desc);
                    experimentsMenu.add(action);
                }
                this.popupMenu.add(experimentsMenu);
                JMenuItem killExperimentMenuItem = new JMenuItem(this.getMenuText("tools_res:MenuItem.KillExperiment"));
                killExperimentMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        Simulation.this.killExperiment();
                    }
                });
                this.popupMenu.add(killExperimentMenuItem);
                this.popupMenu.addSeparator();
            }
            if (this.popupMenuExtraEntries != null && this.popupMenuExtraEntries.size() > 0) {
                Iterator it = this.popupMenuExtraEntries.iterator();
                while (it.hasNext()) {
                    this.addMenuItem(this.popupMenu, it.next());
                }
                this.popupMenu.addSeparator();
            }
            if (canAccessDisk) {
                JMenu snapshotMenu = new JMenu(this.getMenuText("ejs_res:MenuItem.SnapshotTools"));
                snapshotMenu.add(new AbstractAction(this.getMenuText("tools_res:MenuItem.Snapshot")){

                    public void actionPerformed(ActionEvent e) {
                        boolean wasRunning = Simulation.this.isPlaying();
                        if (wasRunning) {
                            Simulation.this.pause();
                        }
                        Simulation.this.saveImageAs(_element);
                        if (wasRunning) {
                            Simulation.this.play();
                        }
                    }
                });
                snapshotMenu.add(new AbstractAction(this.getMenuText("ejs_res:MenuItem.TakeEPSSnapshot")){

                    public void actionPerformed(ActionEvent e) {
                        try {
                            PrintUtils.saveComponentAsEPS(Simulation.this.getTopLevelComponent(_component));
                        }
                        catch (Exception exc) {
                            exc.printStackTrace();
                        }
                    }
                });
                snapshotMenu.add(new AbstractAction(this.getMenuText("ejs_res:MenuItem.TakeEPSSnapshotWindow")){

                    public void actionPerformed(ActionEvent e) {
                        focusListener = new AWTEventListener(){

                            public void eventDispatched(AWTEvent _event) {
                                WindowEvent windowEvent = (WindowEvent)_event;
                                if (windowEvent.getID() == 207) {
                                    Toolkit.getDefaultToolkit().removeAWTEventListener(focusListener);
                                    try {
                                        PrintUtils.saveComponentAsEPS(windowEvent.getWindow());
                                    }
                                    catch (Exception exc) {
                                        exc.printStackTrace();
                                    }
                                }
                            }
                        };
                        System.out.println("Put the focus on the window you want to capture");
                        Toolkit.getDefaultToolkit().addAWTEventListener(focusListener, 64L);
                    }
                });
                snapshotMenu.add(new AbstractAction(this.getMenuText("tools_res:MenuItem.Video")){

                    public void actionPerformed(ActionEvent e) {
                        Simulation.this.startVideoTool(_element);
                    }
                });
                this.popupMenu.add(snapshotMenu);
                JMenu ioStateMenu = new JMenu(this.getMenuText("ejs_res:MenuItem.StateIO"));
                ioStateMenu.add(new AbstractAction(this.getMenuText("tools_res:MenuItem.SaveState")){

                    public void actionPerformed(ActionEvent e) {
                        Simulation.this.saveState(null);
                    }
                });
                ioStateMenu.add(new AbstractAction(this.getMenuText("tools_res:MenuItem.ReadState")){

                    public void actionPerformed(ActionEvent e) {
                        Simulation.this.updateView = false;
                        Simulation.this.readState(null);
                        Simulation.this.updateView = true;
                        Simulation.this.updateAfterModelAction();
                    }
                });
                ioStateMenu.add(new AbstractAction(this.getMenuText("ejs_res:MenuItem.DefaultResetState")){

                    public void actionPerformed(ActionEvent e) {
                        Simulation.this.resetFile = null;
                        Simulation.this.reset();
                    }
                });
                this.popupMenu.add(ioStateMenu);
            }
            JMenu guiMenu = new JMenu(this.getMenuText("ejs_res:MenuItem.GUI"));
            if (!appletMode) {
                this.langMenu = new JMenu(this.getMenuText("tools_res:TranslatorTool.Label.Description"));
                guiMenu.add(this.langMenu);
                if (canAccessDisk) {
                    guiMenu.add(new AbstractAction(this.getMenuText("tools_res:TranslatorTool.Title")){

                        public void actionPerformed(ActionEvent e) {
                            Simulation.this.translate();
                        }
                    });
                }
            }
            JMenu fontMenu = new JMenu(this.getMenuText("display_res:DrawingFrame.Font_menu_title"));
            fontMenu.add(new AbstractAction(this.getMenuText("display_res:DrawingFrame.IncreaseFontSize_menu_item")){

                public void actionPerformed(ActionEvent e) {
                    FontSizer.levelUp();
                    Iterator it = Simulation.this.getWindowsList().iterator();
                    while (it.hasNext()) {
                        FontSizer.setFonts(Simulation.this.getView().getComponent((String)it.next()), FontSizer.getLevel());
                    }
                }
            });
            fontMenu.add(new AbstractAction(this.getMenuText("display_res:DrawingFrame.DecreaseFontSize_menu_item")){

                public void actionPerformed(ActionEvent e) {
                    FontSizer.levelDown();
                    Iterator it = Simulation.this.getWindowsList().iterator();
                    while (it.hasNext()) {
                        FontSizer.setFonts(Simulation.this.getView().getComponent((String)it.next()), FontSizer.getLevel());
                    }
                }
            });
            guiMenu.add(fontMenu);
            this.popupMenu.add(guiMenu);
            this.popupMenu.addSeparator();
            if (this.descriptionDialog != null) {
                this.popupMenu.add(new AbstractAction(Input.getResource("ShowDescription")){

                    public void actionPerformed(ActionEvent e) {
                        Simulation.this.descriptionDialog.setVisible(true);
                    }
                });
            }
            if (canAccessDisk && EjsTool.hasEjsModel(this.getModel().getClass())) {
                this.popupMenu.add(new AbstractAction(launcherRes.getString("Popup.MenuItem.EjsModel")){

                    public void actionPerformed(ActionEvent e) {
                        boolean quit = EjsTool.runEjs(Simulation.this.getModel().getClass());
                        if (quit) {
                            System.exit(1);
                        }
                    }
                });
            }
            if (!this.isUnderEjs && canAccessDisk) {
                this.popupMenu.add(new AbstractAction(Input.getResource("CreateHTMLPage")){

                    public void actionPerformed(ActionEvent e) {
                        Simulation.this.createHTMLpage();
                    }
                });
            }
            this.popupMenu.add(new AbstractAction("OSP " + ToolsRes.getString("MenuItem.Log")){

                public void actionPerformed(ActionEvent e) {
                    OSPLog.getOSPLog().setLocationRelativeTo(Simulation.this.parentComponent);
                    OSPLog.showLog();
                }
            });
        }
        if (this.langMenu != null) {
            this.langMenu.removeAll();
            Locale[] langs = TranslatorTool.getTool().getTranslatedLocales(this.model.getClass());
            ActionListener langListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Simulation.this.setLocale(e.getActionCommand());
                }
            };
            int i = 0;
            while (i < langs.length) {
                JMenuItem item = new JMenuItem(langs[i].getDisplayLanguage(langs[i]));
                item.setActionCommand(langs[i].getLanguage());
                item.addActionListener(langListener);
                this.langMenu.add(item);
                ++i;
            }
        }
        this.popupTriggeredBy = _component;
        if (_x >= 0 && _y >= 0) {
            this.popupMenu.show(_component, _x, _y);
        } else {
            this.popupMenu.show(_component, (_component.getWidth() - this.popupMenu.getWidth()) / 2, (_component.getHeight() - this.popupMenu.getHeight()) / 2);
        }
    }

    private String getMenuText(String name) {
        String text = name.startsWith("ejs_res:") ? ejsRes.getString(name.substring(name.indexOf(58) + 1)) : (name.startsWith("tools_res:") ? ToolsRes.getString(name.substring(name.indexOf(58) + 1)) : (name.startsWith("display_res:") ? DisplayRes.getString(name.substring(name.indexOf(58) + 1)) : ToolsRes.getString(name)));
        if (text.startsWith("!") && text.endsWith("!")) {
            text = DisplayRes.getString(name);
        }
        if (text.startsWith("!") && text.endsWith("!")) {
            text = name;
        }
        return text;
    }

    private void processMenuTexts(Object object) {
        if (object instanceof JMenu) {
            JMenu menu = (JMenu)object;
            menu.setText(this.getMenuText(menu.getActionCommand()));
            int i = 0;
            int n = menu.getItemCount();
            while (i < n) {
                this.processMenuTexts(menu.getItem(i));
                ++i;
            }
        } else if (object instanceof JMenuItem) {
            JMenuItem menuItem = (JMenuItem)object;
            menuItem.setText(this.getMenuText(menuItem.getActionCommand()));
        }
    }

    private void addMenuItem(JComponent targetMenu, Object object) {
        if (object instanceof Action) {
            final Action item = (Action)object;
            String name = (String)item.getValue("Name");
            String text = this.getMenuText(name);
            AbstractAction action = new AbstractAction(text){

                public void actionPerformed(ActionEvent evt) {
                    item.actionPerformed(evt);
                }
            };
            action.putValue("ShortDescription", text);
            if (targetMenu instanceof JMenu) {
                ((JMenu)targetMenu).add(action);
            } else if (targetMenu instanceof JPopupMenu) {
                ((JPopupMenu)targetMenu).add(action);
            }
        } else if (object instanceof JMenu) {
            JMenu menu = (JMenu)object;
            this.processMenuTexts(menu);
            if (targetMenu instanceof JMenu) {
                ((JMenu)targetMenu).add(menu);
            } else if (targetMenu instanceof JPopupMenu) {
                ((JPopupMenu)targetMenu).add(menu);
            }
        } else if (object instanceof JMenuItem) {
            JMenuItem menuItem = (JMenuItem)object;
            this.processMenuTexts(menuItem);
            if (targetMenu instanceof JMenu) {
                ((JMenu)targetMenu).add(menuItem);
            } else if (targetMenu instanceof JPopupMenu) {
                ((JPopupMenu)targetMenu).add(menuItem);
            }
        }
    }

    public ArrayList getWindowsList() {
        return new ArrayList();
    }

    public String getMainWindow() {
        return null;
    }

    public String getJarName() {
        URL clsUrl = this.getClass().getResource(String.valueOf(this.getClass().getSimpleName()) + ".class");
        if (clsUrl != null) {
            try {
                URLConnection conn = clsUrl.openConnection();
                if (conn instanceof JarURLConnection) {
                    JarURLConnection connection = (JarURLConnection)conn;
                    String path = connection.getJarFileURL().getPath();
                    int index = path.lastIndexOf(47);
                    if (index >= 0) {
                        path = path.substring(index + 1);
                    }
                    return path;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void createHTMLpage() {
        String name;
        JFileChooser chooser = OSPRuntime.createChooser("HTML", new String[]{"html"});
        chooser.setSelectedFile(new File(String.valueOf(this.getModelClassname()) + ".html"));
        String filename = OSPRuntime.chooseFilename(chooser, this.popupTriggeredBy, true);
        if (filename == null) {
            return;
        }
        if (filename.lastIndexOf(46) < 0) {
            filename = String.valueOf(filename) + ".html";
        }
        Component mainWindow = this.getView().getComponent(this.getMainWindow());
        Dimension size = new Dimension(100, 100);
        if (mainWindow != null) {
            size = mainWindow.getSize();
        }
        if ((name = this.getClass().getName()).endsWith("Simulation")) {
            name = name.substring(0, name.length() - 10);
        }
        name = String.valueOf(name) + "Applet.class";
        String jarFilename = this.getJarName();
        String programName = this.getModelClassname();
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>\n");
        buffer.append("  <head>\n");
        buffer.append("    <title>" + programName + " HTML</title>\n");
        buffer.append("  </head>\n");
        buffer.append("  <body >\n");
        buffer.append("    <applet code=\"" + name + "\"\n");
        buffer.append("            codebase=\".\" archive=\"" + jarFilename + "\"\n");
        buffer.append("            name=\"" + programName + "\"  id=\"" + programName + "\"\n");
        buffer.append("            width=\"" + size.width + "\" height=\"" + size.height + "\">\n");
        buffer.append("  </applet>\n");
        buffer.append("  </body>\n");
        buffer.append("</html>\n");
        try {
            FileWriter fout = new FileWriter(filename);
            fout.write(buffer.toString());
            fout.close();
        }
        catch (Exception exc) {
            exc.printStackTrace();
            JOptionPane.showMessageDialog(this.popupTriggeredBy, "Error saving file: " + filename, "File Error", 0);
        }
    }

    public boolean saveImage(String _element) {
        GregorianCalendar cal = new GregorianCalendar();
        DecimalFormat format = new DecimalFormat("00");
        String date = String.valueOf(cal.get(1)) + format.format(cal.get(2)) + format.format(cal.get(5)) + "_" + format.format(cal.get(11)) + format.format(cal.get(12)) + format.format(cal.get(13));
        return this.saveImage(String.valueOf(this.getClassname()) + "_" + date + ".jpg", _element);
    }

    public boolean saveImageAs(String _element) {
        return this.saveImage(null, _element);
    }

    public boolean saveImage(String _filename, String _element) {
        if (this.view == null) {
            return false;
        }
        ControlElement ctrlEl = this.view.getElement(_element);
        if (ctrlEl == null) {
            System.err.println("Component not found: " + _element);
            return false;
        }
        Component comp = ctrlEl.getComponent();
        if (this.isEmersionConnected() || this.javascriptControlMode()) {
            OutputStream out;
            block24: {
                boolean supported;
                String format;
                BufferedImage bi;
                block23: {
                    if (comp instanceof JFrame) {
                        comp = ((JFrame)comp).getContentPane();
                    } else if (comp instanceof JDialog) {
                        comp = ((JDialog)comp).getContentPane();
                    }
                    bi = new BufferedImage(comp.getWidth(), comp.getHeight(), 5);
                    if (ctrlEl instanceof SpecialRender) {
                        ((SpecialRender)((Object)ctrlEl)).render(bi);
                    } else {
                        Graphics g = bi.getGraphics();
                        comp.paint(g);
                        g.dispose();
                    }
                    if (_filename == null) {
                        _filename = "default.gif";
                    }
                    if (this.isEmersionConnected()) {
                        return this.eMersion.saveImage(_filename, "GIF image", bi) != null;
                    }
                    try {
                        format = "jpg";
                        int index = _filename.lastIndexOf(46);
                        if (index >= 0) {
                            format = _filename.substring(index + 1).toLowerCase();
                        } else {
                            _filename = String.valueOf(_filename) + "." + format;
                        }
                        supported = Simulation.isImageFormatSupported(format);
                        if (supported || "gif".equalsIgnoreCase(format)) break block23;
                        System.err.println("Format not supported : " + format);
                        return false;
                    }
                    catch (Exception _exc) {
                        _exc.printStackTrace();
                        return false;
                    }
                }
                out = null;
                out = this.javascriptControlMode() || _filename.startsWith("ejs:") ? new ByteArrayOutputStream() : new FileOutputStream(_filename);
                boolean result = true;
                if (supported) {
                    result = ImageIO.write((RenderedImage)bi, format, out);
                } else {
                    try {
                        GIFEncoder encoder = new GIFEncoder(bi);
                        encoder.Write(out);
                    }
                    catch (Exception exc) {
                        result = false;
                        exc.printStackTrace();
                    }
                }
                out.close();
                if (result) break block24;
                return false;
            }
            if (_filename.startsWith("ejs:")) {
                memory.put(_filename, ((ByteArrayOutputStream)out).toByteArray());
            } else if (this.javascriptControlMode()) {
                this.javascriptControledApplet.setImageByteArray(((ByteArrayOutputStream)out).toByteArray());
            }
            return true;
        }
        return SnapshotTool.getTool().saveImage(_filename, comp, null);
    }

    public final boolean startVideoTool(String _element) {
        this.videoImage = null;
        this.videoComponent = null;
        this.videoSpecialRender = null;
        if (this.view == null) {
            return false;
        }
        Component comp = this.view.getComponent(_element);
        if (comp == null) {
            System.err.println("Component not found: " + _element);
            return false;
        }
        if (comp instanceof JFrame) {
            comp = ((JFrame)comp).getContentPane();
        } else if (comp instanceof JDialog) {
            comp = ((JDialog)comp).getContentPane();
        }
        this.videoImage = new BufferedImage(comp.getWidth(), comp.getHeight(), 1);
        this.videoComponent = comp;
        ControlElement ctrlEl = this.view.getElement(_element);
        if (ctrlEl instanceof SpecialRender) {
            this.videoSpecialRender = (SpecialRender)((Object)ctrlEl);
        }
        if (this.videoTool == null) {
            this.videoTool = VideoGrabber.getTool();
        }
        this.videoTool.setVisible(true);
        this.videoTool.clear();
        return true;
    }

    private final void captureVideoImage() {
        if (this.videoSpecialRender != null) {
            this.videoSpecialRender.render(this.videoImage);
        } else {
            Graphics g = this.videoImage.getGraphics();
            this.videoComponent.paint(g);
            g.dispose();
        }
        this.videoTool.addFrame(this.videoImage);
    }

    public void processArguments(String[] _args) {
        LauncherApplet applet = this.model._getApplet();
        if (applet == null) {
            boolean showIt;
            if (_args != null && _args.length > 0) {
                int i = 0;
                while (i < _args.length) {
                    if (_args[i].toLowerCase().endsWith(".xml")) {
                        this.resetFile = _args[i];
                        this.readState(this.resetFile);
                    } else if (_args[i].equals("-_initialState")) {
                        this.resetFile = _args[++i];
                        this.readState(this.resetFile);
                    }
                    ++i;
                }
            }
            boolean bl = showIt = !this.isUnderEjs;
            if (OSPRuntime.isLauncherMode()) {
                showIt = false;
            } else {
                try {
                    if ("true".equals(System.getProperty("osp_launcher"))) {
                        showIt = false;
                    }
                }
                catch (Exception exception) {}
            }
            if (showIt) {
                this.showDescription();
            }
        }
    }

    public static ArrayList toArrayList(String _list) {
        StringTokenizer tkn = new StringTokenizer(_list, " ;,");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (tkn.hasMoreTokens()) {
            arrayList.add(tkn.nextToken());
        }
        return arrayList;
    }

    public ArrayList getStateVariablesList() {
        return this.stateVariablesList;
    }

    public void setStateVariablesList(ArrayList _list) {
        this.stateVariablesList = _list;
    }

    public void setStateVariablesList(String _varList) {
        this.stateVariablesList = Simulation.toArrayList(_varList);
    }

    public boolean saveState(String _filename) {
        return this.saveVariables(_filename, this.stateVariablesList);
    }

    public boolean readState(String _filename) {
        if (_filename == null) {
            return this.readVariables(_filename, null, this.stateVariablesList);
        }
        URL theCodebase = null;
        if (this.model._getApplet() != null && !_filename.startsWith("url:") && !_filename.toLowerCase().startsWith("http:")) {
            theCodebase = this.model._getApplet().getCodeBase();
        }
        return this.readVariables(_filename, theCodebase, this.stateVariablesList);
    }

    public boolean readState(String _filename, URL _codebase) {
        return this.readVariables(_filename, _codebase, this.stateVariablesList);
    }

    public boolean saveVariables(String _filename, String _varList) {
        return this.saveVariables(_filename, Simulation.toArrayList(_varList));
    }

    public boolean readVariables(String _filename, URL _codebase, String _varList) {
        return this.readVariables(_filename, _codebase, Simulation.toArrayList(_varList));
    }

    public boolean readVariables(String _filename, URL _codebase, ArrayList _varList) {
        boolean success;
        if (this.model == null) {
            return false;
        }
        if (_filename == null) {
            JFileChooser chooser = OSPRuntime.createChooser("XML", new String[]{"xml"});
            chooser.setSelectedFile(new File(String.valueOf(this.getModelClassname()) + "_Variables.xml"));
            _filename = OSPRuntime.chooseFilename(chooser, this.popupTriggeredBy, false);
            if (_filename == null) {
                return false;
            }
        }
        if (success = this.justReadVariables(_filename, _codebase, _varList)) {
            if (this.view != null) {
                this.view.initialize();
            }
            this.updateAfterModelAction();
        }
        return success;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected boolean justReadVariables(String _filename, URL _codebase, List _varList) {
        try {
            boolean exists = true;
            URLConnection urlConnection = null;
            Reader reader = null;
            if (_filename.startsWith("ejs:")) {
                exists = memory.get(_filename) != null;
            } else if (!this.isEmersionConnected()) {
                if (_filename.startsWith("url:")) {
                    String urlStr = _filename.substring(4);
                    if (_codebase != null && !urlStr.startsWith("http:")) {
                        urlStr = _codebase + urlStr;
                    }
                    try {
                        urlConnection = new URL(urlStr).openConnection();
                    }
                    catch (Exception exception) {
                        exists = false;
                    }
                } else if (_filename.startsWith("http:")) {
                    try {
                        urlConnection = new URL(_filename).openConnection();
                    }
                    catch (Exception exception) {
                        exists = false;
                    }
                } else if (_codebase != null) {
                    try {
                        urlConnection = new URL(_codebase, _filename).openConnection();
                    }
                    catch (Exception exception) {
                        exists = false;
                    }
                } else {
                    reader = ResourceLoader.openReader(_filename);
                    boolean bl = exists = reader != null;
                }
            }
            if (!exists) {
                this.errorMessage("File does not exist " + _filename);
                return false;
            }
            XMLControlElement control = null;
            ObjectInputStream din = null;
            if (_filename.toLowerCase().endsWith(".xml")) {
                String xmlString = null;
                if (urlConnection != null) {
                    xmlString = (String)urlConnection.getContent();
                } else {
                    Reader in = null;
                    if (_filename.startsWith("ejs:")) {
                        in = new CharArrayReader((char[])memory.get(_filename));
                    } else if (this.isEmersionConnected()) {
                        xmlString = this.eMersion.readXML(_filename);
                    } else {
                        in = reader;
                    }
                    if (in != null) {
                        LineNumberReader l = new LineNumberReader(in);
                        StringBuffer txt = new StringBuffer();
                        String sl = l.readLine();
                        while (sl != null) {
                            txt.append(String.valueOf(sl) + "\n");
                            sl = l.readLine();
                        }
                        in.close();
                        xmlString = txt.toString();
                    }
                }
                control = new XMLControlElement(this.getClass());
                if (!control.readXMLForClass(xmlString, this.getClass())) {
                    return true;
                }
            } else {
                InputStream in;
                if (urlConnection != null) {
                    in = urlConnection.getInputStream();
                } else if (_filename.startsWith("ejs:")) {
                    in = new ByteArrayInputStream((byte[])memory.get(_filename));
                } else if (this.isEmersionConnected()) {
                    byte[] data = this.eMersion.readBinary(_filename);
                    if (data == null) {
                        return false;
                    }
                    in = new ByteArrayInputStream(data);
                } else {
                    in = new FileInputStream(_filename);
                }
                if (in == null) {
                    return false;
                }
                din = new ObjectInputStream(new BufferedInputStream(in));
            }
            Field[] fields = this.model.getClass().getFields();
            if (_varList == null) {
                int i = 0;
                while (i < fields.length) {
                    if (fields[i].get(this.model) instanceof Serializable) {
                        if (control != null) {
                            Object object = control.getObject(fields[i].getName());
                            if (object != null) {
                                fields[i].set(this.model, object);
                            }
                        } else {
                            fields[i].set(this.model, din.readObject());
                        }
                    }
                    ++i;
                }
            } else {
                int j = 0;
                int n = _varList.size();
                while (j < n) {
                    String varName = ((String)_varList.get(j)).trim();
                    int i = 0;
                    while (i < fields.length) {
                        if (fields[i].get(this.model) instanceof Serializable) {
                            if (!fields[i].getName().equals(varName)) break;
                            if (control != null) {
                                Object object = control.getObject(varName);
                                if (object == null) break;
                                fields[i].set(this.model, object);
                                break;
                            }
                            fields[i].set(this.model, din.readObject());
                            break;
                        }
                        ++i;
                    }
                    ++j;
                }
            }
            if (din != null) {
                din.close();
            }
            return true;
        }
        catch (Exception ioe) {
            this.errorMessage("Error when trying to read " + _filename);
            ioe.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this.getParentComponent(), ioe.getLocalizedMessage());
            return false;
        }
    }

    public boolean saveVariables(String _filename, ArrayList _varList) {
        if (this.model == null) {
            return false;
        }
        if (_filename == null) {
            JFileChooser chooser = OSPRuntime.createChooser("XML", new String[]{"xml"});
            chooser.setSelectedFile(new File(String.valueOf(this.getModelClassname()) + "_Variables.xml"));
            _filename = OSPRuntime.chooseFilename(chooser, this.popupTriggeredBy, true);
            if (_filename == null) {
                return false;
            }
            if (_filename.lastIndexOf(46) < _filename.length() - 5) {
                _filename = String.valueOf(_filename) + ".xml";
            }
        }
        try {
            XMLControlElement control = null;
            OutputStream out = null;
            ObjectOutputStream dout = null;
            if (_filename.toLowerCase().endsWith(".xml")) {
                control = new XMLControlElement(this.getClass());
            } else {
                out = this.javascriptControlMode() || _filename.startsWith("ejs:") || this.isEmersionConnected() ? new ByteArrayOutputStream() : new FileOutputStream(_filename);
                BufferedOutputStream bout = new BufferedOutputStream(out);
                dout = new ObjectOutputStream(bout);
            }
            Field[] fields = this.model.getClass().getFields();
            if (_varList == null) {
                int i = 0;
                while (i < fields.length) {
                    if (fields[i].get(this.model) instanceof Serializable) {
                        if (control != null) {
                            control.setValue(fields[i].getName(), fields[i].get(this.model));
                        } else {
                            dout.writeObject(fields[i].get(this.model));
                        }
                    }
                    ++i;
                }
            } else {
                int j = 0;
                int n = _varList.size();
                while (j < n) {
                    String varName = ((String)_varList.get(j)).trim();
                    int i = 0;
                    while (i < fields.length) {
                        if (fields[i].get(this.model) instanceof Serializable && fields[i].getName().equals(varName)) {
                            if (control != null) {
                                control.setValue(fields[i].getName(), fields[i].get(this.model));
                                break;
                            }
                            dout.writeObject(fields[i].get(this.model));
                            break;
                        }
                        ++i;
                    }
                    ++j;
                }
            }
            if (control != null) {
                Writer writer;
                if (_filename.startsWith("ejs:")) {
                    writer = new CharArrayWriter();
                } else {
                    if (this.isEmersionConnected()) {
                        return this.eMersion.saveXML(_filename, "XML file", control.toXML()) != null;
                    }
                    writer = new FileWriter(_filename);
                }
                control.write(writer);
                if (_filename.startsWith("ejs:")) {
                    memory.put(_filename, ((CharArrayWriter)writer).toCharArray());
                }
            } else {
                dout.close();
                if (_filename.startsWith("ejs:")) {
                    memory.put(_filename, ((ByteArrayOutputStream)out).toByteArray());
                } else {
                    if (this.isEmersionConnected()) {
                        return this.eMersion.saveBinary(_filename, "Binary data", ((ByteArrayOutputStream)out).toByteArray()) != null;
                    }
                    if (this.javascriptControlMode()) {
                        this.javascriptControledApplet.setStateByteArray(((ByteArrayOutputStream)out).toByteArray());
                    }
                }
            }
            return true;
        }
        catch (Exception ioe) {
            this.errorMessage("Error when trying to save " + _filename);
            ioe.printStackTrace(System.err);
            return false;
        }
    }

    public boolean saveText(String _filename, String _text) {
        try {
            Writer out;
            if (_filename.startsWith("ejs:")) {
                out = new CharArrayWriter();
            } else {
                if (this.isEmersionConnected()) {
                    if (_filename.toLowerCase().endsWith(".xml")) {
                        return this.eMersion.saveXML(_filename, "XML file", _text) != null;
                    }
                    return this.eMersion.saveText(_filename, "Text file", _text) != null;
                }
                out = new FileWriter(_filename);
            }
            BufferedWriter bout = new BufferedWriter(out);
            bout.write(_text);
            bout.close();
            if (_filename.startsWith("ejs:")) {
                memory.put(_filename, ((CharArrayWriter)out).toCharArray());
            }
            return true;
        }
        catch (Exception ioe) {
            System.err.println("Error when trying to save" + _filename);
            ioe.printStackTrace(System.err);
            return false;
        }
    }

    public boolean saveText(String _filename, StringBuffer _info) {
        return this.saveText(_filename, _info.toString());
    }

    public String readText(String _filename) {
        return this.readText(_filename, null);
    }

    public String readText(String _filename, URL _codebase) {
        if (_filename.startsWith("url:")) {
            String url = _filename.substring(4);
            if (_codebase != null && !url.startsWith("http:")) {
                url = _codebase + url;
            }
            try {
                return (String)new URL(url).getContent();
            }
            catch (Exception ioe) {
                System.err.println("Error when trying to read " + _filename);
                ioe.printStackTrace(System.err);
                return null;
            }
        }
        try {
            Reader in;
            if (_filename.startsWith("ejs:")) {
                in = new CharArrayReader((char[])memory.get(_filename));
            } else {
                if (this.isEmersionConnected()) {
                    if (_filename.toLowerCase().endsWith(".xml")) {
                        return this.eMersion.readXML(_filename);
                    }
                    return this.eMersion.readText(_filename);
                }
                in = new FileReader(_filename);
            }
            LineNumberReader l = new LineNumberReader(in);
            StringBuffer txt = new StringBuffer();
            String sl = l.readLine();
            while (sl != null) {
                txt.append(String.valueOf(sl) + "\n");
                sl = l.readLine();
            }
            in.close();
            return txt.toString();
        }
        catch (Exception ioe) {
            System.err.println("Error when trying to read " + _filename);
            ioe.printStackTrace(System.err);
            return null;
        }
    }
}

