/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.StringTokenizer;
import org.colos.ejs.library.control.ConstantParserUtil;
import org.colos.ejs.library.control.value.BooleanValue;
import org.colos.ejs.library.control.value.ObjectValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.GUIUtils;

public class ConstantParser {
    public static Value fontConstant(Font _currentFont, String _value) {
        Font font = ConstantParserUtil.fontConstant(_currentFont, _value);
        if (font == null) {
            return null;
        }
        return new ObjectValue(font);
    }

    public static Value booleanConstant(String _value) {
        if (_value.equals("true")) {
            return new BooleanValue(true);
        }
        if (_value.equals("false")) {
            return new BooleanValue(false);
        }
        return null;
    }

    public static Value colorConstant(String _value) {
        Color color = ConstantParserUtil.colorConstant(_value);
        if (color == null) {
            return null;
        }
        return new ObjectValue(color);
    }

    public static Value formatConstant(String _value) {
        if (_value == null || "null".equals(_value)) {
            return new ObjectValue(null);
        }
        if (_value.startsWith("\"") && _value.endsWith("\"")) {
            _value = _value.substring(1, _value.length() - 1);
        }
        if ((_value = GUIUtils.parseTeX(_value)).indexOf(";") == -1) {
            int id1 = _value.indexOf("0");
            int id2 = _value.indexOf("#");
            int id = -1;
            if (id1 > 0 && id2 > 0) {
                id = id1 < id2 ? id1 : id2;
            } else if (id1 > 0) {
                id = id1;
            } else if (id2 > 0) {
                id = id2;
            }
            if (id > 0) {
                _value = String.valueOf(_value) + ";" + _value.substring(0, id) + "-" + _value.substring(id);
            }
        }
        try {
            return new ObjectValue(new DecimalFormat(_value));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static Value rectangleConstant(String _value) {
        if (_value.indexOf(44) < 0) {
            return null;
        }
        try {
            StringTokenizer t = new StringTokenizer(_value, ",");
            int x = Integer.parseInt(t.nextToken());
            int y = Integer.parseInt(t.nextToken());
            int w = 0;
            int h = 0;
            if (t.hasMoreTokens()) {
                w = Integer.parseInt(t.nextToken());
            }
            if (t.hasMoreTokens()) {
                h = Integer.parseInt(t.nextToken());
            }
            return new ObjectValue(new Rectangle(x, y, w, h));
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }
}

