/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control;

import java.awt.Color;
import java.awt.Font;
import java.util.StringTokenizer;

public class ConstantParserUtil {
    public static final Color NULL_COLOR = new Color(0, 0, 0, 0);
    private static Font defaultFont = new Font("Dialog", 12, 0);

    public static Font fontConstant(Font _currentFont, String _value) {
        if (_value.indexOf(44) < 0) {
            return null;
        }
        if (_currentFont == null) {
            _currentFont = defaultFont;
        }
        int style = _currentFont.getStyle();
        int size = _currentFont.getSize();
        String name = null;
        StringTokenizer t = new StringTokenizer(_value, ",", true);
        if (t.hasMoreTokens()) {
            name = t.nextToken();
            if (name.equals(",")) {
                name = _currentFont.getName();
            } else if (t.hasMoreTokens()) {
                t.nextToken();
            }
        } else {
            name = _currentFont.getName();
        }
        if (t.hasMoreTokens()) {
            String styleStr = t.nextToken().toLowerCase();
            style = _currentFont.getStyle();
            if (!styleStr.equals(",")) {
                if (styleStr.indexOf("plain") != -1) {
                    style = 0;
                }
                if (styleStr.indexOf("bold") != -1) {
                    style = 1;
                }
                if (styleStr.indexOf("italic") != -1) {
                    style |= 2;
                }
                if (t.hasMoreTokens()) {
                    t.nextToken();
                }
            }
        }
        if (t.hasMoreTokens()) {
            try {
                size = Integer.parseInt(t.nextToken());
            }
            catch (Exception exception) {
                size = _currentFont.getSize();
            }
        }
        return new Font(name, style, size);
    }

    public static Color colorConstant(String _value) {
        if (_value.indexOf(44) >= 0) {
            try {
                StringTokenizer t = new StringTokenizer(_value, ":,");
                int r = Integer.parseInt(t.nextToken());
                int g = Integer.parseInt(t.nextToken());
                int b = Integer.parseInt(t.nextToken());
                int alpha = t.hasMoreTokens() ? Integer.parseInt(t.nextToken()) : 255;
                if (r < 0) {
                    r = 0;
                } else if (r > 255) {
                    r = 255;
                }
                if (g < 0) {
                    g = 0;
                } else if (g > 255) {
                    g = 255;
                }
                if (b < 0) {
                    b = 0;
                } else if (b > 255) {
                    b = 255;
                }
                if (alpha < 0) {
                    alpha = 0;
                } else if (alpha > 255) {
                    alpha = 255;
                }
                return new Color(r, g, b, alpha);
            }
            catch (Exception exc) {
                exc.printStackTrace();
                return null;
            }
        }
        if (_value.startsWith("Color.")) {
            _value = _value.substring(6);
        }
        if ((_value = _value.toUpperCase()).equals("NULL") || _value.equals("NONE")) {
            return NULL_COLOR;
        }
        if (_value.equals("BLACK")) {
            return Color.black;
        }
        if (_value.equals("BLUE")) {
            return Color.blue;
        }
        if (_value.equals("CYAN")) {
            return Color.cyan;
        }
        if (_value.equals("DARKGRAY")) {
            return Color.darkGray;
        }
        if (_value.equals("GRAY")) {
            return Color.gray;
        }
        if (_value.equals("GREEN")) {
            return Color.green;
        }
        if (_value.equals("LIGHTGRAY")) {
            return Color.lightGray;
        }
        if (_value.equals("MAGENTA")) {
            return Color.magenta;
        }
        if (_value.equals("ORANGE")) {
            return Color.orange;
        }
        if (_value.equals("PINK")) {
            return Color.pink;
        }
        if (_value.equals("RED")) {
            return Color.red;
        }
        if (_value.equals("WHITE")) {
            return Color.white;
        }
        if (_value.equals("YELLOW")) {
            return Color.yellow;
        }
        return null;
    }
}

