/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.colos.ejs.library.Function;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.GroupVariable;
import org.colos.ejs.library.control.MethodWithOneParameter;
import org.colos.ejs.library.control.NeedsUpdate;
import org.colos.ejs.library.control.Resetable;
import org.colos.ejs.library.control.swing.ControlContainer;
import org.colos.ejs.library.control.swing.ControlDialog;
import org.colos.ejs.library.control.swing.ControlDrawable;
import org.colos.ejs.library.control.swing.ControlParentOfDrawables;
import org.colos.ejs.library.control.swing.ControlRootPane;
import org.colos.ejs.library.control.swing.ControlWindow;
import org.colos.ejs.library.control.value.BooleanValue;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.ObjectValue;
import org.colos.ejs.library.control.value.StringValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.tools.ResourceLoader;

public class EjsControl {
    private static String _RETURN_;
    protected String replaceOwnerName = null;
    private Frame ownerFrame = null;
    protected Frame replaceOwnerFrame = null;
    private JTextArea messageArea = null;
    protected boolean mustUpdateSimulation = true;
    protected boolean justCollectingData = false;
    private Simulation mySimulation = null;
    private Hashtable targetTable = new Hashtable();
    private Hashtable elementTable = new Hashtable();
    Hashtable variableTable = new Hashtable();
    private Vector elementList = new Vector();
    private Vector updateList = new Vector();
    private URL usercodebase = null;
    private Point displacement = new Point(0, 0);
    GroupVariable methodTriggerVariable = null;
    private Hashtable<ControlDrawable, ControlParentOfDrawables> drawablesReparented = new Hashtable();
    private BooleanValue booleanValue = new BooleanValue(false);
    private IntegerValue integerValue = new IntegerValue(0);
    private DoubleValue doubleValue = new DoubleValue(0.0);
    private StringValue stringValue = new StringValue("");
    private ObjectValue objectValue = new ObjectValue(null);
    private static Color[] colorTable;

    static {
        ResourceLoader.setCacheEnabled(true);
        try {
            _RETURN_ = System.getProperty("line.separator");
        }
        catch (Exception exception) {
            _RETURN_ = "\n";
        }
        colorTable = null;
    }

    public EjsControl() {
        this.setValue("_expr_", new BooleanValue(false));
        this.methodTriggerVariable = (GroupVariable)this.variableTable.get("_expr_");
    }

    public EjsControl(Object _target) {
        this();
        this.addTarget("_default_", _target);
        if (_target instanceof Simulation) {
            this.setSimulation((Simulation)_target);
        }
    }

    public EjsControl(Object _simulation, String _replaceName, Frame _replaceOwnerFrame) {
        this(_simulation);
        this.replaceOwnerFrame(_replaceName, _replaceOwnerFrame);
    }

    public void setOwnerFrame(Frame _frame) {
        this.ownerFrame = _frame;
    }

    public Frame getOwnerFrame() {
        return this.ownerFrame;
    }

    public void replaceOwnerFrame(String _replaceName, Frame _replaceOwnerFrame) {
        this.replaceOwnerName = _replaceName;
        this.replaceOwnerFrame = _replaceOwnerFrame;
    }

    public String getReplaceOwnerName() {
        return this.replaceOwnerName;
    }

    public Frame getReplaceOwnerFrame() {
        return this.replaceOwnerFrame;
    }

    public void setSimulation(Simulation _sim) {
        this.mySimulation = _sim;
    }

    public Simulation getSimulation() {
        return this.mySimulation;
    }

    public void setUpdateSimulation(boolean _value) {
        this.mustUpdateSimulation = _value;
    }

    public void updateSimulation() {
        if (this.mustUpdateSimulation && this.mySimulation != null) {
            this.mySimulation.update();
        }
    }

    public boolean isCollectingData() {
        return this.justCollectingData;
    }

    public void addElementsMenuEntries() {
        Enumeration e = this.elementList.elements();
        while (e.hasMoreElements()) {
            ((ControlElement)e.nextElement()).addMenuEntries();
        }
    }

    public void setDisplacement(int x, int y) {
        this.setDisplacement(x, y, null);
    }

    public void setDisplacement(int x, int y, EjsControl reference) {
        if (reference != null) {
            this.displacement.x = x + reference.displacement.x;
            this.displacement.y = y + reference.displacement.y;
        } else {
            this.displacement.x = x;
            this.displacement.y = y;
        }
        Enumeration e = this.elementList.elements();
        while (e.hasMoreElements()) {
            ControlElement element = (ControlElement)e.nextElement();
            if (!(element instanceof ControlWindow)) continue;
            ((ControlWindow)element).updateLocation();
        }
    }

    public Point getDisplacement() {
        return this.displacement;
    }

    public boolean reparentDrawable(String _childName, ControlElement _parentElement) {
        ControlElement child = this.getElement(_childName);
        if (child instanceof ControlDrawable && _parentElement instanceof ControlParentOfDrawables) {
            ControlDrawable drawable = (ControlDrawable)child;
            this.drawablesReparented.put(drawable, drawable.getParent());
            drawable.setParent((ControlParentOfDrawables)((Object)_parentElement));
            return true;
        }
        JOptionPane.showMessageDialog(null, "Can't reparent drawable.\nOne of the elements is not of the right type", "Error", 1);
        return false;
    }

    public void undoReparenting() {
        Enumeration<ControlDrawable> el = this.drawablesReparented.keys();
        while (el.hasMoreElements()) {
            ControlDrawable element = el.nextElement();
            element.setParent(this.drawablesReparented.get(element));
        }
        this.drawablesReparented.clear();
    }

    public void dispose() {
        Enumeration e = this.elementList.elements();
        while (e.hasMoreElements()) {
            ControlElement element = (ControlElement)e.nextElement();
            if (!(element instanceof ControlWindow)) continue;
            ((ControlWindow)element).dispose();
        }
    }

    public Object getTarget(String _name) {
        return this.targetTable.get(_name);
    }

    public void addTarget(String _name, Object _target) {
        this.targetTable.put(_name, _target);
    }

    public void removeTarget(String _name) {
        this.targetTable.remove(_name);
    }

    public void setValue(String _name, Value _value) {
        this.setValue(_name, _value, false);
    }

    public void setValue(String _name, Value _value, boolean _isModelVariable) {
        GroupVariable variable = (GroupVariable)this.variableTable.get(_name);
        if (variable == null) {
            variable = new GroupVariable(_name, _value);
            variable.setValueObsolete(false);
            variable.setDefinedInModel(_isModelVariable);
            this.variableTable.put(_name, variable);
        } else {
            variable.setValue(_value);
            variable.setValueObsolete(false);
            if (_isModelVariable) {
                variable.setDefinedInModel(true);
            }
            variable.propagateValue(null, this.justCollectingData);
        }
    }

    public Value getValue(String _name) {
        GroupVariable variable = (GroupVariable)this.variableTable.get(_name);
        if (variable == null) {
            return null;
        }
        return variable.getValue();
    }

    public GroupVariable getVariable(String _name) {
        return (GroupVariable)this.variableTable.get(_name);
    }

    public GroupVariable registerVariable(String _name, ControlElement _element, int _index, Value _value) {
        if (_name == null) {
            return null;
        }
        GroupVariable variable = (GroupVariable)this.variableTable.get(_name);
        if (variable == null) {
            variable = new GroupVariable(_name, _value);
            this.variableTable.put(_name, variable);
        }
        variable.addElementListener(_element, _index);
        variable.propagateValue(null, this.justCollectingData);
        return variable;
    }

    public boolean isVariableRegistered(String _name) {
        if (_name == null) {
            return false;
        }
        return this.variableTable.get(_name) != null;
    }

    public void variableChanged(GroupVariable _variable, ControlElement _element, Value _value) {
        if (_variable == null) {
            return;
        }
        _variable.setValue(_value);
        _variable.propagateValue(_element, this.justCollectingData);
        _variable.invokeListeners(_element);
    }

    public void addListener(String _name, String _method) {
        this.addListener(_name, _method, null);
    }

    public void addListener(String _name, String _method, Object _anObject) {
        Object target;
        if (_name == null) {
            return;
        }
        String[] parts = MethodWithOneParameter.splitMethodName(_method);
        if (parts == null) {
            System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Listener <" + _method + "> not assigned");
            return;
        }
        if (parts[0] == null) {
            parts[0] = "_default_";
        }
        if ((target = this.getTarget(parts[0])) == null) {
            System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Target <" + parts[0] + "> not assigned");
            return;
        }
        GroupVariable variable = (GroupVariable)this.variableTable.get(_name);
        if (variable == null) {
            variable = new GroupVariable(_name, this.doubleValue);
            this.variableTable.put(_name, variable);
        }
        if (parts[2] == null) {
            variable.addListener(target, String.valueOf(parts[1]) + "()", _anObject);
        } else {
            variable.addListener(target, String.valueOf(parts[1]) + "(" + parts[2] + ")", _anObject);
        }
    }

    public void rename(ControlElement _element, String _name) {
        String oldName = _element.getProperty("name");
        if (oldName != null) {
            this.elementTable.remove(oldName);
        }
        if (_name != null) {
            this.elementTable.put(_name, _element);
        }
    }

    public final ControlElement addElement(ControlElement element, String name) {
        Object object;
        if (this.replaceOwnerName != null && this.replaceOwnerName.equals(name)) {
            if (element.getObject() instanceof Frame) {
                this.setOwnerFrame(this.replaceOwnerFrame);
            }
            element = new ControlRootPane();
        }
        if ((object = element.getObject()) instanceof Frame) {
            this.setOwnerFrame((Frame)object);
        } else if (object instanceof Dialog && this.ownerFrame != null) {
            element.replaceVisual(this.ownerFrame);
        } else if (object instanceof JTextArea) {
            this.messageArea = (JTextArea)object;
        }
        element.setGroup(this);
        element.setProperty("name", name);
        this.elementList.add(element);
        if (element instanceof NeedsUpdate) {
            this.updateList.add(element);
        }
        if (this.usercodebase != null) {
            element.setProperty("_ejs_codebase", this.usercodebase.toString());
        }
        if (object instanceof Window && element.getProperty("visible") == null) {
            element.setProperty("visible", "true");
        }
        return element;
    }

    public ControlElement getElement(String _name) {
        if (_name == null) {
            return null;
        }
        return (ControlElement)this.elementTable.get(_name);
    }

    public ControlElement getControl(String _name) {
        return this.getElement(_name);
    }

    public Component getVisual(String _name) {
        ControlElement element = this.getElement(_name);
        if (element == null) {
            return null;
        }
        return element.getVisual();
    }

    public Component getComponent(String _name) {
        ControlElement element = this.getElement(_name);
        if (element == null) {
            return null;
        }
        return element.getComponent();
    }

    public Container getContainer(String _name) {
        ControlElement element = this.getElement(_name);
        if (element instanceof ControlContainer) {
            return ((ControlContainer)element).getContainer();
        }
        return null;
    }

    public Object getObject(String _elementName, String _objectName) {
        ControlElement element = this.getElement(_elementName);
        if (element == null) {
            return null;
        }
        return element.getObject(_objectName);
    }

    public Function getFunction(String _elementName, String _functionName) {
        Object f = this.getObject(_elementName, _functionName);
        if (f instanceof Function) {
            return (Function)f;
        }
        return null;
    }

    public void destroy(String _name) {
        this.destroy(this.getElement(_name), true);
    }

    public void destroy(ControlElement _element) {
        this.destroy(_element, true);
    }

    public void reset() {
        this.clearMessages();
        this.undoReparenting();
        Enumeration e = this.elementList.elements();
        while (e.hasMoreElements()) {
            ((ControlElement)e.nextElement()).reset();
        }
    }

    public void initialize() {
        Enumeration e = this.elementList.elements();
        while (e.hasMoreElements()) {
            ((ControlElement)e.nextElement()).initialize();
        }
    }

    public void propagateValues() {
    }

    private void doTheUpdate() {
        this.methodTriggerVariable.propagateValue(null, this.justCollectingData);
        Enumeration e = this.updateList.elements();
        while (e.hasMoreElements()) {
            ((NeedsUpdate)e.nextElement()).update();
        }
    }

    public void update() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.propagateValues();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public synchronized void run() {
                        EjsControl.this.propagateValues();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        this.doTheUpdate();
    }

    public void collectData() {
        this.justCollectingData = true;
        if (SwingUtilities.isEventDispatchThread()) {
            this.propagateValues();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public synchronized void run() {
                        EjsControl.this.propagateValues();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        this.doTheUpdate();
        this.justCollectingData = false;
    }

    public void resetTraces() {
        Enumeration e = this.elementList.elements();
        while (e.hasMoreElements()) {
            ControlElement element = (ControlElement)e.nextElement();
            if (!(element instanceof Resetable)) continue;
            element.reset();
        }
    }

    public void setUserCodebase(URL _url) {
        this.usercodebase = _url;
        Enumeration e = this.elementList.elements();
        while (e.hasMoreElements()) {
            ((ControlElement)e.nextElement()).setProperty("_ejs_codebase", _url.toString());
        }
    }

    public URL getUserCodebase() {
        return this.usercodebase;
    }

    public void flush() {
        Enumeration e = this.elementList.elements();
        while (e.hasMoreElements()) {
            ((ControlElement)e.nextElement()).flush();
        }
    }

    public void setActive(boolean _active) {
        Enumeration e = this.elementList.elements();
        while (e.hasMoreElements()) {
            ((ControlElement)e.nextElement()).setActive(_active);
        }
    }

    public void onExit() {
        Enumeration e = this.elementList.elements();
        while (e.hasMoreElements()) {
            ((ControlElement)e.nextElement()).onExit();
        }
    }

    public void clearVariables() {
        this.variableTable.clear();
    }

    public void clearModelVariables() {
        Hashtable<String, GroupVariable> newTable = new Hashtable<String, GroupVariable>();
        Enumeration e = this.variableTable.elements();
        while (e.hasMoreElements()) {
            GroupVariable var = (GroupVariable)e.nextElement();
            if (!var.isDefinedInModel()) {
                newTable.put(var.getName(), var);
                continue;
            }
            if (!var.hasElementsRegistered()) continue;
            var.setValueObsolete(true);
            newTable.put(var.getName(), var);
        }
        this.variableTable = newTable;
    }

    public Set getVariablesSet() {
        return this.variableTable.keySet();
    }

    public Hashtable getVariablesTable() {
        return this.variableTable;
    }

    public void clear() {
        this.variableTable.clear();
        ArrayList<ControlElement> dialogsList = new ArrayList<ControlElement>();
        ArrayList<ControlElement> framesList = new ArrayList<ControlElement>();
        Enumeration e = this.elementList.elements();
        while (e.hasMoreElements()) {
            ControlElement element = (ControlElement)e.nextElement();
            String parent = element.getProperty("parent");
            if (parent != null) continue;
            if (element instanceof ControlDialog) {
                dialogsList.add(element);
                continue;
            }
            framesList.add(element);
        }
        for (ControlElement element : dialogsList) {
            this.destroy(element, false);
        }
        for (ControlElement element : framesList) {
            this.destroy(element, false);
        }
        this.setOwnerFrame(null);
    }

    private void destroy(ControlElement _element, boolean _informMyParent) {
        if (_element == null) {
            return;
        }
        if (_informMyParent) {
            ControlElement parent = this.getElement(_element.getProperty("parent"));
            if (parent != null) {
                if (parent instanceof ControlContainer) {
                    ((ControlContainer)parent).remove(_element);
                }
            } else {
                Container cont = _element.getComponent().getParent();
                if (cont != null) {
                    cont.remove(_element.getComponent());
                    cont.validate();
                    cont.repaint();
                }
            }
        }
        _element.variablePropertiesClear();
        String name = _element.getProperty("name");
        if (name != null) {
            this.elementTable.remove(name);
        }
        this.elementList.remove(_element);
        if (_element instanceof NeedsUpdate) {
            this.updateList.remove(_element);
        }
        if (_element instanceof ControlContainer) {
            Enumeration e = ((ControlContainer)_element).getChildren().elements();
            while (e.hasMoreElements()) {
                ControlElement child = (ControlElement)e.nextElement();
                this.destroy(child, false);
            }
        }
        if (_element instanceof ControlWindow) {
            ((ControlWindow)_element).dispose();
        }
    }

    public Container getTopLevelAncestor(String _name) {
        if (_name != null) {
            ControlElement element = this.getElement(_name);
            Component comp = element.getComponent();
            if (comp instanceof JComponent) {
                return ((JComponent)comp).getTopLevelAncestor();
            }
        } else {
            Enumeration e = this.elementList.elements();
            while (e.hasMoreElements()) {
                ControlElement element = (ControlElement)e.nextElement();
                Component comp = element.getComponent();
                if (!(comp instanceof Window)) continue;
                return (Window)comp;
            }
        }
        return null;
    }

    public void setValue(String _name, boolean _value) {
        this.booleanValue.value = _value;
        this.setValue(_name, this.booleanValue);
    }

    public void setValue(String _name, int _value) {
        this.integerValue.value = _value;
        this.setValue(_name, this.integerValue);
    }

    public void setValue(String _name, double _value) {
        this.doubleValue.value = _value;
        this.setValue(_name, this.doubleValue);
    }

    public void setValue(String _name, String _value) {
        this.stringValue.value = _value;
        this.setValue(_name, this.stringValue);
    }

    public void setValue(String _name, Object _value) {
        if (_value instanceof String) {
            this.setValue(_name, (String)_value);
        } else {
            this.objectValue.value = _value;
            this.setValue(_name, this.objectValue);
        }
    }

    public boolean getBoolean(String _name) {
        Value value = this.getValue(_name);
        if (value == null) {
            return false;
        }
        return value.getBoolean();
    }

    public int getInt(String _name) {
        Value value = this.getValue(_name);
        if (value == null) {
            return 0;
        }
        return value.getInteger();
    }

    public double getDouble(String _name) {
        Value value = this.getValue(_name);
        if (value == null) {
            return 0.0;
        }
        return value.getDouble();
    }

    public String getString(String _name) {
        Value value = this.getValue(_name);
        if (value == null) {
            return "";
        }
        return value.getString();
    }

    public Object getObject(String _name) {
        Value value = this.getValue(_name);
        if (value == null) {
            return null;
        }
        return value.getObject();
    }

    public static Color[] getPhaseColorTable() {
        if (colorTable == null) {
            colorTable = new Color[256];
            int i = 0;
            while (i < 256) {
                double val = Math.abs(Math.sin(Math.PI * (double)i / 255.0));
                int b = (int)(255.0 * val * val);
                val = Math.abs(Math.sin(Math.PI * (double)i / 255.0 + 1.0471975511965976));
                int g = (int)(255.0 * val * val * Math.sqrt(val));
                val = Math.abs(Math.sin(Math.PI * (double)i / 255.0 + 2.0943951023931953));
                int r = (int)(255.0 * val * val);
                EjsControl.colorTable[i] = new Color(r, g, b);
                ++i;
            }
        }
        return colorTable;
    }

    public static Color phaseToColor(double phi) {
        int index = (int)(127.5 * (1.0 + phi / Math.PI));
        return EjsControl.getPhaseColorTable()[index %= 255];
    }

    public void clearMessages() {
        if (this.messageArea != null) {
            this.messageArea.setText("");
            this.messageArea.setCaretPosition(this.messageArea.getText().length());
        }
    }

    public void println(String s) {
        this.print(String.valueOf(s) + _RETURN_);
    }

    public void println() {
        this.println("");
    }

    public void print(String s) {
        if (this.messageArea != null) {
            this.messageArea.append(s);
            this.messageArea.setCaretPosition(this.messageArea.getText().length());
        } else {
            System.out.print(s);
        }
    }
}

