/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control;

import java.lang.reflect.Method;
import org.colos.ejs.library.control.value.BooleanValue;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.ObjectValue;
import org.colos.ejs.library.control.value.StringValue;
import org.colos.ejs.library.control.value.Value;

public class MethodWithOneParameter {
    private String methodName;
    private int methodType;
    private boolean isArray = false;
    private Object targetObject = null;
    private Object[] parameterList = new Object[0];
    private Method methodToCall;
    private MethodWithOneParameter secondMethod = null;
    private Value returnValue = null;

    public MethodWithOneParameter(int _type, Object _target, String _name, String _returnType, MethodWithOneParameter _secondMethod, Object _anObject) {
        Class[] classList = new Class[]{};
        Object parameter = null;
        Class<Object> parameterClass = null;
        this.methodName = _name;
        this.methodType = _type;
        this.targetObject = _target;
        this.secondMethod = _secondMethod;
        String[] parts = MethodWithOneParameter.splitMethodName(_name.trim());
        if ("#CONTROL#".equals(parts[2]) && _anObject != null) {
            parameter = _anObject;
            parameterClass = _anObject.getClass();
        } else {
            Value value = Value.parseConstant(parts[2], false);
            if (value == null) {
                parameter = null;
            } else if (value instanceof StringValue) {
                parameter = value.getString();
                parameterClass = _name.getClass();
            } else if (value instanceof BooleanValue) {
                parameter = new Boolean(value.getBoolean());
                parameterClass = Boolean.TYPE;
            } else if (value instanceof DoubleValue) {
                parameter = new Double(value.getDouble());
                parameterClass = Double.TYPE;
            } else if (value instanceof IntegerValue) {
                parameter = new Integer(value.getInteger());
                parameterClass = Integer.TYPE;
            }
        }
        if (parameter != null) {
            classList = new Class[]{parameterClass};
            this.parameterList = new Object[1];
            this.parameterList[0] = parameter;
        }
        this.methodToCall = MethodWithOneParameter.resolveMethod(this.targetObject, parts[1], classList);
        Class<?> returnTypeClass = this.methodToCall.getReturnType();
        this.isArray = returnTypeClass.isArray();
        if (this.methodToCall == null) {
            System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Unable to find a suitable method " + this.methodName + " in class " + this.targetObject.getClass().getName());
        }
        this.returnValue = this.isArray ? new ObjectValue(null) : (_returnType == null ? null : ((_returnType = _returnType.trim().toLowerCase()).equals("double") ? new DoubleValue(0.0) : (_returnType.equals("int") ? new IntegerValue(0) : (_returnType.equals("string") ? new StringValue("") : (_returnType.equals("boolean") ? new BooleanValue(false) : (_returnType.equals("object") ? new ObjectValue(null) : null))))));
    }

    public Value invoke(int _type, Object _callingObject) {
        if (this.methodType != _type) {
            return null;
        }
        try {
            if (this.isArray) {
                ((ObjectValue)this.returnValue).value = this.methodToCall.invoke(this.targetObject, this.parameterList);
            } else if (this.returnValue == null) {
                this.methodToCall.invoke(this.targetObject, this.parameterList);
            } else if (this.returnValue instanceof DoubleValue) {
                ((DoubleValue)this.returnValue).value = (Double)this.methodToCall.invoke(this.targetObject, this.parameterList);
            } else if (this.returnValue instanceof IntegerValue) {
                ((IntegerValue)this.returnValue).value = (Integer)this.methodToCall.invoke(this.targetObject, this.parameterList);
            } else if (this.returnValue instanceof BooleanValue) {
                ((BooleanValue)this.returnValue).value = (Boolean)this.methodToCall.invoke(this.targetObject, this.parameterList);
            } else if (this.returnValue instanceof StringValue) {
                Object obj = this.methodToCall.invoke(this.targetObject, this.parameterList);
                ((StringValue)this.returnValue).value = obj == null ? null : this.methodToCall.invoke(this.targetObject, this.parameterList).toString();
            } else if (this.returnValue instanceof ObjectValue) {
                ((ObjectValue)this.returnValue).value = this.methodToCall.invoke(this.targetObject, this.parameterList);
            }
            if (this.secondMethod != null) {
                this.secondMethod.invoke(_type, _callingObject);
            }
        }
        catch (Exception exc) {
            exc.printStackTrace(System.err);
            return null;
        }
        return this.returnValue;
    }

    public boolean equals(int _type, Object _target, String _name) {
        if (this.methodType != _type) {
            return false;
        }
        if (this.targetObject != _target) {
            return false;
        }
        return this.methodName.equals(_name);
    }

    public String toString() {
        return this.methodName;
    }

    public static Method resolveMethod(Object _target, String _name, Class[] _classList) {
        Method[] allMethods = _target.getClass().getMethods();
        int i = 0;
        while (i < allMethods.length) {
            Class<?>[] parameters;
            if (allMethods[i].getName().equals(_name) && (parameters = allMethods[i].getParameterTypes()).length == _classList.length) {
                boolean fits = true;
                int j = 0;
                while (j < parameters.length) {
                    if (!parameters[j].isAssignableFrom(_classList[j])) {
                        fits = false;
                        break;
                    }
                    ++j;
                }
                if (fits) {
                    return allMethods[i];
                }
            }
            ++i;
        }
        return null;
    }

    public static String[] splitMethodName(String _inputName) {
        String[] part = new String[3];
        String restOfIt = _inputName;
        int index1 = _inputName.indexOf(46);
        int index2 = _inputName.indexOf(40);
        if (index1 > 0 && (index2 < 0 || index2 > index1)) {
            part[0] = _inputName.substring(0, index1);
            restOfIt = _inputName.substring(index1 + 1);
        } else {
            part[0] = null;
        }
        index1 = restOfIt.indexOf("(");
        if (index1 <= 0) {
            part[1] = restOfIt;
            part[2] = "";
        } else {
            part[1] = restOfIt.substring(0, index1).trim();
            index2 = (restOfIt = restOfIt.substring(index1)).lastIndexOf(41);
            if (index2 < 0) {
                System.err.println(" : Error! Incorrect method description " + _inputName);
                return null;
            }
            part[2] = restOfIt.substring(1, index2).trim();
        }
        return part;
    }
}

