/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.displayejs;

import java.awt.Color;
import java.util.StringTokenizer;
import org.colos.ejs.library.control.ConstantParserUtil;
import org.colos.ejs.library.control.swing.ControlDrawable;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.ObjectValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.displayejs.Resolution;

public abstract class ControlDrawable3D
extends ControlDrawable {
    public static final Color NULL_COLOR = ConstantParserUtil.NULL_COLOR;

    public Value parseConstant(String _propertyType, String _value) {
        Resolution res;
        if (_value == null) {
            return null;
        }
        if (_propertyType.indexOf("ElementPosition") >= 0) {
            if ((_value = _value.trim().toLowerCase()).equals("centered")) {
                return new IntegerValue(0);
            }
            if (_value.equals("north")) {
                return new IntegerValue(1);
            }
            if (_value.equals("south")) {
                return new IntegerValue(2);
            }
            if (_value.equals("east")) {
                return new IntegerValue(3);
            }
            if (_value.equals("west")) {
                return new IntegerValue(4);
            }
            if (_value.equals("north_east")) {
                return new IntegerValue(5);
            }
            if (_value.equals("north_west")) {
                return new IntegerValue(6);
            }
            if (_value.equals("south_east")) {
                return new IntegerValue(7);
            }
            if (_value.equals("south_west")) {
                return new IntegerValue(8);
            }
            if (_value.equals("hor_centered")) {
                return new IntegerValue(1);
            }
            if (_value.equals("hor_center_down")) {
                return new IntegerValue(1);
            }
            if (_value.equals("hor_center_up")) {
                return new IntegerValue(2);
            }
            if (_value.equals("ver_centered")) {
                return new IntegerValue(4);
            }
            if (_value.equals("ver_center_right")) {
                return new IntegerValue(4);
            }
            if (_value.equals("ver_center_left")) {
                return new IntegerValue(3);
            }
            if (_value.equals("lower_left")) {
                return new IntegerValue(8);
            }
            if (_value.equals("upper_left")) {
                return new IntegerValue(6);
            }
        }
        if (_propertyType.indexOf("MarkerShape") >= 0) {
            if ((_value = _value.trim().toLowerCase()).equals("ellipse")) {
                return new IntegerValue(1);
            }
            if (_value.equals("rectangle")) {
                return new IntegerValue(2);
            }
            if (_value.equals("round_rectangle")) {
                return new IntegerValue(3);
            }
            if (_value.equals("wheel")) {
                return new IntegerValue(4);
            }
            if (_value.equals("none")) {
                return new IntegerValue(0);
            }
            if (_value.equals("filled_circle")) {
                return new IntegerValue(1);
            }
            if (_value.equals("circle")) {
                return new IntegerValue(1);
            }
            if (_value.equals("filled_square")) {
                return new IntegerValue(2);
            }
            if (_value.equals("square")) {
                return new IntegerValue(2);
            }
            if (_value.equals("no_marker")) {
                return new IntegerValue(0);
            }
        }
        if (_propertyType.indexOf("Resolution") >= 0 && (res = ControlDrawable3D.decodeResolution(_value)) != null) {
            return new ObjectValue(res);
        }
        return super.parseConstant(_propertyType, _value);
    }

    public static Resolution decodeResolution(String _value) {
        if ((_value = _value.trim().toLowerCase()).indexOf(46) >= 0) {
            try {
                return Resolution.createDivisions(Double.parseDouble(_value));
            }
            catch (Exception exc) {
                System.out.println("Incorrect double value for resolution");
                exc.printStackTrace();
                return null;
            }
        }
        if (_value.indexOf(44) < 0) {
            try {
                new Resolution(Integer.parseInt(_value));
            }
            catch (Exception exception) {}
            return null;
        }
        try {
            StringTokenizer t = new StringTokenizer(_value, ",");
            int n1 = Integer.parseInt(t.nextToken());
            int n2 = Integer.parseInt(t.nextToken());
            if (t.hasMoreTokens()) {
                return new Resolution(n1, n2, Integer.parseInt(t.nextToken()));
            }
            return new Resolution(n1, n2);
        }
        catch (Exception exc) {
            System.out.println("Incorrect integer values for resolution");
            exc.printStackTrace();
            return null;
        }
    }
}

