/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.displayejs;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.colos.ejs.library.control.ConstantParser;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.swing.ControlDrawable;
import org.colos.ejs.library.control.swing.ControlDrawablesParent;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.dialogs.AutoScaleInspector;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.InteractionEvent;
import org.opensourcephysics.displayejs.InteractionListener;
import org.opensourcephysics.displayejs.InteractionSource;
import org.opensourcephysics.displayejs.InteractionTarget;
import org.opensourcephysics.displayejs.Point3D;

public class ControlDrawingPanel3D
extends ControlDrawablesParent
implements InteractionListener {
    private static final int DP3D_ADDED = 37;
    public static final double TO_RAD = Math.PI / 180;
    protected static final int[] posIndexes = new int[]{9, 10, 11};
    protected static final int[] angleIndexes = new int[]{15, 16};
    protected static final int ZOOM_INDEX = 17;
    protected static final int[] panIndexes = new int[]{18, 19};
    private static final int KEY_INDEX = 31;
    protected DrawingPanel3D drawingPanel3D;
    protected boolean reportDrag = false;
    protected boolean reportViewPoint = false;
    protected double minZ;
    protected double maxZ;
    protected DoubleValue zoomValue;
    protected DoubleValue[] angleValues;
    protected IntegerValue[] panValues;
    protected DoubleValue[] posValues = new DoubleValue[]{new DoubleValue(0.0), new DoubleValue(0.0), new DoubleValue(0.0)};
    private IntegerValue keyPressedValue = new IntegerValue(-1);
    protected boolean autoZ;
    protected boolean zminSet = false;
    protected boolean zmaxSet = false;
    private static ArrayList infoList = null;
    private ControlDrawable selectedDrawable = null;
    private InteractionSource sourceLingered = null;

    protected Component createVisual() {
        this.drawingPanel3D = new DrawingPanel3D();
        this.minX = Double.NaN;
        this.maxX = Double.NaN;
        this.minY = Double.NaN;
        this.maxY = Double.NaN;
        this.minZ = Double.NaN;
        this.maxZ = Double.NaN;
        this.autoX = this.drawingPanel3D.isAutoscaleX();
        this.autoY = this.drawingPanel3D.isAutoscaleY();
        this.autoZ = this.drawingPanel3D.isAutoscaleZ();
        this.angleValues = new DoubleValue[2];
        this.angleValues[0] = new DoubleValue(this.drawingPanel3D.getAlpha());
        this.angleValues[1] = new DoubleValue(this.drawingPanel3D.getBeta());
        this.zoomValue = new DoubleValue(this.drawingPanel3D.getZoom());
        this.panValues = new IntegerValue[2];
        this.panValues[0] = new IntegerValue(this.drawingPanel3D.getPan().x);
        this.panValues[1] = new IntegerValue(this.drawingPanel3D.getPan().y);
        this.drawingPanel3D.setAllowQuickRedraw(true);
        this.drawingPanel3D.addListener(this);
        this.drawingPanel3D.setFocusable(true);
        this.drawingPanel3D.render();
        this.drawingPanel3D.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent _e) {
                ((ControlDrawingPanel3D)ControlDrawingPanel3D.this).keyPressedValue.value = _e.getKeyCode();
                ControlDrawingPanel3D.this.variableChanged(31, ControlDrawingPanel3D.this.keyPressedValue);
                ControlDrawingPanel3D.this.invokeActions(30);
            }

            public void keyReleased(KeyEvent _e) {
                ((ControlDrawingPanel3D)ControlDrawingPanel3D.this).keyPressedValue.value = -1;
                ControlDrawingPanel3D.this.variableChanged(31, ControlDrawingPanel3D.this.keyPressedValue);
            }
        });
        return this.drawingPanel3D;
    }

    protected void updateAutoscale() {
        if (!this.isZoomed) {
            DrawingPanel dPanel = (DrawingPanel)this.getVisual();
            dPanel.setAutoscaleX(this.autoX);
            dPanel.setAutoscaleY(this.autoY);
            this.drawingPanel3D.setAutoscaleZ(this.autoZ);
            this.updateExtrema();
        }
    }

    protected void updateExtrema() {
        if (!this.isZoomed) {
            DrawingPanel dPanel = (DrawingPanel)this.getVisual();
            if (dPanel.isAutoscaleX()) {
                if (this.xminSet || this.xmaxSet) {
                    dPanel.limitAutoscaleX(this.minX, this.maxX);
                }
            } else {
                dPanel.setPreferredMinMaxX(this.minX, this.maxX);
            }
            if (dPanel.isAutoscaleY()) {
                if (this.yminSet || this.ymaxSet) {
                    dPanel.limitAutoscaleY(this.minY, this.maxY);
                }
            } else {
                dPanel.setPreferredMinMaxY(this.minY, this.maxY);
            }
            if (this.drawingPanel3D.isAutoscaleZ()) {
                if (this.zminSet || this.zmaxSet) {
                    this.drawingPanel3D.limitAutoscaleZ(this.minZ, this.maxZ);
                }
            } else {
                this.drawingPanel3D.setPreferredMinMaxZ(this.minZ, this.maxZ);
            }
        }
    }

    protected void checkAutoscaling() {
        DrawingPanel dPanel = (DrawingPanel)this.getVisual();
        if (dPanel.isAutoscaleX() || dPanel.isAutoscaleY() || this.drawingPanel3D.isAutoscaleZ()) {
            this.isZoomed = true;
            AutoScaleInspector plotInspector = new AutoScaleInspector(dPanel);
            plotInspector.setLocationRelativeTo(dPanel);
            plotInspector.updateDisplay();
            plotInspector.setVisible(true);
        }
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("autoscaleX");
            infoList.add("autoscaleY");
            infoList.add("autoscaleZ");
            infoList.add("minimumX");
            infoList.add("maximumX");
            infoList.add("minimumY");
            infoList.add("maximumY");
            infoList.add("minimumZ");
            infoList.add("maximumZ");
            infoList.add("x");
            infoList.add("y");
            infoList.add("z");
            infoList.add("pressaction");
            infoList.add("dragaction");
            infoList.add("action");
            infoList.add("alpha");
            infoList.add("beta");
            infoList.add("zoom");
            infoList.add("panx");
            infoList.add("pany");
            infoList.add("displayMode");
            infoList.add("decoration");
            infoList.add("square");
            infoList.add("cursorMode");
            infoList.add("showCoordinates");
            infoList.add("hideLines");
            infoList.add("quickRedraw");
            infoList.add("xFormat");
            infoList.add("yFormat");
            infoList.add("zFormat");
            infoList.add("keyAction");
            infoList.add("keyPressed");
            infoList.add("enteredAction");
            infoList.add("exitedAction");
            infoList.add("printTarget");
            infoList.add("colorDepth");
            infoList.add("axesLabels");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyCommonName(String _property) {
        if (_property.equals("angle")) {
            return "rotationAngle";
        }
        if (_property.equals("displayMode")) {
            return "projectionMode";
        }
        if (_property.equals("hideLines")) {
            return "removeHiddenLines";
        }
        if (_property.equals("quickRedraw")) {
            return "allowQuickRedraw";
        }
        if (_property.equals("colorDepth")) {
            return "useColorDepth";
        }
        if (_property.equals("decoration")) {
            return "decorationType";
        }
        if (_property.equals("cursorMode")) {
            return "cursorType";
        }
        if (_property.equals("quickRedraw")) {
            return "allowQuickRedraw";
        }
        return super.getPropertyCommonName(_property);
    }

    public String getPropertyInfo(String _property) {
        if (_property.equals("autoscaleX")) {
            return "boolean DEPRECATED";
        }
        if (_property.equals("autoscaleY")) {
            return "boolean";
        }
        if (_property.equals("autoscaleZ")) {
            return "boolean";
        }
        if (_property.equals("minimumX")) {
            return "int|double DEPRECATED";
        }
        if (_property.equals("maximumX")) {
            return "int|double";
        }
        if (_property.equals("minimumY")) {
            return "int|double";
        }
        if (_property.equals("maximumY")) {
            return "int|double";
        }
        if (_property.equals("minimumZ")) {
            return "int|double";
        }
        if (_property.equals("maximumZ")) {
            return "int|double";
        }
        if (_property.equals("x")) {
            return "int|double";
        }
        if (_property.equals("y")) {
            return "int|double";
        }
        if (_property.equals("z")) {
            return "int|double";
        }
        if (_property.equals("action")) {
            return "Action CONSTANT";
        }
        if (_property.equals("pressaction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("dragaction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("alpha")) {
            return "int|double";
        }
        if (_property.equals("beta")) {
            return "int|double";
        }
        if (_property.equals("zoom")) {
            return "int|double";
        }
        if (_property.equals("panx")) {
            return "int|double";
        }
        if (_property.equals("pany")) {
            return "int|double";
        }
        if (_property.equals("displayMode")) {
            return "int|DisplayMode";
        }
        if (_property.equals("decoration")) {
            return "int|Decoration";
        }
        if (_property.equals("square")) {
            return "boolean";
        }
        if (_property.equals("cursorMode")) {
            return "int|CursorMode";
        }
        if (_property.equals("showCoordinates")) {
            return "boolean";
        }
        if (_property.equals("hideLines")) {
            return "boolean";
        }
        if (_property.equals("quickRedraw")) {
            return "boolean";
        }
        if (_property.equals("xFormat")) {
            return "Format|Object|String TRANSLATABLE";
        }
        if (_property.equals("yFormat")) {
            return "Format|Object|String TRANSLATABLE";
        }
        if (_property.equals("zFormat")) {
            return "Format|Object|String TRANSLATABLE";
        }
        if (_property.equals("keyAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("keyPressed")) {
            return "int";
        }
        if (_property.equals("enteredAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("exitedAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("printTarget")) {
            return "String";
        }
        if (_property.equals("colorDepth")) {
            return "boolean";
        }
        if (_property.equals("axesLabels")) {
            return "String TRANSLATABLE";
        }
        if (_property.equals("name")) {
            return "String DEPRECATED CONSTANT";
        }
        return super.getPropertyInfo(_property);
    }

    public ControlElement setProperty(String _property, String _value) {
        if ((_property = _property.trim()).equals("x") || _property.equals("y") || _property.equals("z") || _property.equals("dragaction")) {
            if (_value != null) {
                Value constant = Value.parseConstant(_value, true);
                if (!this.reportDrag) {
                    this.reportDrag = constant == null;
                }
            }
        } else if ((_property.equals("alpha") || _property.equals("beta") || _property.equals("zoom")) && _value != null) {
            Value constant = Value.parseConstant(_value, true);
            if (!this.reportViewPoint) {
                this.reportViewPoint = constant == null;
            }
        }
        return super.setProperty(_property, _value);
    }

    public Value parseConstant(String _propertyType, String _value) {
        if (_value == null) {
            return null;
        }
        if (_propertyType.indexOf("DisplayMode") >= 0) {
            if ((_value = _value.trim().toLowerCase()).equals("perspective")) {
                return new IntegerValue(10);
            }
            if (_value.equals("no_perspective")) {
                return new IntegerValue(12);
            }
            if (_value.equals("planar_xy")) {
                return new IntegerValue(0);
            }
            if (_value.equals("planar_xz")) {
                return new IntegerValue(1);
            }
            if (_value.equals("planar_yz")) {
                return new IntegerValue(2);
            }
        }
        if (_propertyType.indexOf("Decoration") >= 0) {
            if ((_value = _value.trim().toLowerCase()).equals("none")) {
                return new IntegerValue(0);
            }
            if (_value.equals("cube")) {
                return new IntegerValue(2);
            }
            if (_value.equals("axes")) {
                return new IntegerValue(1);
            }
        }
        if (_propertyType.indexOf("CursorMode") >= 0) {
            if ((_value = _value.trim().toLowerCase()).equals("none")) {
                return new IntegerValue(0);
            }
            if (_value.equals("cube")) {
                return new IntegerValue(2);
            }
            if (_value.equals("crosshair")) {
                return new IntegerValue(3);
            }
            if (_value.equals("xyz")) {
                return new IntegerValue(1);
            }
        }
        return super.parseConstant(_propertyType, _value);
    }

    private void setAxesLabels(String _labelsStr) {
        String[] labels = new String[]{"X", "Y", "Z"};
        if (_labelsStr != null) {
            StringTokenizer tkn = new StringTokenizer(_labelsStr, ",;");
            if (tkn.hasMoreTokens()) {
                labels[0] = tkn.nextToken();
            }
            if (tkn.hasMoreTokens()) {
                labels[1] = tkn.nextToken();
            }
            if (tkn.hasMoreTokens()) {
                labels[2] = tkn.nextToken();
            }
        }
        this.drawingPanel3D.setAxesLabels(labels);
    }

    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                this.autoX = _value.getBoolean();
                this.updateAutoscale();
                break;
            }
            case 1: {
                this.autoY = _value.getBoolean();
                this.updateAutoscale();
                break;
            }
            case 2: {
                this.autoZ = _value.getBoolean();
                this.updateAutoscale();
                break;
            }
            case 3: {
                if (_value.getDouble() == this.minX && this.xminSet) break;
                this.minX = _value.getDouble();
                this.xminSet = true;
                this.updateExtrema();
                break;
            }
            case 4: {
                if (_value.getDouble() == this.maxX && this.xmaxSet) break;
                this.maxX = _value.getDouble();
                this.xmaxSet = true;
                this.updateExtrema();
                break;
            }
            case 5: {
                if (_value.getDouble() == this.minY && this.yminSet) break;
                this.minY = _value.getDouble();
                this.yminSet = true;
                this.updateExtrema();
                break;
            }
            case 6: {
                if (_value.getDouble() == this.maxY && this.ymaxSet) break;
                this.maxY = _value.getDouble();
                this.ymaxSet = true;
                this.updateExtrema();
                break;
            }
            case 7: {
                if (_value.getDouble() == this.minZ && this.zminSet) break;
                this.minZ = _value.getDouble();
                this.zminSet = true;
                this.updateExtrema();
                break;
            }
            case 8: {
                if (_value.getDouble() == this.maxZ && this.zmaxSet) break;
                this.maxZ = _value.getDouble();
                this.zmaxSet = true;
                this.updateExtrema();
                break;
            }
            case 9: {
                this.posValues[0].value = _value.getDouble();
                break;
            }
            case 10: {
                this.posValues[1].value = _value.getDouble();
                break;
            }
            case 11: {
                this.posValues[2].value = _value.getDouble();
                break;
            }
            case 12: {
                this.removeAction(10, this.getProperty("pressaction"));
                this.addAction(10, _value.getString());
                break;
            }
            case 13: {
                this.removeAction(1, this.getProperty("dragaction"));
                this.addAction(1, _value.getString());
                break;
            }
            case 14: {
                this.removeAction(0, this.getProperty("action"));
                this.addAction(0, _value.getString());
                break;
            }
            case 15: {
                double angle = _value instanceof IntegerValue ? (double)_value.getInteger() * (Math.PI / 180) : _value.getDouble();
                if (angle == this.angleValues[0].value) break;
                this.angleValues[0].value = angle;
                this.drawingPanel3D.setAlpha(this.angleValues[0].value);
                break;
            }
            case 16: {
                double angle = _value instanceof IntegerValue ? (double)_value.getInteger() * (Math.PI / 180) : _value.getDouble();
                if (angle == this.angleValues[1].value) break;
                this.angleValues[1].value = angle;
                this.drawingPanel3D.setBeta(this.angleValues[1].value);
                break;
            }
            case 17: {
                if (_value.getDouble() == this.zoomValue.value) break;
                this.zoomValue.value = _value.getDouble();
                this.drawingPanel3D.setZoom(this.zoomValue.value);
                break;
            }
            case 18: {
                if (_value.getInteger() == this.panValues[0].value) break;
                this.panValues[0].value = _value.getInteger();
                this.drawingPanel3D.setPan(this.panValues[0].value, this.panValues[1].value);
                break;
            }
            case 19: {
                if (_value.getInteger() == this.panValues[1].value) break;
                this.panValues[1].value = _value.getInteger();
                this.drawingPanel3D.setPan(this.panValues[0].value, this.panValues[1].value);
                break;
            }
            case 20: {
                if (_value.getInteger() == this.drawingPanel3D.getDisplayMode()) break;
                this.drawingPanel3D.setDisplayMode(_value.getInteger());
                break;
            }
            case 21: {
                if (_value.getInteger() == this.drawingPanel3D.getDecorationType()) break;
                this.drawingPanel3D.setDecorationType(_value.getInteger());
                break;
            }
            case 22: {
                if (_value.getBoolean() == this.drawingPanel3D.isSquareAspect()) break;
                this.drawingPanel3D.setSquareAspect(_value.getBoolean());
                break;
            }
            case 23: {
                if (_value.getInteger() == this.drawingPanel3D.getCursorMode()) break;
                this.drawingPanel3D.setCursorMode(_value.getInteger());
                break;
            }
            case 24: {
                this.drawingPanel3D.setShowCoordinates(_value.getBoolean());
                break;
            }
            case 25: {
                this.drawingPanel3D.setRemoveHiddenLines(_value.getBoolean());
                break;
            }
            case 26: {
                this.drawingPanel3D.setAllowQuickRedraw(_value.getBoolean());
                break;
            }
            case 27: {
                if (_value.getObject() instanceof DecimalFormat) {
                    this.drawingPanel3D.setXFormat((DecimalFormat)_value.getObject());
                    break;
                }
                this.drawingPanel3D.setXFormat((DecimalFormat)ConstantParser.formatConstant(_value.getString()).getObject());
                break;
            }
            case 28: {
                if (_value.getObject() instanceof DecimalFormat) {
                    this.drawingPanel3D.setYFormat((DecimalFormat)_value.getObject());
                    break;
                }
                this.drawingPanel3D.setYFormat((DecimalFormat)ConstantParser.formatConstant(_value.getString()).getObject());
                break;
            }
            case 29: {
                if (_value.getObject() instanceof DecimalFormat) {
                    this.drawingPanel3D.setZFormat((DecimalFormat)_value.getObject());
                    break;
                }
                this.drawingPanel3D.setZFormat((DecimalFormat)ConstantParser.formatConstant(_value.getString()).getObject());
                break;
            }
            case 30: {
                this.removeAction(30, this.getProperty("keyAction"));
                this.addAction(30, _value.getString());
                break;
            }
            case 31: {
                this.keyPressedValue.value = _value.getInteger();
                break;
            }
            case 32: {
                this.removeAction(31, this.getProperty("enteredAction"));
                this.addAction(31, _value.getString());
                break;
            }
            case 33: {
                this.removeAction(32, this.getProperty("exitedAction"));
                this.addAction(32, _value.getString());
                break;
            }
            case 34: {
                this.setPrintTarget(_value.getString());
                break;
            }
            case 35: {
                this.drawingPanel3D.setUseColorDepth(_value.getBoolean());
                break;
            }
            case 36: {
                this.setAxesLabels(_value.toString());
                break;
            }
            default: {
                super.setValue(_index - 37, _value);
            }
        }
    }

    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.drawingPanel3D.setAutoscaleX(false);
                this.drawingPanel3D.setPreferredMinMaxX(this.minX, this.maxX);
                break;
            }
            case 1: {
                this.drawingPanel3D.setAutoscaleY(false);
                this.drawingPanel3D.setPreferredMinMaxY(this.minY, this.maxY);
                break;
            }
            case 2: {
                this.drawingPanel3D.setAutoscaleZ(false);
                this.drawingPanel3D.setPreferredMinMaxZ(this.minZ, this.maxZ);
                break;
            }
            case 3: {
                this.minX = 0.0;
                this.drawingPanel3D.setPreferredMinMaxX(0.0, this.maxX);
                break;
            }
            case 4: {
                this.maxX = 1.0;
                this.drawingPanel3D.setPreferredMinMaxX(this.minX, 1.0);
                break;
            }
            case 5: {
                this.minY = 0.0;
                this.drawingPanel3D.setPreferredMinMaxY(0.0, this.maxY);
                break;
            }
            case 6: {
                this.maxY = 1.0;
                this.drawingPanel3D.setPreferredMinMaxY(this.minY, 1.0);
                break;
            }
            case 7: {
                this.minZ = 0.0;
                this.drawingPanel3D.setPreferredMinMaxZ(0.0, this.maxZ);
                break;
            }
            case 8: {
                this.maxZ = 1.0;
                this.drawingPanel3D.setPreferredMinMaxZ(this.minZ, 1.0);
                break;
            }
            case 9: {
                this.posValues[0].value = (this.minX + this.maxX) / 2.0;
                break;
            }
            case 10: {
                this.posValues[1].value = (this.minY + this.maxY) / 2.0;
                break;
            }
            case 11: {
                this.posValues[2].value = (this.minZ + this.maxZ) / 2.0;
                break;
            }
            case 12: {
                this.removeAction(10, this.getProperty("pressaction"));
                break;
            }
            case 13: {
                this.removeAction(1, this.getProperty("dragaction"));
                break;
            }
            case 14: {
                this.removeAction(0, this.getProperty("action"));
                break;
            }
            case 15: {
                this.angleValues[0].value = 0.0;
                this.drawingPanel3D.setAlpha(0.0);
                break;
            }
            case 16: {
                this.angleValues[1].value = 0.0;
                this.drawingPanel3D.setBeta(0.0);
                break;
            }
            case 17: {
                this.zoomValue.value = 1.0;
                this.drawingPanel3D.setZoom(1.0);
                break;
            }
            case 18: {
                this.panValues[0].value = 0;
                this.drawingPanel3D.setPan(0, this.panValues[1].value);
                break;
            }
            case 19: {
                this.panValues[1].value = 0;
                this.drawingPanel3D.setPan(this.panValues[0].value, 0);
                break;
            }
            case 20: {
                this.drawingPanel3D.setDisplayMode(10);
                break;
            }
            case 21: {
                this.drawingPanel3D.setDecorationType(2);
                break;
            }
            case 22: {
                this.drawingPanel3D.setSquareAspect(true);
                break;
            }
            case 23: {
                this.drawingPanel3D.setCursorMode(3);
                break;
            }
            case 24: {
                this.drawingPanel3D.setShowCoordinates(true);
                break;
            }
            case 25: {
                this.drawingPanel3D.setRemoveHiddenLines(true);
                break;
            }
            case 26: {
                this.drawingPanel3D.setAllowQuickRedraw(true);
                break;
            }
            case 27: {
                this.drawingPanel3D.setXFormat(new DecimalFormat("x=0.000;x=-0.000"));
                break;
            }
            case 28: {
                this.drawingPanel3D.setYFormat(new DecimalFormat("y=0.000;y=-0.000"));
                break;
            }
            case 29: {
                this.drawingPanel3D.setZFormat(new DecimalFormat("z=0.000;z=-0.000"));
                break;
            }
            case 30: {
                this.removeAction(30, this.getProperty("keyAction"));
                break;
            }
            case 31: {
                this.keyPressedValue.value = -1;
                break;
            }
            case 32: {
                this.removeAction(31, this.getProperty("enteredAction"));
                break;
            }
            case 33: {
                this.removeAction(32, this.getProperty("exitedAction"));
                break;
            }
            case 34: {
                this.setPrintTarget(null);
                break;
            }
            case 35: {
                this.drawingPanel3D.setUseColorDepth(true);
                break;
            }
            case 36: {
                this.setAxesLabels(null);
                break;
            }
            default: {
                super.setDefaultValue(_index - 37);
            }
        }
    }

    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                return null;
            }
            case 9: {
                return this.posValues[0];
            }
            case 10: {
                return this.posValues[1];
            }
            case 11: {
                return this.posValues[2];
            }
            case 15: {
                return this.angleValues[0];
            }
            case 16: {
                return this.angleValues[1];
            }
            case 17: {
                return this.zoomValue;
            }
            case 18: {
                return this.panValues[0];
            }
            case 19: {
                return this.panValues[1];
            }
            case 31: {
                return this.keyPressedValue;
            }
        }
        return super.getValue(_index - 37);
    }

    public ControlDrawable getSelectedDrawable() {
        return this.selectedDrawable;
    }

    public void setSelectedDrawable(ControlDrawable _dr) {
        this.selectedDrawable = _dr;
    }

    public void interactionPerformed(InteractionEvent _event) {
        if (_event.getTarget() == null) {
            if (_event.getID() == 2003) {
                this.invokeActions(31);
            } else if (_event.getID() == 2004) {
                this.invokeActions(32);
                if (this.sourceLingered != null) {
                    this.sourceLingered.invokeActions(new InteractionEvent((Object)this.sourceLingered, 2004, null, this.sourceLingered));
                }
                this.sourceLingered = null;
            } else if (_event.getID() == 2005) {
                Interactive interactiveDrawableLingered = this.drawingPanel3D.getInteractive();
                if (interactiveDrawableLingered != null) {
                    if (interactiveDrawableLingered instanceof InteractionTarget && this.sourceLingered != ((InteractionTarget)interactiveDrawableLingered).getSource()) {
                        if (this.sourceLingered != null) {
                            this.sourceLingered.invokeActions(new InteractionEvent((Object)this.sourceLingered, 2004, null, this.sourceLingered));
                        }
                        this.sourceLingered = ((InteractionTarget)interactiveDrawableLingered).getSource();
                        this.sourceLingered.invokeActions(new InteractionEvent((Object)this.sourceLingered, 2003, null, interactiveDrawableLingered));
                    }
                } else {
                    if (this.sourceLingered != null) {
                        this.sourceLingered.invokeActions(new InteractionEvent((Object)this.sourceLingered, 2004, null, this.sourceLingered));
                    }
                    this.sourceLingered = null;
                }
            } else if (_event.getID() == 2000) {
                this.invokeActions(10);
            } else if (_event.getID() == 2002) {
                this.invokeActions(0);
            } else if (_event.getID() == 2001) {
                if (this.angleValues[0].value != this.drawingPanel3D.getAlpha() || this.angleValues[1].value != this.drawingPanel3D.getBeta()) {
                    this.angleValues[0].value = this.drawingPanel3D.getAlpha();
                    this.angleValues[1].value = this.drawingPanel3D.getBeta();
                    if (this.reportViewPoint) {
                        this.variablesChanged(angleIndexes, this.angleValues);
                    }
                    if (this.isUnderEjs) {
                        this.setFieldListValues(angleIndexes, this.angleValues);
                    }
                }
                if (this.zoomValue.value != this.drawingPanel3D.getZoom()) {
                    this.zoomValue.value = this.drawingPanel3D.getZoom();
                    if (this.reportViewPoint) {
                        this.variableChanged(17, this.zoomValue);
                    }
                    if (this.isUnderEjs) {
                        this.setFieldListValue(17, this.zoomValue);
                    }
                }
                if (this.panValues[0].value != this.drawingPanel3D.getPan().x || this.panValues[1].value != this.drawingPanel3D.getPan().y) {
                    this.panValues[0].value = this.drawingPanel3D.getPan().x;
                    this.panValues[1].value = this.drawingPanel3D.getPan().y;
                    if (this.reportViewPoint) {
                        this.variablesChanged(panIndexes, this.panValues);
                    }
                    if (this.isUnderEjs) {
                        this.setFieldListValues(panIndexes, this.panValues);
                    }
                }
            }
            return;
        }
        if (!(_event.getTarget() instanceof Point3D)) {
            return;
        }
        Point3D point = (Point3D)_event.getTarget();
        switch (_event.getID()) {
            case 2000: {
                this.drawingPanel3D.requestFocus();
                this.invokeActions(10);
            }
            case 2001: {
                this.posValues[0].value = point.x;
                this.posValues[1].value = point.y;
                this.posValues[2].value = point.z;
                if (this.reportDrag) {
                    this.variablesChanged(posIndexes, this.posValues);
                }
                if (!this.isUnderEjs) break;
                this.setFieldListValues(posIndexes, this.posValues);
                break;
            }
            case 2002: {
                this.invokeActions(0);
            }
        }
    }
}

