/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawables;

import java.awt.Color;
import java.util.ArrayList;
import org.colos.ejs.library.control.DataCollector;
import org.colos.ejs.library.control.swing.ControlDrawable;
import org.colos.ejs.library.control.swing.NeedsPreUpdate;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.ComplexDataset;
import org.opensourcephysics.display.Drawable;

public class ControlComplexDataset
extends ControlDrawable
implements NeedsPreUpdate,
DataCollector {
    private static final int COMPLEXDATASET_ADDED = 11;
    private ComplexDataset dataset;
    protected double x;
    protected double re;
    protected double im;
    protected double[] xArray;
    protected double[] reArray;
    protected double[] imArray;
    protected boolean enabled;
    protected boolean clearAtInput;
    protected Color reColor;
    protected Color imColor;
    protected int isSet = -1;
    private static ArrayList infoList = null;

    protected Drawable createDrawable() {
        this.im = 0.0;
        this.re = 0.0;
        this.x = 0.0;
        this.reColor = Color.BLACK;
        this.imColor = Color.BLUE;
        this.enabled = true;
        this.clearAtInput = true;
        this.dataset = new ComplexDataset();
        this.dataset.setLineColor(this.reColor, this.imColor);
        return this.dataset;
    }

    public void initialize() {
        this.dataset.clear();
    }

    public void reset() {
        this.dataset.clear();
    }

    public void onExit() {
        this.dataset.clear();
    }

    public void preupdate() {
        if (!this.enabled) {
            return;
        }
        switch (this.isSet) {
            case 0: {
                if (this.clearAtInput) {
                    this.dataset.clear();
                }
                this.dataset.append(this.x, this.re, this.im);
                break;
            }
            case 1: {
                if (this.clearAtInput) {
                    this.dataset.clear();
                }
                this.dataset.append(this.xArray, this.reArray, this.imArray);
            }
        }
        this.isSet = -1;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("x");
            infoList.add("real");
            infoList.add("imag");
            infoList.add("realColor");
            infoList.add("imagColor");
            infoList.add("enabled");
            infoList.add("centered");
            infoList.add("connected");
            infoList.add("markersize");
            infoList.add("markershape");
            infoList.add("sorted");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String _property) {
        if (_property.equals("x")) {
            return "int|double|double[]";
        }
        if (_property.equals("real")) {
            return "int|double|double[]";
        }
        if (_property.equals("imag")) {
            return "int|double|double[]";
        }
        if (_property.equals("realColor")) {
            return "Color|Object";
        }
        if (_property.equals("imagColor")) {
            return "Color|Object";
        }
        if (_property.equals("enabled")) {
            return "boolean";
        }
        if (_property.equals("centered")) {
            return "boolean";
        }
        if (_property.equals("connected")) {
            return "boolean";
        }
        if (_property.equals("markersize")) {
            return "int";
        }
        if (_property.equals("markershape")) {
            return "ComplexMarkerShape|int";
        }
        if (_property.equals("sorted")) {
            return "boolean";
        }
        return super.getPropertyInfo(_property);
    }

    public Value parseConstant(String _propertyType, String _value) {
        if (_value == null) {
            return null;
        }
        if (_propertyType.indexOf("ComplexMarkerShape") >= 0) {
            if ((_value = _value.trim().toLowerCase()).equals("amp_curve")) {
                return new IntegerValue(0);
            }
            if (_value.equals("re_im_curve")) {
                return new IntegerValue(1);
            }
            if (_value.equals("phase_curve")) {
                return new IntegerValue(2);
            }
            if (_value.equals("phase_bar")) {
                return new IntegerValue(3);
            }
            if (_value.equals("phase_post")) {
                return new IntegerValue(4);
            }
        }
        return super.parseConstant(_propertyType, _value);
    }

    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                if (_value.getObject() instanceof double[]) {
                    this.xArray = (double[])_value.getObject();
                    this.isSet = 1;
                    break;
                }
                this.x = _value.getDouble();
                this.isSet = 0;
                break;
            }
            case 1: {
                if (_value.getObject() instanceof double[]) {
                    this.reArray = (double[])_value.getObject();
                    this.isSet = 1;
                    break;
                }
                this.re = _value.getDouble();
                this.isSet = 0;
                break;
            }
            case 2: {
                if (_value.getObject() instanceof double[]) {
                    this.imArray = (double[])_value.getObject();
                    this.isSet = 1;
                    break;
                }
                this.im = _value.getDouble();
                this.isSet = 0;
                break;
            }
            case 3: {
                this.reColor = (Color)_value.getObject();
                this.dataset.setLineColor(this.reColor, this.imColor);
                break;
            }
            case 4: {
                this.imColor = (Color)_value.getObject();
                this.dataset.setLineColor(this.reColor, this.imColor);
                break;
            }
            case 5: {
                this.enabled = _value.getBoolean();
                break;
            }
            case 6: {
                this.dataset.setCentered(_value.getBoolean());
                break;
            }
            case 7: {
                this.dataset.setConnected(_value.getBoolean());
                break;
            }
            case 8: {
                this.dataset.setMarkerSize(_value.getInteger());
                break;
            }
            case 9: {
                this.dataset.setMarkerShape(_value.getInteger());
                break;
            }
            case 10: {
                this.dataset.setSorted(_value.getBoolean());
                break;
            }
            default: {
                super.setValue(_index - 11, _value);
            }
        }
    }

    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.x = 0.0;
                this.isSet = -1;
                break;
            }
            case 1: {
                this.re = 0.0;
                this.isSet = -1;
                break;
            }
            case 2: {
                this.im = 0.0;
                this.isSet = -1;
                break;
            }
            case 3: {
                this.reColor = Color.BLACK;
                this.dataset.setLineColor(this.reColor, this.imColor);
                break;
            }
            case 4: {
                this.imColor = Color.BLUE;
                this.dataset.setLineColor(this.reColor, this.imColor);
                break;
            }
            case 5: {
                this.enabled = true;
                break;
            }
            case 6: {
                this.dataset.setCentered(true);
                break;
            }
            case 7: {
                this.dataset.setConnected(true);
                break;
            }
            case 8: {
                this.dataset.setMarkerSize(5);
                break;
            }
            case 9: {
                this.dataset.setMarkerShape(2);
                break;
            }
            case 10: {
                this.dataset.setSorted(false);
                break;
            }
            default: {
                super.setDefaultValue(_index - 11);
            }
        }
    }

    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: 
            case 1: 
            case 2: {
                return "<none>";
            }
            case 3: {
                return "BLACK";
            }
            case 4: {
                return "BLUE";
            }
            case 5: {
                return "true";
            }
            case 6: {
                return "true";
            }
            case 7: {
                return "true";
            }
            case 8: {
                return "5";
            }
            case 9: {
                return "PHASE_CURVE";
            }
            case 10: {
                return "false";
            }
        }
        return super.getDefaultValueString(_index - 11);
    }

    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return null;
            }
        }
        return super.getValue(_index - 11);
    }
}

