/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.ObjectValue;
import org.colos.ejs.library.control.value.StringValue;
import org.colos.ejs.library.control.value.Value;

public class ConstantParser
extends org.colos.ejs.library.control.ConstantParser {
    public static String toString(Point p) {
        return "\"" + p.x + "," + p.y + "\"";
    }

    public static String toString(Dimension d) {
        return "\"" + d.width + "," + d.height + "\"";
    }

    public static Value pointConstant(String _value) {
        if ((_value = _value.trim().toLowerCase()).startsWith("\"") && _value.endsWith("\"")) {
            _value = _value.substring(1, _value.length() - 1);
        }
        if ("center".equals(_value)) {
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            return new ObjectValue(new Point(d.width / 2, d.height / 2));
        }
        if (_value.indexOf(44) < 0) {
            return null;
        }
        try {
            StringTokenizer t = new StringTokenizer(_value, ",");
            int x = Integer.parseInt(t.nextToken());
            int y = Integer.parseInt(t.nextToken());
            return new ObjectValue(new Point(x, y));
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static Value dimensionConstant(String _value) {
        if ((_value = _value.trim().toLowerCase()).startsWith("\"") && _value.endsWith("\"")) {
            _value = _value.substring(1, _value.length() - 1);
        }
        if ("pack".equals(_value)) {
            return new StringValue("pack");
        }
        if (_value.indexOf(44) < 0) {
            return null;
        }
        try {
            StringTokenizer t = new StringTokenizer(_value, ",");
            int w = Integer.parseInt(t.nextToken());
            int h = Integer.parseInt(t.nextToken());
            return new ObjectValue(new Dimension(w, h));
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static Value placementConstant(String _value) {
        if ((_value = _value.trim().toLowerCase()).equals("bottom")) {
            return new IntegerValue(3);
        }
        if (_value.equals("left")) {
            return new IntegerValue(2);
        }
        if (_value.equals("right")) {
            return new IntegerValue(4);
        }
        if (_value.equals("top")) {
            return new IntegerValue(1);
        }
        return null;
    }

    public static Value layoutConstant(Container _container, String _value) {
        StringTokenizer tkn = new StringTokenizer(_value = _value.trim().toLowerCase(), ":, ");
        String type = tkn.nextToken();
        if (type.equals("flow")) {
            if (tkn.hasMoreTokens()) {
                try {
                    String alignStr = tkn.nextToken();
                    int align = alignStr.equals("left") ? 0 : (alignStr.equals("right") ? 2 : 1);
                    if (tkn.hasMoreTokens()) {
                        int hgap = Integer.parseInt(tkn.nextToken());
                        int vgap = Integer.parseInt(tkn.nextToken());
                        return new ObjectValue(new FlowLayout(align, hgap, vgap));
                    }
                    return new ObjectValue(new FlowLayout(align));
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
            return new ObjectValue(new FlowLayout());
        }
        if (type.equals("grid")) {
            if (tkn.hasMoreTokens()) {
                try {
                    int rows = Integer.parseInt(tkn.nextToken());
                    int cols = Integer.parseInt(tkn.nextToken());
                    if (tkn.hasMoreTokens()) {
                        int hgap = Integer.parseInt(tkn.nextToken());
                        int vgap = Integer.parseInt(tkn.nextToken());
                        return new ObjectValue(new GridLayout(rows, cols, hgap, vgap));
                    }
                    return new ObjectValue(new GridLayout(rows, cols));
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
            return new ObjectValue(new GridLayout());
        }
        if (type.equals("border")) {
            if (tkn.hasMoreTokens()) {
                try {
                    int hgap = Integer.parseInt(tkn.nextToken());
                    int vgap = Integer.parseInt(tkn.nextToken());
                    return new ObjectValue(new BorderLayout(hgap, vgap));
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
            return new ObjectValue(new BorderLayout());
        }
        if (type.equals("hbox")) {
            return new ObjectValue(new BoxLayout(_container, 0));
        }
        if (type.equals("vbox")) {
            return new ObjectValue(new BoxLayout(_container, 1));
        }
        return null;
    }

    public static Value constraintsConstant(String _value) {
        if ((_value = _value.trim().toLowerCase()).equals("north")) {
            return new StringValue("North");
        }
        if (_value.equals("south")) {
            return new StringValue("South");
        }
        if (_value.equals("east")) {
            return new StringValue("East");
        }
        if (_value.equals("west")) {
            return new StringValue("West");
        }
        if (_value.equals("center")) {
            return new StringValue("Center");
        }
        return new StringValue("Center");
    }

    public static Value orientationConstant(String _value) {
        if ((_value = _value.trim().toLowerCase()).equals("vertical")) {
            return new IntegerValue(1);
        }
        return new IntegerValue(0);
    }

    public static Value alignmentConstant(String _value) {
        if ((_value = _value.trim().toLowerCase()).indexOf("top") != -1) {
            return new IntegerValue(1);
        }
        if (_value.indexOf("center") != -1) {
            return new IntegerValue(0);
        }
        if (_value.indexOf("bottom") != -1) {
            return new IntegerValue(3);
        }
        if (_value.indexOf("left") != -1) {
            return new IntegerValue(2);
        }
        if (_value.indexOf("right") != -1) {
            return new IntegerValue(4);
        }
        if (_value.indexOf("leading") != -1) {
            return new IntegerValue(10);
        }
        if (_value.indexOf("trailing") != -1) {
            return new IntegerValue(11);
        }
        return new IntegerValue(0);
    }
}

