/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.value.ObjectValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.ArrayPanel;

public class ControlArrayPanel
extends ControlSwingElement {
    private static final int ARRAY_PANEL_ADDED = 11;
    protected ArrayPanel panel;
    private boolean isStatic;
    protected ObjectValue dataValue;
    private static ArrayList infoList = null;

    protected Component createVisual() {
        this.panel = new ArrayPanel();
        double[][] emptyData = new double[][]{{0.0, 0.0}, {0.0, 0.0}};
        this.panel.setArray((Object)emptyData);
        this.dataValue = new ObjectValue(emptyData);
        this.panel.setNumericFormat("0.00;-0.00");
        this.panel.setRowNumberVisible(true);
        this.panel.setEditable(true);
        this.panel.setFirstRowIndex(0);
        this.panel.setFirstColIndex(0);
        this.isStatic = false;
        this.panel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent pce) {
                if (pce.getPropertyName().equals("cell")) {
                    ControlArrayPanel.this.variableChanged(0, ControlArrayPanel.this.dataValue);
                    if (ControlArrayPanel.this.isUnderEjs) {
                        ControlArrayPanel.this.setFieldListValue(0, ControlArrayPanel.this.dataValue);
                    }
                }
            }
        });
        return this.panel;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("data");
            infoList.add("action");
            infoList.add("format");
            infoList.add("showRowNumber");
            infoList.add("columnNames");
            infoList.add("firstRowIndex");
            infoList.add("firstColIndex");
            infoList.add("editable");
            infoList.add("columnsLocked");
            infoList.add("static");
            infoList.add("transposed");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String _property) {
        if (_property.equals("data")) {
            return "int[]|int[][]|int[][][]|double[]|double[][]|double[][][]|boolean[]|boolean[][]|boolean[][][]|String[]|String[][]|String[][][]|Object";
        }
        if (_property.equals("action")) {
            return "Action CONSTANT";
        }
        if (_property.equals("format")) {
            return "String  TRANSLATABLE";
        }
        if (_property.equals("showRowNumber")) {
            return "boolean";
        }
        if (_property.equals("columnNames")) {
            return "String[] TRANSLATABLE";
        }
        if (_property.equals("firstRowIndex")) {
            return "int";
        }
        if (_property.equals("firstColIndex")) {
            return "int";
        }
        if (_property.equals("editable")) {
            return "boolean";
        }
        if (_property.equals("columnsLocked")) {
            return "boolean[]";
        }
        if (_property.equals("static")) {
            return "boolean";
        }
        if (_property.equals("transposed")) {
            return "boolean";
        }
        return super.getPropertyInfo(_property);
    }

    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                Object arrayObj = _value.getObject();
                if (arrayObj != null && arrayObj != this.panel.getArray()) {
                    this.panel.setArray(arrayObj);
                    this.dataValue.value = arrayObj;
                    break;
                }
                this.panel.setFirstRowIndex(this.panel.getFirstRowIndex());
                if (this.isStatic) break;
                this.panel.refreshTable();
                break;
            }
            case 1: {
                this.removeAction(1, this.getProperty("action"));
                this.addAction(1, _value.getString());
                break;
            }
            case 2: {
                this.panel.setNumericFormat(_value.getString());
                break;
            }
            case 3: {
                this.panel.setRowNumberVisible(_value.getBoolean());
                break;
            }
            case 4: {
                this.panel.setColumnNames((String[])_value.getObject());
                break;
            }
            case 5: {
                this.panel.setFirstRowIndex(_value.getInteger());
                break;
            }
            case 6: {
                this.panel.setFirstColIndex(_value.getInteger());
                break;
            }
            case 7: {
                this.panel.setEditable(_value.getBoolean());
                break;
            }
            case 8: {
                if (!(_value.getObject() instanceof boolean[])) break;
                boolean[] array = (boolean[])_value.getObject();
                int i = 0;
                int n = array.length;
                while (i < n) {
                    this.panel.setColumnLock(i, array[i]);
                    ++i;
                }
                break;
            }
            case 9: {
                this.isStatic = _value.getBoolean();
                break;
            }
            case 10: {
                this.panel.setTransposed(_value.getBoolean());
                break;
            }
            default: {
                super.setValue(_index - 11, _value);
            }
        }
    }

    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.panel.setArray((Object)new double[][]{{0.0, 0.0}, {0.0, 0.0}});
                break;
            }
            case 1: {
                this.removeAction(1, this.getProperty("action"));
                break;
            }
            case 2: {
                this.panel.setNumericFormat("0.00;-0.00");
                break;
            }
            case 3: {
                this.panel.setRowNumberVisible(true);
                break;
            }
            case 4: {
                this.panel.setColumnNames(null);
                break;
            }
            case 5: {
                this.panel.setFirstRowIndex(0);
                break;
            }
            case 6: {
                this.panel.setFirstColIndex(0);
                break;
            }
            case 7: {
                this.panel.setEditable(true);
                break;
            }
            case 8: {
                int i = 0;
                int n = this.panel.getNumColumns();
                while (i < n) {
                    this.panel.setColumnLock(i, true);
                    ++i;
                }
                break;
            }
            case 9: {
                this.isStatic = false;
                break;
            }
            case 10: {
                this.panel.setTransposed(false);
                break;
            }
            default: {
                super.setDefaultValue(_index - 11);
            }
        }
    }

    public Value getValue(int _index) {
        switch (_index) {
            case 0: {
                return this.dataValue;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return null;
            }
        }
        return super.getValue(_index - 11);
    }

    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return "{{0.0,0.0},{0.0,0.0}}";
            }
            case 1: {
                return "<no_action>";
            }
            case 2: {
                return "0.00;-0.00";
            }
            case 3: {
                return "true";
            }
            case 4: {
                return "<none>";
            }
            case 5: {
                return "0";
            }
            case 6: {
                return "0";
            }
            case 7: {
                return "true";
            }
            case 8: {
                return "true";
            }
            case 9: {
                return "false";
            }
            case 10: {
                return "false";
            }
        }
        return super.getDefaultValueString(_index - 11);
    }
}

