/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.swing.ConstantParser;
import org.colos.ejs.library.control.swing.ControlMenuBar;
import org.colos.ejs.library.control.swing.ControlRadioButton;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.value.BooleanValue;

public abstract class ControlContainer
extends ControlSwingElement {
    private static final BooleanValue falseValue = new BooleanValue(false);
    protected Vector radioButtons = new Vector();
    protected Vector children = new Vector();

    public Container getContainer() {
        return (Container)this.getVisual();
    }

    public boolean acceptsChild(ControlElement _child) {
        if (_child instanceof ControlMenuBar) {
            return false;
        }
        return _child instanceof ControlSwingElement;
    }

    public void add(ControlElement _child) {
        this.children.add(_child);
        Container container = this.getContainer();
        LayoutManager layout = container.getLayout();
        String indexInParent = _child.getProperty("_ejs_indexInParent_");
        int index = -1;
        if (indexInParent != null) {
            index = Integer.parseInt(indexInParent);
        }
        _child.setProperty("_ejs_indexInParent_", null);
        if (layout instanceof BorderLayout) {
            String pos = _child.getProperty("position");
            if (pos != null) {
                container.add(_child.getComponent(), ConstantParser.constraintsConstant(pos).getString(), index);
            } else {
                container.add(_child.getComponent(), "Center", index);
            }
        } else {
            container.add(_child.getComponent(), index);
        }
        this.adjustSize();
        if (_child instanceof ControlRadioButton) {
            this.radioButtons.add(_child);
            ((ControlRadioButton)_child).setParent(this);
        }
        this.propagateProperty(_child, "font", this.getPropagatedProperty("font"));
        this.propagateProperty(_child, "foreground", this.getPropagatedProperty("foreground"));
        this.propagateProperty(_child, "background", this.getPropagatedProperty("background"));
    }

    protected void adjustChildren() {
        Container container = this.getContainer();
        if (container.getLayout() instanceof BorderLayout) {
            container.removeAll();
            ArrayList<String> freeSlots = new ArrayList<String>();
            freeSlots.add("center");
            freeSlots.add("north");
            freeSlots.add("south");
            freeSlots.add("east");
            freeSlots.add("west");
            Enumeration childList = this.children.elements();
            while (childList.hasMoreElements()) {
                ControlElement child = (ControlElement)childList.nextElement();
                String pos = child.getProperty("position");
                if (pos == null) {
                    pos = (String)freeSlots.get(0);
                }
                if (pos == null) {
                    pos = "center";
                } else {
                    freeSlots.remove(pos);
                }
                container.add(child.getComponent(), ConstantParser.constraintsConstant(pos).getString(), -1);
            }
        }
    }

    public void adjustSize() {
        this.getContainer().validate();
        this.getContainer().repaint();
        ControlContainer.resizeContainer(this.getContainer());
        ControlContainer.resizeContainer(this.getComponent().getParent());
    }

    private static void resizeContainer(Container _container) {
        if (_container == null) {
            return;
        }
        Rectangle b = _container.getBounds();
        _container.setBounds(b.x, b.y, b.width + 1, b.height + 1);
        _container.setBounds(b.x, b.y, b.width, b.height);
        _container.validate();
        _container.repaint();
    }

    public Vector getChildren() {
        return this.children;
    }

    public void remove(ControlElement _child) {
        this.children.remove(_child);
        Container container = this.getContainer();
        container.remove(_child.getComponent());
        container.validate();
        container.repaint();
        if (_child instanceof ControlRadioButton) {
            this.radioButtons.remove(_child);
            ((ControlRadioButton)_child).setParent(null);
        }
    }

    public void informRadioGroup(ControlRadioButton _source, boolean _state) {
        if (!_state) {
            return;
        }
        Enumeration e = this.radioButtons.elements();
        while (e.hasMoreElements()) {
            ControlRadioButton rb = (ControlRadioButton)e.nextElement();
            if (rb == _source) continue;
            boolean wasActive = rb.isActive();
            rb.setActive(false);
            rb.setValue(_source.getVariableIndex(), falseValue);
            rb.reportChanges();
            rb.setActive(wasActive);
        }
    }

    protected void propagateProperty(ControlElement _child, String _property, String _value) {
        if (_child.getProperty(_property) == null) {
            _child.setProperty(_property, _value, false);
        }
    }

    protected void propagateProperty(String _property, String _value) {
        int i = 0;
        while (i < this.children.size()) {
            this.propagateProperty((ControlElement)this.children.elementAt(i), _property, _value);
            ++i;
        }
    }

    protected String getPropagatedProperty(String _property) {
        String prop = this.getProperty(_property);
        if (prop != null) {
            return prop;
        }
        ControlElement parent = this.myGroup.getElement(this.getProperty("parent"));
        if (parent != null && parent instanceof ControlContainer) {
            return ((ControlContainer)parent).getPropagatedProperty(_property);
        }
        return null;
    }

    public ControlElement setProperty(String _property, String _value, boolean _store) {
        ControlElement returnValue = super.setProperty(_property, _value, _store);
        if (_property.equals("font") || _property.equals("foreground") || _property.equals("background")) {
            this.propagateProperty(_property, _value);
        }
        return returnValue;
    }
}

