/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.NeedsUpdate;
import org.colos.ejs.library.control.swing.ControlDrawable;
import org.colos.ejs.library.control.swing.ControlParentOfDrawables;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.swing.NeedsPreUpdate;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.MouseController;
import org.opensourcephysics.display.dialogs.AutoScaleInspector;
import org.opensourcephysics.display.dialogs.ScaleInspector;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.InteractivePoligon;
import org.opensourcephysics.displayejs.InteractiveTrace;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.FourierTool;

public abstract class ControlDrawablesParent
extends ControlSwingElement
implements NeedsUpdate,
ControlParentOfDrawables {
    protected Vector preupdateList = new Vector();
    private String printTarget = null;
    protected boolean isZoomed = false;
    protected double minX;
    protected double maxX;
    protected double minY;
    protected double maxY;
    protected boolean autoX;
    protected boolean autoY;
    protected boolean enableMenu = true;
    protected boolean xminSet = false;
    protected boolean xmaxSet = false;
    protected boolean yminSet = false;
    protected boolean ymaxSet = false;

    public ControlDrawablesParent() {
        this.getVisual().addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent _e) {
                if (_e.isControlDown() && ControlDrawablesParent.this.getSimulation() != null) {
                    if (_e.getKeyCode() == 77) {
                        ControlDrawablesParent.this.getPopupMenu(0, 0);
                    } else if (_e.getKeyCode() == 80) {
                        ControlDrawablesParent.this.printScreen();
                    }
                }
            }
        });
        this.getVisual().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent _e) {
                if (!ControlDrawablesParent.this.enableMenu) {
                    return;
                }
                if (SwingUtilities.isRightMouseButton(_e) && ControlDrawablesParent.this.getSimulation() != null) {
                    Interactive interactive = ((InteractivePanel)ControlDrawablesParent.this.getVisual()).getInteractive();
                    if (interactive != null) {
                        if (interactive instanceof InteractiveTrace) {
                            ((InteractiveTrace)interactive).showPopup(ControlDrawablesParent.this.getVisual(), _e.getX(), _e.getY());
                        } else if (interactive instanceof InteractivePoligon) {
                            ((InteractivePoligon)interactive).showPopup(ControlDrawablesParent.this.getVisual(), _e.getX(), _e.getY());
                        }
                    } else {
                        ControlDrawablesParent.this.getPopupMenu(_e.getX(), _e.getY());
                    }
                }
            }
        });
    }

    public String getPropertyCommonName(String _property) {
        if (_property.equals("pressaction")) {
            return "pressAction";
        }
        if (_property.equals("dragaction")) {
            return "dragAction";
        }
        if (_property.equals("action")) {
            return "releaseAction";
        }
        return super.getPropertyCommonName(_property);
    }

    public void addMenuEntries() {
        if (this.getVisual() instanceof DrawingPanel3D) {
            return;
        }
        if (this.getMenuNameEntry() == null) {
            return;
        }
        JMenuItem scales = new JMenuItem("tools_res:MenuItem.Scale");
        scales.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent _evt) {
                ControlDrawablesParent.this.isZoomed = true;
                ScaleInspector plotInspector = new ScaleInspector((DrawingPanel)ControlDrawablesParent.this.getVisual());
                plotInspector.setLocationRelativeTo((DrawingPanel)ControlDrawablesParent.this.getVisual());
                plotInspector.updateDisplay();
                plotInspector.setVisible(true);
            }
        });
        scales.setActionCommand("tools_res:MenuItem.Scale");
        JMenuItem zoomIn = new JMenuItem("tools_res:MenuItem.ZoomIn");
        zoomIn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent _evt) {
                ControlDrawablesParent.this.checkAutoscaling();
                new ZoomController();
            }
        });
        zoomIn.setActionCommand("tools_res:MenuItem.ZoomIn");
        JMenuItem zoomOut = new JMenuItem("tools_res:MenuItem.ZoomOut");
        zoomOut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent _evt) {
                ControlDrawablesParent.this.checkAutoscaling();
                double xmin = ((DrawingPanel)ControlDrawablesParent.this.getVisual()).getXMin();
                double xmax = ((DrawingPanel)ControlDrawablesParent.this.getVisual()).getXMax();
                double ymin = ((DrawingPanel)ControlDrawablesParent.this.getVisual()).getYMin();
                double ymax = ((DrawingPanel)ControlDrawablesParent.this.getVisual()).getYMax();
                double dx = xmax - xmin;
                double dy = ymax - ymin;
                ControlDrawablesParent.this.isZoomed = true;
                if (!((DrawingPanel)ControlDrawablesParent.this.getVisual()).isAutoscaleX()) {
                    ((DrawingPanel)ControlDrawablesParent.this.getVisual()).setPreferredMinMaxX(xmin - dx / 2.0, xmax + dx / 2.0);
                }
                if (!((DrawingPanel)ControlDrawablesParent.this.getVisual()).isAutoscaleY()) {
                    ((DrawingPanel)ControlDrawablesParent.this.getVisual()).setPreferredMinMaxY(ymin - dy / 2.0, ymax + dy / 2.0);
                }
                ControlDrawablesParent.this.update();
            }
        });
        zoomOut.setActionCommand("tools_res:MenuItem.ZoomOut");
        JMenuItem zoomCancel = new JMenuItem("tools_res:MenuItem.ZoomCancel");
        zoomCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent _evt) {
                ControlDrawablesParent.this.isZoomed = false;
                ControlDrawablesParent.this.updateAutoscale();
                ControlDrawablesParent.this.update();
                ((DrawingPanel)ControlDrawablesParent.this.getVisual()).render();
            }
        });
        zoomCancel.setActionCommand("tools_res:MenuItem.ZoomCancel");
        JMenu zoomMenu = new JMenu("tools_res:MenuItem.Zoom");
        zoomMenu.setActionCommand("tools_res:MenuItem.Zoom");
        zoomMenu.add(scales);
        zoomMenu.add(zoomIn);
        zoomMenu.add(zoomOut);
        zoomMenu.add(zoomCancel);
        final JCheckBoxMenuItem textAliasItem = new JCheckBoxMenuItem("display_res:DrawingFrame.Text_checkbox_label", false);
        textAliasItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((DrawingPanel)ControlDrawablesParent.this.getVisual()).setAntialiasTextOn(textAliasItem.isSelected());
                ((DrawingPanel)ControlDrawablesParent.this.getVisual()).invalidateImage();
                ((DrawingPanel)ControlDrawablesParent.this.getVisual()).repaint();
            }
        });
        textAliasItem.setActionCommand("display_res:DrawingFrame.Text_checkbox_label");
        final JCheckBoxMenuItem shapeAliasItem = new JCheckBoxMenuItem("display_res:DrawingFrame.Drawing_textbox_label", false);
        shapeAliasItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((DrawingPanel)ControlDrawablesParent.this.getVisual()).setAntialiasShapeOn(shapeAliasItem.isSelected());
                ((DrawingPanel)ControlDrawablesParent.this.getVisual()).invalidateImage();
                ((DrawingPanel)ControlDrawablesParent.this.getVisual()).repaint();
            }
        });
        shapeAliasItem.setActionCommand("display_res:DrawingFrame.Drawing_textbox_label");
        JMenu aliasMenu = new JMenu("display_res:DrawingFrame.AntiAlias_menu_title");
        aliasMenu.add(textAliasItem);
        aliasMenu.add(shapeAliasItem);
        aliasMenu.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                textAliasItem.setSelected(((DrawingPanel)ControlDrawablesParent.this.getVisual()).isAntialiasTextOn());
                shapeAliasItem.setSelected(((DrawingPanel)ControlDrawablesParent.this.getVisual()).isAntialiasShapeOn());
            }
        });
        aliasMenu.setActionCommand("display_res:DrawingFrame.AntiAlias_menu_title");
        JMenuItem dataToolItem = new JMenuItem("tools_res:DataTool.Frame.Title");
        dataToolItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ControlDrawablesParent.showDataTool((DrawingPanel)ControlDrawablesParent.this.getVisual(), false);
            }
        });
        dataToolItem.setActionCommand("tools_res:DataTool.Frame.Title");
        JMenuItem fourierToolItem = new JMenuItem("tools_res:FourierTool.Frame.Title");
        fourierToolItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ControlDrawablesParent.showDataTool((DrawingPanel)ControlDrawablesParent.this.getVisual(), true);
            }
        });
        fourierToolItem.setActionCommand("tools_res:FourierTool.Frame.Title");
        ArrayList<JMenuItem> menuEntries = new ArrayList<JMenuItem>();
        menuEntries.add(zoomMenu);
        menuEntries.add(aliasMenu);
        menuEntries.add(dataToolItem);
        menuEntries.add(fourierToolItem);
        this.getSimulation().addElementMenuEntries(this.getMenuNameEntry(), menuEntries);
    }

    public static void showDataTool(DrawingPanel _panel, boolean fourier) {
        DataTool tool = fourier ? new FourierTool() : new DataTool();
        boolean added = false;
        for (Drawable drawable : _panel.getDrawables()) {
            ArrayList set;
            if (!(drawable instanceof Data) || (set = ((Data)((Object)drawable)).getDatasets()) == null || set.size() <= 0) continue;
            added = true;
            for (Dataset dataset : set) {
                tool.addTab(dataset, dataset.getName());
            }
        }
        if (added) {
            tool.setVisible(true);
        }
    }

    public DrawingPanel getDrawingPanel() {
        return (DrawingPanel)this.getVisual();
    }

    public void reset() {
        this.isZoomed = false;
        this.updateAutoscale();
        if (this.isUnderEjs) {
            ((DrawingPanel)this.getVisual()).setBuffered(false);
        }
    }

    protected void updateAutoscale() {
        if (!this.isZoomed) {
            DrawingPanel dPanel = (DrawingPanel)this.getVisual();
            dPanel.setAutoscaleX(this.autoX);
            dPanel.setAutoscaleY(this.autoY);
            this.updateExtrema();
        }
    }

    protected void updateExtrema() {
        if (!this.isZoomed) {
            DrawingPanel dPanel = (DrawingPanel)this.getVisual();
            if (dPanel.isAutoscaleX()) {
                if (this.xminSet || this.xmaxSet) {
                    dPanel.limitAutoscaleX(this.minX, this.maxX);
                }
            } else {
                dPanel.setPreferredMinMaxX(this.minX, this.maxX);
            }
            if (dPanel.isAutoscaleY()) {
                if (this.yminSet || this.ymaxSet) {
                    dPanel.limitAutoscaleY(this.minY, this.maxY);
                }
            } else {
                dPanel.setPreferredMinMaxY(this.minY, this.maxY);
            }
        }
    }

    protected void checkAutoscaling() {
        DrawingPanel dPanel = (DrawingPanel)this.getVisual();
        if (dPanel.isAutoscaleX() || dPanel.isAutoscaleY()) {
            this.isZoomed = true;
            AutoScaleInspector plotInspector = new AutoScaleInspector(dPanel);
            plotInspector.setLocationRelativeTo(dPanel);
            plotInspector.updateDisplay();
            plotInspector.setVisible(true);
        }
    }

    public boolean acceptsChild(ControlElement _child) {
        return _child instanceof ControlDrawable;
    }

    public void setPrintTarget(String _target) {
        this.printTarget = _target;
    }

    protected void getPopupMenu(int x, int y) {
        if (this.printTarget == null) {
            this.getSimulation().getPopupMenu(this.getVisual(), x, y, this.getProperty("name"));
        } else {
            this.getSimulation().getPopupMenu(this.getVisual(), x, y, this.printTarget);
        }
    }

    private void printScreen() {
        if (this.printTarget == null) {
            this.getSimulation().saveImage(this.getProperty("name"));
        } else {
            this.getSimulation().saveImage(this.printTarget);
        }
    }

    public void update() {
        Enumeration e = this.preupdateList.elements();
        while (e.hasMoreElements()) {
            ((NeedsPreUpdate)e.nextElement()).preupdate();
        }
        if (this.myGroup != null && this.myGroup.isCollectingData()) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread() || Thread.currentThread().getName().equals("main")) {
            ((DrawingPanel)this.getVisual()).invalidateImage();
            ((DrawingPanel)this.getVisual()).repaint();
        } else {
            ((DrawingPanel)this.getVisual()).render();
        }
    }

    public Component getComponent() {
        return this.getVisual();
    }

    public void addToPreupdateList(NeedsPreUpdate _child) {
        this.preupdateList.add(_child);
    }

    public void removeFromPreupdateList(NeedsPreUpdate _child) {
        this.preupdateList.remove(_child);
    }

    public void addDrawable(Drawable _drawable) {
        ((DrawingPanel)this.getVisual()).addDrawable(_drawable);
    }

    public void removeDrawable(Drawable _drawable) {
        ((DrawingPanel)this.getVisual()).removeDrawable(_drawable);
    }

    public ControlDrawable getSelectedDrawable() {
        return null;
    }

    class ZoomController
    extends MouseController {
        ZoomController() {
            DrawingPanel dPanel = (DrawingPanel)ControlDrawablesParent.this.getVisual();
            dPanel.addMouseListener(this);
            dPanel.addMouseMotionListener(this);
            dPanel.getZoomBox().prepareZoom();
        }

        public void mousePressed(MouseEvent e) {
            ((DrawingPanel)ControlDrawablesParent.this.getVisual()).getZoomBox().startZoom(e.getX(), e.getY());
        }

        public void mouseDragged(MouseEvent e) {
            ((DrawingPanel)ControlDrawablesParent.this.getVisual()).getZoomBox().drag(e.getX(), e.getY());
        }

        public void mouseReleased(MouseEvent e) {
            DrawingPanel dPanel = (DrawingPanel)ControlDrawablesParent.this.getVisual();
            Rectangle2D.Double rect = ((DrawingPanel)ControlDrawablesParent.this.getVisual()).getZoomBox().reportZoom(e.getX(), e.getY());
            dPanel.removeMouseListener(this);
            dPanel.removeMouseMotionListener(this);
            if (rect != null) {
                ControlDrawablesParent.this.isZoomed = true;
                if (!dPanel.isAutoscaleX()) {
                    dPanel.setPreferredMinMaxX(rect.x, rect.x + rect.width);
                }
                if (!dPanel.isAutoscaleY()) {
                    dPanel.setPreferredMinMaxY(rect.y, rect.y + rect.height);
                }
                ControlDrawablesParent.this.update();
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }
    }
}

