/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.swing.ControlMenuBar;
import org.colos.ejs.library.control.swing.ControlWindow;
import org.colos.ejs.library.control.value.BooleanValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.tools.ResourceLoader;

public class ControlFrame
extends ControlWindow {
    private static final int FRAME_ADDED = 6;
    private static final int NAME = 11;
    protected JFrame frame;
    protected String iconImageFile = null;
    private static ArrayList infoList = null;

    protected Component createVisual() {
        this.startingup = true;
        this.frame = new JFrame();
        this.frame.getContentPane().setLayout(new BorderLayout());
        Image image = ResourceLoader.getImage(String.valueOf(Simulation.getPathToLibrary()) + "_ejs_library/images/EjsMainIcon.gif");
        if (image != null) {
            this.frame.setIconImage(image);
        }
        this.frame.setDefaultCloseOperation(1);
        this.internalValue = new BooleanValue(true);
        return this.frame.getContentPane();
    }

    public String getObjectClassname() {
        return "java.awt.Component";
    }

    public Object getObject() {
        return this.frame;
    }

    protected void whenClosing() {
        super.whenClosing();
        if (this.frame.getDefaultCloseOperation() == 3 || this.frame.getDefaultCloseOperation() == 2) {
            this.invokeActions();
        }
    }

    protected int getVisibleIndex() {
        return 15;
    }

    protected int getLocationIndex() {
        return 7;
    }

    protected int getSizeIndex() {
        return 16;
    }

    public Component getComponent() {
        return this.frame;
    }

    public JFrame getJFrame() {
        return this.frame;
    }

    public Container getContainer() {
        return this.frame.getContentPane();
    }

    public JRootPane getRootPane() {
        return this.frame.getRootPane();
    }

    public void add(final ControlElement _child) {
        if (!(_child instanceof ControlMenuBar)) {
            super.add(_child);
            return;
        }
        this.children.add(_child);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ControlFrame.this.menubar = (JMenuBar)_child.getVisual();
                ControlFrame.this.frame.setJMenuBar(ControlFrame.this.menubar);
            }
        });
        ((ControlMenuBar)_child).setControlWindow(this);
        this.adjustSize();
        this.propagateProperty(_child, "font", this.getPropagatedProperty("font"));
        this.propagateProperty(_child, "foreground", this.getPropagatedProperty("foreground"));
        this.propagateProperty(_child, "background", this.getPropagatedProperty("background"));
    }

    public void remove(ControlElement _child) {
        if (!(_child instanceof ControlMenuBar)) {
            super.remove(_child);
            return;
        }
        this.children.remove(_child);
        this.menubar = null;
        this.frame.setJMenuBar(null);
        this.getRootPane().validate();
        this.getRootPane().repaint();
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("title");
            infoList.add("resizable");
            infoList.add("exit");
            infoList.add("onExit");
            infoList.add("image");
            infoList.add("glasspane");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String _property) {
        if (_property.equals("title")) {
            return "String TRANSLATABLE";
        }
        if (_property.equals("resizable")) {
            return "boolean";
        }
        if (_property.equals("exit")) {
            return "boolean CONSTANT";
        }
        if (_property.equals("onExit")) {
            return "Action CONSTANT";
        }
        if (_property.equals("image")) {
            return "File|String TRANSLATABLE";
        }
        if (_property.equals("glasspane")) {
            return "boolean";
        }
        return super.getPropertyInfo(_property);
    }

    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                String ejsWindow = this.getProperty("_ejs_window_");
                if (ejsWindow != null) {
                    this.frame.setTitle(String.valueOf(GUIUtils.parseTeX(_value.getString())) + " " + ejsWindow);
                    break;
                }
                this.frame.setTitle(GUIUtils.parseTeX(_value.getString()));
                break;
            }
            case 1: {
                this.frame.setResizable(_value.getBoolean());
                break;
            }
            case 2: {
                if (this.getProperty("_ejs_") != null) break;
                if (_value.getBoolean()) {
                    this.frame.setDefaultCloseOperation(3);
                    break;
                }
                this.frame.setDefaultCloseOperation(1);
                break;
            }
            case 3: {
                this.removeAction(0, this.getProperty("onExit"));
                this.addAction(0, _value.getString());
                break;
            }
            case 4: {
                if (_value.getString().equals(this.iconImageFile)) {
                    return;
                }
                this.iconImageFile = _value.getString();
                this.frame.setIconImage(this.getIcon(this.iconImageFile).getImage());
                break;
            }
            case 5: {
                this.frame.getGlassPane().setVisible(_value.getBoolean());
                break;
            }
            case 11: {
                super.setValue(5, _value);
                if (this.getGroup() == null || this.getGroup().getOwnerFrame() != this.getComponent()) break;
                String replacement = this.getGroup().getReplaceOwnerName();
                if (replacement != null && replacement.equals(_value.getString())) {
                    this.getGroup().setOwnerFrame(this.getGroup().getReplaceOwnerFrame());
                    break;
                }
                this.getGroup().setOwnerFrame(this.frame);
                break;
            }
            default: {
                super.setValue(_index - 6, _value);
            }
        }
    }

    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                String ejsWindow = this.getProperty("_ejs_window_");
                if (ejsWindow != null) {
                    this.frame.setTitle(ejsWindow);
                    break;
                }
                this.frame.setTitle("");
                break;
            }
            case 1: {
                this.frame.setResizable(true);
                break;
            }
            case 2: {
                if (this.getProperty("_ejs_") != null) break;
                this.frame.setDefaultCloseOperation(1);
                break;
            }
            case 3: {
                this.removeAction(0, this.getProperty("onExit"));
                break;
            }
            case 4: {
                this.iconImageFile = null;
                this.frame.setIconImage(null);
                break;
            }
            case 5: {
                this.frame.getGlassPane().setVisible(false);
                break;
            }
            case 11: {
                super.setDefaultValue(5);
                if (this.getGroup() != null && this.getGroup().getOwnerFrame() == this.getComponent()) {
                    this.getGroup().setOwnerFrame(this.frame);
                }
            }
            default: {
                super.setDefaultValue(_index - 6);
            }
        }
    }

    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return null;
            }
        }
        return super.getValue(_index - 6);
    }
}

