/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.colos.ejs.library.control.ConstantParser;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.GUIUtils;

public class ControlNumberField
extends ControlSwingElement {
    private static final int NUMBER_FIELD_ADDED = 5;
    protected static final int VARIABLE = 0;
    protected static final int VALUE = 1;
    private static final int BACKGROUND = 12;
    protected static final DecimalFormat defaultFormat = new DecimalFormat("0.000;0.000");
    protected JTextField textfield;
    protected DoubleValue internalValue;
    protected double defaultValue;
    protected boolean defaultValueSet;
    protected DecimalFormat format;
    protected String formatStr = null;
    protected Color defaultColor;
    protected Color editingColor;
    protected Color errorColor;
    private static ArrayList infoList = null;

    protected Component createVisual() {
        this.textfield = new JTextField();
        defaultFormat.setDecimalFormatSymbols(new DecimalFormatSymbols(new Locale("en")));
        this.format = defaultFormat;
        this.defaultValue = 0.0;
        this.defaultValueSet = false;
        this.internalValue = new DoubleValue(this.defaultValue);
        this.textfield.setText(this.format.format(this.internalValue.value));
        this.textfield.addActionListener(new MyActionListener());
        this.textfield.addKeyListener(new MyKeyListener());
        this.decideColors(this.textfield.getBackground());
        return this.textfield;
    }

    public void reset() {
        if (this.defaultValueSet) {
            this.setTheValue(this.defaultValue);
            this.setInternalValue(this.defaultValue);
        }
    }

    private void setTheValue(double _value) {
        if (_value != this.internalValue.value) {
            this.internalValue.value = _value;
            if (SwingUtilities.isEventDispatchThread()) {
                this.textfield.setText(this.format.format(_value));
                if (this.textfield.isEditable()) {
                    this.getVisual().setBackground(this.defaultColor);
                }
            } else {
                final String str = this.format.format(_value);
                SwingUtilities.invokeLater(new Runnable(){

                    public synchronized void run() {
                        ControlNumberField.this.textfield.setText(str);
                        if (ControlNumberField.this.textfield.isEditable()) {
                            ControlNumberField.this.getVisual().setBackground(ControlNumberField.this.defaultColor);
                        }
                    }
                });
            }
        }
    }

    protected void setInternalValue(double _value) {
        this.internalValue.value = _value;
        this.variableChanged(0, this.internalValue);
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("variable");
            infoList.add("value");
            infoList.add("editable");
            infoList.add("format");
            infoList.add("action");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String _property) {
        if (_property.equals("variable")) {
            return "int|double";
        }
        if (_property.equals("value")) {
            return "int|double CONSTANT";
        }
        if (_property.equals("editable")) {
            return "boolean";
        }
        if (_property.equals("format")) {
            return "Format|Object|String TRANSLATABLE";
        }
        if (_property.equals("action")) {
            return "Action CONSTANT";
        }
        return super.getPropertyInfo(_property);
    }

    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                this.setTheValue(_value.getDouble());
                break;
            }
            case 1: {
                this.defaultValueSet = true;
                this.defaultValue = _value.getDouble();
                this.setActive(false);
                this.reset();
                this.setActive(true);
                break;
            }
            case 2: {
                this.textfield.setEditable(_value.getBoolean());
                break;
            }
            case 3: {
                DecimalFormat newFormat = null;
                if (_value.getObject() instanceof DecimalFormat) {
                    newFormat = (DecimalFormat)_value.getObject();
                    newFormat.setDecimalFormatSymbols(new DecimalFormatSymbols(new Locale("en")));
                    this.formatStr = null;
                } else {
                    String newFormatStr = GUIUtils.parseTeX(_value.getString());
                    if (newFormatStr.equals(this.formatStr)) {
                        return;
                    }
                    this.formatStr = newFormatStr;
                    newFormat = (DecimalFormat)ConstantParser.formatConstant(this.formatStr).getObject();
                    newFormat.setDecimalFormatSymbols(new DecimalFormatSymbols(new Locale("en")));
                }
                if (newFormat.equals(this.format)) {
                    return;
                }
                this.format = newFormat;
                if (SwingUtilities.isEventDispatchThread()) {
                    this.textfield.setText(this.format.format(this.internalValue.value));
                    break;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public synchronized void run() {
                        ControlNumberField.this.textfield.setText(ControlNumberField.this.format.format(ControlNumberField.this.internalValue.value));
                    }
                });
                break;
            }
            case 4: {
                this.removeAction(1, this.getProperty("action"));
                this.addAction(1, _value.getString());
                break;
            }
            case 12: {
                super.setValue(7, _value);
                this.decideColors(this.getVisual().getBackground());
                break;
            }
            default: {
                super.setValue(_index - 5, _value);
            }
        }
    }

    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                break;
            }
            case 1: {
                this.defaultValueSet = false;
                break;
            }
            case 2: {
                this.textfield.setEditable(true);
                break;
            }
            case 3: {
                this.format = defaultFormat;
                this.formatStr = null;
                Runnable refreshScreen = new Runnable(){

                    public synchronized void run() {
                        ControlNumberField.this.textfield.setText(ControlNumberField.this.format.format(ControlNumberField.this.internalValue.value));
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    refreshScreen.run();
                    break;
                }
                SwingUtilities.invokeLater(refreshScreen);
                break;
            }
            case 4: {
                this.removeAction(1, this.getProperty("action"));
                break;
            }
            case 12: {
                super.setDefaultValue(7);
                this.decideColors(this.getVisual().getBackground());
                break;
            }
            default: {
                super.setDefaultValue(_index - 5);
            }
        }
    }

    public Value getValue(int _index) {
        switch (_index) {
            case 0: {
                return this.internalValue;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return null;
            }
        }
        return super.getValue(_index - 5);
    }

    protected void setColor(Color aColor) {
        if (this.textfield.isEditable()) {
            this.getVisual().setBackground(aColor);
        }
    }

    protected void decideColors(Color aColor) {
        if (aColor == null) {
            return;
        }
        this.defaultColor = aColor;
        this.editingColor = this.defaultColor.equals(Color.yellow) ? Color.orange : Color.yellow;
        this.errorColor = this.defaultColor.equals(Color.red) ? Color.magenta : Color.red;
    }

    protected void acceptValue() {
        this.setColor(this.defaultColor);
        try {
            this.setInternalValue(this.format.parse(this.textfield.getText()).doubleValue());
            if (this.isUnderEjs) {
                this.setFieldListValueWithAlternative(0, 1, this.internalValue);
            }
        }
        catch (Exception exception) {
            this.setColor(this.errorColor);
        }
    }

    protected class MyActionListener
    implements ActionListener {
        protected MyActionListener() {
        }

        public void actionPerformed(ActionEvent _e) {
            if (ControlNumberField.this.textfield.isEditable()) {
                ControlNumberField.this.acceptValue();
            }
        }
    }

    protected class MyKeyListener
    implements KeyListener {
        protected MyKeyListener() {
        }

        public void keyPressed(KeyEvent _e) {
            this.processKeyEvent(_e, 0);
        }

        public void keyReleased(KeyEvent _e) {
            this.processKeyEvent(_e, 1);
        }

        public void keyTyped(KeyEvent _e) {
            this.processKeyEvent(_e, 2);
        }

        private void processKeyEvent(KeyEvent _e, int _n) {
            if (!ControlNumberField.this.textfield.isEditable()) {
                return;
            }
            if (_e.getKeyChar() != '\n') {
                ControlNumberField.this.setColor(ControlNumberField.this.editingColor);
            }
            if (_e.getKeyCode() == 27) {
                ControlNumberField.this.setValue(0, ControlNumberField.this.internalValue);
            }
        }
    }
}

