/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.swing.ControlContainer;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;

public class ControlPanel
extends ControlContainer {
    public static final int PANEL_ADDED = 7;
    public static final int EMPTY_BORDER = 0;
    public static final int LOWERED_BEVEL_BORDER = 1;
    public static final int RAISED_BEVEL_BORDER = 2;
    public static final int LOWERED_ETCHED_BORDER = 3;
    public static final int RAISED_ETCHED_BORDER = 4;
    public static final int LINE_BORDER = 5;
    public static final int ROUNDED_LINE_BORDER = 6;
    public static final int MATTE_BORDER = 7;
    public static final int TITLED_BORDER = 8;
    public static final int ROUNDED_TITLED_BORDER = 9;
    protected JPanel panel;
    private LayoutManager myLayout = null;
    private Rectangle myBorder = new Rectangle(0, 0, 0, 0);
    private int borderType = 0;
    private Color borderColor = Color.BLACK;
    private String borderTitle = "Title";
    private int borderPosition = 0;
    private int borderJustification = 0;
    private static ArrayList infoList = null;

    protected Component createVisual() {
        this.panel = new JPanel();
        return this.panel;
    }

    private void setBorder() {
        AbstractBorder border;
        switch (this.borderType) {
            default: {
                border = new EmptyBorder(this.myBorder.x, this.myBorder.y, this.myBorder.width, this.myBorder.height);
                break;
            }
            case 1: {
                border = new BevelBorder(1);
                break;
            }
            case 2: {
                border = new BevelBorder(0);
                break;
            }
            case 3: {
                border = new EtchedBorder(1);
                break;
            }
            case 4: {
                border = new EtchedBorder(0);
                break;
            }
            case 5: 
            case 6: {
                int size = Math.max(Math.max(Math.max(Math.max(this.myBorder.x, this.myBorder.y), this.myBorder.width), this.myBorder.height), 1);
                border = new LineBorder(this.borderColor, size, this.borderType == 6);
                break;
            }
            case 7: {
                border = new MatteBorder(this.myBorder.x, this.myBorder.y, this.myBorder.width, this.myBorder.height, this.borderColor);
                break;
            }
            case 8: 
            case 9: {
                int size2 = Math.max(Math.max(Math.max(Math.max(this.myBorder.x, this.myBorder.y), this.myBorder.width), this.myBorder.height), 1);
                border = new TitledBorder(new LineBorder(this.borderColor, size2, this.borderType == 9), this.borderTitle, this.borderJustification, this.borderPosition, this.panel.getFont(), this.panel.getForeground());
            }
        }
        this.panel.setBorder(border);
    }

    public ControlElement setProperty(String _property, String _value, boolean _store) {
        ControlElement returnValue = super.setProperty(_property, _value, _store);
        if (_property.equals("font") || _property.equals("foreground")) {
            this.setBorder();
        }
        return returnValue;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("layout");
            infoList.add("border");
            infoList.add("borderType");
            infoList.add("borderColor");
            infoList.add("borderTitle");
            infoList.add("borderPosition");
            infoList.add("borderJustification");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String _property) {
        if (_property.equals("layout")) {
            return "Layout|Object NO_RESET";
        }
        if (_property.equals("border")) {
            return "Margins|Object";
        }
        if (_property.equals("borderType")) {
            return "BorderType|int";
        }
        if (_property.equals("borderColor")) {
            return "Color|Object";
        }
        if (_property.equals("borderTitle")) {
            return "String TRANSLATABLE";
        }
        if (_property.equals("borderPosition")) {
            return "BorderPosition|int";
        }
        if (_property.equals("borderJustification")) {
            return "Alignment|int";
        }
        return super.getPropertyInfo(_property);
    }

    public Value parseConstant(String _propertyType, String _value) {
        if (_value == null) {
            return null;
        }
        if (_propertyType.indexOf("BorderType") >= 0) {
            if ((_value = _value.trim().toLowerCase()).equals("empty")) {
                return new IntegerValue(0);
            }
            if (_value.equals("lowered_bevel")) {
                return new IntegerValue(1);
            }
            if (_value.equals("raised_bevel")) {
                return new IntegerValue(2);
            }
            if (_value.equals("lowered_etched")) {
                return new IntegerValue(3);
            }
            if (_value.equals("raised_etched")) {
                return new IntegerValue(4);
            }
            if (_value.equals("line")) {
                return new IntegerValue(5);
            }
            if (_value.equals("rounded_line")) {
                return new IntegerValue(6);
            }
            if (_value.equals("matte")) {
                return new IntegerValue(7);
            }
            if (_value.equals("titled")) {
                return new IntegerValue(8);
            }
            if (_value.equals("rounded_titled")) {
                return new IntegerValue(9);
            }
        } else if (_propertyType.indexOf("BorderPosition") >= 0) {
            if ((_value = _value.trim().toLowerCase()).equals("top")) {
                return new IntegerValue(2);
            }
            if (_value.equals("bottom")) {
                return new IntegerValue(5);
            }
            if (_value.equals("above_top")) {
                return new IntegerValue(1);
            }
            if (_value.equals("above_bottom")) {
                return new IntegerValue(4);
            }
            if (_value.equals("below_top")) {
                return new IntegerValue(3);
            }
            if (_value.equals("below_bottom")) {
                return new IntegerValue(6);
            }
        } else if (_propertyType.indexOf("Alignment") >= 0) {
            if ((_value = _value.trim().toLowerCase()).equals("left")) {
                return new IntegerValue(1);
            }
            if (_value.equals("center")) {
                return new IntegerValue(2);
            }
            if (_value.equals("right")) {
                return new IntegerValue(3);
            }
        }
        return super.parseConstant(_propertyType, _value);
    }

    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                LayoutManager layout;
                if (!(_value.getObject() instanceof LayoutManager) || (layout = (LayoutManager)_value.getObject()) == this.myLayout) break;
                this.myLayout = layout;
                this.getContainer().setLayout(this.myLayout);
                this.adjustChildren();
                this.panel.validate();
                break;
            }
            case 1: {
                Rectangle rect;
                if (!(_value.getObject() instanceof Rectangle) || (rect = (Rectangle)_value.getObject()) == this.myBorder) break;
                this.myBorder = rect;
                this.setBorder();
                break;
            }
            case 2: {
                if (_value.getInteger() == this.borderType) break;
                this.borderType = _value.getInteger();
                this.setBorder();
                break;
            }
            case 3: {
                Color newColor;
                if (!(_value.getObject() instanceof Color) || (newColor = (Color)_value.getObject()) == this.borderColor) break;
                this.borderColor = newColor;
                this.setBorder();
                break;
            }
            case 4: {
                if (this.borderTitle.equals(_value.getString())) break;
                this.borderTitle = _value.getString();
                this.setBorder();
                break;
            }
            case 5: {
                if (_value.getInteger() == this.borderPosition) break;
                this.borderPosition = _value.getInteger();
                this.setBorder();
                break;
            }
            case 6: {
                if (_value.getInteger() == this.borderJustification) break;
                this.borderJustification = _value.getInteger();
                this.setBorder();
                break;
            }
            default: {
                super.setValue(_index - 7, _value);
            }
        }
    }

    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.myLayout = new BorderLayout();
                this.getContainer().setLayout(this.myLayout);
                this.adjustChildren();
                this.panel.validate();
                break;
            }
            case 1: {
                this.myBorder = new Rectangle(0, 0, 0, 0);
                this.setBorder();
                break;
            }
            case 2: {
                this.borderType = 0;
                this.setBorder();
                break;
            }
            case 3: {
                this.borderColor = Color.BLACK;
                this.setBorder();
                break;
            }
            case 4: {
                this.borderTitle = "Title";
                this.setBorder();
                break;
            }
            case 5: {
                this.borderPosition = 0;
                this.setBorder();
                break;
            }
            case 6: {
                this.borderJustification = 0;
                this.setBorder();
                break;
            }
            default: {
                super.setDefaultValue(_index - 7);
            }
        }
    }

    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return null;
            }
        }
        return super.getValue(_index - 7);
    }
}

