/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import org.colos.ejs.library.control.ConstantParser;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.swing.ControlDrawable;
import org.colos.ejs.library.control.swing.ControlDrawablesParent;
import org.colos.ejs.library.control.swing.MyCoordinateStringBuilder;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.InteractiveMouseHandler;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.axes.AxisFactory;
import org.opensourcephysics.display.axes.CartesianAxes;
import org.opensourcephysics.display.axes.CartesianType1;
import org.opensourcephysics.display.axes.CartesianType2;
import org.opensourcephysics.display.axes.CartesianType3;
import org.opensourcephysics.display.axes.DrawableAxes;
import org.opensourcephysics.display.axes.PolarAxes;
import org.opensourcephysics.display.axes.PolarType1;
import org.opensourcephysics.display.axes.PolarType2;
import org.opensourcephysics.displayejs.InteractionEvent;
import org.opensourcephysics.displayejs.InteractionSource;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Point3D;
import org.opensourcephysics.drawing.basic.Element;
import org.opensourcephysics.drawing.basic.InteractionTarget;
import org.opensourcephysics.drawing.drawing2d.PlottingPanel2D;

public class ControlPlottingPanel
extends ControlDrawablesParent
implements InteractiveMouseHandler {
    protected static final int ADDEDBYPLOTTINGPANEL = 47;
    static final int FONT = 55;
    private static final int[] posIndex = new int[]{18, 19};
    private static final int KEY_INDEX = 31;
    private static final int ALIASING = 45;
    private static final int MENU = 46;
    protected PlottingPanel2D plottingPanel;
    private String title;
    private String titleFontname;
    protected boolean reportDrag = false;
    private Rectangle myGutters;
    private int[] defaultGutters;
    private DrawableAxes axes;
    private boolean axisGridX;
    private boolean axisGridY;
    private boolean xaxisLog;
    private boolean yaxisLog;
    private int axesType;
    private double xaxisPos;
    private double yaxisPos;
    private double deltaR;
    private double deltaTheta;
    private String xLabel;
    private String yLabel;
    private String labelFontname;
    protected MyCoordinateStringBuilder strBuilder;
    private DoubleValue[] posValues = new DoubleValue[]{new DoubleValue(0.0), new DoubleValue(0.0)};
    private IntegerValue keyPressedValue = new IntegerValue(-1);
    private static ArrayList infoList = null;
    private org.opensourcephysics.displayejs.InteractionTarget targetHit = null;
    private InteractionSource sourceLingered = null;
    private InteractionTarget target2D = null;
    private InteractionTarget target2DEntered = null;

    protected Component createVisual() {
        this.plottingPanel = new PlottingPanel2D("", "", "");
        this.plottingPanel.enableInspector(false);
        this.plottingPanel.setSquareAspect(false);
        this.plottingPanel.setPreferredMinMax(-1.0, 1.0, -1.0, 1.0);
        this.plottingPanel.setAutoscaleX(true);
        this.plottingPanel.setAutoscaleY(true);
        this.plottingPanel.setBuffered(true);
        this.plottingPanel.removeOptionController();
        this.axes = this.plottingPanel.getAxes();
        this.axes.setVisible(true);
        this.axisGridX = true;
        this.axes.setShowMajorXGrid(true);
        this.axisGridY = true;
        this.axes.setShowMajorYGrid(true);
        this.yaxisLog = false;
        this.xaxisLog = false;
        this.deltaR = 1.0;
        this.deltaTheta = 0.39269908169872414;
        if (this.axes instanceof CartesianAxes) {
            this.xaxisLog = ((CartesianAxes)this.axes).isXLog();
            this.yaxisLog = ((CartesianAxes)this.axes).isYLog();
            if (this.axes instanceof CartesianType1) {
                this.axesType = 1;
            } else if (this.axes instanceof CartesianType2) {
                this.axesType = 2;
            } else if (this.axes instanceof CartesianType3) {
                this.axesType = 3;
                ((CartesianType3)this.axes).setEnabled(false);
            } else {
                this.axesType = 1;
            }
        } else if (this.axes instanceof PolarAxes) {
            this.deltaR = ((PolarAxes)this.axes).getDeltaR();
            this.deltaTheta = ((PolarAxes)this.axes).getDeltaTheta();
            this.axesType = this.axes instanceof PolarType1 ? 4 : (this.axes instanceof PolarType2 ? 5 : 4);
        } else {
            this.axesType = 0;
        }
        this.minX = Double.NaN;
        this.maxX = Double.NaN;
        this.minY = Double.NaN;
        this.maxY = Double.NaN;
        this.autoX = this.plottingPanel.isAutoscaleX();
        this.autoY = this.plottingPanel.isAutoscaleY();
        this.plottingPanel.setInteractiveMouseHandler(this);
        this.strBuilder = new MyCoordinateStringBuilder();
        this.plottingPanel.setCoordinateStringBuilder(this.strBuilder);
        this.plottingPanel.setFocusable(true);
        this.defaultGutters = this.plottingPanel.getGutters();
        this.plottingPanel.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent _e) {
                ((ControlPlottingPanel)ControlPlottingPanel.this).keyPressedValue.value = _e.getKeyCode();
                ControlPlottingPanel.this.variableChanged(31, ControlPlottingPanel.this.keyPressedValue);
                ControlPlottingPanel.this.invokeActions(30);
            }

            public void keyReleased(KeyEvent _e) {
                ((ControlPlottingPanel)ControlPlottingPanel.this).keyPressedValue.value = -1;
                ControlPlottingPanel.this.variableChanged(31, ControlPlottingPanel.this.keyPressedValue);
            }
        });
        return this.plottingPanel;
    }

    protected int[] getPosIndex() {
        return posIndex;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("title");
            infoList.add("titleFont");
            infoList.add("axesType");
            infoList.add("titleX");
            infoList.add("titleY");
            infoList.add("xaxisType");
            infoList.add("yaxisType");
            infoList.add("deltaR");
            infoList.add("deltaTheta");
            infoList.add("interiorBackground");
            infoList.add("majorTicksX");
            infoList.add("majorTicksY");
            infoList.add("autoscaleX");
            infoList.add("autoscaleY");
            infoList.add("minimumX");
            infoList.add("maximumX");
            infoList.add("minimumY");
            infoList.add("maximumY");
            infoList.add("x");
            infoList.add("y");
            infoList.add("pressaction");
            infoList.add("dragaction");
            infoList.add("action");
            infoList.add("square");
            infoList.add("showCoordinates");
            infoList.add("gutters");
            infoList.add("xaxisPos");
            infoList.add("yaxisPos");
            infoList.add("xFormat");
            infoList.add("yFormat");
            infoList.add("keyAction");
            infoList.add("keyPressed");
            infoList.add("enteredAction");
            infoList.add("exitedAction");
            infoList.add("printTarget");
            infoList.add("xyExpression");
            infoList.add("xyFormat");
            infoList.add("xMarginPercentage");
            infoList.add("yMarginPercentage");
            infoList.add("TLmessage");
            infoList.add("TRmessage");
            infoList.add("BLmessage");
            infoList.add("BRmessage");
            infoList.add("showAxes");
            infoList.add("fixedGutters");
            infoList.add("aliasing");
            infoList.add("menu");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyCommonName(String _property) {
        if (_property.equals("pressaction")) {
            return "pressAction";
        }
        if (_property.equals("dragaction")) {
            return "dragAction";
        }
        if (_property.equals("action")) {
            return "releaseAction";
        }
        if (_property.equals("square")) {
            return "squareAspect";
        }
        return super.getPropertyCommonName(_property);
    }

    public String getPropertyInfo(String _property) {
        if (_property.equals("title")) {
            return "String TRANSLATABLE";
        }
        if (_property.equals("titleFont")) {
            return "Font|Object";
        }
        if (_property.equals("axesType")) {
            return "int|AxesType";
        }
        if (_property.equals("titleX")) {
            return "String TRANSLATABLE";
        }
        if (_property.equals("titleY")) {
            return "String TRANSLATABLE";
        }
        if (_property.equals("xaxisType")) {
            return "int|CartesianAxisType";
        }
        if (_property.equals("yaxisType")) {
            return "int|CartesianAxisType";
        }
        if (_property.equals("deltaR")) {
            return "int|double";
        }
        if (_property.equals("deltaTheta")) {
            return "int|double";
        }
        if (_property.equals("interiorBackground")) {
            return "Color|Object";
        }
        if (_property.equals("majorTicksX")) {
            return "boolean";
        }
        if (_property.equals("majorTicksY")) {
            return "boolean";
        }
        if (_property.equals("autoscaleX")) {
            return "boolean";
        }
        if (_property.equals("autoscaleY")) {
            return "boolean";
        }
        if (_property.equals("minimumX")) {
            return "int|double";
        }
        if (_property.equals("maximumX")) {
            return "int|double";
        }
        if (_property.equals("minimumY")) {
            return "int|double";
        }
        if (_property.equals("maximumY")) {
            return "int|double";
        }
        if (_property.equals("x")) {
            return "int|double";
        }
        if (_property.equals("y")) {
            return "int|double";
        }
        if (_property.equals("action")) {
            return "Action CONSTANT";
        }
        if (_property.equals("pressaction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("dragaction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("square")) {
            return "boolean";
        }
        if (_property.equals("showCoordinates")) {
            return "boolean";
        }
        if (_property.equals("gutters")) {
            return "Margins|Object";
        }
        if (_property.equals("xaxisPos")) {
            return "int|double";
        }
        if (_property.equals("yaxisPos")) {
            return "int|double";
        }
        if (_property.equals("xFormat")) {
            return "Format|Object|String TRANSLATABLE";
        }
        if (_property.equals("yFormat")) {
            return "Format|Object|String TRANSLATABLE";
        }
        if (_property.equals("keyAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("keyPressed")) {
            return "int";
        }
        if (_property.equals("enteredAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("exitedAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("printTarget")) {
            return "String";
        }
        if (_property.equals("xyExpression")) {
            return "Object|String";
        }
        if (_property.equals("xyFormat")) {
            return "Format|Object|String TRANSLATABLE";
        }
        if (_property.equals("xMarginPercentage")) {
            return "int|double";
        }
        if (_property.equals("yMarginPercentage")) {
            return "int|double";
        }
        if (_property.equals("TLmessage")) {
            return "String";
        }
        if (_property.equals("TRmessage")) {
            return "String";
        }
        if (_property.equals("BLmessage")) {
            return "String";
        }
        if (_property.equals("BRmessage")) {
            return "String";
        }
        if (_property.equals("showAxes")) {
            return "boolean";
        }
        if (_property.equals("fixedGutters")) {
            return "boolean";
        }
        if (_property.equals("aliasing")) {
            return "boolean";
        }
        if (_property.equals("menu")) {
            return "boolean";
        }
        return super.getPropertyInfo(_property);
    }

    public Value parseConstant(String _propertyType, String _value) {
        if (_value == null) {
            return null;
        }
        if (_propertyType.indexOf("CartesianAxisType") >= 0) {
            if ((_value = _value.trim().toLowerCase()).equals("linear")) {
                return new IntegerValue(0);
            }
            if (_value.equals("log10")) {
                return new IntegerValue(1);
            }
        }
        if (_propertyType.indexOf("AxesType") >= 0) {
            if ((_value = _value.trim().toLowerCase()).equals("null") || _value.equals("none")) {
                return new IntegerValue(0);
            }
            if (_value.equals("cartesian1")) {
                return new IntegerValue(1);
            }
            if (_value.equals("cartesian2")) {
                return new IntegerValue(2);
            }
            if (_value.equals("cartesian3")) {
                return new IntegerValue(3);
            }
            if (_value.equals("polar1")) {
                return new IntegerValue(4);
            }
            if (_value.equals("polar2")) {
                return new IntegerValue(5);
            }
        }
        return super.parseConstant(_propertyType, _value);
    }

    public ControlElement setProperty(String _property, String _value) {
        if (((_property = _property.trim()).equals("x") || _property.equals("y") || _property.equals("dragaction")) && _value != null) {
            Value constant = Value.parseConstant(_value, true);
            boolean bl = this.reportDrag = constant == null;
        }
        if (_property.equals("xaxis")) {
            return super.setProperty("xaxisPos", _value);
        }
        if (_property.equals("yaxis")) {
            return super.setProperty("yaxisPos", _value);
        }
        return super.setProperty(_property, _value);
    }

    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                this.title = _value.getString();
                this.plottingPanel.setTitle(this.title, this.titleFontname);
                break;
            }
            case 1: {
                if (!(_value.getObject() instanceof Font)) break;
                Font font = (Font)_value.getObject();
                this.titleFontname = font.getFamily();
                if (font.isPlain()) {
                    this.titleFontname = String.valueOf(this.titleFontname) + "-PLAIN";
                } else if (font.isItalic()) {
                    this.titleFontname = font.isBold() ? String.valueOf(this.titleFontname) + "-BOLDITALIC" : String.valueOf(this.titleFontname) + "-ITALIC";
                } else if (font.isBold()) {
                    this.titleFontname = String.valueOf(this.titleFontname) + "-BOLD";
                }
                this.titleFontname = String.valueOf(this.titleFontname) + "-" + font.getSize();
                if (this.title == null) break;
                this.axes.setTitle(this.title, this.titleFontname);
                break;
            }
            case 2: {
                if (this.axesType == _value.getInteger()) break;
                this.axesType = _value.getInteger();
                switch (this.axesType) {
                    default: {
                        this.axes = AxisFactory.createAxesType1(this.plottingPanel);
                        ((CartesianType1)this.axes).setXLog(this.xaxisLog);
                        ((CartesianType1)this.axes).setYLog(this.yaxisLog);
                        break;
                    }
                    case 2: {
                        this.axes = AxisFactory.createAxesType2(this.plottingPanel);
                        ((CartesianType2)this.axes).setXLog(this.xaxisLog);
                        ((CartesianType2)this.axes).setYLog(this.yaxisLog);
                        break;
                    }
                    case 3: {
                        this.axes = AxisFactory.createAxesType3(this.plottingPanel);
                        ((CartesianType3)this.axes).setEnabled(false);
                        ((CartesianType3)this.axes).setXLog(this.xaxisLog);
                        ((CartesianType3)this.axes).setYLog(this.yaxisLog);
                        break;
                    }
                    case 4: {
                        this.axes = new PolarType1(this.plottingPanel);
                        ((PolarAxes)this.axes).setDeltaR(this.deltaR);
                        ((PolarAxes)this.axes).setDeltaTheta(this.deltaTheta);
                        break;
                    }
                    case 5: {
                        this.axes = new PolarType2(this.plottingPanel);
                        ((PolarAxes)this.axes).setDeltaR(this.deltaR);
                        ((PolarAxes)this.axes).setDeltaTheta(this.deltaTheta);
                    }
                }
                if (this.xLabel != null) {
                    this.axes.setXLabel(this.xLabel, this.labelFontname);
                }
                if (this.yLabel != null) {
                    this.axes.setYLabel(this.yLabel, this.labelFontname);
                }
                if (this.title != null) {
                    this.axes.setTitle(this.title, this.titleFontname);
                }
                this.axes.setShowMajorXGrid(this.axisGridX);
                this.axes.setShowMajorYGrid(this.axisGridY);
                if (this.axes instanceof CartesianAxes) {
                    ((CartesianAxes)this.axes).setX(this.xaxisPos);
                    ((CartesianAxes)this.axes).setY(this.yaxisPos);
                }
                if (this.axesType == 0) {
                    this.plottingPanel.setAxes(null);
                } else {
                    this.plottingPanel.setAxes(this.axes);
                }
                this.plottingPanel.setPreferredMinMax(this.minX, this.maxX, this.minY, this.maxY);
                this.plottingPanel.setCoordinateStringBuilder(this.strBuilder);
                break;
            }
            case 3: {
                this.xLabel = _value.getString();
                this.plottingPanel.setXLabel(this.xLabel, this.labelFontname);
                break;
            }
            case 4: {
                this.yLabel = _value.getString();
                this.plottingPanel.setYLabel(this.yLabel, this.labelFontname);
                break;
            }
            case 5: {
                if (this.xaxisLog && _value.getInteger() != 1) {
                    this.xaxisLog = false;
                    this.plottingPanel.setLogScale(false, this.yaxisLog);
                    break;
                }
                if (this.xaxisLog || _value.getInteger() != 1) break;
                this.xaxisLog = true;
                this.plottingPanel.setLogScale(true, this.yaxisLog);
                break;
            }
            case 6: {
                if (this.yaxisLog && _value.getInteger() != 1) {
                    this.yaxisLog = false;
                    this.plottingPanel.setLogScale(this.xaxisLog, false);
                    break;
                }
                if (this.yaxisLog || _value.getInteger() != 1) break;
                this.yaxisLog = true;
                this.plottingPanel.setLogScale(this.xaxisLog, true);
                break;
            }
            case 7: {
                if (_value.getDouble() == this.deltaR) break;
                this.deltaR = _value.getDouble();
                if (!(this.axes instanceof PolarAxes)) break;
                ((PolarAxes)this.axes).setDeltaR(this.deltaR);
                break;
            }
            case 8: {
                if (_value.getDouble() == this.deltaTheta) break;
                this.deltaTheta = _value.getDouble();
                if (!(this.axes instanceof PolarAxes)) break;
                ((PolarAxes)this.axes).setDeltaTheta(this.deltaTheta);
                break;
            }
            case 9: {
                if (!(_value.getObject() instanceof Color)) break;
                this.axes.setInteriorBackground((Color)_value.getObject());
                break;
            }
            case 10: {
                this.axes.setShowMajorXGrid(_value.getBoolean());
                break;
            }
            case 11: {
                this.axes.setShowMajorYGrid(_value.getBoolean());
                break;
            }
            case 12: {
                this.autoX = _value.getBoolean();
                this.updateAutoscale();
                break;
            }
            case 13: {
                this.autoY = _value.getBoolean();
                this.updateAutoscale();
                break;
            }
            case 14: {
                if (_value.getDouble() == this.minX && this.xminSet) break;
                this.minX = _value.getDouble();
                this.xminSet = true;
                this.updateExtrema();
                break;
            }
            case 15: {
                if (_value.getDouble() == this.maxX && this.xmaxSet) break;
                this.maxX = _value.getDouble();
                this.xmaxSet = true;
                this.updateExtrema();
                break;
            }
            case 16: {
                if (_value.getDouble() == this.minY && this.yminSet) break;
                this.minY = _value.getDouble();
                this.yminSet = true;
                this.updateExtrema();
                break;
            }
            case 17: {
                if (_value.getDouble() == this.maxY && this.ymaxSet) break;
                this.maxY = _value.getDouble();
                this.ymaxSet = true;
                this.updateExtrema();
                break;
            }
            case 18: {
                this.posValues[0].value = _value.getDouble();
                break;
            }
            case 19: {
                this.posValues[1].value = _value.getDouble();
                break;
            }
            case 20: {
                this.removeAction(10, this.getProperty("pressaction"));
                this.addAction(10, _value.getString());
                break;
            }
            case 21: {
                this.removeAction(1, this.getProperty("dragaction"));
                this.addAction(1, _value.getString());
                break;
            }
            case 22: {
                this.removeAction(0, this.getProperty("action"));
                this.addAction(0, _value.getString());
                break;
            }
            case 23: {
                this.plottingPanel.setSquareAspect(_value.getBoolean());
                break;
            }
            case 24: {
                this.plottingPanel.setShowCoordinates(_value.getBoolean());
                break;
            }
            case 25: {
                Rectangle rect;
                if (!(_value.getObject() instanceof Rectangle) || (rect = (Rectangle)_value.getObject()) == this.myGutters) break;
                this.plottingPanel.setPreferredGutters(rect.x, rect.y, rect.width, rect.height);
                this.myGutters = rect;
                break;
            }
            case 26: {
                if (this.xaxisPos == _value.getDouble() || !(this.axes instanceof CartesianAxes)) break;
                this.xaxisPos = _value.getDouble();
                ((CartesianAxes)this.axes).setX(this.xaxisPos);
                break;
            }
            case 27: {
                if (this.yaxisPos == _value.getDouble() || !(this.axes instanceof CartesianAxes)) break;
                this.yaxisPos = _value.getDouble();
                ((CartesianAxes)this.axes).setY(this.yaxisPos);
                break;
            }
            case 28: {
                if (_value.getObject() instanceof DecimalFormat) {
                    this.strBuilder.setXFormat((DecimalFormat)_value.getObject());
                    break;
                }
                this.strBuilder.setXFormat((DecimalFormat)ConstantParser.formatConstant(_value.getString()).getObject());
                break;
            }
            case 29: {
                if (_value.getObject() instanceof DecimalFormat) {
                    this.strBuilder.setYFormat((DecimalFormat)_value.getObject());
                    break;
                }
                this.strBuilder.setYFormat((DecimalFormat)ConstantParser.formatConstant(_value.getString()).getObject());
                break;
            }
            case 30: {
                this.removeAction(30, this.getProperty("keyAction"));
                this.addAction(30, _value.getString());
                break;
            }
            case 31: {
                this.keyPressedValue.value = _value.getInteger();
                break;
            }
            case 32: {
                this.removeAction(31, this.getProperty("enteredAction"));
                this.addAction(31, _value.getString());
                break;
            }
            case 33: {
                this.removeAction(32, this.getProperty("exitedAction"));
                this.addAction(32, _value.getString());
                break;
            }
            case 34: {
                this.setPrintTarget(_value.getString());
                break;
            }
            case 35: {
                this.strBuilder.setExpression(_value.getString());
                break;
            }
            case 36: {
                if (_value.getObject() instanceof DecimalFormat) {
                    this.strBuilder.setExpressionFormat((DecimalFormat)_value.getObject());
                    break;
                }
                this.strBuilder.setExpressionFormat((DecimalFormat)ConstantParser.formatConstant(_value.getString()).getObject());
                break;
            }
            case 37: {
                this.plottingPanel.setXMarginPercentage(_value.getDouble());
                break;
            }
            case 38: {
                this.plottingPanel.setYMarginPercentage(_value.getDouble());
                break;
            }
            case 39: {
                this.plottingPanel.setMessage(_value.getString(), 3);
                break;
            }
            case 40: {
                this.plottingPanel.setMessage(_value.getString(), 2);
                break;
            }
            case 41: {
                this.plottingPanel.setMessage(_value.getString(), 0);
                break;
            }
            case 42: {
                this.plottingPanel.setMessage(_value.getString(), 1);
                break;
            }
            case 43: {
                boolean visible = _value.getBoolean();
                this.plottingPanel.setClipAtGutter(visible);
                this.plottingPanel.setAxesVisible(visible);
                break;
            }
            case 44: {
                this.plottingPanel.setAdjustableGutter(!_value.getBoolean());
                break;
            }
            case 45: {
                boolean on = _value.getBoolean();
                this.plottingPanel.setAntialiasTextOn(on);
                this.plottingPanel.setAntialiasShapeOn(on);
                break;
            }
            case 46: {
                this.enableMenu = _value.getBoolean();
                break;
            }
            default: {
                super.setValue(_index - 47, _value);
                break;
            }
            case 55: {
                if (_value.getObject() instanceof Font) {
                    Font font = (Font)_value.getObject();
                    this.labelFontname = font.getFamily();
                    if (font.isPlain()) {
                        this.labelFontname = String.valueOf(this.labelFontname) + "-PLAIN";
                    } else if (font.isItalic()) {
                        this.labelFontname = font.isBold() ? String.valueOf(this.labelFontname) + "-BOLDITALIC" : String.valueOf(this.labelFontname) + "-ITALIC";
                    } else if (font.isBold()) {
                        this.labelFontname = String.valueOf(this.labelFontname) + "-BOLD";
                    }
                    this.labelFontname = String.valueOf(this.labelFontname) + "-" + font.getSize();
                    if (this.xLabel != null) {
                        this.axes.setXLabel(this.xLabel, this.labelFontname);
                    }
                    if (this.yLabel != null) {
                        this.axes.setYLabel(this.yLabel, this.labelFontname);
                    }
                }
                super.setValue(8, _value);
            }
        }
    }

    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.title = "";
                this.plottingPanel.setTitle("", this.titleFontname);
                break;
            }
            case 1: {
                this.titleFontname = "Helvetica-BOLD-14";
                if (this.title == null) break;
                this.axes.setTitle(this.title, this.titleFontname);
                break;
            }
            case 2: {
                this.axesType = 1;
                this.axes = AxisFactory.createAxesType1(this.plottingPanel);
                ((CartesianType1)this.axes).setXLog(this.xaxisLog);
                ((CartesianType1)this.axes).setYLog(this.yaxisLog);
                if (this.xLabel != null) {
                    this.axes.setXLabel(this.xLabel, this.labelFontname);
                }
                if (this.yLabel != null) {
                    this.axes.setYLabel(this.yLabel, this.labelFontname);
                }
                if (this.title != null) {
                    this.axes.setTitle(this.title, this.titleFontname);
                }
                this.axes.setShowMajorXGrid(this.axisGridX);
                this.axes.setShowMajorYGrid(this.axisGridY);
                break;
            }
            case 3: {
                this.xLabel = "";
                this.plottingPanel.setXLabel("", this.labelFontname);
                break;
            }
            case 4: {
                this.yLabel = "";
                this.plottingPanel.setYLabel("", this.labelFontname);
                break;
            }
            case 5: {
                this.xaxisLog = false;
                this.plottingPanel.setLogScale(false, this.yaxisLog);
                break;
            }
            case 6: {
                this.yaxisLog = false;
                this.plottingPanel.setLogScale(this.xaxisLog, false);
                break;
            }
            case 7: {
                this.deltaR = 1.0;
                if (!(this.axes instanceof PolarAxes)) break;
                ((PolarAxes)this.axes).setDeltaR(this.deltaR);
                break;
            }
            case 8: {
                this.deltaTheta = 0.39269908169872414;
                if (!(this.axes instanceof PolarAxes)) break;
                ((PolarAxes)this.axes).setDeltaTheta(this.deltaTheta);
                break;
            }
            case 9: {
                this.axes.setInteriorBackground(Color.white);
                break;
            }
            case 10: {
                this.axes.setShowMajorXGrid(true);
                break;
            }
            case 11: {
                this.axes.setShowMajorYGrid(true);
                break;
            }
            case 12: {
                this.autoX = false;
                this.updateAutoscale();
                break;
            }
            case 13: {
                this.autoY = false;
                this.updateAutoscale();
                break;
            }
            case 14: {
                this.minX = Double.NaN;
            }
            case 15: {
                this.maxX = Double.NaN;
            }
            case 16: {
                this.minY = Double.NaN;
            }
            case 17: {
                this.maxY = Double.NaN;
            }
            case 18: {
                this.posValues[0].value = (this.minX + this.maxX) / 2.0;
                break;
            }
            case 19: {
                this.posValues[1].value = (this.minY + this.maxY) / 2.0;
                break;
            }
            case 20: {
                this.removeAction(10, this.getProperty("pressaction"));
                break;
            }
            case 21: {
                this.removeAction(1, this.getProperty("dragaction"));
                break;
            }
            case 22: {
                this.removeAction(0, this.getProperty("action"));
                break;
            }
            case 23: {
                this.plottingPanel.setSquareAspect(false);
                break;
            }
            case 24: {
                this.plottingPanel.setShowCoordinates(true);
                break;
            }
            case 25: {
                this.plottingPanel.setPreferredGutters(this.defaultGutters[0], this.defaultGutters[1], this.defaultGutters[2], this.defaultGutters[3]);
                this.myGutters = null;
                break;
            }
            case 26: {
                if (!(this.axes instanceof CartesianAxes)) break;
                this.xaxisPos = Double.NaN;
                ((CartesianAxes)this.axes).setX(Double.NaN);
                break;
            }
            case 27: {
                if (!(this.axes instanceof CartesianAxes)) break;
                this.yaxisPos = Double.NaN;
                ((CartesianAxes)this.axes).setY(Double.NaN);
                break;
            }
            case 28: {
                this.strBuilder.setXFormat(new DecimalFormat("x=0.000;x=-0.000"));
                break;
            }
            case 29: {
                this.strBuilder.setYFormat(new DecimalFormat("y=0.000;y=-0.000"));
                break;
            }
            case 30: {
                this.removeAction(30, this.getProperty("keyAction"));
                break;
            }
            case 31: {
                this.keyPressedValue.value = -1;
                break;
            }
            case 32: {
                this.removeAction(31, this.getProperty("enteredAction"));
                break;
            }
            case 33: {
                this.removeAction(32, this.getProperty("exitedAction"));
                break;
            }
            case 34: {
                this.setPrintTarget(null);
                break;
            }
            case 35: {
                this.strBuilder.setExpression(null);
                break;
            }
            case 36: {
                this.strBuilder.setXFormat(new DecimalFormat("0.000;-0.000"));
                break;
            }
            case 37: {
                this.plottingPanel.setXMarginPercentage(0.0);
                break;
            }
            case 38: {
                this.plottingPanel.setYMarginPercentage(0.0);
                break;
            }
            case 39: {
                this.plottingPanel.setMessage("", 3);
                break;
            }
            case 40: {
                this.plottingPanel.setMessage("", 2);
                break;
            }
            case 41: {
                this.plottingPanel.setMessage("", 0);
                break;
            }
            case 42: {
                this.plottingPanel.setMessage("", 1);
                break;
            }
            case 43: {
                this.plottingPanel.setClipAtGutter(true);
                this.plottingPanel.setAxesVisible(true);
                break;
            }
            case 44: {
                this.plottingPanel.setAdjustableGutter(false);
                break;
            }
            case 45: {
                this.plottingPanel.setAntialiasTextOn(false);
                this.plottingPanel.setAntialiasShapeOn(false);
                break;
            }
            case 46: {
                this.enableMenu = true;
                break;
            }
            default: {
                super.setDefaultValue(_index - 47);
                break;
            }
            case 55: {
                this.labelFontname = "Helvetica-PLAIN-12";
                if (this.xLabel != null) {
                    this.axes.setXLabel(this.xLabel, this.labelFontname);
                }
                if (this.yLabel != null) {
                    this.axes.setYLabel(this.yLabel, this.labelFontname);
                }
                super.setDefaultValue(8);
            }
        }
    }

    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return null;
            }
            case 18: {
                return this.posValues[0];
            }
            case 19: {
                return this.posValues[1];
            }
            case 31: {
                return this.keyPressedValue;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                return null;
            }
        }
        return super.getValue(_index - 47);
    }

    public ControlDrawable getSelectedDrawable() {
        Object data;
        if (this.targetHit != null && this.targetHit.getSource() instanceof InteractiveElement) {
            Object data2 = ((InteractiveElement)this.targetHit.getSource()).getDataObject();
            if (data2 instanceof ControlDrawable) {
                return (ControlDrawable)data2;
            }
        } else if (this.target2D != null && (data = this.target2D.getElement().getDataObject()) instanceof ControlDrawable) {
            return (ControlDrawable)data;
        }
        return null;
    }

    private final void invokeTheAction(InteractionTarget _target2D, int _action, MouseEvent _evt) {
        Element element = _target2D.getElement();
        element.invokeActions(new org.opensourcephysics.drawing.core.interaction.InteractionEvent((Object)element, _action, _target2D.getActionCommand(), _target2D, _evt));
    }

    public void handleMouseAction(InteractivePanel _panel, MouseEvent _evt) {
        switch (_panel.getMouseAction()) {
            case 1: {
                Interactive interactiveDrawable = _panel.getInteractive();
                if (interactiveDrawable instanceof org.opensourcephysics.displayejs.InteractionTarget) {
                    this.targetHit = (org.opensourcephysics.displayejs.InteractionTarget)interactiveDrawable;
                    this.targetHit.getSource().invokeActions(new InteractionEvent((Object)this.targetHit.getSource(), 2000, null, this.targetHit));
                    break;
                }
                if (interactiveDrawable instanceof InteractionTarget) {
                    this.target2D = (InteractionTarget)interactiveDrawable;
                    this.invokeTheAction(this.target2D, 2000, _evt);
                    break;
                }
                this.targetHit = null;
                this.target2D = null;
                this.mousePressed(_panel.getMouseX(), _panel.getMouseY());
                break;
            }
            case 3: {
                if (this.targetHit != null) {
                    Point3D trackerPoint = new Point3D(_panel.getMouseX(), _panel.getMouseY(), 0.0);
                    this.targetHit.updateHotspot(_panel, trackerPoint);
                    this.targetHit.getSource().invokeActions(new InteractionEvent((Object)this.targetHit.getSource(), 2001, null, this.targetHit));
                    _panel.render();
                    break;
                }
                if (this.target2D != null) {
                    double[] point = new double[]{_panel.getMouseX(), _panel.getMouseY(), 0.0};
                    this.target2D.getElement().updateHotSpot(this.target2D, point);
                    this.invokeTheAction(this.target2D, 2001, _evt);
                    _panel.render();
                    break;
                }
                this.mouseDragged(_panel.getMouseX(), _panel.getMouseY());
                break;
            }
            case 2: {
                if (this.targetHit != null) {
                    this.targetHit.getSource().invokeActions(new InteractionEvent((Object)this.targetHit.getSource(), 2002, null, this.targetHit));
                    _panel.invalidateImage();
                    _panel.repaint();
                } else if (this.target2D != null) {
                    this.invokeTheAction(this.target2D, 2002, _evt);
                    _panel.invalidateImage();
                    _panel.repaint();
                } else {
                    this.mouseReleased(_panel.getMouseX(), _panel.getMouseY());
                }
                this.targetHit = null;
                this.target2D = null;
                break;
            }
            case 5: {
                this.invokeActions(31);
                break;
            }
            case 6: {
                this.invokeActions(32);
                this.targetHit = null;
                this.target2D = null;
                if (this.sourceLingered != null) {
                    this.sourceLingered.invokeActions(new InteractionEvent((Object)this.sourceLingered, 2004, null, this.sourceLingered));
                } else if (this.target2DEntered != null) {
                    this.invokeTheAction(this.target2DEntered, 2004, _evt);
                }
                this.sourceLingered = null;
                this.target2DEntered = null;
                break;
            }
            case 7: {
                Interactive interactiveDrawableLingered = _panel.getInteractive();
                if (interactiveDrawableLingered != null) {
                    _panel.setMouseCursor(Cursor.getPredefinedCursor(12));
                    if (interactiveDrawableLingered instanceof org.opensourcephysics.displayejs.InteractionTarget) {
                        if (this.sourceLingered == ((org.opensourcephysics.displayejs.InteractionTarget)interactiveDrawableLingered).getSource()) break;
                        if (this.sourceLingered != null) {
                            this.sourceLingered.invokeActions(new InteractionEvent((Object)this.sourceLingered, 2004, null, this.sourceLingered));
                        }
                        this.sourceLingered = ((org.opensourcephysics.displayejs.InteractionTarget)interactiveDrawableLingered).getSource();
                        this.sourceLingered.invokeActions(new InteractionEvent((Object)this.sourceLingered, 2003, null, interactiveDrawableLingered));
                        break;
                    }
                    if (!(interactiveDrawableLingered instanceof InteractionTarget) || this.target2DEntered != null && this.target2DEntered == interactiveDrawableLingered) break;
                    if (this.target2DEntered != null) {
                        this.invokeTheAction(this.target2DEntered, 2004, _evt);
                    }
                    this.target2DEntered = (InteractionTarget)interactiveDrawableLingered;
                    this.invokeTheAction(this.target2DEntered, 2003, _evt);
                    break;
                }
                _panel.setMouseCursor(Cursor.getPredefinedCursor(1));
                if (this.sourceLingered != null) {
                    this.sourceLingered.invokeActions(new InteractionEvent((Object)this.sourceLingered, 2004, null, this.sourceLingered));
                } else if (this.target2DEntered != null) {
                    this.invokeTheAction(this.target2DEntered, 2004, _evt);
                }
                this.sourceLingered = null;
                this.target2DEntered = null;
            }
        }
    }

    public void mousePressed(double _x, double _y) {
        this.plottingPanel.requestFocus();
        this.invokeActions(10);
        this.mouseDragged(_x, _y);
    }

    public void mouseDragged(double _x, double _y) {
        this.posValues[0].value = _x;
        this.posValues[1].value = _y;
        if (this.reportDrag) {
            this.variablesChanged(this.getPosIndex(), this.posValues);
            if (this.isUnderEjs) {
                this.setFieldListValues(this.getPosIndex(), this.posValues);
            }
        }
    }

    public void mouseReleased(double _x, double _y) {
        this.invokeActions(0);
    }
}

