/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.colos.ejs.library.control.ConstantParser;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.GUIUtils;

public class ControlSlider
extends ControlSwingElement {
    protected static final int SLIDER_ADDED = 12;
    protected static final int MY_FONT = 20;
    protected static final int MY_FOREGROUND = 18;
    private static final int RESOLUTION = 100000;
    private static final int VARIABLE = 0;
    private static final int VALUE = 1;
    protected JSlider slider;
    private DoubleValue internalValue;
    private boolean recalculate = true;
    private boolean defaultValueSet;
    private int ticks = 0;
    private double defaultValue;
    private double scale;
    private double minimum = 0.0;
    private double maximum = 1.0;
    private TitledBorder titledBorder;
    private EtchedBorder etchedBorder;
    private DecimalFormat format = null;
    private DecimalFormat ticksFormat = null;
    private String formatStr = null;
    private Color currentColor = null;
    private static ArrayList infoList = null;
    private boolean adjusted = false;

    protected Component createVisual() {
        this.slider = new JSlider();
        this.slider.setPaintLabels(false);
        this.slider.setPaintTicks(false);
        this.slider.setPaintTrack(true);
        this.slider.setMinimum(0);
        this.slider.setMaximum(100000);
        this.slider.setValue(0);
        this.slider.setForeground(Color.BLACK);
        this.etchedBorder = new EtchedBorder(1);
        this.titledBorder = new TitledBorder(this.etchedBorder, "");
        this.titledBorder.setTitleJustification(2);
        this.slider.setBorder(this.etchedBorder);
        this.defaultValue = 0.0;
        this.defaultValueSet = false;
        this.internalValue = new DoubleValue(this.defaultValue);
        this.minimum = 0.0;
        this.maximum = 1.0;
        this.scale = 100000.0 * (this.maximum - this.minimum);
        this.setMaximum(this.maximum);
        this.internalValue.value = this.minimum + (double)this.slider.getValue() / this.scale;
        this.slider.addChangeListener(new MyChangeListener());
        this.slider.addMouseListener(new MyMouseListener());
        return this.slider;
    }

    private void setTheValue(double val) {
        this.internalValue.value = val;
        this.recalculate = false;
        this.slider.setValue((int)((this.internalValue.value - this.minimum) * this.scale));
        this.recalculate = true;
        if (this.format != null) {
            this.titledBorder.setTitle(this.format.format(this.internalValue.value));
            this.slider.repaint();
        }
    }

    public void reset() {
        if (this.defaultValueSet) {
            this.setTheValue(this.defaultValue);
            this.variableChanged(0, this.internalValue);
        }
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("variable");
            infoList.add("value");
            infoList.add("minimum");
            infoList.add("maximum");
            infoList.add("pressaction");
            infoList.add("dragaction");
            infoList.add("action");
            infoList.add("format");
            infoList.add("ticks");
            infoList.add("ticksFormat");
            infoList.add("closest");
            infoList.add("orientation");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyCommonName(String _property) {
        if (_property.equals("action")) {
            return "releaseAction";
        }
        if (_property.equals("pressaction")) {
            return "pressAction";
        }
        if (_property.equals("dragaction")) {
            return "dragAction";
        }
        return super.getPropertyCommonName(_property);
    }

    public String getPropertyInfo(String _property) {
        if (_property.equals("variable")) {
            return "int|double";
        }
        if (_property.equals("value")) {
            return "int|double CONSTANT";
        }
        if (_property.equals("minimum")) {
            return "int|double";
        }
        if (_property.equals("maximum")) {
            return "int|double";
        }
        if (_property.equals("pressaction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("dragaction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("action")) {
            return "Action CONSTANT";
        }
        if (_property.equals("format")) {
            return "Format|Object|String TRANSLATABLE";
        }
        if (_property.equals("ticks")) {
            return "int";
        }
        if (_property.equals("ticksFormat")) {
            return "Format|Object|String TRANSLATABLE";
        }
        if (_property.equals("closest")) {
            return "boolean";
        }
        if (_property.equals("orientation")) {
            return "Orientation|int";
        }
        return super.getPropertyInfo(_property);
    }

    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                if (this.internalValue.value == _value.getDouble()) break;
                this.setTheValue(_value.getDouble());
                break;
            }
            case 1: {
                this.defaultValueSet = true;
                this.defaultValue = _value.getDouble();
                this.setActive(false);
                this.reset();
                this.setActive(true);
                break;
            }
            case 2: {
                this.setMinimum(_value.getDouble());
                break;
            }
            case 3: {
                this.setMaximum(_value.getDouble());
                break;
            }
            case 4: {
                this.removeAction(10, this.getProperty("pressaction"));
                this.addAction(10, _value.getString());
                break;
            }
            case 5: {
                this.removeAction(1, this.getProperty("dragaction"));
                this.addAction(1, _value.getString());
                break;
            }
            case 6: {
                this.removeAction(0, this.getProperty("action"));
                this.addAction(0, _value.getString());
                break;
            }
            case 7: {
                DecimalFormat newFormat;
                if (_value.getObject() instanceof DecimalFormat) {
                    newFormat = (DecimalFormat)_value.getObject();
                    this.formatStr = null;
                } else {
                    String newFormatStr = GUIUtils.parseTeX(_value.getString());
                    if (newFormatStr.equals(this.formatStr)) {
                        return;
                    }
                    this.formatStr = newFormatStr;
                    newFormat = (DecimalFormat)ConstantParser.formatConstant(this.formatStr).getObject();
                }
                if (newFormat.equals(this.format)) {
                    return;
                }
                this.format = newFormat;
                this.titledBorder.setTitle(this.format.format(this.internalValue.value));
                this.slider.setBorder(this.titledBorder);
                this.slider.repaint();
                break;
            }
            case 8: {
                if (_value.getInteger() == this.ticks) break;
                this.ticks = _value.getInteger();
                this.setTicks();
                break;
            }
            case 9: {
                DecimalFormat newFormat = _value.getObject() instanceof DecimalFormat ? (DecimalFormat)_value.getObject() : (DecimalFormat)ConstantParser.formatConstant(GUIUtils.parseTeX(_value.getString())).getObject();
                if (newFormat.equals(this.ticksFormat)) {
                    return;
                }
                this.ticksFormat = newFormat;
                this.slider.setPaintLabels(true);
                this.setTicks();
                break;
            }
            case 10: {
                this.slider.setSnapToTicks(_value.getBoolean());
                break;
            }
            case 11: {
                if (this.slider.getOrientation() == _value.getInteger()) break;
                this.slider.setOrientation(_value.getInteger());
                break;
            }
            default: {
                super.setValue(_index - 12, _value);
                break;
            }
            case 20: {
                if (_value.getObject() instanceof Font) {
                    this.setFont((Font)_value.getObject());
                }
                super.setValue(8, _value);
                break;
            }
            case 18: {
                if (_value.getObject() instanceof Color) {
                    this.setForeground((Color)_value.getObject());
                }
                super.setValue(6, _value);
            }
        }
    }

    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                break;
            }
            case 1: {
                this.defaultValueSet = false;
                break;
            }
            case 2: {
                this.setMinimum(0.0);
                break;
            }
            case 3: {
                this.setMaximum(1.0);
                break;
            }
            case 4: {
                this.removeAction(10, this.getProperty("pressaction"));
                break;
            }
            case 5: {
                this.removeAction(1, this.getProperty("dragaction"));
                break;
            }
            case 6: {
                this.removeAction(0, this.getProperty("action"));
                break;
            }
            case 7: {
                this.format = null;
                this.formatStr = null;
                this.slider.setBorder(this.etchedBorder);
                break;
            }
            case 8: {
                this.ticks = 0;
                this.setTicks();
                break;
            }
            case 9: {
                this.ticksFormat = null;
                this.slider.setPaintLabels(false);
                this.setTicks();
                break;
            }
            case 10: {
                this.slider.setSnapToTicks(false);
                break;
            }
            case 11: {
                this.slider.setOrientation(0);
                break;
            }
            default: {
                super.setDefaultValue(_index - 12);
                break;
            }
            case 20: {
                this.setFont(this.myDefaultFont);
                super.setDefaultValue(8);
                break;
            }
            case 18: {
                this.setForeground(this.myDefaultFrgd);
                super.setDefaultValue(6);
            }
        }
    }

    public Value getValue(int _index) {
        switch (_index) {
            case 0: {
                return this.internalValue;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return null;
            }
        }
        return super.getValue(_index - 12);
    }

    private void setTicks() {
        if (this.ticks < 2) {
            this.slider.setPaintTicks(false);
            return;
        }
        int spacing = 100000 / (this.ticks - 1);
        this.slider.setMinorTickSpacing(spacing);
        this.slider.setMajorTickSpacing(2 * spacing);
        this.slider.setPaintTicks(true);
        if (this.ticksFormat != null) {
            Hashtable<Integer, JLabel> table = new Hashtable<Integer, JLabel>();
            int i = 0;
            while (i <= 100000) {
                table.put(new Integer(i), new JLabel(this.ticksFormat.format(this.minimum + (double)i / this.scale)));
                i += 2 * spacing;
            }
            this.slider.setLabelTable(table);
        }
        if (this.currentColor != null) {
            this.setForeground(this.currentColor);
        }
    }

    private void setMinimum(double val) {
        if (val == this.minimum) {
            return;
        }
        this.minimum = val;
        this.scale = 100000.0 / (this.maximum - this.minimum);
        this.setTicks();
        this.setTheValue(this.internalValue.value);
    }

    private void setMaximum(double val) {
        if (val == this.maximum) {
            return;
        }
        this.maximum = val;
        this.scale = 100000.0 / (this.maximum - this.minimum);
        this.setTicks();
        this.setTheValue(this.internalValue.value);
    }

    private void setFont(Font aFont) {
        this.titledBorder.setTitleFont(aFont);
    }

    private void setForeground(Color aColor) {
        this.titledBorder.setTitleColor(aColor);
        Dictionary labels = this.slider.getLabelTable();
        if (labels != null) {
            Enumeration e = labels.elements();
            while (e.hasMoreElements()) {
                Object object = e.nextElement();
                if (!(object instanceof JLabel)) continue;
                ((JLabel)object).setForeground(aColor);
            }
        }
        this.currentColor = aColor;
    }

    private class MyChangeListener
    implements ChangeListener {
        private MyChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            if (ControlSlider.this.recalculate) {
                double value;
                ((ControlSlider)ControlSlider.this).internalValue.value = value = ControlSlider.this.minimum + (double)ControlSlider.this.slider.getValue() / ControlSlider.this.scale;
                if (ControlSlider.this.format != null) {
                    ControlSlider.this.titledBorder.setTitle(ControlSlider.this.format.format(((ControlSlider)ControlSlider.this).internalValue.value));
                    ControlSlider.this.slider.repaint();
                }
                ControlSlider.this.variableChanged(0, ControlSlider.this.internalValue);
                if (ControlSlider.this.isUnderEjs) {
                    ControlSlider.this.setFieldListValueWithAlternative(0, 1, ControlSlider.this.internalValue);
                }
            }
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        public void mousePressed(MouseEvent evt) {
            if (ControlSlider.this.slider.isEnabled()) {
                ControlSlider.this.invokeActions(10);
            }
        }

        public void mouseReleased(MouseEvent evt) {
            if (ControlSlider.this.slider.isEnabled()) {
                ControlSlider.this.invokeActions(0);
            }
        }
    }
}

