/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.swing.ConstantParser;
import org.colos.ejs.library.control.swing.ControlContainer;
import org.colos.ejs.library.control.swing.ControlWindow;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.ObjectValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.tools.ResourceLoader;

public abstract class ControlSwingElement
extends ControlElement {
    public static final int NAME = 0;
    public static final int POSITION = 1;
    public static final int PARENT = 2;
    public static final int ENABLED = 3;
    public static final int VISIBLE = 4;
    public static final int SIZE = 5;
    public static final int FOREGROUND = 6;
    public static final int BACKGROUND = 7;
    public static final int FONT = 8;
    public static final int TOOLTIP = 9;
    public static final int MENU_NAME = 10;
    public static final int ACTION_PRESS = 10;
    public static final int ACTION_ON = 20;
    public static final int ACTION_OFF = 21;
    public static final int KEY_ACTION = 30;
    public static final int MOUSE_ENTERED_ACTION = 31;
    public static final int MOUSE_EXITED_ACTION = 32;
    public static final int MOUSE_MOVED_ACTION = 33;
    private static ArrayList myInfoList = null;
    protected Component myVisual = this.createVisual();
    protected Color myDefaultBkgd;
    protected Color myDefaultFrgd;
    protected Font myDefaultFont;
    private Dimension mySize;
    private String menuNameEntry = null;

    public ControlSwingElement() {
        this.myObject = this.myVisual;
        this.myDefaultFrgd = this.myVisual.getForeground();
        this.myDefaultBkgd = this.myVisual.getBackground();
        this.myDefaultFont = this.myVisual.getFont();
        if (this.myVisual instanceof JComponent) {
            this.mySize = ((JComponent)this.myVisual).getPreferredSize();
        }
    }

    protected abstract Component createVisual();

    public final Component getVisual() {
        return this.myVisual;
    }

    public Component getComponent() {
        return this.myVisual;
    }

    public final void changeVisual(Component newVisual) {
        newVisual.setEnabled(this.myVisual.isEnabled());
        newVisual.setVisible(this.myVisual.isVisible());
        if (newVisual instanceof JComponent && this.getComponent() instanceof JComponent) {
            ControlElement parentElement;
            ((JComponent)newVisual).setPreferredSize(this.mySize);
            if (newVisual instanceof Container) {
                ((Container)newVisual).validate();
            }
            if ((parentElement = this.myGroup.getElement(this.getProperty("parent"))) != null) {
                ((ControlContainer)parentElement).adjustSize();
            }
        }
        newVisual.setForeground(this.myVisual.getForeground());
        newVisual.setBackground(this.myVisual.getBackground());
        newVisual.setFont(this.myVisual.getFont());
        ((JComponent)newVisual).setToolTipText(((JComponent)this.myVisual).getToolTipText());
        final ControlElement parent = this.myGroup.getElement(this.getProperty("parent"));
        if (parent != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                ((ControlContainer)parent).remove(this);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public synchronized void run() {
                            ((ControlContainer)parent).remove(ControlSwingElement.this);
                        }
                    });
                }
                catch (Exception exception) {}
            }
        }
        this.myVisual = newVisual;
        this.myObject = this.myVisual;
        this.myDefaultFrgd = this.myVisual.getForeground();
        this.myDefaultBkgd = this.myVisual.getBackground();
        this.myDefaultFont = this.myVisual.getFont();
        if (this.myVisual instanceof JComponent) {
            this.mySize = ((JComponent)this.myVisual).getPreferredSize();
        }
        if (parent != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                ((ControlContainer)parent).add(this);
                ((ControlContainer)parent).adjustSize();
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public synchronized void run() {
                            ((ControlContainer)parent).add(ControlSwingElement.this);
                            ((ControlContainer)parent).adjustSize();
                        }
                    });
                }
                catch (Exception exception) {}
            }
        }
    }

    public String getMenuNameEntry() {
        if (this.menuNameEntry != null) {
            if (this.menuNameEntry.equals("null")) {
                return null;
            }
            return this.menuNameEntry;
        }
        return this.getProperty("name");
    }

    public ArrayList getPropertyList() {
        if (myInfoList == null) {
            myInfoList = new ArrayList();
            myInfoList.add("name");
            myInfoList.add("position");
            myInfoList.add("parent");
            myInfoList.add("enabled");
            myInfoList.add("visible");
            myInfoList.add("size");
            myInfoList.add("foreground");
            myInfoList.add("background");
            myInfoList.add("font");
            myInfoList.add("tooltip");
            myInfoList.add("menuName");
        }
        return myInfoList;
    }

    public String getPropertyInfo(String _property) {
        if (_property.equals("name")) {
            return "String         CONSTANT";
        }
        if (_property.equals("position")) {
            return "Position       CONSTANT PREVIOUS";
        }
        if (_property.equals("parent")) {
            return "ControlElement CONSTANT";
        }
        if (_property.equals("enabled")) {
            return "boolean";
        }
        if (_property.equals("visible")) {
            return "boolean";
        }
        if (_property.equals("size")) {
            return "Dimension|Object|String TRANSLATABLE";
        }
        if (_property.equals("foreground")) {
            return "Color|Object";
        }
        if (_property.equals("background")) {
            return "Color|Object";
        }
        if (_property.equals("font")) {
            return "Font|Object";
        }
        if (_property.equals("tooltip")) {
            return "String TRANSLATABLE";
        }
        if (_property.equals("menuName")) {
            return "String TRANSLATABLE";
        }
        return null;
    }

    public Value parseConstant(String _propertyType, String _value) {
        Value constantValue;
        if (_value == null) {
            return null;
        }
        if (_propertyType.indexOf("Alignment") >= 0 && (constantValue = ConstantParser.alignmentConstant(_value)) != null) {
            return constantValue;
        }
        if (_propertyType.indexOf("Dimension") >= 0 && (constantValue = ConstantParser.dimensionConstant(_value)) != null) {
            return constantValue;
        }
        if (_propertyType.indexOf("Layout") >= 0 && (constantValue = ConstantParser.layoutConstant(((ControlContainer)this).getContainer(), _value)) != null) {
            return constantValue;
        }
        if (_propertyType.indexOf("Orientation") >= 0 && (constantValue = ConstantParser.orientationConstant(_value)) != null) {
            return constantValue;
        }
        if (_propertyType.indexOf("Placement") >= 0 && (constantValue = ConstantParser.placementConstant(_value)) != null) {
            return constantValue;
        }
        if (_propertyType.indexOf("Point") >= 0 && (constantValue = ConstantParser.pointConstant(_value)) != null) {
            return constantValue;
        }
        if (_propertyType.indexOf("Mnemonic") >= 0 && (_value = _value.trim().toLowerCase()).length() > 0) {
            return new IntegerValue(_value.charAt(0));
        }
        return super.parseConstant(_propertyType, _value);
    }

    public String toStringValue(Value _value) {
        if (_value instanceof ObjectValue) {
            ObjectValue obj = (ObjectValue)_value;
            if (obj.value instanceof Point) {
                return ConstantParser.toString((Point)obj.value);
            }
            if (obj.value instanceof Dimension) {
                return ConstantParser.toString((Dimension)obj.value);
            }
        }
        return super.toStringValue(_value);
    }

    public void setValue(int _index, final Value _value) {
        switch (_index) {
            case 0: {
                super.setValue(0, _value);
                this.getComponent().setName(_value.toString());
                break;
            }
            case 1: {
                Runnable doIt = new Runnable(){

                    public synchronized void run() {
                        ControlElement parent = ControlSwingElement.this.myGroup.getElement(ControlSwingElement.this.getProperty("parent"));
                        if (parent != null && parent instanceof ControlContainer) {
                            ((ControlContainer)parent).remove(ControlSwingElement.this);
                        }
                        ControlSwingElement.this.myPropertiesTable.put("position", _value.toString());
                        if (parent != null && parent instanceof ControlContainer) {
                            ((ControlContainer)parent).add(ControlSwingElement.this);
                        }
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    doIt.run();
                    break;
                }
                try {
                    SwingUtilities.invokeAndWait(doIt);
                }
                catch (Exception exception) {
                    doIt.run();
                }
                break;
            }
            case 2: {
                Runnable doIt = new Runnable(){

                    public synchronized void run() {
                        ControlElement parent = ControlSwingElement.this.myGroup.getElement(ControlSwingElement.this.getProperty("parent"));
                        if (parent != null && parent instanceof ControlContainer) {
                            ((ControlContainer)parent).remove(ControlSwingElement.this);
                        }
                        if ((parent = ControlSwingElement.this.myGroup.getElement(_value.toString())) == null) {
                            if (!(ControlSwingElement.this instanceof ControlWindow)) {
                                System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Parent <" + _value + "> not found for " + this.toString());
                            }
                        } else if (parent instanceof ControlContainer) {
                            ((ControlContainer)parent).add(ControlSwingElement.this);
                        } else {
                            System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Parent <" + _value + "> is not a ControlContainer");
                        }
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    doIt.run();
                    break;
                }
                try {
                    SwingUtilities.invokeAndWait(doIt);
                }
                catch (Exception exception) {
                    doIt.run();
                }
                break;
            }
            case 3: {
                this.getVisual().setEnabled(_value.getBoolean());
                break;
            }
            case 4: {
                this.getVisual().setVisible(_value.getBoolean());
                break;
            }
            case 5: {
                Runnable doIt = new Runnable(){

                    public synchronized void run() {
                        if (ControlSwingElement.this.getComponent() instanceof JComponent) {
                            ControlElement parentElement;
                            Dimension size = (Dimension)_value.getObject();
                            if (size.width == ((ControlSwingElement)ControlSwingElement.this).mySize.width && size.height == ((ControlSwingElement)ControlSwingElement.this).mySize.height) {
                                return;
                            }
                            JComponent jComponent = (JComponent)ControlSwingElement.this.getComponent();
                            Dimension dimension = size;
                            ControlSwingElement.this.mySize = dimension;
                            jComponent.setPreferredSize(dimension);
                            if (ControlSwingElement.this instanceof ControlContainer) {
                                ((ControlContainer)ControlSwingElement.this).getContainer().validate();
                            }
                            if ((parentElement = ControlSwingElement.this.myGroup.getElement(ControlSwingElement.this.getProperty("parent"))) != null) {
                                ((ControlContainer)parentElement).adjustSize();
                            }
                        }
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    doIt.run();
                    break;
                }
                try {
                    SwingUtilities.invokeAndWait(doIt);
                }
                catch (Exception exception) {
                    doIt.run();
                }
                break;
            }
            case 6: {
                if (!(_value.getObject() instanceof Color)) break;
                this.getVisual().setForeground((Color)_value.getObject());
                break;
            }
            case 7: {
                if (!(_value.getObject() instanceof Color)) break;
                this.getVisual().setBackground((Color)_value.getObject());
                break;
            }
            case 8: {
                if (!(_value.getObject() instanceof Font)) break;
                this.getVisual().setFont((Font)_value.getObject());
                break;
            }
            case 9: {
                if (!(this.getVisual() instanceof JComponent)) break;
                ((JComponent)this.getVisual()).setToolTipText(GUIUtils.parseTeX(_value.getString()));
                break;
            }
            case 10: {
                this.menuNameEntry = _value.getString();
            }
        }
    }

    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                super.setDefaultValue(0);
                this.getComponent().setName("");
                break;
            }
            case 1: {
                ControlElement parent = this.myGroup.getElement(this.getProperty("parent"));
                if (parent != null && parent instanceof ControlContainer) {
                    ((ControlContainer)parent).remove(this);
                }
                this.myPropertiesTable.remove("position");
                if (parent == null || !(parent instanceof ControlContainer)) break;
                ((ControlContainer)parent).add(this);
                break;
            }
            case 2: {
                ControlElement parent = this.myGroup.getElement(this.getProperty("parent"));
                if (parent == null || !(parent instanceof ControlContainer)) break;
                ((ControlContainer)parent).remove(this);
                break;
            }
            case 3: {
                this.getVisual().setEnabled(true);
                break;
            }
            case 4: {
                this.getVisual().setVisible(true);
                break;
            }
            case 5: {
                ControlElement parentElement;
                if (!(this.getComponent() instanceof JComponent)) break;
                ((JComponent)this.getComponent()).setPreferredSize(null);
                if (this instanceof ControlContainer) {
                    ((ControlContainer)this).getContainer().validate();
                }
                if ((parentElement = this.myGroup.getElement(this.getProperty("parent"))) == null) break;
                ((ControlContainer)parentElement).adjustSize();
                break;
            }
            case 6: {
                this.getVisual().setForeground(this.myDefaultFrgd);
                break;
            }
            case 7: {
                this.getVisual().setBackground(this.myDefaultBkgd);
                break;
            }
            case 8: {
                this.getVisual().setFont(this.myDefaultFont);
                break;
            }
            case 9: {
                if (!(this.getComponent() instanceof JComponent)) break;
                ((JComponent)this.getVisual()).setToolTipText(null);
                break;
            }
            case 10: {
                this.menuNameEntry = null;
                break;
            }
        }
    }

    public Value getValue(int _index) {
        return null;
    }

    protected ImageIcon getIcon(String _iconFile) {
        ImageIcon icon = ResourceLoader.getIcon(_iconFile);
        return icon;
    }
}

