/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.NeedsUpdate;
import org.colos.ejs.library.control.swing.ConstantParser;
import org.colos.ejs.library.control.swing.ControlContainer;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.value.BooleanValue;
import org.colos.ejs.library.control.value.ObjectValue;
import org.colos.ejs.library.control.value.StringValue;
import org.colos.ejs.library.control.value.Value;

public abstract class ControlWindow
extends ControlContainer
implements NeedsUpdate {
    public static final int WINDOW_ADDED = 5;
    public static final int LOCATION = 1;
    public static final int NAME = 5;
    public static final int VISIBLE = 9;
    public static final int SIZE = 10;
    private static final Dimension ScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
    private static boolean keepHidden = false;
    private Window myWindow;
    private LayoutManager myLayout = null;
    private Point myLocation = null;
    private Dimension mySize = null;
    protected boolean waitForReset = false;
    protected boolean startingup = true;
    protected boolean shouldShow = true;
    protected JMenuBar menubar = null;
    private boolean notFirstTimeMoved = false;
    private boolean notFirstTimeSized = false;
    private ObjectValue locationValue;
    private ObjectValue sizeValue;
    protected BooleanValue internalValue;
    private static ArrayList infoList = null;

    public static void setKeepHidden(boolean hidden) {
        keepHidden = hidden;
    }

    public ControlWindow() {
        this.setListeners();
    }

    public boolean acceptsChild(ControlElement _child) {
        return _child instanceof ControlSwingElement;
    }

    public abstract JRootPane getRootPane();

    public void updateLocation() {
        Point loc = this.getComponent().getLocation();
        this.setLocation(loc.x, loc.y);
    }

    protected void setLocation(int x, int y) {
        if (this.myGroup != null) {
            Point disp = this.myGroup.getDisplacement();
            x += disp.x;
            y += disp.y;
        }
        if (x < 0) {
            x = 0;
        } else if (x > ControlWindow.ScreenSize.width - this.getComponent().getWidth()) {
            x = ControlWindow.ScreenSize.width - this.getComponent().getWidth();
        }
        if (y < 0) {
            y = 0;
        } else if (y > ControlWindow.ScreenSize.height - this.getComponent().getHeight()) {
            y = ControlWindow.ScreenSize.height - this.getComponent().getHeight();
        }
        this.getComponent().setLocation(x, y);
    }

    protected Point getLocation() {
        if (this.myGroup != null) {
            Point disp = this.myGroup.getDisplacement();
            Point loc = this.getComponent().getLocation();
            return new Point(loc.x - disp.x, loc.y - disp.y);
        }
        return this.getComponent().getLocation();
    }

    protected void setListeners() {
        this.myWindow = (Window)this.getComponent();
        this.locationValue = new ObjectValue(this.getLocation());
        this.sizeValue = new ObjectValue(this.myWindow.getSize());
        this.myWindow.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent evt) {
                ObjectValue objectValue = ControlWindow.this.locationValue;
                Point point = ControlWindow.this.getLocation();
                ControlWindow.this.myLocation = point;
                objectValue.value = point;
                if (ControlWindow.this.isUnderEjs && ControlWindow.this.notFirstTimeMoved) {
                    ControlWindow.this.setFieldListValue(ControlWindow.this.getLocationIndex(), ControlWindow.this.locationValue, false);
                }
                ControlWindow.this.notFirstTimeMoved = true;
            }

            public void componentResized(ComponentEvent _e) {
                Dimension size = ControlWindow.this.myWindow instanceof RootPaneContainer ? ControlWindow.this.getRootPane().getSize() : ControlWindow.this.myWindow.getSize();
                if (ControlWindow.this.startingup || !ControlWindow.this.notFirstTimeSized) {
                    ControlWindow.this.notFirstTimeSized = true;
                    return;
                }
                ObjectValue objectValue = ControlWindow.this.sizeValue;
                Dimension dimension = size;
                ControlWindow.this.mySize = dimension;
                objectValue.value = dimension;
                if (ControlWindow.this.isUnderEjs) {
                    ControlWindow.this.setFieldListValue(ControlWindow.this.getSizeIndex(), ControlWindow.this.sizeValue, false);
                }
                ControlWindow.this.invokeActions(10);
            }
        });
        this.myWindow.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ControlWindow.this.whenClosing();
            }
        });
    }

    protected abstract int getVisibleIndex();

    protected abstract int getLocationIndex();

    protected abstract int getSizeIndex();

    protected void whenClosing() {
        this.internalValue.value = false;
        this.variableChanged(this.getVisibleIndex(), this.internalValue);
        this.invokeActions(21);
    }

    public void dispose() {
        ((Window)this.getComponent()).setVisible(false);
        ((Window)this.getComponent()).dispose();
    }

    public void show() {
        Window w;
        if (keepHidden) {
            return;
        }
        if (this.startingup) {
            this.shouldShow = true;
            if (this.waitForReset) {
                return;
            }
        }
        if (!(w = (Window)this.getComponent()).isShowing()) {
            w.setVisible(true);
        }
    }

    public void hide() {
        Window w;
        if (this.startingup) {
            this.shouldShow = false;
            if (this.waitForReset) {
                return;
            }
        }
        if ((w = (Window)this.getComponent()).isShowing()) {
            w.setVisible(false);
        }
    }

    public void destroy() {
        this.dispose();
        super.destroy();
    }

    public void setWaitForReset(boolean _option) {
        this.waitForReset = _option;
        if (this.waitForReset) {
            ((Window)this.getComponent()).setVisible(false);
        }
    }

    public void reset() {
        this.startingup = false;
        if (this.shouldShow) {
            this.show();
        } else {
            this.hide();
        }
        super.reset();
    }

    public void update() {
        this.startingup = false;
    }

    public void adjustSize() {
        String size = this.getProperty("size");
        ((Container)this.getComponent()).validate();
        if (size != null && size.trim().toLowerCase().equals("pack")) {
            ((Window)this.getComponent()).pack();
        } else {
            super.adjustSize();
        }
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("layout");
            infoList.add("location");
            infoList.add("waitForReset");
            infoList.add("onClosing");
            infoList.add("resizeAction");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String _property) {
        if (_property.equals("location")) {
            return "Point|Object|String NO_RESET";
        }
        if (_property.equals("layout")) {
            return "Layout|Object NO_RESET";
        }
        if (_property.equals("waitForReset")) {
            return "boolean";
        }
        if (_property.equals("onClosing")) {
            return "Action CONSTANT";
        }
        if (_property.equals("resizeAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("size")) {
            return "Dimension|Object|String TRANSLATABLE NO_RESET";
        }
        return super.getPropertyInfo(_property);
    }

    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                if (!(_value.getObject() instanceof LayoutManager)) break;
                LayoutManager layout = (LayoutManager)_value.getObject();
                if (layout != this.myLayout) {
                    this.myLayout = layout;
                    this.getContainer().setLayout(this.myLayout);
                    this.adjustChildren();
                }
                ((Container)this.getComponent()).validate();
                break;
            }
            case 1: {
                Point pos = null;
                if (_value.getObject() instanceof Point) {
                    pos = (Point)_value.getObject();
                } else {
                    Value val = ConstantParser.pointConstant(_value.getString());
                    if (val == null) {
                        return;
                    }
                    pos = (Point)val.getObject();
                }
                this.locationValue.value = pos;
                if (pos.equals(this.myLocation)) {
                    return;
                }
                this.myLocation = pos;
                this.setLocation(pos.x, pos.y);
                break;
            }
            case 2: {
                this.setWaitForReset(_value.getBoolean());
                break;
            }
            case 3: {
                this.removeAction(21, this.getProperty("onClosing"));
                this.addAction(21, _value.getString());
                break;
            }
            case 4: {
                this.removeAction(10, this.getProperty("resizeAction"));
                this.addAction(10, _value.getString());
                break;
            }
            case 9: {
                this.internalValue.value = _value.getBoolean();
                if (this.internalValue.value) {
                    this.show();
                    break;
                }
                this.hide();
                break;
            }
            case 10: {
                Dimension size = null;
                if (_value instanceof StringValue) {
                    if ("pack".equals(_value.getString())) {
                        ((Window)this.getComponent()).pack();
                        this.mySize = size = this.getComponent().getSize();
                        this.sizeValue.value = size;
                    } else {
                        Value val = ConstantParser.dimensionConstant(_value.getString());
                        if (val == null) {
                            return;
                        }
                        size = (Dimension)val.getObject();
                        this.sizeValue.value = size;
                        if (size.equals(this.mySize)) {
                            return;
                        }
                        this.mySize = size;
                        this.getRootPane().setPreferredSize(this.mySize);
                        ((Container)this.getComponent()).validate();
                        ((Window)this.getComponent()).pack();
                    }
                } else if (_value.getObject() instanceof Dimension) {
                    size = (Dimension)_value.getObject();
                    this.sizeValue.value = size;
                    if (size.equals(this.mySize)) {
                        return;
                    }
                    this.mySize = size;
                    this.getRootPane().setPreferredSize(this.mySize);
                    ((Container)this.getComponent()).validate();
                    ((Window)this.getComponent()).pack();
                } else {
                    return;
                }
                String loc = this.getProperty("location");
                if (loc == null || !loc.trim().toLowerCase().equals("center")) break;
                Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                this.setLocation((dim.width - size.width) / 2, (dim.height - size.height) / 2);
                break;
            }
            default: {
                super.setValue(_index - 5, _value);
            }
        }
    }

    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.myLayout = new BorderLayout();
                this.getContainer().setLayout(this.myLayout);
                this.adjustChildren();
                ((Container)this.getComponent()).validate();
                break;
            }
            case 1: {
                this.myLocation = new Point(0, 0);
                this.setLocation(0, 0);
                this.locationValue.value = this.myLocation;
                break;
            }
            case 2: {
                this.setWaitForReset(false);
                break;
            }
            case 3: {
                this.removeAction(21, this.getProperty("onClosing"));
                break;
            }
            case 4: {
                this.removeAction(10, this.getProperty("resizeAction"));
                break;
            }
            case 9: {
                this.internalValue.value = true;
                this.show();
                break;
            }
            case 10: {
                ((Window)this.getComponent()).pack();
                Dimension size = this.getComponent().getSize();
                if (this.menubar != null) {
                    Dimension mbs = this.menubar.getSize();
                    size.height += mbs.height;
                }
                this.sizeValue.value = size;
                String loc = this.getProperty("location");
                if (loc == null || !loc.trim().toLowerCase().equals("center")) break;
                Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                this.setLocation((dim.width - size.width) / 2, (dim.height - size.height) / 2);
                break;
            }
            default: {
                super.setDefaultValue(_index - 5);
            }
        }
    }

    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 2: 
            case 3: 
            case 4: {
                return null;
            }
            case 1: {
                return this.locationValue;
            }
            case 9: {
                return this.internalValue;
            }
            case 10: {
                return this.sizeValue;
            }
        }
        return super.getValue(_index - 5);
    }
}

