/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import org.colos.ejs.library.control.value.ParserSuryono;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.axes.CoordinateStringBuilder;

class MyCoordinateStringBuilder
extends CoordinateStringBuilder {
    DecimalFormat xFormat = new DecimalFormat("x=0.000;x=-0.000");
    DecimalFormat yFormat = new DecimalFormat("y=0.000;y=-0.000");
    ParserSuryono parser = null;
    DecimalFormat expressionFormat = new DecimalFormat("0.000;-0.000");

    MyCoordinateStringBuilder() {
    }

    public void setXFormat(DecimalFormat format) {
        this.xFormat = format;
    }

    public void setYFormat(DecimalFormat format) {
        this.yFormat = format;
    }

    public void setExpressionFormat(DecimalFormat format) {
        this.expressionFormat = format;
    }

    public void setExpression(String _expression) {
        if (_expression == null) {
            this.parser = null;
            return;
        }
        this.parser = new ParserSuryono(2);
        this.parser.defineVariable(0, "x");
        this.parser.defineVariable(1, "y");
        this.parser.define(_expression);
        this.parser.parse();
    }

    public String getCoordinateString(DrawingPanel panel, MouseEvent e) {
        String txt = "";
        double x = panel.pixToX(e.getPoint().x);
        double y = panel.pixToY(e.getPoint().y);
        if (this.xFormat != null) {
            txt = this.yFormat != null ? String.valueOf(this.xFormat.format(x)) + " " + this.yFormat.format(y) : this.xFormat.format(x);
        } else if (this.yFormat != null) {
            txt = this.yFormat.format(y);
        }
        if (this.parser != null) {
            this.parser.setVariable(0, x);
            this.parser.setVariable(1, y);
            if (txt.length() > 0) {
                txt = String.valueOf(txt) + " ";
            }
            txt = String.valueOf(txt) + this.expressionFormat.format(this.parser.evaluate());
        }
        return txt;
    }
}

