/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.value;

import java.util.StringTokenizer;
import org.colos.ejs.library.control.value.BooleanValue;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.ObjectValue;
import org.colos.ejs.library.control.value.StringValue;

public abstract class Value {
    public abstract boolean getBoolean();

    public abstract int getInteger();

    public abstract double getDouble();

    public abstract String getString();

    public abstract Object getObject();

    public void copyValue(Value _source) {
        if (this instanceof DoubleValue) {
            ((DoubleValue)this).value = _source.getDouble();
        } else if (this instanceof IntegerValue) {
            ((IntegerValue)this).value = _source.getInteger();
        } else if (this instanceof BooleanValue) {
            ((BooleanValue)this).value = _source.getBoolean();
        } else if (this instanceof StringValue) {
            ((StringValue)this).value = _source.getString();
        } else if (this instanceof ObjectValue) {
            ((ObjectValue)this).value = _source.getObject();
        }
    }

    public Value cloneValue() {
        if (this instanceof DoubleValue) {
            return new DoubleValue(this.getDouble());
        }
        if (this instanceof IntegerValue) {
            return new IntegerValue(this.getInteger());
        }
        if (this instanceof BooleanValue) {
            return new BooleanValue(this.getBoolean());
        }
        if (this instanceof StringValue) {
            return new StringValue(this.getString());
        }
        if (this instanceof ObjectValue) {
            return new ObjectValue(this.getObject());
        }
        return null;
    }

    public String toString() {
        return this.getString();
    }

    public static Value parseConstantOrArray(String _input, boolean _silentMode) {
        int index;
        String inputTrimmed = _input.trim();
        boolean isArray = false;
        if (inputTrimmed.startsWith("new ") && (index = inputTrimmed.indexOf(123)) > 0) {
            inputTrimmed = inputTrimmed.substring(index);
        }
        if (inputTrimmed.startsWith("{") && inputTrimmed.endsWith("}")) {
            _input = inputTrimmed.substring(1, inputTrimmed.length() - 1);
            isArray = true;
        }
        StringTokenizer tkn = new StringTokenizer(_input, ",");
        int dim = tkn.countTokens();
        if (!isArray && dim <= 1) {
            return Value.parseConstant(_input, _silentMode);
        }
        Value[] data = new Value[dim];
        boolean hasDoubles = false;
        boolean hasInts = false;
        boolean hasBooleans = false;
        boolean hasStrings = false;
        int i = 0;
        while (i < dim) {
            String token = tkn.nextToken();
            data[i] = Value.parseConstant(token, _silentMode);
            if (data[i] == null) {
                return Value.parseConstant(_input, _silentMode);
            }
            if (data[i] instanceof DoubleValue) {
                hasDoubles = true;
            } else if (data[i] instanceof IntegerValue) {
                hasInts = true;
            } else if (data[i] instanceof BooleanValue) {
                hasBooleans = true;
            } else if (data[i] instanceof StringValue) {
                hasStrings = true;
            }
            ++i;
        }
        if (hasDoubles) {
            double[] doubleArray = new double[dim];
            int i2 = 0;
            while (i2 < dim) {
                doubleArray[i2] = data[i2].getDouble();
                ++i2;
            }
            return new ObjectValue(doubleArray);
        }
        if (hasInts) {
            int[] intArray = new int[dim];
            int i3 = 0;
            while (i3 < dim) {
                intArray[i3] = data[i3].getInteger();
                ++i3;
            }
            return new ObjectValue(intArray);
        }
        if (hasBooleans) {
            boolean[] booleanArray = new boolean[dim];
            int i4 = 0;
            while (i4 < dim) {
                booleanArray[i4] = data[i4].getBoolean();
                ++i4;
            }
            return new ObjectValue(booleanArray);
        }
        if (hasStrings) {
            String[] stringArray = new String[dim];
            int i5 = 0;
            while (i5 < dim) {
                stringArray[i5] = data[i5].getString();
                ++i5;
            }
            return new ObjectValue(stringArray);
        }
        return Value.parseConstant(_input, _silentMode);
    }

    public static String removeScapes(String str) {
        String txt = "";
        int l = str.length();
        int i = 0;
        while (i < l) {
            char c = str.charAt(i);
            if (c == '\\') {
                if (i == l - 1) {
                    return String.valueOf(txt) + c;
                }
                c = str.charAt(++i);
            }
            txt = String.valueOf(txt) + c;
            ++i;
        }
        return txt;
    }

    public static Value parseConstant(String _input, boolean _silentMode) {
        if ((_input = _input.trim()).length() <= 0) {
            return null;
        }
        if (_input.equals("null")) {
            return new ObjectValue(null);
        }
        if (_input.startsWith("\"")) {
            if (_input.length() <= 1) {
                return null;
            }
            if (!_input.endsWith("\"")) {
                return null;
            }
            return new StringValue(Value.removeScapes(_input.substring(1, _input.length() - 1)));
        }
        if (_input.startsWith("'")) {
            if (!_input.endsWith("'")) {
                return null;
            }
            return new StringValue(Value.removeScapes(_input.substring(1, _input.length() - 1)));
        }
        if (_input.equals("true")) {
            return new BooleanValue(true);
        }
        if (_input.equals("false")) {
            return new BooleanValue(false);
        }
        if (_input.indexOf(46) >= 0) {
            try {
                double v = Double.parseDouble(_input);
                return new DoubleValue(v);
            }
            catch (Exception exception) {
                if (!_silentMode) {
                    System.err.println("Value : Error 2! Incorrect input to parse " + _input);
                }
                return null;
            }
        }
        try {
            int i = Integer.parseInt(_input);
            return new IntegerValue(i);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

