/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.external;

import com.calerga.sysquake.SQLinkVariableListener;
import com.calerga.sysquake.SysquakeLink;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.external.ExternalApp;
import org.colos.ejs.library.external.ExternalClient;
import org.opensourcephysics.display.OSPRuntime;

public class EjsSysquake
implements ExternalApp,
SQLinkVariableListener {
    private static SysquakeLink sqlink = null;
    private static String homeDir = null;
    private static boolean alreadyLoaded = false;
    private static int numberOfEngines = 0;
    private static int dllCounter = -1;
    private int sqID = -1;
    private String sqFile = null;
    private ExternalClient client = null;
    private Hashtable varTable = new Hashtable();

    private static SysquakeLink tryThisOne(String _dll) {
        File file = new File(_dll);
        try {
            _dll = file.getCanonicalPath();
        }
        catch (Exception exception) {
            _dll = file.getAbsolutePath();
        }
        if (file.exists()) {
            return new SysquakeLink(_dll);
        }
        return null;
    }

    private static void initSysquake() {
        if (sqlink != null) {
            return;
        }
        homeDir = null;
        String localDir = System.getProperty("user.dir").replace('\\', '/');
        if (!localDir.endsWith("/")) {
            localDir = String.valueOf(localDir) + "/";
        }
        if (OSPRuntime.isWindows()) {
            sqlink = EjsSysquake.tryThisOne(String.valueOf(localDir) + Simulation.getPathToLibrary() + "_library/external/SysquakeLink.dll");
            if (sqlink == null) {
                sqlink = EjsSysquake.tryThisOne(String.valueOf(localDir) + "_library/external/SysquakeLink.dll");
            }
            if (sqlink == null) {
                homeDir = Simulation.getTemporaryDir();
                if (!alreadyLoaded) {
                    dllCounter = 0;
                    int i = 1;
                    while (i <= 50) {
                        File lib = new File(String.valueOf(homeDir) + "_library/external/SysquakeLink" + i + ".dll");
                        if (lib.exists()) {
                            lib.delete();
                        } else if (dllCounter == 0) {
                            dllCounter = i;
                            if (Simulation.extractResource("../_library/external/SysquakeLink.dll", lib.getPath()) != null) {
                                Simulation.extractResource("_library/external/SysquakeLink.dll", lib.getPath());
                            }
                        }
                        ++i;
                    }
                    alreadyLoaded = true;
                }
                sqlink = EjsSysquake.tryThisOne(String.valueOf(homeDir) + "_library/external/SysquakeLink" + dllCounter + ".dll");
            }
        } else {
            new SysquakeLink(String.valueOf(localDir) + "_library/external/libSysquakeLink.jnilib");
        }
    }

    public EjsSysquake(String _sqFile) {
        EjsSysquake.initSysquake();
        String userDir = null;
        if (homeDir != null) {
            userDir = homeDir;
        } else {
            userDir = System.getProperty("user.dir").replace('\\', '/');
            if (!userDir.endsWith("/")) {
                userDir = String.valueOf(userDir) + "/";
            }
        }
        if (_sqFile != null) {
            this.sqFile = _sqFile.trim();
            if (this.sqFile.length() == 0 || this.sqFile.toLowerCase().startsWith("<sysquake>")) {
                this.sqFile = null;
            } else if (!(homeDir == null && new File(String.valueOf(userDir) + this.sqFile).exists() || Simulation.extractResource(this.sqFile, String.valueOf(userDir = Simulation.getTemporaryDir()) + this.sqFile) == null)) {
                System.out.println("Warning : the sq file " + this.sqFile + " does not exist!");
                this.sqFile = null;
            }
            if (this.sqFile != null) {
                this.sqFile = String.valueOf(userDir) + this.sqFile;
            }
        }
        try {
            SysquakeLink.connect();
        }
        catch (Exception exc) {
            System.err.println("EjsSysquake error: " + exc);
        }
        if (!SysquakeLink.isConnected()) {
            System.out.println("Warning : Sysquake is NOT connected!!!");
        }
        this.loadSQFile();
    }

    private synchronized void loadSQFile() {
        try {
            SysquakeLink.resetVariableChangeNotification(this.sqID);
            if (this.sqID != -1) {
                // empty if block
            }
            if (this.sqFile == null) {
                this.sqID = -1;
                return;
            }
            SysquakeLink.show();
            this.sqID = SysquakeLink.open(this.sqFile);
            if (this.sqID == -1) {
                return;
            }
            SysquakeLink.setVariableChangeNotification(this.sqID, this);
            String[] varNames = SysquakeLink.variableNames(this.sqID);
            if (varNames != null) {
                int i = 0;
                int n = varNames.length;
                while (i < n) {
                    String text = varNames[i];
                    if (!text.startsWith("_")) {
                        this.varTable.put(varNames[i], new Integer(i));
                    }
                    ++i;
                }
            }
        }
        catch (Exception exc) {
            System.err.println("EjsSysquake error: " + exc);
        }
    }

    public void variableChange(int instanceId) {
        if (instanceId != this.sqID) {
            System.out.println("Wrong Sysquake ID!");
            return;
        }
        if (this.client != null) {
            this.client._externalGetValuesAndUpdate(false, this);
        }
    }

    public String toString() {
        return this.sqFile;
    }

    public void setClient(ExternalClient _cli) {
        this.client = _cli;
    }

    public void setInitCommand(String _command) {
    }

    public void eval(String _command) {
        try {
            SysquakeLink.execute(_command);
        }
        catch (Exception exc) {
            System.err.println("EjsSysquake error: " + exc);
        }
    }

    public synchronized void eval(String _command, boolean _flushNow) {
        this.eval(_command);
    }

    public void resetIC() {
    }

    public void resetParam() {
    }

    public synchronized void step(double dt) {
    }

    public void stepAS(double dt) {
    }

    public void stepAS(double dt, int _package) {
    }

    public synchronized void reset() {
        try {
            SysquakeLink.disconnect();
            SysquakeLink.connect();
            this.loadSQFile();
        }
        catch (Exception exc) {
            System.err.println("EjsSysquake error: " + exc);
        }
    }

    public synchronized void quit() {
        try {
            if (this.sqID != -1) {
                SysquakeLink.resetVariableChangeNotification(this.sqID);
            }
            SysquakeLink.disconnect();
            this.sqID = -1;
            SysquakeLink.quit();
            sqlink = null;
        }
        catch (Exception exc) {
            System.err.println("EjsSysquake error: " + exc);
        }
    }

    public void setValues(Vector _names, Vector _values) throws Exception {
        if (this.sqID == -1) {
            return;
        }
        int n = _names.size();
        if (n <= 0) {
            return;
        }
        int[] indexes = new int[n];
        int i = 0;
        while (i < n) {
            Integer index = (Integer)this.varTable.get((String)_names.get(i));
            if (index != null) {
                indexes[i] = index;
            } else {
                System.out.println("EjsSysquake Error: Variable " + _names.get(i) + " not found");
                indexes[i] = -1;
            }
            ++i;
        }
        SysquakeLink.setVariableValue(this.sqID, indexes, _values.toArray());
    }

    public void setValue(String _name, String _value) throws Exception {
        Integer n = (Integer)this.varTable.get(_name);
        if (n != null) {
            SysquakeLink.setVariableValue(this.sqID, _name, (Object)_value);
        } else {
            SysquakeLink.execute(String.valueOf(_name) + " = '" + _value + "';");
        }
    }

    public void setValue(String _name, double _value) throws Exception {
        Integer n = (Integer)this.varTable.get(_name);
        if (n != null) {
            SysquakeLink.setVariableValue(this.sqID, _name, (Object)new Double(_value));
        } else {
            SysquakeLink.execute(String.valueOf(_name) + " = " + _value + ";");
        }
    }

    public void setValue(String _name, double[] _value) throws Exception {
        Integer n = (Integer)this.varTable.get(_name);
        if (n != null) {
            SysquakeLink.setVariableValue(this.sqID, _name, (Object)_value);
        } else {
            StringBuffer cmd = new StringBuffer(_name);
            cmd.append(" = [ ");
            int i = 0;
            while (i < _value.length) {
                if (i > 0) {
                    cmd.append(",");
                }
                cmd.append(Double.toString(_value[i]));
                ++i;
            }
            cmd.append("];");
            SysquakeLink.execute(cmd.toString());
        }
    }

    public void setValue(String _name, double[][] _value) throws Exception {
        Integer n = (Integer)this.varTable.get(_name);
        if (n != null) {
            SysquakeLink.setVariableValue(this.sqID, _name, (Object)_value);
        } else {
            StringBuffer cmd = new StringBuffer(_name);
            cmd.append(" = [ ");
            int i = 0;
            while (i < _value.length) {
                if (i > 0) {
                    cmd.append(";");
                }
                int j = 0;
                while (j < _value[i].length) {
                    if (j > 0) {
                        cmd.append(",");
                    }
                    cmd.append(Double.toString(_value[i][j]));
                    ++j;
                }
                ++i;
            }
            cmd.append("];");
            SysquakeLink.execute(cmd.toString());
        }
    }

    public synchronized String getString(String _variable) throws Exception {
        Object obj = null;
        Integer n = (Integer)this.varTable.get(_variable);
        obj = n != null ? SysquakeLink.variableValue(this.sqID, _variable) : SysquakeLink.lmeVariableValue(_variable);
        return (String)obj;
    }

    public double getDouble(String _variable) {
        Object obj = null;
        Integer n = (Integer)this.varTable.get(_variable);
        try {
            obj = n != null ? SysquakeLink.variableValue(this.sqID, _variable) : SysquakeLink.lmeVariableValue(_variable);
        }
        catch (Exception exc) {
            System.err.println("EjsSysquake error: " + exc);
        }
        if (obj == null) {
            return Double.NaN;
        }
        return (Double)obj;
    }

    public synchronized double[] getDoubleArray(String _variable) {
        Object obj = null;
        Integer n = (Integer)this.varTable.get(_variable);
        try {
            obj = n != null ? SysquakeLink.variableValue(this.sqID, _variable) : SysquakeLink.lmeVariableValue(_variable);
            if (obj instanceof double[][]) {
                return ((double[][])obj)[0];
            }
            return (double[])obj;
        }
        catch (Exception exc) {
            System.err.println("EjsSysquake error: " + exc);
            return null;
        }
    }

    public double[][] getDoubleArray2D(String _variable) {
        Object obj = null;
        Integer n = (Integer)this.varTable.get(_variable);
        try {
            obj = n != null ? SysquakeLink.variableValue(this.sqID, _variable) : SysquakeLink.lmeVariableValue(_variable);
        }
        catch (Exception exc) {
            System.err.println("EjsSysquake error: " + exc);
        }
        return (double[][])obj;
    }

    public synchronized void update(String _command, String _outputvars, int _steps) {
    }

    public synchronized void update(String _command, String _outputvars, int _steps, int _package) {
    }

    public synchronized void haltUpdate(boolean _remove) {
    }

    public synchronized void haltStepAS(boolean _remove) {
    }

    public void setValue(String _name, double[][] _value, boolean _flushNow) throws Exception {
        this.setValue(_name, _value);
    }

    public void setValue(String _name, double[] _value, boolean _flushNow) throws Exception {
        this.setValue(_name, _value);
    }

    public synchronized void setValue(String _name, String _value, boolean _flushNow) throws Exception {
        this.setValue(_name, _value);
    }

    public void setValue(String _name, double _value, boolean _flushNow) throws Exception {
        this.setValue(_name, _value);
    }

    public synchronized String getStringAS() throws Exception {
        return null;
    }

    public double getDoubleAS() {
        return 0.0;
    }

    public synchronized void synchronize(boolean _remove) {
    }

    public synchronized void synchronize() {
    }

    public synchronized void externalVars(String _externalVars) {
    }

    public synchronized void setCommand(String _command) {
    }

    public synchronized void packageSize(double _package) {
    }

    public synchronized double[] getDoubleArrayAS() {
        return null;
    }

    public double[][] getDoubleArray2DAS() {
        return null;
    }
}

