/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.external;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.external.EjsSysquake;
import org.colos.ejs.library.external.ExternalApp;
import org.colos.ejs.library.external.ExternalClient;

public class ExternalAppsHandler {
    private ExternalClient client;
    private Hashtable appList = new Hashtable();

    public ExternalAppsHandler(ExternalClient _client) {
        this.client = _client;
    }

    public ExternalAppsHandler(String _jarFileName, ExternalClient _client) {
        this(_client);
    }

    public void requires(String _file) {
        String source = _file.replace('\\', '/');
        if (!new File(source).exists() && Simulation.extractResource(source, String.valueOf(Simulation.getTemporaryDir()) + _file) == null) {
            System.out.println("Warning : the required file " + _file + " could not be extracted!");
        }
    }

    public ExternalApp add(Class externalAppClass, String externalFile) {
        try {
            externalFile = externalFile.trim();
            ExternalApp app = (ExternalApp)this.appList.get(externalFile);
            if (app != null) {
                return app;
            }
            Class[] c = new Class[]{String.class};
            Object[] o = new Object[]{externalFile};
            Constructor constructor = externalAppClass.getDeclaredConstructor(c);
            app = (ExternalApp)constructor.newInstance(o);
            app.setInitCommand(this.client._externalInitCommand(externalFile));
            this.appList.put(externalFile, app);
            if (app instanceof EjsSysquake) {
                ((EjsSysquake)app).setClient(this.client);
            }
            return app;
        }
        catch (Exception _exc) {
            _exc.printStackTrace();
            System.err.println("ExternalAppsHandler: error when trying to add class " + externalAppClass + "!");
            return null;
        }
    }

    public void remove(String externalFile) {
        this.appList.remove(externalFile);
    }

    public ExternalApp getApplication(String externalFile) {
        return (ExternalApp)this.appList.get(externalFile);
    }

    public ExternalClient getClient() {
        return this.client;
    }

    public void eval(String _appFile, String command) {
        ExternalApp app = this.getApplication(_appFile);
        if (app == null) {
            System.err.println("Error: application " + _appFile + " not found!");
        } else {
            try {
                app.eval(command);
            }
            catch (Exception exc) {
                System.err.println("Error evaluating <" + command + "> for application : " + app);
                exc.printStackTrace();
            }
        }
    }

    public void eval(String _appFile, String command, boolean _flushNow) {
        ExternalApp app = this.getApplication(_appFile);
        if (app == null) {
            System.err.println("Error: application " + _appFile + " not found!");
        } else {
            try {
                app.eval(command, _flushNow);
            }
            catch (Exception exc) {
                System.err.println("Error evaluating <" + command + "> for application : " + app);
                exc.printStackTrace();
            }
        }
    }

    public void eval(String command) {
        Enumeration e = this.appList.elements();
        while (e.hasMoreElements()) {
            ExternalApp app = (ExternalApp)e.nextElement();
            try {
                app.eval(command);
            }
            catch (Exception exc) {
                System.err.println("Error evaluating <" + command + "> for application : " + app);
                exc.printStackTrace();
            }
        }
    }

    public void eval(String _command, boolean _flushNow) {
        Enumeration e = this.appList.elements();
        while (e.hasMoreElements()) {
            ExternalApp app = (ExternalApp)e.nextElement();
            try {
                app.eval(_command, _flushNow);
            }
            catch (Exception exc) {
                System.err.println("Error evaluating <" + _command + "> for application : " + app);
                exc.printStackTrace();
            }
        }
    }

    public void resetIC(String _appFile) {
        ExternalApp app = this.getApplication(_appFile);
        if (app == null) {
            System.err.println("Error: application " + _appFile + " not found!");
        } else {
            app.resetIC();
        }
    }

    public void resetIC() {
        Enumeration e = this.appList.elements();
        while (e.hasMoreElements()) {
            ((ExternalApp)e.nextElement()).resetIC();
        }
    }

    public void resetParam() {
        Enumeration e = this.appList.elements();
        while (e.hasMoreElements()) {
            ((ExternalApp)e.nextElement()).resetParam();
        }
    }

    public void step(String _appFile, double dt) {
        ExternalApp app = this.getApplication(_appFile);
        if (app == null) {
            System.err.println("Error: application " + _appFile + " not found!");
        } else {
            this.client._externalSetValues(false, app);
            try {
                app.step(dt);
            }
            catch (Exception exc) {
                System.err.println("Error stepping application : " + app);
                exc.printStackTrace();
            }
            this.client._externalGetValues(false, app);
        }
    }

    public void step(double dt) {
        this.client._externalSetValues(true, null);
        Enumeration e = this.appList.elements();
        while (e.hasMoreElements()) {
            ExternalApp app = (ExternalApp)e.nextElement();
            try {
                app.step(dt);
            }
            catch (Exception exc) {
                System.err.println("Error stepping application : " + app);
                exc.printStackTrace();
            }
        }
        this.client._externalGetValues(true, null);
    }

    public void update(String _appFile) {
        ExternalApp app = this.getApplication(_appFile);
        if (app == null) {
            System.err.println("Error: application " + _appFile + " not found!");
        } else {
            this.client._externalSetValues(false, app);
            this.client._externalGetValues(false, app);
        }
    }

    public void update() {
        this.client._externalSetValues(true, null);
        this.client._externalGetValues(true, null);
    }

    public void reset(String _appFile) {
        ExternalApp app = this.getApplication(_appFile);
        if (app == null) {
            System.err.println("Error: application " + _appFile + " not found!");
        } else {
            app.reset();
        }
    }

    public void reset() {
        Enumeration e = this.appList.elements();
        while (e.hasMoreElements()) {
            ExternalApp app = (ExternalApp)e.nextElement();
            app.reset();
        }
    }

    public void quit(String _appFile) {
        ExternalApp app = this.getApplication(_appFile);
        if (app == null) {
            System.err.println("Error: application " + _appFile + " not found!");
        } else {
            app.quit();
        }
    }

    public void quit() {
        Enumeration e = this.appList.elements();
        while (e.hasMoreElements()) {
            ExternalApp app = (ExternalApp)e.nextElement();
            app.quit();
        }
    }

    public void setValues() {
        this.client._externalSetValues(true, null);
    }

    public void getValues() {
        this.client._externalGetValues(true, null);
    }

    public void setValue(String _name, String _value) {
        Enumeration e = this.appList.elements();
        while (e.hasMoreElements()) {
            ExternalApp app = (ExternalApp)e.nextElement();
            try {
                app.synchronize(true);
                app.setValue(_name, _value);
            }
            catch (Exception exc) {
                System.err.println("Error setting <" + _name + "> to <" + _value + "> for application : " + app);
                exc.printStackTrace();
            }
        }
    }

    public void setValue(String _name, String _value, boolean _flushNow) {
        Enumeration e = this.appList.elements();
        while (e.hasMoreElements()) {
            ExternalApp app = (ExternalApp)e.nextElement();
            try {
                app.synchronize(true);
                app.setValue(_name, _value, _flushNow);
            }
            catch (Exception exc) {
                System.err.println("Error setting <" + _name + "> to <" + _value + "> for application : " + app);
                exc.printStackTrace();
            }
        }
    }

    public void setValue(String _appFile, String _name, String _value) {
        ExternalApp app = this.getApplication(_appFile);
        if (app == null) {
            System.err.println("Error: application " + _appFile + " not found!");
        } else {
            try {
                app.synchronize(true);
                app.setValue(_name, _value);
            }
            catch (Exception exc) {
                System.err.println("Error setting <" + _name + "> to <" + _value + "> for application : " + _appFile);
                exc.printStackTrace();
            }
        }
    }

    public void setValue(String _appFile, String _name, String _value, boolean _flushNow) {
        ExternalApp app = this.getApplication(_appFile);
        if (app == null) {
            System.err.println("Error: application " + _appFile + " not found!");
        } else {
            try {
                app.synchronize(true);
                app.setValue(_name, _value, _flushNow);
            }
            catch (Exception exc) {
                System.err.println("Error setting <" + _name + "> to <" + _value + "> for application : " + _appFile);
                exc.printStackTrace();
            }
        }
    }

    public void setValue(String _name, double _value) {
        Enumeration e = this.appList.elements();
        while (e.hasMoreElements()) {
            ExternalApp app = (ExternalApp)e.nextElement();
            try {
                app.synchronize(true);
                app.setValue(_name, _value);
            }
            catch (Exception exc) {
                System.err.println("Error setting <" + _name + "> to <" + _value + "> for application : " + app);
                exc.printStackTrace();
            }
        }
    }

    public void setValue(String _name, double _value, boolean _flushNow) {
        Enumeration e = this.appList.elements();
        while (e.hasMoreElements()) {
            ExternalApp app = (ExternalApp)e.nextElement();
            try {
                app.synchronize(true);
                app.setValue(_name, _value, _flushNow);
            }
            catch (Exception exc) {
                System.err.println("Error setting <" + _name + "> to <" + _value + "> for application : " + app);
                exc.printStackTrace();
            }
        }
    }

    public void setValue(String _appFile, String _name, double _value) {
        ExternalApp app = this.getApplication(_appFile);
        if (app == null) {
            System.err.println("Error: application " + _appFile + " not found!");
        } else {
            try {
                app.synchronize(true);
                app.setValue(_name, _value);
            }
            catch (Exception exc) {
                System.err.println("Error setting <" + _name + "> to <" + _value + "> for application : " + _appFile);
                exc.printStackTrace();
            }
        }
    }

    public void setValue(String _appFile, String _name, double _value, boolean _flushNow) {
        ExternalApp app = this.getApplication(_appFile);
        if (app == null) {
            System.err.println("Error: application " + _appFile + " not found!");
        } else {
            try {
                app.synchronize(true);
                app.setValue(_name, _value, _flushNow);
            }
            catch (Exception exc) {
                System.err.println("Error setting <" + _name + "> to <" + _value + "> for application : " + _appFile);
                exc.printStackTrace();
            }
        }
    }

    public void setValue(String _name, double[] _value) {
        Enumeration e = this.appList.elements();
        while (e.hasMoreElements()) {
            ExternalApp app = (ExternalApp)e.nextElement();
            try {
                app.synchronize(true);
                app.setValue(_name, _value);
            }
            catch (Exception exc) {
                System.err.println("Error setting <" + _name + "> to <" + _value + "> for application : " + app);
                exc.printStackTrace();
            }
        }
    }

    public void setValue(String _name, double[] _value, boolean _flushNow) {
        Enumeration e = this.appList.elements();
        while (e.hasMoreElements()) {
            ExternalApp app = (ExternalApp)e.nextElement();
            try {
                app.synchronize(true);
                app.setValue(_name, _value, _flushNow);
            }
            catch (Exception exc) {
                System.err.println("Error setting <" + _name + "> to <" + _value + "> for application : " + app);
                exc.printStackTrace();
            }
        }
    }

    public void setValue(String _appFile, String _name, double[] _value) {
        ExternalApp app = this.getApplication(_appFile);
        if (app == null) {
            System.err.println("Error: application " + _appFile + " not found!");
        } else {
            try {
                app.synchronize(true);
                app.setValue(_name, _value);
            }
            catch (Exception exc) {
                System.err.println("Error setting <" + _name + "> to <" + _value + "> for application : " + _appFile);
                exc.printStackTrace();
            }
        }
    }

    public void setValue(String _appFile, String _name, double[] _value, boolean _flushNow) {
        ExternalApp app = this.getApplication(_appFile);
        if (app == null) {
            System.err.println("Error: application " + _appFile + " not found!");
        } else {
            try {
                app.synchronize(true);
                app.setValue(_name, _value, _flushNow);
            }
            catch (Exception exc) {
                System.err.println("Error setting <" + _name + "> to <" + _value + "> for application : " + _appFile);
                exc.printStackTrace();
            }
        }
    }

    public void setValue(String _name, double[][] _value) {
        Enumeration e = this.appList.elements();
        while (e.hasMoreElements()) {
            ExternalApp app = (ExternalApp)e.nextElement();
            try {
                app.synchronize(true);
                app.setValue(_name, _value);
            }
            catch (Exception exc) {
                System.err.println("Error setting <" + _name + "> to <" + _value + "> for application : " + app);
                exc.printStackTrace();
            }
        }
    }

    public void setValue(String _name, double[][] _value, boolean _flushNow) {
        Enumeration e = this.appList.elements();
        while (e.hasMoreElements()) {
            ExternalApp app = (ExternalApp)e.nextElement();
            try {
                app.synchronize(true);
                app.setValue(_name, _value, _flushNow);
            }
            catch (Exception exc) {
                System.err.println("Error setting <" + _name + "> to <" + _value + "> for application : " + app);
                exc.printStackTrace();
            }
        }
    }

    public void setValue(String _appFile, String _name, double[][] _value) {
        ExternalApp app = this.getApplication(_appFile);
        if (app == null) {
            System.err.println("Error: application " + _appFile + " not found!");
        } else {
            try {
                app.synchronize(true);
                app.setValue(_name, _value);
            }
            catch (Exception exc) {
                System.err.println("Error setting <" + _name + "> to <" + _value + "> for application : " + _appFile);
                exc.printStackTrace();
            }
        }
    }

    public void setValue(String _appFile, String _name, double[][] _value, boolean _flushNow) {
        ExternalApp app = this.getApplication(_appFile);
        if (app == null) {
            System.err.println("Error: application " + _appFile + " not found!");
        } else {
            try {
                app.synchronize(true);
                app.setValue(_name, _value, _flushNow);
            }
            catch (Exception exc) {
                System.err.println("Error setting <" + _name + "> to <" + _value + "> for application : " + _appFile);
                exc.printStackTrace();
            }
        }
    }

    public String getString(String _variable) {
        Enumeration e = this.appList.elements();
        while (e.hasMoreElements()) {
            ExternalApp app = (ExternalApp)e.nextElement();
            try {
                app.synchronize(true);
                return app.getString(_variable);
            }
            catch (Exception exception) {}
        }
        System.err.println("Error: variable <" + _variable + "> doesn't exists in any external application.");
        return "";
    }

    public String getStringAS() {
        Enumeration e = this.appList.elements();
        while (e.hasMoreElements()) {
            ExternalApp app = (ExternalApp)e.nextElement();
            try {
                return app.getStringAS();
            }
            catch (Exception exception) {}
        }
        System.err.println("Error: variable doesn't exists in any external application.");
        return "";
    }

    public String getString(String _appFile, String _variable) {
        ExternalApp app = this.getApplication(_appFile);
        if (app != null) {
            try {
                app.synchronize(true);
                return app.getString(_variable);
            }
            catch (Exception exc) {
                System.err.println("Error getting <" + _variable + "> from application : " + _appFile);
                exc.printStackTrace();
            }
        }
        return "";
    }

    public String getStringAS(String _appFile) {
        ExternalApp app = this.getApplication(_appFile);
        if (app != null) {
            try {
                return app.getStringAS();
            }
            catch (Exception exc) {
                System.err.println("Error getting buffer from application : " + _appFile);
                exc.printStackTrace();
            }
        }
        return "";
    }

    public double getDouble(String _variable) {
        Enumeration e = this.appList.elements();
        while (e.hasMoreElements()) {
            ExternalApp app = (ExternalApp)e.nextElement();
            try {
                app.synchronize(true);
                return app.getDouble(_variable);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        System.err.println("Error: variable <" + _variable + "> doesn't exists in any external application.");
        return 0.0;
    }

    public double getDoubleAS() {
        Enumeration e = this.appList.elements();
        while (e.hasMoreElements()) {
            ExternalApp app = (ExternalApp)e.nextElement();
            try {
                return app.getDoubleAS();
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        System.err.println("Error: variable can't get from Buffer in any external application.");
        return 0.0;
    }

    public double getDouble(String _appFile, String _variable) {
        ExternalApp app = this.getApplication(_appFile);
        if (app != null) {
            try {
                app.synchronize(true);
                return app.getDouble(_variable);
            }
            catch (Exception exc) {
                System.err.println("Error getting <" + _variable + "> from application : " + _appFile);
                exc.printStackTrace();
            }
        }
        return 0.0;
    }

    public double getDoubleAS(String _appFile) {
        ExternalApp app = this.getApplication(_appFile);
        if (app != null) {
            try {
                return app.getDoubleAS();
            }
            catch (Exception exc) {
                System.err.println("Error getting buffer from application : " + _appFile);
                exc.printStackTrace();
            }
        }
        return 0.0;
    }

    public double[] getDoubleArray(String _variable) {
        Enumeration e = this.appList.elements();
        while (e.hasMoreElements()) {
            ExternalApp app = (ExternalApp)e.nextElement();
            try {
                app.synchronize(true);
                return app.getDoubleArray(_variable);
            }
            catch (Exception exception) {}
        }
        System.err.println("Error: variable <" + _variable + "> doesn't exists in any external application.");
        return null;
    }

    public double[] getDoubleArrayAS() {
        Enumeration e = this.appList.elements();
        while (e.hasMoreElements()) {
            ExternalApp app = (ExternalApp)e.nextElement();
            try {
                return app.getDoubleArrayAS();
            }
            catch (Exception exception) {}
        }
        System.err.println("Error: variable doesn't exists in any external application.");
        return null;
    }

    public double[] getDoubleArray(String _appFile, String _variable) {
        ExternalApp app = this.getApplication(_appFile);
        if (app != null) {
            try {
                app.synchronize(true);
                return app.getDoubleArray(_variable);
            }
            catch (Exception exc) {
                System.err.println("Error getting <" + _variable + "> from application : " + _appFile);
                exc.printStackTrace();
            }
        }
        return null;
    }

    public double[] getDoubleArrayAS(String _appFile) {
        ExternalApp app = this.getApplication(_appFile);
        if (app != null) {
            try {
                return app.getDoubleArrayAS();
            }
            catch (Exception exc) {
                System.err.println("Error getting buffer from application : " + _appFile);
                exc.printStackTrace();
            }
        }
        return null;
    }

    public double[][] getDoubleArray2D(String _variable) {
        Enumeration e = this.appList.elements();
        while (e.hasMoreElements()) {
            ExternalApp app = (ExternalApp)e.nextElement();
            try {
                app.synchronize(true);
                return app.getDoubleArray2D(_variable);
            }
            catch (Exception exception) {}
        }
        System.err.println("Error: variable <" + _variable + "> doesn't exists in any external application.");
        return null;
    }

    public double[][] getDoubleArray2DAS() {
        Enumeration e = this.appList.elements();
        while (e.hasMoreElements()) {
            ExternalApp app = (ExternalApp)e.nextElement();
            try {
                return app.getDoubleArray2DAS();
            }
            catch (Exception exception) {}
        }
        System.err.println("Error: variable doesn't exists in any external application.");
        return null;
    }

    public double[][] getDoubleArray2D(String _appFile, String _variable) {
        ExternalApp app = this.getApplication(_appFile);
        if (app != null) {
            try {
                app.synchronize(true);
                return app.getDoubleArray2D(_variable);
            }
            catch (Exception exc) {
                System.err.println("Error getting <" + _variable + "> from application : " + _appFile);
                exc.printStackTrace();
            }
        }
        return null;
    }

    public double[][] getDoubleArray2DAS(String _appFile) {
        ExternalApp app = this.getApplication(_appFile);
        if (app != null) {
            try {
                return app.getDoubleArray2DAS();
            }
            catch (Exception exc) {
                System.err.println("Error getting buffer from application : " + _appFile);
                exc.printStackTrace();
            }
        }
        return null;
    }

    public synchronized void externalVars(String _appFile, String _externalVars) {
        ExternalApp app = this.getApplication(_appFile);
        if (app != null) {
            try {
                app.externalVars(_externalVars);
            }
            catch (Exception exc) {
                System.err.println("Error: can't to set external variables in any external application.");
                exc.printStackTrace();
            }
        }
    }

    public synchronized void externalVars(String _externalVars) {
        Enumeration e = this.appList.elements();
        while (e.hasMoreElements()) {
            ExternalApp app = (ExternalApp)e.nextElement();
            try {
                app.externalVars(_externalVars);
            }
            catch (Exception exception) {
                System.err.println("Error: can't to set external variables in any external application.");
            }
        }
    }

    public synchronized void synchronize(String _appFile, boolean _remove) {
        ExternalApp app = this.getApplication(_appFile);
        if (app != null) {
            try {
                app.synchronize(_remove);
            }
            catch (Exception exc) {
                System.err.println("Error: can't to synchronize in any external application.");
                exc.printStackTrace();
            }
        }
    }

    public synchronized void synchronize(String _appFile) {
        ExternalApp app = this.getApplication(_appFile);
        if (app != null) {
            try {
                app.synchronize();
            }
            catch (Exception exc) {
                System.err.println("Error: can't to synchronize in any external application.");
                exc.printStackTrace();
            }
        }
    }

    public synchronized void synchronize(boolean _remove) {
        Enumeration e = this.appList.elements();
        while (e.hasMoreElements()) {
            ExternalApp app = (ExternalApp)e.nextElement();
            try {
                app.synchronize(_remove);
            }
            catch (Exception exception) {
                System.err.println("Error: can't to synchronize in any external application.");
            }
        }
    }

    public synchronized void synchronize() {
        Enumeration e = this.appList.elements();
        while (e.hasMoreElements()) {
            ExternalApp app = (ExternalApp)e.nextElement();
            try {
                app.synchronize();
            }
            catch (Exception exception) {
                System.err.println("Error: can't to synchronize in any external application.");
            }
        }
    }

    public synchronized void setCommand(String _command) {
        Enumeration e = this.appList.elements();
        while (e.hasMoreElements()) {
            ExternalApp app = (ExternalApp)e.nextElement();
            try {
                app.setCommand(_command);
            }
            catch (Exception exception) {
                System.err.println("Error: can't to set Command in any external application.");
            }
        }
    }

    public synchronized void setCommand(String _appFile, String _command) {
        ExternalApp app = this.getApplication(_appFile);
        if (app != null) {
            try {
                app.setCommand(_command);
            }
            catch (Exception exc) {
                System.err.println("Error: can't to synchronize in any external application.");
                exc.printStackTrace();
            }
        }
    }

    public synchronized void packageSize(String _appFile, double _package) {
        ExternalApp app = this.getApplication(_appFile);
        if (app != null) {
            try {
                app.packageSize(_package);
            }
            catch (Exception exc) {
                System.err.println("Error: can't to set package size in any external application.");
                exc.printStackTrace();
            }
        }
    }

    public synchronized void packageSize(double _package) {
        Enumeration e = this.appList.elements();
        while (e.hasMoreElements()) {
            ExternalApp app = (ExternalApp)e.nextElement();
            try {
                app.packageSize(_package);
            }
            catch (Exception exception) {
                System.err.println("Error: can't to set package size in any external application.");
            }
        }
    }

    public synchronized void update(String _command, String _outputvars, int _steps) {
        Enumeration e = this.appList.elements();
        while (e.hasMoreElements()) {
            ExternalApp app = (ExternalApp)e.nextElement();
            try {
                app.update(_command, _outputvars, _steps);
            }
            catch (Exception exception) {
                System.err.println("Error: can't to update in any external application.");
            }
        }
    }

    public synchronized void update(String _appFile, String _command, String _outputvars, int _steps) {
        ExternalApp app = this.getApplication(_appFile);
        if (app != null) {
            try {
                app.update(_command, _outputvars, _steps);
            }
            catch (Exception exc) {
                System.err.println("Error: can't to update in any external application.");
                exc.printStackTrace();
            }
        }
    }

    public synchronized void update(String _command, String _outputvars, int _steps, int _package) {
        Enumeration e = this.appList.elements();
        while (e.hasMoreElements()) {
            ExternalApp app = (ExternalApp)e.nextElement();
            try {
                app.update(_command, _outputvars, _steps, _package);
            }
            catch (Exception exception) {
                System.err.println("Error: can't update in any external application.");
            }
        }
    }

    public synchronized void update(String _appFile, String _command, String _outputvars, int _steps, int _package) {
        ExternalApp app = this.getApplication(_appFile);
        if (app != null) {
            try {
                app.update(_command, _outputvars, _steps, _package);
            }
            catch (Exception exc) {
                System.err.println("Error: can't to update in any external application.");
                exc.printStackTrace();
            }
        }
    }

    public synchronized void stepAS(double dt) {
        this.client._externalSetValues(true, null);
        Enumeration e = this.appList.elements();
        while (e.hasMoreElements()) {
            ExternalApp app = (ExternalApp)e.nextElement();
            try {
                app.stepAS(dt);
            }
            catch (Exception exc) {
                System.err.println("Error stepping application : " + app);
                exc.printStackTrace();
            }
        }
        this.client._externalGetValues(true, null);
    }

    public synchronized void stepAS(String _appFile, double dt) {
        this.client._externalSetValues(true, null);
        ExternalApp app = this.getApplication(_appFile);
        if (app != null) {
            try {
                app.stepAS(dt);
            }
            catch (Exception exc) {
                System.err.println("Error stepping application : " + app);
                exc.printStackTrace();
            }
        }
        this.client._externalGetValues(true, null);
    }

    public synchronized void stepAS(double dt, int _package) {
        this.client._externalSetValues(true, null);
        Enumeration e = this.appList.elements();
        while (e.hasMoreElements()) {
            ExternalApp app = (ExternalApp)e.nextElement();
            try {
                app.stepAS(dt, _package);
            }
            catch (Exception exc) {
                System.err.println("Error stepping application : " + app);
                exc.printStackTrace();
            }
        }
        this.client._externalGetValues(true, null);
    }

    public synchronized void stepAS(String _appFile, double dt, int _package) {
        this.client._externalSetValues(true, null);
        ExternalApp app = this.getApplication(_appFile);
        if (app != null) {
            try {
                app.stepAS(dt, _package);
            }
            catch (Exception exc) {
                System.err.println("Error stepping application : " + app);
                exc.printStackTrace();
            }
        }
        this.client._externalGetValues(true, null);
    }

    public synchronized void haltStepAS(boolean _remove) {
        Enumeration e = this.appList.elements();
        while (e.hasMoreElements()) {
            ExternalApp app = (ExternalApp)e.nextElement();
            try {
                app.haltStepAS(_remove);
            }
            catch (Exception exception) {
                System.err.println("Error: can't halt update in any external application.");
            }
        }
    }

    public synchronized void haltStepAS(String _appFile, boolean _remove) {
        this.client._externalSetValues(true, null);
        ExternalApp app = this.getApplication(_appFile);
        if (app != null) {
            try {
                app.haltStepAS(_remove);
            }
            catch (Exception exception) {
                System.err.println("Error: can't halt update in any external application.");
            }
        }
    }

    public synchronized void haltUpdate(boolean _remove) {
        Enumeration e = this.appList.elements();
        while (e.hasMoreElements()) {
            ExternalApp app = (ExternalApp)e.nextElement();
            try {
                app.haltUpdate(_remove);
            }
            catch (Exception exception) {
                System.err.println("Error: can't halt update in any external application.");
            }
        }
    }

    public synchronized void haltUpdate(String _appFile, boolean _remove) {
        this.client._externalSetValues(true, null);
        ExternalApp app = this.getApplication(_appFile);
        if (app != null) {
            try {
                app.haltUpdate(_remove);
            }
            catch (Exception exception) {
                System.err.println("Error: can't halt update in any external application.");
            }
        }
    }
}

