/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.utils;

import java.io.IOException;
import java.io.OutputStream;
import org.colos.ejs.library.utils.BitFile;
import org.colos.ejs.library.utils.LZWStringTable;

class LZWCompressor {
    LZWCompressor() {
    }

    public static void LZWCompress(OutputStream output, int codesize, byte[] toCompress) throws IOException {
        short prefix = -1;
        BitFile bitFile = new BitFile(output);
        LZWStringTable strings = new LZWStringTable();
        int clearcode = 1 << codesize;
        int endofinfo = clearcode + 1;
        int numbits = codesize + 1;
        int limit = (1 << numbits) - 1;
        strings.ClearTable(codesize);
        bitFile.WriteBits(clearcode, numbits);
        int loop = 0;
        while (loop < toCompress.length) {
            byte c = toCompress[loop];
            short index = strings.FindCharString(prefix, c);
            if (index != -1) {
                prefix = index;
            } else {
                bitFile.WriteBits(prefix, numbits);
                if (strings.AddCharString(prefix, c) > limit) {
                    if (++numbits > 12) {
                        bitFile.WriteBits(clearcode, numbits - 1);
                        strings.ClearTable(codesize);
                        numbits = codesize + 1;
                    }
                    limit = (1 << numbits) - 1;
                }
                prefix = (short)((short)c & 0xFF);
            }
            ++loop;
        }
        if (prefix != -1) {
            bitFile.WriteBits(prefix, numbits);
        }
        bitFile.WriteBits(endofinfo, numbits);
        bitFile.Flush();
    }
}

