/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.analysis;

import java.awt.Color;
import java.util.ArrayList;
import org.opensourcephysics.display.ComplexDataset;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.numerics.FFTReal;

public class FourierSinCosAnalysis
implements Data {
    static final double PI2 = Math.PI * 2;
    FFTReal fft = new FFTReal();
    double[] fftData;
    double[] omega;
    double[] freqs;
    private double[] cosVec;
    private double[] sinVec;
    private double[] gutterVec;
    ComplexDataset[] complexDatasets = new ComplexDataset[1];
    Dataset[] realDatasets = new Dataset[3];
    boolean radians = false;

    public double[] doAnalysis(double[] dArray, double[] dArray2, int n) {
        int n2 = dArray2.length % 2;
        this.fftData = new double[dArray2.length + 2 * n - n2];
        this.gutterVec = new double[n];
        System.arraycopy(dArray2, 0, this.fftData, n, dArray2.length - n2);
        this.fft.transform(this.fftData);
        double d = dArray[1] - dArray[0];
        double d2 = dArray[0] - (double)n * d;
        double d3 = dArray[dArray.length - 1 - n2] + (double)(n + 1) * d;
        this.omega = this.fft.getNaturalOmega(d2, d3);
        this.freqs = this.fft.getNaturalFreq(d2, d3);
        this.cosVec = new double[this.omega.length];
        this.sinVec = new double[this.omega.length];
        double d4 = 2.0 / (double)dArray2.length;
        int n3 = 0;
        int n4 = this.omega.length;
        while (n3 < n4) {
            this.cosVec[n3] = d4 * Math.cos(this.omega[n3] * d2);
            this.sinVec[n3] = d4 * Math.sin(this.omega[n3] * d2);
            ++n3;
        }
        this.cosVec[0] = this.cosVec[0] * 0.5;
        this.sinVec[0] = this.sinVec[0] * 0.5;
        n3 = 0;
        n4 = this.omega.length;
        while (n3 < n4) {
            double d5 = this.fftData[2 * n3];
            double d6 = this.fftData[2 * n3 + 1];
            this.fftData[2 * n3] = d5 * this.cosVec[n3] + d6 * this.sinVec[n3];
            this.fftData[2 * n3 + 1] = -d6 * this.cosVec[n3] + d5 * this.sinVec[n3];
            ++n3;
        }
        return this.fftData;
    }

    public double[] repeatAnalysis(double[] dArray) {
        double d;
        double d2;
        int n;
        int n2 = dArray.length % 2;
        if (this.fftData == null) {
            n = dArray.length - n2;
            double[] dArray2 = new double[n];
            d2 = 0.0;
            d = 1.0 / (double)n;
            int n3 = 0;
            while (n3 < n) {
                dArray2[n3] = d2;
                d2 += d;
                ++n3;
            }
            this.doAnalysis(dArray2, dArray, 0);
        }
        System.arraycopy(this.gutterVec, 0, this.fftData, 0, this.gutterVec.length);
        System.arraycopy(this.gutterVec, 0, this.fftData, this.fftData.length - 1 - this.gutterVec.length, this.gutterVec.length);
        System.arraycopy(dArray, 0, this.fftData, this.gutterVec.length, dArray.length - n2);
        this.fft.transform(this.fftData);
        n = 0;
        int n4 = this.omega.length;
        while (n < n4) {
            d2 = this.fftData[2 * n];
            d = this.fftData[2 * n + 1];
            this.fftData[2 * n] = d2 * this.cosVec[n] + d * this.sinVec[n];
            this.fftData[2 * n + 1] = d * this.cosVec[n] - d2 * this.sinVec[n];
            ++n;
        }
        return this.fftData;
    }

    public double[] getNaturalOmega() {
        return this.omega;
    }

    public double[] getNaturalFreq() {
        return this.freqs;
    }

    public void useRadians(boolean bl) {
        this.radians = bl;
    }

    public boolean isRadians() {
        return this.radians;
    }

    public ArrayList getComplexDatasets() {
        return new ArrayList();
    }

    public ArrayList getDatasets() {
        ArrayList<Dataset> arrayList = new ArrayList<Dataset>();
        if (this.fftData == null) {
            return arrayList;
        }
        if (this.realDatasets[0] == null) {
            this.realDatasets[0] = new Dataset();
            this.realDatasets[0].setXYColumnNames("frequency", "power", "Power Spectrum");
            this.realDatasets[0].setLineColor(Color.GREEN.darker());
            this.realDatasets[0].setMarkerColor(Color.GREEN.darker());
            this.realDatasets[0].setMarkerShape(7);
            this.realDatasets[0].setMarkerSize(4);
            this.realDatasets[1] = new Dataset();
            this.realDatasets[1].setXYColumnNames("frequency", "cos", "Cosine Coefficients");
            this.realDatasets[1].setLineColor(Color.CYAN.darker());
            this.realDatasets[1].setMarkerColor(Color.CYAN.darker());
            this.realDatasets[1].setMarkerShape(7);
            this.realDatasets[1].setMarkerSize(4);
            this.realDatasets[2] = new Dataset();
            this.realDatasets[2].setXYColumnNames("frequency", "sin", "Sine Coefficients");
            this.realDatasets[2].setLineColor(Color.BLUE.darker());
            this.realDatasets[2].setMarkerColor(Color.BLUE.darker());
            this.realDatasets[2].setMarkerShape(7);
            this.realDatasets[2].setMarkerSize(4);
        } else {
            this.realDatasets[0].clear();
            this.realDatasets[1].clear();
            this.realDatasets[2].clear();
        }
        if (this.radians) {
            int n = 0;
            int n2 = this.omega.length;
            while (n < n2) {
                double d = this.fftData[2 * n];
                double d2 = this.fftData[2 * n + 1];
                this.realDatasets[0].append(this.omega[n], d2 * d2 + d * d);
                this.realDatasets[1].append(this.omega[n], d2);
                this.realDatasets[2].append(this.omega[n], d);
                ++n;
            }
        } else {
            int n = 0;
            int n3 = this.freqs.length;
            while (n < n3) {
                double d = this.fftData[2 * n];
                double d3 = this.fftData[2 * n + 1];
                this.realDatasets[0].append(this.freqs[n], d * d + d3 * d3);
                this.realDatasets[1].append(this.freqs[n], d);
                this.realDatasets[2].append(this.freqs[n], d3);
                ++n;
            }
        }
        arrayList.add(this.realDatasets[0]);
        arrayList.add(this.realDatasets[1]);
        arrayList.add(this.realDatasets[2]);
        return arrayList;
    }

    public double[][] getData2D() {
        if (this.fftData == null) {
            return null;
        }
        double[][] dArrayArray = new double[4][];
        int n = this.fftData.length / 2;
        dArrayArray[1] = new double[n];
        dArrayArray[2] = new double[n];
        dArrayArray[3] = new double[n];
        int n2 = 0;
        while (n2 < n) {
            double d = this.fftData[2 * n2];
            double d2 = this.fftData[2 * n2 + 1];
            dArrayArray[1][n2] = d2 * d2 + d * d;
            dArrayArray[2][n2] = d;
            dArrayArray[3][n2] = d2;
            ++n2;
        }
        dArrayArray[0] = this.radians ? this.omega : this.freqs;
        return dArrayArray;
    }

    public double[][][] getData3D() {
        return null;
    }
}

