/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.display.ArrayTable;

public class ArrayPanel
extends JPanel
implements PropertyChangeListener {
    JTabbedPane tabbedPane = new JTabbedPane();
    ArrayTable[] tables;
    JSpinner spinner;
    JScrollPane scrollpane;
    Object array;
    boolean changed;
    String format = null;
    String[] columnNames = null;
    int firstRowIndex = 0;
    int firstColIndex = 0;
    boolean rowNumberVisible = true;
    boolean editable = true;

    public static ArrayPanel getArrayPanel(Object object) {
        ArrayPanel arrayPanel = new ArrayPanel();
        arrayPanel.setArray(object);
        return arrayPanel;
    }

    public void setArray(Object object) {
        if (!ArrayPanel.canDisplay(object)) {
            return;
        }
        if (object instanceof double[]) {
            this.setArray((double[])object);
        } else if (object instanceof double[][]) {
            this.setArray((double[][])object);
        } else if (object instanceof double[][][]) {
            this.setArray((double[][][])object);
        } else if (object instanceof int[]) {
            this.setArray((int[])object);
        } else if (object instanceof int[][]) {
            this.setArray((int[][])object);
        } else if (object instanceof int[][][]) {
            this.setArray((int[][][])object);
        } else if (object instanceof String[]) {
            this.setArray((String[])object);
        } else if (object instanceof String[][]) {
            this.setArray((String[][])object);
        } else if (object instanceof String[][][]) {
            this.setArray((String[][][])object);
        } else if (object instanceof boolean[]) {
            this.setArray((boolean[])object);
        } else if (object instanceof boolean[][]) {
            this.setArray((boolean[][])object);
        } else if (object instanceof boolean[][][]) {
            this.setArray((boolean[][][])object);
        }
        this.array = object;
    }

    public static boolean canDisplay(Object object) {
        if (object == null) {
            return false;
        }
        return object instanceof double[] || object instanceof double[][] || object instanceof double[][][] || object instanceof int[] || object instanceof int[][] || object instanceof int[][][] || object instanceof boolean[] || object instanceof boolean[][] || object instanceof boolean[][][] || object instanceof String[] || object instanceof String[][] || object instanceof String[][][];
    }

    public Object getArray() {
        return this.array;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.changed = true;
        this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
    }

    public void setNumericFormat(String string) {
        this.format = string;
        int n = 0;
        while (n < this.tables.length) {
            this.tables[n].setNumericFormat(string);
            ++n;
        }
    }

    public void setRowNumberVisible(boolean bl) {
        this.rowNumberVisible = bl;
        int n = 0;
        while (n < this.tables.length) {
            this.tables[n].setRowNumberVisible(bl);
            ++n;
        }
    }

    public void setColumnNames(String[] stringArray) {
        this.columnNames = stringArray;
        int n = 0;
        while (n < this.tables.length) {
            this.tables[n].setColumnNames(stringArray);
            ++n;
        }
    }

    public int getFirstRowIndex() {
        return this.firstRowIndex;
    }

    public void setFirstRowIndex(int n) {
        this.firstRowIndex = n;
        int n2 = 0;
        while (n2 < this.tables.length) {
            this.tables[n2].setFirstRowIndex(n);
            ++n2;
        }
    }

    public void setFirstColIndex(int n) {
        this.firstColIndex = n;
        int n2 = 0;
        while (n2 < this.tables.length) {
            this.tables[n2].setFirstColIndex(n);
            ++n2;
        }
    }

    public void setColumnLock(int n, boolean bl) {
        int n2 = 0;
        while (n2 < this.tables.length) {
            this.tables[n2].setColumnLock(n, bl);
            ++n2;
        }
    }

    public void setColumnLocks(boolean[] blArray) {
        int n = 0;
        while (n < this.tables.length) {
            this.tables[n].setColumnLocks(blArray);
            ++n;
        }
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
        int n = 0;
        while (n < this.tables.length) {
            this.tables[n].setEditable(bl);
            ++n;
        }
    }

    public void setTransposed(boolean bl) {
        int n = 0;
        while (n < this.tables.length) {
            this.tables[n].setTransposed(bl);
            ++n;
        }
    }

    public int getNumColumns() {
        return this.tables[0].getColumnCount();
    }

    public void refreshTable() {
        int n = 0;
        while (n < this.tables.length) {
            this.tables[n].refreshTable();
            ++n;
        }
    }

    public void setRefreshDelay(int n) {
        int n2 = 0;
        while (n2 < this.tables.length) {
            this.tables[n2].setRefreshDelay(n);
            ++n2;
        }
    }

    protected void createGUI() {
        this.removeAll();
        this.setPreferredSize(new Dimension(400, 300));
        this.setLayout(new BorderLayout());
        this.scrollpane = new JScrollPane(this.tables[0]);
        if (this.tables.length > 1) {
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(0, 0, this.tables.length - 1, 1);
            this.spinner = new JSpinner(spinnerNumberModel);
            JSpinner.NumberEditor numberEditor = new JSpinner.NumberEditor(this.spinner);
            numberEditor.getTextField().setFont(this.tables[0].indexRenderer.getFont());
            this.spinner.setEditor(numberEditor);
            this.spinner.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    int n = (Integer)ArrayPanel.this.spinner.getValue();
                    ArrayPanel.this.scrollpane.setViewportView(ArrayPanel.this.tables[n]);
                }
            });
            Dimension dimension = this.spinner.getMinimumSize();
            this.spinner.setMaximumSize(dimension);
            this.add((Component)this.scrollpane, "Center");
            JToolBar jToolBar = new JToolBar();
            jToolBar.setFloatable(false);
            jToolBar.add(new JLabel(" index "));
            jToolBar.add(this.spinner);
            jToolBar.add(Box.createHorizontalGlue());
            this.add((Component)jToolBar, "North");
        } else {
            this.scrollpane.createHorizontalScrollBar();
            this.add((Component)this.scrollpane, "Center");
        }
        this.validate();
    }

    private void setArray(int[] nArray) {
        if (this.array instanceof int[]) {
            this.tables[0].tableModel.setArray(nArray);
            return;
        }
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(nArray);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.createGUI();
    }

    private void setArray(int[][] nArray) {
        if (this.array instanceof int[][]) {
            this.tables[0].tableModel.setArray(nArray);
            return;
        }
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(nArray);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.createGUI();
    }

    private void setArray(int[][][] nArray) {
        this.tables = new ArrayTable[nArray.length];
        int n = 0;
        while (n < this.tables.length) {
            this.tables[n] = new ArrayTable(nArray[n]);
            this.tables[n].addPropertyChangeListener("cell", this);
            ++n;
        }
        this.createGUI();
    }

    private void setArray(double[] dArray) {
        if (this.array instanceof double[]) {
            this.tables[0].tableModel.setArray(dArray);
            return;
        }
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(dArray);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.createGUI();
    }

    private void setArray(double[][] dArray) {
        if (this.array instanceof double[][]) {
            this.tables[0].tableModel.setArray(dArray);
            return;
        }
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(dArray);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.createGUI();
    }

    private void setArray(double[][][] dArray) {
        this.tables = new ArrayTable[dArray.length];
        int n = 0;
        while (n < this.tables.length) {
            this.tables[n] = new ArrayTable(dArray[n]);
            this.tables[n].addPropertyChangeListener("cell", this);
            ++n;
        }
        this.createGUI();
    }

    private void setArray(String[] stringArray) {
        if (this.array instanceof String[]) {
            this.tables[0].tableModel.setArray(stringArray);
            return;
        }
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(stringArray);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.createGUI();
    }

    private void setArray(String[][] stringArray) {
        if (this.array instanceof String[][]) {
            this.tables[0].tableModel.setArray(stringArray);
            return;
        }
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(stringArray);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.createGUI();
    }

    private void setArray(String[][][] stringArray) {
        this.tables = new ArrayTable[stringArray.length];
        int n = 0;
        while (n < this.tables.length) {
            this.tables[n] = new ArrayTable(stringArray[n]);
            this.tables[n].addPropertyChangeListener("cell", this);
            ++n;
        }
        this.createGUI();
    }

    private void setArray(boolean[] blArray) {
        if (this.array instanceof boolean[]) {
            this.tables[0].tableModel.setArray(blArray);
            return;
        }
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(blArray);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.createGUI();
    }

    private void setArray(boolean[][] blArray) {
        if (this.array instanceof boolean[][]) {
            this.tables[0].tableModel.setArray(blArray);
            return;
        }
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(blArray);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.createGUI();
    }

    private void setArray(boolean[][][] blArray) {
        this.tables = new ArrayTable[blArray.length];
        int n = 0;
        while (n < this.tables.length) {
            this.tables[n] = new ArrayTable(blArray[n]);
            this.tables[n].addPropertyChangeListener("cell", this);
            ++n;
        }
        this.createGUI();
    }
}

