/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLTreeChooser;
import org.opensourcephysics.controls.XMLTreePanel;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.InteractiveMouseHandler;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.PrintUtils;
import org.opensourcephysics.display.axes.DrawableAxes;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.LocalJob;
import org.opensourcephysics.tools.SnapshotTool;
import org.opensourcephysics.tools.Tool;
import org.opensourcephysics.tools.VideoTool;

public class DrawingFrame
extends OSPFrame
implements ClipboardOwner {
    protected JMenu fileMenu;
    protected JMenu editMenu;
    protected JMenuItem copyItem;
    protected JMenuItem pasteItem;
    protected JMenuItem replaceItem;
    protected DrawingPanel drawingPanel;
    protected static final int MENU_SHORTCUT_KEY_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    protected Window customInspector;
    protected Tool reply;

    public DrawingFrame() {
        this(DisplayRes.getString("DrawingFrame.DefaultTitle"), new InteractivePanel());
    }

    public DrawingFrame(DrawingPanel drawingPanel) {
        this(DisplayRes.getString("DrawingFrame.DefaultTitle"), drawingPanel);
    }

    public DrawingFrame(String string, DrawingPanel drawingPanel) {
        super(string);
        this.drawingPanel = drawingPanel;
        if (this.drawingPanel != null) {
            this.getContentPane().add((Component)this.drawingPanel, "Center");
        }
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
        if (!OSPRuntime.appletMode) {
            this.createMenuBar();
        }
        this.reply = new Tool(){

            public void send(Job job, Tool tool) throws RemoteException {
                XMLControlElement xMLControlElement = new XMLControlElement();
                try {
                    xMLControlElement.readXML(job.getXML());
                }
                catch (RemoteException remoteException) {}
                ArrayList arrayList = DrawingFrame.this.drawingPanel.getObjectOfClass(Dataset.class);
                block2: for (Dataset dataset : xMLControlElement.getObjects(Dataset.class)) {
                    int n = dataset.getID();
                    int n2 = 0;
                    int n3 = arrayList.size();
                    while (n2 < n3) {
                        if (((Dataset)arrayList.get(n2)).getID() == n) {
                            XMLControlElement xMLControlElement2 = new XMLControlElement(dataset);
                            Dataset.getLoader().loadObject(xMLControlElement2, arrayList.get(n2));
                            continue block2;
                        }
                        ++n2;
                    }
                }
                DrawingFrame.this.drawingPanel.repaint();
            }
        };
    }

    public void render() {
        if (this.isIconified() || !this.isShowing()) {
            return;
        }
        if (this.drawingPanel != null) {
            this.drawingPanel.render();
        } else {
            this.repaint();
        }
    }

    public void invalidateImage() {
        if (this.drawingPanel != null) {
            this.drawingPanel.invalidateImage();
        }
    }

    public DrawingPanel getDrawingPanel() {
        return this.drawingPanel;
    }

    public void setXLabel(String string) {
        if (this.drawingPanel instanceof PlottingPanel) {
            ((PlottingPanel)this.drawingPanel).setXLabel(string);
        }
    }

    public void setYLabel(String string) {
        if (this.drawingPanel instanceof PlottingPanel) {
            ((PlottingPanel)this.drawingPanel).setYLabel(string);
        }
    }

    public void setPolar(String string, double d) {
        if (this.drawingPanel instanceof PlottingPanel) {
            ((PlottingPanel)this.drawingPanel).setPolar(string, d);
        }
    }

    public void setCartesian(String string, String string2, String string3) {
        if (this.drawingPanel instanceof PlottingPanel) {
            ((PlottingPanel)this.drawingPanel).setCartesian(string, string2, string3);
        }
    }

    public void limitAutoscaleX(double d, double d2) {
        this.drawingPanel.limitAutoscaleX(d, d2);
    }

    public void limitAutoscaleY(double d, double d2) {
        this.drawingPanel.limitAutoscaleY(d, d2);
    }

    public void setAutoscaleX(boolean bl) {
        if (this.drawingPanel != null) {
            this.drawingPanel.setAutoscaleX(bl);
        }
    }

    public boolean isAutoscaleX() {
        if (this.drawingPanel != null) {
            return this.drawingPanel.isAutoscaleX();
        }
        return false;
    }

    public void setAutoscaleY(boolean bl) {
        if (this.drawingPanel != null) {
            this.drawingPanel.setAutoscaleY(bl);
        }
    }

    public boolean isAutoscaleY() {
        if (this.drawingPanel != null) {
            return this.drawingPanel.isAutoscaleY();
        }
        return false;
    }

    public void setSquareAspect(boolean bl) {
        if (this.drawingPanel != null) {
            this.drawingPanel.setSquareAspect(bl);
        }
    }

    public void setLogScale(boolean bl, boolean bl2) {
        if (this.drawingPanel != null && this.drawingPanel instanceof PlottingPanel) {
            ((PlottingPanel)this.drawingPanel).setLogScale(bl, bl2);
        }
    }

    public void setPixelsPerUnit(boolean bl, double d, double d2) {
        this.drawingPanel.setPixelsPerUnit(bl, d, d2);
    }

    public void setPreferredMinMax(double d, double d2, double d3, double d4) {
        if (this.drawingPanel != null) {
            this.drawingPanel.setPreferredMinMax(d, d2, d3, d4);
        }
    }

    public void setPreferredMinMaxY(double d, double d2) {
        if (this.drawingPanel != null) {
            this.drawingPanel.setPreferredMinMaxY(d, d2);
        }
    }

    public void setPreferredMinMaxX(double d, double d2) {
        if (this.drawingPanel != null) {
            this.drawingPanel.setPreferredMinMaxX(d, d2);
        }
    }

    public void clearDataAndRepaint() {
        this.clearData();
        this.drawingPanel.repaint();
    }

    public void clearDrawables() {
        this.drawingPanel.clear();
    }

    public synchronized void addDrawable(Drawable drawable) {
        if (this.drawingPanel != null) {
            this.drawingPanel.addDrawable(drawable);
        }
    }

    public synchronized void replaceDrawable(Drawable drawable, Drawable drawable2) {
        if (this.drawingPanel != null) {
            this.drawingPanel.replaceDrawable(drawable, drawable2);
        }
    }

    public synchronized void removeDrawable(Drawable drawable) {
        if (this.drawingPanel != null) {
            this.drawingPanel.removeDrawable(drawable);
        }
    }

    public void setMessage(String string) {
        this.drawingPanel.setMessage(string);
    }

    public void setMessage(String string, int n) {
        this.drawingPanel.setMessage(string, n);
    }

    public synchronized ArrayList getObjectOfClass(Class clazz) {
        if (this.drawingPanel != null) {
            return this.drawingPanel.getObjectOfClass(clazz);
        }
        return null;
    }

    public synchronized ArrayList getDrawables() {
        if (this.drawingPanel != null) {
            return this.drawingPanel.getDrawables();
        }
        return new ArrayList();
    }

    public DrawableAxes getAxes() {
        if (this.drawingPanel instanceof PlottingPanel) {
            return ((PlottingPanel)this.drawingPanel).getAxes();
        }
        return null;
    }

    public synchronized ArrayList getDrawables(Class clazz) {
        if (this.drawingPanel != null) {
            return this.drawingPanel.getDrawables(clazz);
        }
        return new ArrayList();
    }

    public synchronized void removeObjectsOfClass(Class clazz) {
        this.drawingPanel.removeObjectsOfClass(clazz);
    }

    public void setInteractiveMouseHandler(InteractiveMouseHandler interactiveMouseHandler) {
        ((InteractivePanel)this.drawingPanel).setInteractiveMouseHandler(interactiveMouseHandler);
    }

    public void setDrawingPanel(DrawingPanel drawingPanel) {
        if (this.drawingPanel != null) {
            this.getContentPane().remove(this.drawingPanel);
        }
        this.drawingPanel = drawingPanel;
        if (this.drawingPanel != null) {
            this.getContentPane().add((Component)this.drawingPanel, "Center");
        }
    }

    public void setInteriorBackground(Color color) {
        if (this.drawingPanel instanceof PlottingPanel) {
            ((PlottingPanel)this.drawingPanel).getAxes().setInteriorBackground(color);
        } else {
            this.drawingPanel.setBackground(color);
        }
    }

    public void paint(Graphics graphics) {
        if (!OSPRuntime.appletMode) {
            super.paint(graphics);
            return;
        }
        try {
            super.paint(graphics);
        }
        catch (Exception exception) {
            System.err.println("OSPFrame paint error: " + exception.toString());
            System.err.println("Title: " + this.getTitle());
        }
    }

    public void setEnabledPaste(boolean bl) {
        this.pasteItem.setEnabled(bl);
    }

    protected void pasteAction(XMLControlElement xMLControlElement) {
        XMLTreeChooser xMLTreeChooser = new XMLTreeChooser(DisplayRes.getString("DrawingFrame.SelectDrawables_chooser_title"), DisplayRes.getString("DrawingFrame.SelectDrawables_chooser_message"), this);
        List list = xMLTreeChooser.choose(xMLControlElement, Drawable.class);
        if (!list.isEmpty()) {
            for (XMLControl xMLControl : list) {
                Drawable drawable = (Drawable)xMLControl.loadObject(null);
                this.addDrawable(drawable);
            }
        }
        this.drawingPanel.repaint();
    }

    public void setEnabledReplace(boolean bl) {
        this.replaceItem.setEnabled(bl);
    }

    public void replaceAction(XMLControlElement xMLControlElement) {
        this.clearDrawables();
        this.pasteAction(xMLControlElement);
    }

    protected void copyAction(XMLControlElement xMLControlElement) {
        StringSelection stringSelection = new StringSelection(xMLControlElement.toXML());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void setEnabledCopy(boolean bl) {
        this.copyItem.setEnabled(bl);
    }

    protected void refreshGUI() {
        this.createMenuBar();
        this.pack();
    }

    private void createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        this.fileMenu = new JMenu(DisplayRes.getString("DrawingFrame.File_menu_item"));
        JMenu jMenu = new JMenu(DisplayRes.getString("DrawingFrame.Print_menu_title"));
        JMenuItem jMenuItem = new JMenuItem(DisplayRes.getString("DrawingFrame.Print_menu_item"));
        jMenu.add(jMenuItem);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, MENU_SHORTCUT_KEY_MASK));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintUtils.printComponent(DrawingFrame.this.drawingPanel);
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(DisplayRes.getString("DrawingFrame.PrintFrame_menu_item"));
        jMenu.add(jMenuItem2);
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintUtils.printComponent(DrawingFrame.this);
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem(DisplayRes.getString("DrawingFrame.SaveXML_menu_item"));
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(83, MENU_SHORTCUT_KEY_MASK));
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DrawingFrame.this.saveXML();
            }
        });
        JMenuItem jMenuItem4 = new JMenuItem(DisplayRes.getString("DrawingFrame.Export_menu_item"));
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(69, MENU_SHORTCUT_KEY_MASK));
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.opensourcephysics.tools.ExportTool");
        }
        catch (Exception exception) {
            jMenuItem4.setEnabled(false);
        }
        final Class<?> clazz2 = clazz;
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Method method = clazz2.getMethod("getTool", null);
                    Tool tool = (Tool)method.invoke(null, null);
                    tool.send(new LocalJob(DrawingFrame.this.drawingPanel), DrawingFrame.this.reply);
                }
                catch (Exception exception) {}
            }
        });
        JMenu jMenu2 = new JMenu(DisplayRes.getString("DrawingFrame.SaveImage_menu_title"));
        JMenuItem jMenuItem5 = new JMenuItem(DisplayRes.getString("DrawingFrame.EPS_menu_item"));
        JMenuItem jMenuItem6 = new JMenuItem(DisplayRes.getString("DrawingFrame.JPEG_menu_item"));
        JMenuItem jMenuItem7 = new JMenuItem(DisplayRes.getString("DrawingFrame.PNG_menu_item"));
        jMenu2.add(jMenuItem5);
        jMenu2.add(jMenuItem6);
        jMenu2.add(jMenuItem7);
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIUtils.saveImage((JComponent)DrawingFrame.this.drawingPanel, "eps", DrawingFrame.this);
            }
        });
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIUtils.saveImage((JComponent)DrawingFrame.this.drawingPanel, DisplayRes.getString("DrawingFrame.17"), DrawingFrame.this);
            }
        });
        jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIUtils.saveImage((JComponent)DrawingFrame.this.drawingPanel, "png", DrawingFrame.this);
            }
        });
        JMenuItem jMenuItem8 = new JMenuItem(DisplayRes.getString("DrawingFrame.InspectMenuItem"));
        jMenuItem8.setAccelerator(KeyStroke.getKeyStroke(73, MENU_SHORTCUT_KEY_MASK));
        jMenuItem8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DrawingFrame.this.inspectXML();
            }
        });
        if (OSPRuntime.applet == null) {
            this.fileMenu.add(jMenu);
            this.fileMenu.add(jMenuItem3);
            this.fileMenu.add(jMenuItem4);
            this.fileMenu.add(jMenu2);
        }
        this.fileMenu.add(jMenuItem8);
        jMenuBar.add(this.fileMenu);
        this.editMenu = new JMenu(DisplayRes.getString("DrawingFrame.Edit_menu_title"));
        jMenuBar.add(this.editMenu);
        this.copyItem = new JMenuItem(DisplayRes.getString("DrawingFrame.Copy_menu_item"));
        this.copyItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XMLControlElement xMLControlElement = new XMLControlElement(DrawingFrame.this);
                xMLControlElement.saveObject(null);
                DrawingFrame.this.copyAction(xMLControlElement);
            }
        });
        this.editMenu.add(this.copyItem);
        this.pasteItem = new JMenuItem(DisplayRes.getString("DrawingFrame.Paste_menu_item"));
        this.pasteItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    Transferable transferable = clipboard.getContents(null);
                    XMLControlElement xMLControlElement = new XMLControlElement();
                    xMLControlElement.readXML((String)transferable.getTransferData(DataFlavor.stringFlavor));
                    DrawingFrame.this.pasteAction(xMLControlElement);
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {
                }
                catch (HeadlessException headlessException) {}
            }
        });
        this.pasteItem.setEnabled(false);
        this.editMenu.add(this.pasteItem);
        this.replaceItem = new JMenuItem(DisplayRes.getString("DrawingFrame.Replace_menu_item"));
        this.replaceItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    Transferable transferable = clipboard.getContents(null);
                    XMLControlElement xMLControlElement = new XMLControlElement();
                    xMLControlElement.readXML((String)transferable.getTransferData(DataFlavor.stringFlavor));
                    DrawingFrame.this.replaceAction(xMLControlElement);
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {
                }
                catch (HeadlessException headlessException) {}
            }
        });
        this.replaceItem.setEnabled(false);
        this.editMenu.add(this.replaceItem);
        this.setJMenuBar(jMenuBar);
        this.loadDisplayMenu();
        this.loadToolsMenu();
        JMenu jMenu3 = new JMenu(DisplayRes.getString("DrawingFrame.Help_menu_item"));
        jMenuBar.add(jMenu3);
        JMenuItem jMenuItem9 = new JMenuItem(DisplayRes.getString("DrawingFrame.AboutOSP_menu_item"));
        jMenuItem9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OSPRuntime.showAboutDialog(DrawingFrame.this);
            }
        });
        jMenu3.add(jMenuItem9);
    }

    protected JMenu loadDisplayMenu() {
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar == null) {
            return null;
        }
        JMenu jMenu = new JMenu(DisplayRes.getString("DrawingFrame.Display_menu_title"));
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu(DisplayRes.getString("DrawingFrame.Font_menu_title"));
        jMenu.add(jMenu2);
        JMenuItem jMenuItem = new JMenuItem(DisplayRes.getString("DrawingFrame.IncreaseFontSize_menu_item"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontSizer.levelUp();
            }
        });
        jMenu2.add(jMenuItem);
        final JMenuItem jMenuItem2 = new JMenuItem(DisplayRes.getString("DrawingFrame.DecreaseFontSize_menu_item"));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontSizer.levelDown();
            }
        });
        jMenu2.add(jMenuItem2);
        jMenu2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jMenuItem2.setEnabled(FontSizer.getLevel() > 0);
            }
        });
        JMenu jMenu3 = new JMenu(DisplayRes.getString("DrawingFrame.AntiAlias_menu_title"));
        jMenu.add(jMenu3);
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(DisplayRes.getString("DrawingFrame.Text_checkbox_label"), false);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DrawingFrame.this.drawingPanel.antialiasTextOn = jCheckBoxMenuItem.isSelected();
                DrawingFrame.this.drawingPanel.repaint();
            }
        });
        jMenu3.add(jCheckBoxMenuItem);
        final JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem(DisplayRes.getString("DrawingFrame.Drawing_textbox_label"), false);
        jCheckBoxMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DrawingFrame.this.drawingPanel.antialiasShapeOn = jCheckBoxMenuItem2.isSelected();
                DrawingFrame.this.drawingPanel.repaint();
            }
        });
        jMenu3.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jCheckBoxMenuItem.setSelected(DrawingFrame.this.drawingPanel.antialiasTextOn);
                jCheckBoxMenuItem2.setSelected(DrawingFrame.this.drawingPanel.antialiasShapeOn);
            }
        });
        jMenu3.add(jCheckBoxMenuItem2);
        jMenuBar.add(jMenu);
        return jMenu;
    }

    protected JMenu loadToolsMenu() {
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar == null) {
            return null;
        }
        JMenu jMenu = new JMenu(DisplayRes.getString("DrawingFrame.Tools_menu_title"));
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem(DisplayRes.getString("DrawingFrame.DatasetTool_menu_item"));
        jMenu.add(jMenuItem);
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.opensourcephysics.tools.DataTool");
        }
        catch (Exception exception) {
            jMenuItem.setEnabled(false);
        }
        final Class<?> clazz2 = clazz;
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Method method = clazz2.getMethod("getTool", null);
                    Tool tool = (Tool)method.invoke(null, null);
                    tool.send(new LocalJob(DrawingFrame.this.drawingPanel), DrawingFrame.this.reply);
                    if (tool instanceof OSPFrame) {
                        ((OSPFrame)((Object)tool)).setKeepHidden(false);
                    }
                    ((JFrame)((Object)tool)).setVisible(true);
                }
                catch (Exception exception) {}
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(DisplayRes.getString("DrawingFrame.FourierTool_menu_item"));
        jMenu.add(jMenuItem2);
        Class<?> clazz3 = null;
        try {
            clazz3 = Class.forName("org.opensourcephysics.tools.FourierTool");
        }
        catch (Exception exception) {
            jMenuItem2.setEnabled(false);
        }
        final Class<?> clazz4 = clazz3;
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Method method = clazz4.getMethod("getTool", null);
                    Tool tool = (Tool)method.invoke(null, null);
                    tool.send(new LocalJob(DrawingFrame.this.drawingPanel), DrawingFrame.this.reply);
                    if (tool instanceof OSPFrame) {
                        ((OSPFrame)((Object)tool)).setKeepHidden(false);
                    }
                    ((JFrame)((Object)tool)).setVisible(true);
                }
                catch (Exception exception) {}
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem("Snapshot");
        if (OSPRuntime.applet == null) {
            jMenu.add(jMenuItem3);
        }
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotTool snapshotTool = SnapshotTool.getTool();
                if (DrawingFrame.this.drawingPanel != null) {
                    snapshotTool.saveImage(null, DrawingFrame.this.drawingPanel);
                } else {
                    snapshotTool.saveImage(null, DrawingFrame.this.getContentPane());
                }
            }
        });
        JMenuItem jMenuItem4 = new JMenuItem("Video Capture");
        if (OSPRuntime.applet == null) {
            jMenu.add(jMenuItem4);
        }
        Class<?> clazz5 = null;
        try {
            clazz5 = Class.forName("org.opensourcephysics.tools.VideoCaptureTool");
        }
        catch (Exception exception) {
            OSPLog.finest("Cannot instantiate video capture tool class:\n" + exception.toString());
            jMenuItem4.setEnabled(false);
        }
        final Class<?> clazz6 = clazz5;
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DrawingFrame.this.drawingPanel.getVideoTool() == null) {
                    try {
                        Method method = clazz6.getMethod("getTool", null);
                        Tool tool = (Tool)method.invoke(null, null);
                        DrawingFrame.this.drawingPanel.setVideoTool((VideoTool)((Object)tool));
                        ((VideoTool)((Object)tool)).setVisible(true);
                        ((VideoTool)((Object)tool)).clear();
                    }
                    catch (Exception exception) {
                        OSPLog.finest("Cannot perform action to get video tool class:\n" + exception.toString());
                    }
                } else {
                    DrawingFrame.this.drawingPanel.getVideoTool().setVisible(true);
                }
            }
        });
        return jMenu;
    }

    public void setCustomInspector(Window window) {
        if (this.customInspector != null) {
            this.customInspector.setVisible(false);
        }
        this.customInspector = window;
    }

    public void inspectXML() {
        Object object;
        if (this.customInspector != null) {
            this.customInspector.setVisible(true);
            return;
        }
        XMLControlElement xMLControlElement = null;
        try {
            object = this.drawingPanel.getClass().getMethod("getLoader", null);
            if (object != null && Modifier.isStatic(((Method)object).getModifiers())) {
                xMLControlElement = new XMLControlElement(this.drawingPanel);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return;
        }
        object = new XMLTreePanel(xMLControlElement);
        JDialog jDialog = new JDialog(null, true);
        jDialog.setContentPane((Container)object);
        jDialog.setSize(new Dimension(600, 300));
        jDialog.setVisible(true);
    }

    public void saveXML() {
        JFileChooser jFileChooser = OSPRuntime.getChooser();
        int n = jFileChooser.showSaveDialog(null);
        if (n == 0) {
            int n2;
            OSPRuntime.chooserDir = jFileChooser.getCurrentDirectory().toString();
            File file = jFileChooser.getSelectedFile();
            if (file.exists() && (n2 = JOptionPane.showConfirmDialog(null, String.valueOf(DisplayRes.getString("DrawingFrame.ReplaceExisting_message")) + file.getName() + DisplayRes.getString("DrawingFrame.QuestionMark"), DisplayRes.getString("DrawingFrame.ReplaceFile_option_title"), 1)) != 0) {
                return;
            }
            String string = XML.getRelativePath(file.getAbsolutePath());
            if (string == null || string.trim().equals("")) {
                return;
            }
            int n3 = string.toLowerCase().lastIndexOf(".xml");
            if (n3 != string.length() - 4) {
                string = String.valueOf(string) + ".xml";
            }
            try {
                Method method = this.drawingPanel.getClass().getMethod("getLoader", null);
                if (method != null && Modifier.isStatic(method.getModifiers())) {
                    XMLControlElement xMLControlElement = new XMLControlElement(this.drawingPanel);
                    xMLControlElement.write(string);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return;
            }
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new DrawingFrameLoader();
    }

    protected static class DrawingFrameLoader
    implements XML.ObjectLoader {
        protected DrawingFrameLoader() {
        }

        public Object createObject(XMLControl xMLControl) {
            DrawingFrame drawingFrame = new DrawingFrame();
            drawingFrame.setTitle(xMLControl.getString("title"));
            drawingFrame.setLocation(xMLControl.getInt("location x"), xMLControl.getInt("location y"));
            drawingFrame.setSize(xMLControl.getInt("width"), xMLControl.getInt("height"));
            if (xMLControl.getBoolean("showing")) {
                drawingFrame.setVisible(true);
            }
            return drawingFrame;
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            DrawingFrame drawingFrame = (DrawingFrame)object;
            xMLControl.setValue("title", drawingFrame.getTitle());
            xMLControl.setValue("showing", drawingFrame.isShowing());
            xMLControl.setValue("location x", drawingFrame.getLocation().x);
            xMLControl.setValue("location y", drawingFrame.getLocation().y);
            xMLControl.setValue("width", drawingFrame.getSize().width);
            xMLControl.setValue("height", drawingFrame.getSize().height);
            xMLControl.setValue("drawing panel", drawingFrame.getDrawingPanel());
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            DrawingFrame drawingFrame = (DrawingFrame)object;
            DrawingPanel drawingPanel = drawingFrame.getDrawingPanel();
            drawingPanel.clear();
            XMLControl xMLControl2 = xMLControl.getChildControl("drawing panel");
            xMLControl2.loadObject(drawingPanel);
            drawingPanel.repaint();
            drawingFrame.setTitle(xMLControl.getString("title"));
            drawingFrame.setLocation(xMLControl.getInt("location x"), xMLControl.getInt("location y"));
            drawingFrame.setSize(xMLControl.getInt("width"), xMLControl.getInt("height"));
            if (xMLControl.getBoolean("showing")) {
                drawingFrame.setVisible(true);
            }
            return object;
        }
    }
}

