/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPLayout;

public class TextPanel
extends JPanel {
    protected static Dimension ZEROSIZE = new Dimension(0, 0);
    protected String text = "";
    protected Font font;
    protected String fontname = "TimesRoman";
    protected int fontsize = 14;
    protected int fontstyle = 0;
    protected Color textColor = Color.black;
    protected Color backgroundColor = Color.yellow;
    protected Dimension dim = ZEROSIZE;

    public TextPanel() {
        this.setBackground(this.backgroundColor);
        this.font = new Font(this.fontname, this.fontstyle, this.fontsize);
    }

    public TextPanel(String string) {
        this();
        this.setText(string);
    }

    public void setText(String string) {
        Container container;
        if (this.text == (string = GUIUtils.parseTeX(string))) {
            return;
        }
        this.text = string;
        if (this.text == null) {
            this.text = "";
        }
        if ((container = this.getParent()) == null) {
            return;
        }
        if (container.getLayout() instanceof OSPLayout) {
            ((OSPLayout)container.getLayout()).quickLayout(container, this);
            this.repaint();
        } else {
            container.validate();
        }
    }

    public Dimension getPreferredSize() {
        Container container = this.getParent();
        String string = this.text;
        if (container == null || string.equals("")) {
            return ZEROSIZE;
        }
        Graphics2D graphics2D = (Graphics2D)container.getGraphics();
        if (graphics2D == null) {
            return ZEROSIZE;
        }
        Font font = graphics2D.getFont();
        graphics2D.setFont(this.font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n = fontMetrics.getAscent() + 4;
        int n2 = fontMetrics.stringWidth(string) + 6;
        graphics2D.setFont(font);
        return new Dimension(n2, n);
    }

    public void paintComponent(Graphics graphics) {
        String string = this.text;
        if (!this.dim.equals(this.getPreferredSize())) {
            this.dim = this.getPreferredSize();
            this.setSize(this.dim);
        }
        if (string.equals("") || !this.isVisible()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paintComponent(graphics);
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics2D.setColor(this.textColor);
        Font font = graphics2D.getFont();
        graphics2D.setFont(this.font);
        graphics2D.drawString(string, 3, n2 - 4);
        graphics2D.setFont(font);
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(0, 0, n - 1, n2 - 1);
    }
}

