/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import org.opensourcephysics.controls.Control;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.ElementSet;
import org.opensourcephysics.displayejs.Group;
import org.opensourcephysics.displayejs.InteractionEvent;
import org.opensourcephysics.displayejs.InteractionListener;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Object3D;
import org.opensourcephysics.displayejs.Resolution;
import org.opensourcephysics.displayejs.Style;

public abstract class AbstractInteractiveElement
implements InteractiveElement {
    public static int SENSIBILITY = 5;
    protected boolean canBeMeasured = true;
    protected boolean visible = true;
    protected boolean positionEnabled = false;
    protected boolean sizeEnabled = false;
    protected boolean positionGroupEnabled = true;
    protected boolean sizeGroupEnabled = false;
    protected int actualSensitivity = SENSIBILITY;
    protected double x = 0.0;
    protected double y = 0.0;
    protected double z = 0.0;
    protected double sizex = 0.1;
    protected double sizey = 0.1;
    protected double sizez = 0.1;
    protected final Style style = new Style(this);
    protected Resolution resolution = null;
    protected Group group = null;
    protected ElementSet set = null;
    protected int setIndex = -1;
    protected Control control = null;
    protected Object dataObject = null;
    protected boolean hasChanged = true;
    protected DrawingPanel panelWithValidProjection = null;
    private ArrayList listeners = new ArrayList();

    public void canBeMeasured(boolean _canBe) {
        this.canBeMeasured = _canBe;
    }

    public void copyFrom(InteractiveElement _element) {
        this.setX(_element.getX());
        this.setY(_element.getY());
        this.setZ(_element.getZ());
        this.setSizeX(_element.getSizeX());
        this.setSizeY(_element.getSizeY());
        this.setSizeZ(_element.getSizeZ());
        this.setVisible(_element.isVisible());
        this.setEnabled(0, _element.isEnabled(0));
        this.setEnabled(1, _element.isEnabled(1));
        this.getStyle().copyFrom(_element.getStyle());
        this.setResolution(_element.getResolution());
        this.setGroup(_element.getGroup());
        this.setGroupEnabled(0, _element.isGroupEnabled(0));
        this.setGroupEnabled(1, _element.isGroupEnabled(1));
        this.setControl(_element.getControl());
    }

    public void setSensitivity(int _s) {
        this.actualSensitivity = _s <= 0 ? SENSIBILITY : _s;
    }

    public int getSensitivity() {
        return this.actualSensitivity;
    }

    public void setX(double _x) {
        this.x = _x;
        this.hasChanged = true;
    }

    public double getX() {
        return this.x;
    }

    public void setY(double _y) {
        this.y = _y;
        this.hasChanged = true;
    }

    public double getY() {
        return this.y;
    }

    public void setZ(double _z) {
        this.z = _z;
        this.hasChanged = true;
    }

    public double getZ() {
        return this.z;
    }

    public void setXY(double _x, double _y) {
        this.x = _x;
        this.y = _y;
        this.hasChanged = true;
    }

    public void setXYZ(double _x, double _y, double _z) {
        this.x = _x;
        this.y = _y;
        this.z = _z;
        this.hasChanged = true;
    }

    public void setSizeX(double _sizex) {
        this.sizex = _sizex;
        this.hasChanged = true;
    }

    public double getSizeX() {
        return this.sizex;
    }

    public void setSizeY(double _sizey) {
        this.sizey = _sizey;
        this.hasChanged = true;
    }

    public double getSizeY() {
        return this.sizey;
    }

    public void setSizeZ(double _sizez) {
        this.sizez = _sizez;
        this.hasChanged = true;
    }

    public double getSizeZ() {
        return this.sizez;
    }

    public void setSizeXY(double _sizex, double _sizey) {
        this.sizex = _sizex;
        this.sizey = _sizey;
        this.hasChanged = true;
    }

    public void setSizeXYZ(double _sizex, double _sizey, double _sizez) {
        this.sizex = _sizex;
        this.sizey = _sizey;
        this.sizez = _sizez;
        this.hasChanged = true;
    }

    public void setVisible(boolean _visible) {
        this.visible = _visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setResolution(Resolution _resolution) {
        this.resolution = _resolution;
        this.hasChanged = true;
    }

    public Resolution getResolution() {
        return this.resolution;
    }

    public void setGroup(Group _group) {
        if (this.group != null) {
            this.group.removeElement(this);
        }
        this.group = _group;
        if (this.group != null) {
            this.group.addElement(this);
        }
        this.hasChanged = true;
    }

    public Group getGroup() {
        return this.group;
    }

    public void setGroupEnabled(boolean affectsGroup) {
        this.positionGroupEnabled = this.sizeGroupEnabled = affectsGroup;
    }

    public boolean isGroupEnabled() {
        return this.positionGroupEnabled || this.sizeGroupEnabled;
    }

    public void setGroupEnabled(int target, boolean affectsGroup) {
        switch (target) {
            case 0: {
                this.positionGroupEnabled = affectsGroup;
                break;
            }
            case 1: {
                this.sizeGroupEnabled = affectsGroup;
            }
        }
    }

    public boolean isGroupEnabled(int target) {
        switch (target) {
            case 0: {
                return this.positionGroupEnabled;
            }
            case 1: {
                return this.sizeGroupEnabled;
            }
        }
        return false;
    }

    public void setSet(ElementSet _set, int _index) {
        this.set = _set;
        this.setIndex = _index;
    }

    public ElementSet getSet() {
        return this.set;
    }

    public int getSetIndex() {
        return this.setIndex;
    }

    public void setControl(Control _control) {
        this.control = _control;
    }

    public Control getControl() {
        return this.control;
    }

    public String toXML() {
        return this.toString();
    }

    public void setDataObject(Object _data) {
        this.dataObject = _data;
    }

    public Object getDataObject() {
        return this.dataObject;
    }

    public abstract Interactive findInteractive(DrawingPanel var1, int var2, int var3);

    public void needsToProject(DrawingPanel _panel) {
        this.panelWithValidProjection = null;
    }

    public abstract Object3D[] getObjects3D(DrawingPanel3D var1);

    public abstract void draw(DrawingPanel3D var1, Graphics2D var2, int var3);

    public void drawQuickly(DrawingPanel3D _panel, Graphics2D _g2) {
        this.draw(_panel, _g2);
    }

    public abstract void draw(DrawingPanel var1, Graphics var2);

    public void setEnabled(boolean _enabled) {
        this.positionEnabled = this.sizeEnabled = _enabled;
    }

    public boolean isEnabled() {
        return this.positionEnabled || this.sizeEnabled;
    }

    public void setEnabled(int _target, boolean _enabled) {
        switch (_target) {
            case 0: {
                this.positionEnabled = _enabled;
                break;
            }
            case 1: {
                this.sizeEnabled = _enabled;
            }
        }
    }

    public boolean isEnabled(int _target) {
        switch (_target) {
            case 0: {
                return this.positionEnabled;
            }
            case 1: {
                return this.sizeEnabled;
            }
        }
        return false;
    }

    public void addListener(InteractionListener _listener) {
        if (this.set != null) {
            System.out.println("Warning: elements in sets should not add listeners! " + this.toString());
        }
        if (_listener == null || this.listeners.contains(_listener)) {
            return;
        }
        this.listeners.add(_listener);
    }

    public void removeListener(InteractionListener _listener) {
        this.listeners.remove(_listener);
    }

    public void removeAllListeners() {
        this.listeners = new ArrayList();
    }

    public void invokeActions(InteractionEvent _event) {
        for (InteractionListener listener : this.listeners) {
            listener.interactionPerformed(_event);
        }
    }

    public boolean isMeasured() {
        return this.canBeMeasured && this.visible;
    }

    public double getXMin() {
        if (this.group == null) {
            return this.x - Math.abs(this.sizex);
        }
        return this.group.x + this.x - Math.abs(this.sizex * this.group.sizex);
    }

    public double getXMax() {
        if (this.group == null) {
            return this.x + Math.abs(this.sizex);
        }
        return this.group.x + this.x + Math.abs(this.sizex * this.group.sizex);
    }

    public double getYMin() {
        if (this.group == null) {
            return this.y - Math.abs(this.sizey);
        }
        return this.group.y + this.y - Math.abs(this.sizey * this.group.sizey);
    }

    public double getYMax() {
        if (this.group == null) {
            return this.y + Math.abs(this.sizey);
        }
        return this.group.y + this.y + Math.abs(this.sizey * this.group.sizey);
    }

    public double getZMin() {
        if (this.group == null) {
            return this.z - Math.abs(this.sizez);
        }
        return this.group.z + this.z - Math.abs(this.sizez * this.group.sizez);
    }

    public double getZMax() {
        if (this.group == null) {
            return this.z + Math.abs(this.sizez);
        }
        return this.group.z + this.z + Math.abs(this.sizez * this.group.sizez);
    }
}

