/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.displayejs.AbstractInteractionSource;
import org.opensourcephysics.displayejs.Drawable3D;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.InteractionTarget;
import org.opensourcephysics.displayejs.InteractionTargetSetElement;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Measurable3D;
import org.opensourcephysics.displayejs.Object3D;

public class ElementSet
extends AbstractInteractionSource
implements Interactive,
Drawable3D,
Measurable3D {
    protected int numElements = 0;
    protected Class classType;
    protected int elementInteracted = -1;
    protected String name = "";
    protected InteractiveElement[] elements = null;
    protected ArrayList list3D = new ArrayList();
    protected Object3D[] minimalObjects = new Object3D[1];

    public ElementSet(int _n, Class _aClass) {
        if (_n < 1) {
            System.out.println("ElementSet error: An element set must contain at least one element!");
            _n = 1;
        }
        this.classType = _aClass;
        this.setNumberOfElements(_n);
    }

    public void setName(String _name) {
        this.name = _name;
    }

    public String getName() {
        return this.name;
    }

    public int getNumberOfElements() {
        return this.numElements;
    }

    public synchronized void setNumberOfElements(int _n) {
        int i;
        if (_n == this.numElements || _n < 1) {
            return;
        }
        InteractiveElement[] oldElements = this.elements;
        this.elements = new InteractiveElement[_n];
        try {
            i = 0;
            while (i < _n) {
                this.elements[i] = (InteractiveElement)this.classType.newInstance();
                this.elements[i].setSet(this, i);
                ++i;
            }
            this.numElements = _n;
        }
        catch (Exception exc) {
            System.out.println("Error: ElementSet requires a class that extends InteractiveElement!");
            exc.printStackTrace();
            this.numElements = 0;
            return;
        }
        if (oldElements == null) {
            return;
        }
        i = 0;
        int n = Math.min(this.elements.length, oldElements.length);
        while (i < n) {
            this.elements[i].copyFrom(oldElements[i]);
            ++i;
        }
        if (this.elements.length > oldElements.length) {
            i = oldElements.length;
            n = this.elements.length;
            while (i < n) {
                this.elements[i].copyFrom(oldElements[0]);
                ++i;
            }
        }
        oldElements = null;
        this.setName(this.name);
    }

    public InteractiveElement elementAt(int i) {
        return this.elements[i];
    }

    public void setXs(double[] _x) {
        int n = this.numElements;
        if (n > _x.length) {
            n = _x.length;
        }
        int i = 0;
        while (i < n) {
            this.elements[i].setX(_x[i]);
            ++i;
        }
    }

    public double[] getXs() {
        double[] x = new double[this.numElements];
        int i = 0;
        while (i < this.numElements) {
            x[i] = this.elements[i].getX();
            ++i;
        }
        return x;
    }

    public void setYs(double[] _y) {
        int n = this.numElements;
        if (n > _y.length) {
            n = _y.length;
        }
        int i = 0;
        while (i < n) {
            this.elements[i].setY(_y[i]);
            ++i;
        }
    }

    public double[] getYs() {
        double[] y = new double[this.numElements];
        int i = 0;
        while (i < this.numElements) {
            y[i] = this.elements[i].getY();
            ++i;
        }
        return y;
    }

    public void setZs(double[] _z) {
        int n = this.numElements;
        if (n > _z.length) {
            n = _z.length;
        }
        int i = 0;
        while (i < n) {
            this.elements[i].setZ(_z[i]);
            ++i;
        }
    }

    public double[] getZs() {
        double[] z = new double[this.numElements];
        int i = 0;
        while (i < this.numElements) {
            z[i] = this.elements[i].getZ();
            ++i;
        }
        return z;
    }

    public void setXYZs(double[] _x, double[] _y, double[] _z) {
        int n = this.numElements;
        if (n > _x.length) {
            n = _x.length;
        }
        if (n > _y.length) {
            n = _y.length;
        }
        if (n > _z.length) {
            n = _z.length;
        }
        int i = 0;
        while (i < n) {
            this.elements[i].setXYZ(_x[i], _y[i], _z[i]);
            ++i;
        }
    }

    public void setSizeXs(double[] _x) {
        int n = this.numElements;
        if (n > _x.length) {
            n = _x.length;
        }
        int i = 0;
        while (i < n) {
            this.elements[i].setSizeX(_x[i]);
            ++i;
        }
    }

    public double[] getSizeXs() {
        double[] sx = new double[this.numElements];
        int i = 0;
        while (i < this.numElements) {
            sx[i] = this.elements[i].getSizeX();
            ++i;
        }
        return sx;
    }

    public void setSizeYs(double[] _y) {
        int n = this.numElements;
        if (n > _y.length) {
            n = _y.length;
        }
        int i = 0;
        while (i < n) {
            this.elements[i].setSizeY(_y[i]);
            ++i;
        }
    }

    public double[] getSizeYs() {
        double[] sy = new double[this.numElements];
        int i = 0;
        while (i < this.numElements) {
            sy[i] = this.elements[i].getSizeY();
            ++i;
        }
        return sy;
    }

    public void setSizeZs(double[] _z) {
        int n = this.numElements;
        if (n > _z.length) {
            n = _z.length;
        }
        int i = 0;
        while (i < n) {
            this.elements[i].setSizeZ(_z[i]);
            ++i;
        }
    }

    public double[] getSizeZs() {
        double[] sz = new double[this.numElements];
        int i = 0;
        while (i < this.numElements) {
            sz[i] = this.elements[i].getSizeZ();
            ++i;
        }
        return sz;
    }

    public void setSizeXYZs(double[] _x, double[] _y, double[] _z) {
        int n = this.numElements;
        if (n > _x.length) {
            n = _x.length;
        }
        if (n > _y.length) {
            n = _y.length;
        }
        if (n > _z.length) {
            n = _z.length;
        }
        int i = 0;
        while (i < n) {
            this.elements[i].setSizeXYZ(_x[i], _y[i], _z[i]);
            ++i;
        }
    }

    public void setVisible(boolean _visible) {
        int i = 0;
        while (i < this.numElements) {
            this.elements[i].setVisible(_visible);
            ++i;
        }
    }

    public boolean isVisible() {
        int i = 0;
        while (i < this.numElements) {
            if (this.elements[i].isVisible()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setVisibles(boolean[] _vis) {
        int n = this.numElements;
        if (n > _vis.length) {
            n = _vis.length;
        }
        int i = 0;
        while (i < n) {
            this.elements[i].setVisible(_vis[i]);
            ++i;
        }
    }

    public void setEnabled(boolean _enabled) {
        int i = 0;
        while (i < this.numElements) {
            this.elements[i].setEnabled(_enabled);
            ++i;
        }
    }

    public boolean isEnabled() {
        int i = 0;
        while (i < this.numElements) {
            if (this.elements[i].isEnabled()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setEnabled(int _target, boolean _enabled) {
        int i = 0;
        while (i < this.numElements) {
            this.elements[i].setEnabled(_target, _enabled);
            ++i;
        }
    }

    public boolean isEnabled(int _target) {
        int i = 0;
        while (i < this.numElements) {
            if (this.elements[i].isEnabled(_target)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setEnableds(boolean[] _enab) {
        int n = this.numElements;
        if (n > _enab.length) {
            n = _enab.length;
        }
        int i = 0;
        while (i < n) {
            this.elements[i].setEnabled(_enab[i]);
            ++i;
        }
    }

    public void setEnableds(int _target, boolean[] _enab) {
        int n = this.numElements;
        if (n > _enab.length) {
            n = _enab.length;
        }
        int i = 0;
        while (i < n) {
            this.elements[i].setEnabled(_target, _enab[i]);
            ++i;
        }
    }

    public String toXML() {
        return this.toString();
    }

    public int getElementInteracted() {
        return this.elementInteracted;
    }

    public int getInteractedIndex() {
        return this.elementInteracted;
    }

    public Interactive findInteractive(DrawingPanel _panel, int _xpix, int _ypix) {
        int i = 0;
        while (i < this.numElements) {
            Interactive iad = this.elements[i].findInteractive(_panel, _xpix, _ypix);
            if (iad != null) {
                this.elementInteracted = i;
                if (iad instanceof InteractionTarget) {
                    return new InteractionTargetSetElement(this, i, (InteractionTarget)iad);
                }
                return iad;
            }
            ++i;
        }
        this.elementInteracted = -1;
        return null;
    }

    public void needsToProject(DrawingPanel _panel) {
        int i = 0;
        while (i < this.numElements) {
            this.elements[i].needsToProject(_panel);
            ++i;
        }
    }

    public Object3D[] getObjects3D(DrawingPanel3D _panel) {
        if (this.numElements <= 0) {
            return null;
        }
        this.list3D.clear();
        int i = 0;
        while (i < this.numElements) {
            Object3D[] objects = this.elements[i].getObjects3D(_panel);
            if (objects != null) {
                int j = 0;
                while (j < objects.length) {
                    this.list3D.add(objects[j]);
                    ++j;
                }
            }
            ++i;
        }
        if (this.list3D.size() == 0) {
            return null;
        }
        return this.list3D.toArray(this.minimalObjects);
    }

    public void draw(DrawingPanel3D _panel, Graphics2D _g2, int _index) {
        System.out.println("ElementSet draw (i): I should not be called!");
    }

    public void drawQuickly(DrawingPanel3D _panel, Graphics2D _g2) {
        int i = this.numElements - 1;
        while (i >= 0) {
            this.elements[i].drawQuickly(_panel, _g2);
            --i;
        }
    }

    public void draw(DrawingPanel _panel, Graphics _g) {
        int i = this.numElements - 1;
        while (i >= 0) {
            this.elements[i].draw(_panel, _g);
            --i;
        }
    }

    public boolean isMeasured() {
        return this.numElements > 0;
    }

    public double getXMin() {
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < this.numElements) {
            double d;
            double aux = this.elements[i].getXMin();
            if (d < min) {
                min = aux;
            }
            ++i;
        }
        return min;
    }

    public double getXMax() {
        double max = -1.7976931348623157E308;
        int i = 0;
        while (i < this.numElements) {
            double d;
            double aux = this.elements[i].getXMax();
            if (d > max) {
                max = aux;
            }
            ++i;
        }
        return max;
    }

    public double getYMin() {
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < this.numElements) {
            double d;
            double aux = this.elements[i].getYMin();
            if (d < min) {
                min = aux;
            }
            ++i;
        }
        return min;
    }

    public double getYMax() {
        double max = -1.7976931348623157E308;
        int i = 0;
        while (i < this.numElements) {
            double d;
            double aux = this.elements[i].getYMax();
            if (d > max) {
                max = aux;
            }
            ++i;
        }
        return max;
    }

    public double getZMin() {
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < this.numElements) {
            double d;
            double aux = this.elements[i].getZMin();
            if (d < min) {
                min = aux;
            }
            ++i;
        }
        return min;
    }

    public double getZMax() {
        double max = -1.7976931348623157E308;
        int i = 0;
        while (i < this.numElements) {
            double d;
            double aux = this.elements[i].getZMax();
            if (d > max) {
                max = aux;
            }
            ++i;
        }
        return max;
    }

    public void setXY(double _x, double _y) {
    }

    public void setX(double _x) {
    }

    public void setY(double _y) {
    }

    public double getX() {
        return Double.NaN;
    }

    public double getY() {
        return Double.NaN;
    }
}

