/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.Graphics;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.displayejs.InteractionSource;
import org.opensourcephysics.displayejs.InteractionTarget;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Point3D;

public class InteractionTargetElementPosition
implements InteractionTarget {
    protected InteractiveElement element;

    InteractionTargetElementPosition(InteractiveElement _element) {
        this.element = _element;
    }

    public InteractionSource getSource() {
        return this.element;
    }

    public Point3D getHotspot(DrawingPanel _panel) {
        if (this.element.getGroup() == null) {
            return new Point3D(this.element.getX(), this.element.getY(), this.element.getZ());
        }
        return new Point3D(this.element.getGroup().getX() + this.element.getX() * this.element.getGroup().getSizeX(), this.element.getGroup().getY() + this.element.getY() * this.element.getGroup().getSizeY(), this.element.getGroup().getZ() + this.element.getZ() * this.element.getGroup().getSizeZ());
    }

    public void updateHotspot(DrawingPanel _panel, Point3D _point) {
        if (this.element.getGroup() == null) {
            this.element.setXYZ(_point.x, _point.y, _point.z);
        } else if (this.element.isGroupEnabled(0)) {
            this.element.getGroup().setXYZ(_point.x - this.element.getX() * this.element.getGroup().getSizeX(), _point.y - this.element.getY() * this.element.getGroup().getSizeY(), _point.z - this.element.getZ() * this.element.getGroup().getSizeZ());
        } else {
            double x = this.element.getGroup().getSizeX();
            double y = this.element.getGroup().getSizeY();
            double z = this.element.getGroup().getSizeZ();
            x = x == 0.0 ? this.element.getX() : (_point.x - this.element.getGroup().getX()) / x;
            y = y == 0.0 ? this.element.getY() : (_point.y - this.element.getGroup().getY()) / y;
            z = z == 0.0 ? this.element.getZ() : (_point.z - this.element.getGroup().getZ()) / z;
            this.element.setXYZ(x, y, z);
        }
    }

    public Interactive findInteractive(DrawingPanel _panel, int _xpix, int _ypix) {
        return this.element;
    }

    public void setEnabled(boolean _enabled) {
        this.element.setEnabled(0, _enabled);
    }

    public boolean isEnabled() {
        return this.element.isEnabled(0);
    }

    public void setXY(double _x, double _y) {
        this.element.setXY(_x, _y);
    }

    public void setX(double _x) {
        this.element.setX(_x);
    }

    public void setY(double _y) {
        this.element.setY(_y);
    }

    public double getX() {
        return this.element.getX();
    }

    public double getY() {
        return this.element.getY();
    }

    public boolean isMeasured() {
        return true;
    }

    public double getXMin() {
        return this.element.getXMin();
    }

    public double getXMax() {
        return this.element.getXMax();
    }

    public double getYMin() {
        return this.element.getYMin();
    }

    public double getYMax() {
        return this.element.getYMax();
    }

    public void draw(DrawingPanel _panel, Graphics _g) {
        this.element.draw(_panel, _g);
    }
}

