/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.Graphics;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.displayejs.InteractionSource;
import org.opensourcephysics.displayejs.InteractionTarget;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Point3D;

public class InteractionTargetElementSize
implements InteractionTarget {
    protected InteractiveElement element;

    InteractionTargetElementSize(InteractiveElement _element) {
        this.element = _element;
    }

    public InteractionSource getSource() {
        return this.element;
    }

    public Point3D getHotspot(DrawingPanel _panel) {
        if (this.element.getGroup() == null) {
            return new Point3D(this.element.getX() + this.element.getSizeX(), this.element.getY() + this.element.getSizeY(), this.element.getZ() + this.element.getSizeZ());
        }
        return new Point3D(this.element.getGroup().getX() + (this.element.getX() + this.element.getSizeX()) * this.element.getGroup().getSizeX(), this.element.getGroup().getY() + (this.element.getY() + this.element.getSizeY()) * this.element.getGroup().getSizeY(), this.element.getGroup().getZ() + (this.element.getZ() + this.element.getSizeZ()) * this.element.getGroup().getSizeZ());
    }

    public void updateHotspot(DrawingPanel _panel, Point3D _point) {
        if (this.element.getGroup() == null) {
            this.element.setSizeXYZ(_point.x - this.element.getX(), _point.y - this.element.getY(), _point.z - this.element.getZ());
        } else if (this.element.isGroupEnabled(1)) {
            double dx = this.element.getX() + this.element.getSizeX();
            double dy = this.element.getY() + this.element.getSizeY();
            double dz = this.element.getZ() + this.element.getSizeZ();
            dx = dx == 0.0 ? this.element.getGroup().getSizeX() : (_point.x - this.element.getGroup().getX()) / dx;
            dy = dy == 0.0 ? this.element.getGroup().getSizeY() : (_point.y - this.element.getGroup().getY()) / dy;
            dz = dz == 0.0 ? this.element.getGroup().getSizeZ() : (_point.z - this.element.getGroup().getZ()) / dz;
            this.element.getGroup().setSizeXYZ(dx, dy, dz);
        } else {
            double dx = this.element.getGroup().getSizeX();
            double dy = this.element.getGroup().getSizeY();
            double dz = this.element.getGroup().getSizeZ();
            dx = dx == 0.0 ? this.element.getSizeX() : (_point.x - this.element.getGroup().getX()) / dx - this.element.getX();
            dy = dy == 0.0 ? this.element.getSizeY() : (_point.y - this.element.getGroup().getY()) / dy - this.element.getY();
            dz = dz == 0.0 ? this.element.getSizeZ() : (_point.z - this.element.getGroup().getZ()) / dz - this.element.getZ();
            this.element.setSizeXYZ(dx, dy, dz);
        }
    }

    public Interactive findInteractive(DrawingPanel _panel, int _xpix, int _ypix) {
        return this.element;
    }

    public void setEnabled(boolean _enabled) {
        this.element.setEnabled(0, _enabled);
    }

    public boolean isEnabled() {
        return this.element.isEnabled(0);
    }

    public void setXY(double _x, double _y) {
        this.element.setXY(_x, _y);
    }

    public void setX(double _x) {
        this.element.setX(_x);
    }

    public void setY(double _y) {
        this.element.setY(_y);
    }

    public double getX() {
        return this.element.getX();
    }

    public double getY() {
        return this.element.getY();
    }

    public boolean isMeasured() {
        return true;
    }

    public double getXMin() {
        return this.element.getXMin();
    }

    public double getXMax() {
        return this.element.getXMax();
    }

    public double getYMin() {
        return this.element.getYMin();
    }

    public double getYMax() {
        return this.element.getYMax();
    }

    public void draw(DrawingPanel _panel, Graphics _g) {
        this.element.draw(_panel, _g);
    }
}

