/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.displayejs.InteractionTargetElementPosition;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Point3D;

public class InteractionTargetTracePoint
extends InteractionTargetElementPosition {
    Point3D point;

    InteractionTargetTracePoint(InteractiveElement _element, Point3D _point) {
        super(_element);
        this.point = _point;
    }

    public Point3D getHotspot(DrawingPanel _panel) {
        if (this.element.getGroup() == null) {
            return new Point3D(this.element.getX() + this.point.x, this.element.getY() + this.point.y, this.element.getZ() + this.point.z);
        }
        return new Point3D(this.element.getGroup().getX() + (this.element.getX() + this.point.x) * this.element.getGroup().getSizeX(), this.element.getGroup().getY() + (this.element.getY() + this.point.y) * this.element.getGroup().getSizeY(), this.element.getGroup().getZ() + (this.element.getZ() + this.point.z) * this.element.getGroup().getSizeZ());
    }

    public void updateHotspot(DrawingPanel _panel, Point3D _point) {
        if (this.element.getGroup() == null) {
            this.element.setXYZ(_point.x - this.point.x, _point.y - this.point.y, _point.z - this.point.z);
        } else if (this.element.isGroupEnabled(0)) {
            this.element.getGroup().setXYZ(_point.x - (this.element.getX() + this.point.x) * this.element.getGroup().getSizeX(), _point.y - (this.element.getY() + this.point.y) * this.element.getGroup().getSizeY(), _point.z - (this.element.getZ() + this.point.z) * this.element.getGroup().getSizeZ());
        } else {
            double x = this.element.getGroup().getSizeX();
            double y = this.element.getGroup().getSizeY();
            double z = this.element.getGroup().getSizeZ();
            x = x == 0.0 ? this.element.getX() - this.point.x : (_point.x - this.element.getGroup().getX()) / x - this.point.x;
            y = y == 0.0 ? this.element.getY() - this.point.y : (_point.y - this.element.getGroup().getY()) / y - this.point.y;
            z = z == 0.0 ? this.element.getZ() - this.point.z : (_point.z - this.element.getGroup().getZ()) / z - this.point.z;
            this.element.setXYZ(x, y, z);
        }
    }
}

