/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.displayejs.AbstractInteractiveElement;
import org.opensourcephysics.displayejs.Body;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.InteractionTargetElementPosition;
import org.opensourcephysics.displayejs.InteractionTargetElementSize;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Object3D;
import org.opensourcephysics.numerics.Transformation;

public class InteractiveArrow
extends AbstractInteractiveElement
implements Body {
    public static final int ARROW = 0;
    public static final int SEGMENT = 1;
    public static final int BOX = 2;
    protected int arrowType = 0;
    protected Transformation transformation = null;
    protected double originx = 0.0;
    protected double originy = 0.0;
    protected double originz = 0.0;
    protected boolean originIsRelative = true;
    private int div = -1;
    protected double xmin = Double.NaN;
    protected double xmax = Double.NaN;
    protected double ymin = Double.NaN;
    protected double ymax = Double.NaN;
    protected double zmin = Double.NaN;
    protected double zmax = Double.NaN;
    private double[] coordinates = new double[3];
    private double[] pixel = new double[3];
    private Object3D[] objects = null;
    private int[] aCoord = null;
    private int[] bCoord = null;
    private double[][] points = null;
    protected double[] pixelOrigin = new double[3];
    protected double[] pixelEndpoint = new double[3];
    private static final double ARROW_CST = 0.35;
    private static final double ARROW_MAX = 25.0;
    private int headPoints = 0;
    private int[] headA = new int[10];
    private int[] headB = new int[10];

    public InteractiveArrow() {
        this(0);
    }

    public InteractiveArrow(int _type) {
        this.setArrowType(_type);
        this.div = -1;
    }

    public void copyFrom(InteractiveElement _element) {
        super.copyFrom(_element);
        if (_element instanceof InteractiveArrow) {
            InteractiveArrow old = (InteractiveArrow)_element;
            this.setArrowType(old.arrowType);
            this.setOrigin(old.originx, old.originy, old.originz, old.originIsRelative);
            this.setTransformation(old.transformation);
        }
    }

    public void setArrowType(int _type) {
        this.arrowType = _type;
        this.panelWithValidProjection = null;
    }

    public Interactive findInteractive(DrawingPanel _panel, int _xpix, int _ypix) {
        if (!this.visible) {
            return null;
        }
        if (this.hasChanged) {
            this.computeDivisions();
            this.projectPoints(_panel);
        } else if (_panel != this.panelWithValidProjection) {
            this.projectPoints(_panel);
        }
        if (this.sizeEnabled && Math.abs(this.pixelEndpoint[0] - (double)_xpix) < (double)SENSIBILITY && Math.abs(this.pixelEndpoint[1] - (double)_ypix) < (double)SENSIBILITY) {
            return new InteractionTargetElementSize(this);
        }
        if (this.positionEnabled && Math.abs(this.pixelOrigin[0] - (double)_xpix) < (double)SENSIBILITY && Math.abs(this.pixelOrigin[1] - (double)_ypix) < (double)SENSIBILITY) {
            return new InteractionTargetElementPosition(this);
        }
        return null;
    }

    public Object3D[] getObjects3D(DrawingPanel3D _panel) {
        if (!this.visible) {
            return null;
        }
        if (this.hasChanged) {
            this.computeDivisions();
            this.projectPoints(_panel);
        } else if (_panel != this.panelWithValidProjection) {
            this.projectPoints(_panel);
        }
        return this.objects;
    }

    public void draw(DrawingPanel3D _panel, Graphics2D _g2, int _index) {
        Color theColor = _panel.projectColor(this.style.edgeColor, this.objects[_index].distance);
        if (_index < this.div - 1 || this.arrowType == 1) {
            _g2.setStroke(this.style.edgeStroke);
            _g2.setColor(theColor);
            _g2.drawLine(this.aCoord[_index], this.bCoord[_index], this.aCoord[_index + 1], this.bCoord[_index + 1]);
            return;
        }
        Paint theFillPattern = this.style.fillPattern;
        if (theFillPattern instanceof Color) {
            theFillPattern = _panel.projectColor((Color)theFillPattern, this.objects[_index].distance);
        }
        this.drawHead(_panel, _g2, this.aCoord[_index], this.bCoord[_index], theColor, theFillPattern);
    }

    public synchronized void drawQuickly(DrawingPanel3D _panel, Graphics2D _g2) {
        if (!this.visible) {
            return;
        }
        if (this.hasChanged) {
            this.computeDivisions();
            this.projectPoints(_panel);
        } else if (_panel != this.panelWithValidProjection) {
            this.projectPoints(_panel);
        }
        this.drawHead(_panel, _g2, this.aCoord[0], this.bCoord[0], this.style.edgeColor, this.style.fillPattern);
    }

    public synchronized void draw(DrawingPanel _panel, Graphics _g) {
        if (!this.visible) {
            return;
        }
        if (this.hasChanged) {
            this.computeDivisions();
            this.projectPoints(_panel);
        } else {
            this.projectPoints(_panel);
        }
        this.drawHead(_panel, (Graphics2D)_g, this.aCoord[0], this.bCoord[0], this.style.edgeColor, this.style.fillPattern);
    }

    public void setOrigin(double ox, double oy, double oz, boolean relativeToSize) {
        this.originx = ox;
        this.originy = oy;
        this.originz = oz;
        this.originIsRelative = relativeToSize;
        this.hasChanged = true;
    }

    public void setTransformation(Transformation transformation) {
        this.transformation = transformation == null ? null : (Transformation)transformation.clone();
        this.hasChanged = true;
    }

    public void toSpaceFrame(double[] vector) {
        if (this.transformation != null) {
            this.transformation.direct(vector);
        }
        vector[0] = vector[0] + this.x;
        vector[1] = vector[1] + this.y;
        vector[2] = vector[2] + this.z;
    }

    public void toBodyFrame(double[] vector) throws UnsupportedOperationException {
        vector[0] = vector[0] - this.x;
        vector[1] = vector[1] - this.y;
        vector[2] = vector[2] - this.z;
        if (this.transformation != null) {
            this.transformation.inverse(vector);
        }
    }

    public double getXMin() {
        if (this.hasChanged) {
            this.computeDivisions();
            this.computeExtrema();
        } else if (Double.isNaN(this.xmin)) {
            this.computeExtrema();
        }
        return this.xmin;
    }

    public double getXMax() {
        if (this.hasChanged) {
            this.computeDivisions();
            this.computeExtrema();
        } else if (Double.isNaN(this.xmax)) {
            this.computeExtrema();
        }
        return this.xmax;
    }

    public double getYMin() {
        if (this.hasChanged) {
            this.computeDivisions();
            this.computeExtrema();
        } else if (Double.isNaN(this.ymin)) {
            this.computeExtrema();
        }
        return this.ymin;
    }

    public double getYMax() {
        if (this.hasChanged) {
            this.computeDivisions();
            this.computeExtrema();
        } else if (Double.isNaN(this.ymax)) {
            this.computeExtrema();
        }
        return this.ymax;
    }

    public double getZMin() {
        if (this.hasChanged) {
            this.computeDivisions();
            this.computeExtrema();
        } else if (Double.isNaN(this.zmin)) {
            this.computeExtrema();
        }
        return this.zmin;
    }

    public double getZMax() {
        if (this.hasChanged) {
            this.computeDivisions();
            this.computeExtrema();
        } else if (Double.isNaN(this.zmax)) {
            this.computeExtrema();
        }
        return this.zmax;
    }

    protected void computeExtrema() {
        this.zmin = Double.MAX_VALUE;
        this.ymin = Double.MAX_VALUE;
        this.xmin = Double.MAX_VALUE;
        this.zmax = -1.7976931348623157E308;
        this.ymax = -1.7976931348623157E308;
        this.xmax = -1.7976931348623157E308;
        int i = 0;
        while (i <= this.div) {
            double aux = this.points[i][0];
            if (aux < this.xmin) {
                this.xmin = aux;
            }
            if (aux > this.xmax) {
                this.xmax = aux;
            }
            if ((aux = this.points[i][1]) < this.ymin) {
                this.ymin = aux;
            }
            if (aux > this.ymax) {
                this.ymax = aux;
            }
            if ((aux = this.points[i][2]) < this.zmin) {
                this.zmin = aux;
            }
            if (aux > this.zmax) {
                this.zmax = aux;
            }
            ++i;
        }
        if (this.group != null) {
            this.xmin = this.group.x + this.xmin * this.group.sizex;
            this.xmax = this.group.x + this.xmax * this.group.sizex;
            this.ymin = this.group.y + this.ymin * this.group.sizey;
            this.ymax = this.group.y + this.ymax * this.group.sizey;
            this.zmin = this.group.z + this.zmin * this.group.sizez;
            this.zmax = this.group.z + this.zmax * this.group.sizez;
        }
    }

    protected void projectPoints(DrawingPanel _panel) {
        if (this.group == null) {
            this.coordinates[0] = this.x;
            this.coordinates[1] = this.y;
            this.coordinates[2] = this.z;
            this.transformPoint(this.coordinates, false);
            _panel.project(this.coordinates, this.pixelOrigin);
            this.coordinates[0] = this.x + this.sizex;
            this.coordinates[1] = this.y + this.sizey;
            this.coordinates[2] = this.z + this.sizez;
            this.transformPoint(this.coordinates, true);
            _panel.project(this.coordinates, this.pixelEndpoint);
            int i = 0;
            while (i < this.div) {
                _panel.project(this.points[i], this.pixel);
                this.aCoord[i] = (int)this.pixel[0];
                this.bCoord[i] = (int)this.pixel[1];
                int j = 0;
                while (j < 3) {
                    this.coordinates[j] = (this.points[i][j] + this.points[i + 1][j]) * 0.5;
                    ++j;
                }
                _panel.project(this.coordinates, this.pixel);
                this.objects[i].distance = this.pixel[2];
                ++i;
            }
            _panel.project(this.points[this.div], this.pixel);
            this.aCoord[this.div] = (int)this.pixel[0];
            this.bCoord[this.div] = (int)this.pixel[1];
        } else {
            this.coordinates[0] = this.x;
            this.coordinates[1] = this.y;
            this.coordinates[2] = this.z;
            this.transformPoint(this.coordinates, false);
            this.coordinates[0] = this.group.x + this.coordinates[0] * this.group.sizex;
            this.coordinates[1] = this.group.y + this.coordinates[1] * this.group.sizey;
            this.coordinates[2] = this.group.z + this.coordinates[2] * this.group.sizez;
            _panel.project(this.coordinates, this.pixelOrigin);
            this.coordinates[0] = this.x + this.sizex;
            this.coordinates[1] = this.y + this.sizey;
            this.coordinates[2] = this.z + this.sizez;
            this.transformPoint(this.coordinates, true);
            this.coordinates[0] = this.group.x + this.coordinates[0] * this.group.sizex;
            this.coordinates[1] = this.group.y + this.coordinates[1] * this.group.sizey;
            this.coordinates[2] = this.group.z + this.coordinates[2] * this.group.sizez;
            _panel.project(this.coordinates, this.pixelEndpoint);
            int i = 0;
            while (i < this.div) {
                this.coordinates[0] = this.group.x + this.points[i][0] * this.group.sizex;
                this.coordinates[1] = this.group.y + this.points[i][1] * this.group.sizey;
                this.coordinates[2] = this.group.z + this.points[i][2] * this.group.sizez;
                _panel.project(this.coordinates, this.pixel);
                this.aCoord[i] = (int)this.pixel[0];
                this.bCoord[i] = (int)this.pixel[1];
                int j = 0;
                while (j < 3) {
                    this.coordinates[j] = (this.points[i][j] + this.points[i + 1][j]) * 0.5;
                    ++j;
                }
                this.coordinates[0] = this.group.x + this.coordinates[0] * this.group.sizex;
                this.coordinates[1] = this.group.y + this.coordinates[1] * this.group.sizey;
                this.coordinates[2] = this.group.z + this.coordinates[2] * this.group.sizez;
                _panel.project(this.coordinates, this.pixel);
                this.objects[i].distance = this.pixel[2];
                ++i;
            }
            this.coordinates[0] = this.group.x + this.points[this.div][0] * this.group.sizex;
            this.coordinates[1] = this.group.y + this.points[this.div][1] * this.group.sizey;
            this.coordinates[2] = this.group.z + this.points[this.div][2] * this.group.sizez;
            _panel.project(this.coordinates, this.pixel);
            this.aCoord[this.div] = (int)this.pixel[0];
            this.bCoord[this.div] = (int)this.pixel[1];
        }
        this.computeHead();
        this.panelWithValidProjection = _panel;
    }

    protected void computeDivisions() {
        int theDiv = 1;
        if (this.resolution != null) {
            switch (this.resolution.type) {
                case 1: {
                    double length = Math.sqrt(this.sizex * this.sizex + this.sizey * this.sizey + this.sizez * this.sizez);
                    theDiv = Math.max((int)Math.round(0.49 + length / this.resolution.maxLength), 1);
                    break;
                }
                case 0: {
                    theDiv = Math.max(this.resolution.n1, 1);
                }
            }
        }
        if (this.div != theDiv) {
            this.div = theDiv;
            this.points = new double[this.div + 1][3];
            this.aCoord = new int[this.div + 1];
            this.bCoord = new int[this.div + 1];
            this.objects = new Object3D[this.div];
            int i = 0;
            while (i < this.div) {
                this.objects[i] = new Object3D(this, i);
                ++i;
            }
        }
        this.points[0][0] = this.x;
        this.points[0][1] = this.y;
        this.points[0][2] = this.z;
        double dx = this.sizex;
        double dy = this.sizey;
        double dz = this.sizez;
        this.points[this.div][0] = this.x + dx;
        this.points[this.div][1] = this.y + dy;
        this.points[this.div][2] = this.z + dz;
        dx /= (double)this.div;
        dy /= (double)this.div;
        dz /= (double)this.div;
        int i = 1;
        while (i < this.div) {
            this.points[i][0] = this.x + (double)i * dx;
            this.points[i][1] = this.y + (double)i * dy;
            this.points[i][2] = this.z + (double)i * dz;
            ++i;
        }
        this.transformDivisions();
        this.zmax = Double.NaN;
        this.zmin = Double.NaN;
        this.ymax = Double.NaN;
        this.ymin = Double.NaN;
        this.xmax = Double.NaN;
        this.xmin = Double.NaN;
        this.hasChanged = false;
    }

    protected void computeAbsoluteDifference(double[] result) {
        result[0] = this.originx * this.sizex;
        result[1] = this.originy * this.sizey;
        result[2] = this.originz * this.sizez;
    }

    protected void transformPoint(double[] result, boolean displace) {
        if (displace) {
            double[] disp = new double[3];
            this.computeAbsoluteDifference(disp);
            result[0] = result[0] - disp[0];
            result[1] = result[1] - disp[1];
            result[2] = result[2] - disp[2];
        }
        if (this.transformation != null) {
            result[0] = result[0] - this.x;
            result[1] = result[1] - this.y;
            result[2] = result[2] - this.z;
            this.transformation.direct(result);
            result[0] = result[0] + this.x;
            result[1] = result[1] + this.y;
            result[2] = result[2] + this.z;
        }
    }

    protected void transformDivisions() {
        if (this.originIsRelative) {
            this.computeAbsoluteDifference(this.coordinates);
        } else {
            this.coordinates[0] = this.originx;
            this.coordinates[1] = this.originy;
            this.coordinates[2] = this.originz;
        }
        int i = 0;
        while (i <= this.div) {
            double[] dArray = this.points[i];
            dArray[0] = dArray[0] - this.coordinates[0];
            double[] dArray2 = this.points[i];
            dArray2[1] = dArray2[1] - this.coordinates[1];
            double[] dArray3 = this.points[i];
            dArray3[2] = dArray3[2] - this.coordinates[2];
            if (this.transformation != null) {
                double[] dArray4 = this.points[i];
                dArray4[0] = dArray4[0] - this.x;
                double[] dArray5 = this.points[i];
                dArray5[1] = dArray5[1] - this.y;
                double[] dArray6 = this.points[i];
                dArray6[2] = dArray6[2] - this.z;
                this.transformation.direct(this.points[i]);
                double[] dArray7 = this.points[i];
                dArray7[0] = dArray7[0] + this.x;
                double[] dArray8 = this.points[i];
                dArray8[1] = dArray8[1] + this.y;
                double[] dArray9 = this.points[i];
                dArray9[2] = dArray9[2] + this.z;
            }
            ++i;
        }
    }

    private void computeHead() {
        if (this.arrowType == 1) {
            this.headPoints = 0;
            return;
        }
        double a = this.aCoord[this.div] - this.aCoord[0];
        double b = this.bCoord[this.div] - this.bCoord[0];
        double h = Math.sqrt(a * a + b * b);
        if (h == 0.0) {
            this.headPoints = 0;
            return;
        }
        a = 0.35 * a / h;
        b = 0.35 * b / h;
        if (h > 25.0) {
            a *= 25.0 / h;
            b *= 25.0 / h;
        }
        int p0 = (int)((double)this.aCoord[this.div] - a * h);
        int q0 = (int)((double)this.bCoord[this.div] - b * h);
        a *= h / 2.0;
        b *= h / 2.0;
        switch (this.arrowType) {
            default: {
                this.headPoints = 6;
                this.headA[0] = p0;
                this.headB[0] = q0;
                this.headA[1] = p0 - (int)b;
                this.headB[1] = q0 + (int)a;
                this.headA[2] = this.aCoord[this.div];
                this.headB[2] = this.bCoord[this.div];
                this.headA[3] = p0 + (int)b;
                this.headB[3] = q0 - (int)a;
                this.headA[4] = p0;
                this.headB[4] = q0;
                break;
            }
            case 2: {
                this.headPoints = 7;
                this.headA[0] = p0;
                this.headB[0] = q0;
                this.headA[1] = p0 - (int)b;
                this.headB[1] = q0 + (int)a;
                this.headA[2] = this.aCoord[this.div] - (int)b;
                this.headB[2] = this.bCoord[this.div] + (int)a;
                this.headA[3] = this.aCoord[this.div] + (int)b;
                this.headB[3] = this.bCoord[this.div] - (int)a;
                this.headA[4] = p0 + (int)b;
                this.headB[4] = q0 - (int)a;
                this.headA[5] = p0;
                this.headB[5] = q0;
            }
        }
    }

    private void drawHead(DrawingPanel _panel, Graphics2D _g2, int a1, int b1, Color _color, Paint _fill) {
        _g2.setStroke(this.style.edgeStroke);
        if (this.headPoints == 0) {
            _g2.setColor(_color);
            _g2.drawLine(a1, b1, this.aCoord[this.div], this.bCoord[this.div]);
        } else {
            int n = this.headPoints - 1;
            this.headA[n] = a1;
            this.headB[n] = b1;
            if (_fill != null) {
                _g2.setPaint(_fill);
                _g2.fillPolygon(this.headA, this.headB, n);
            }
            _g2.setColor(_color);
            _g2.drawPolyline(this.headA, this.headB, this.headPoints);
        }
    }
}

