/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.displayejs.AbstractInteractiveElement;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.InteractionTargetElementPosition;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Object3D;

public class InteractiveParticle
extends AbstractInteractiveElement {
    public static final int NONE = 0;
    public static final int ELLIPSE = 1;
    public static final int RECTANGLE = 2;
    public static final int ROUND_RECTANGLE = 3;
    public static final int WHEEL = 4;
    protected int shapeType = -1;
    protected boolean pixelSize = false;
    protected double a1 = 0.0;
    protected double b1 = 0.0;
    protected double[] coordinates = new double[6];
    protected double[] pixelOrigin = new double[5];
    protected Object3D[] objects = new Object3D[]{new Object3D(this, 0)};
    protected AffineTransform transform = new AffineTransform();

    public InteractiveParticle() {
        this(1);
    }

    public InteractiveParticle(int _type) {
        this.setShapeType(_type);
    }

    public void copyFrom(InteractiveElement _element) {
        super.copyFrom(_element);
        if (_element instanceof InteractiveParticle) {
            this.setShapeType(((InteractiveParticle)_element).shapeType);
            this.setPixelSize(((InteractiveParticle)_element).getPixelSize());
        }
    }

    public void setShapeType(int _type) {
        if (this.shapeType == _type) {
            return;
        }
        this.shapeType = _type;
        switch (this.shapeType) {
            default: {
                this.style.displayObject = null;
                break;
            }
            case 1: 
            case 4: {
                this.style.displayObject = new Ellipse2D.Float();
                break;
            }
            case 2: {
                this.style.displayObject = new Rectangle2D.Float();
                break;
            }
            case 3: {
                this.style.displayObject = new RoundRectangle2D.Float();
            }
        }
    }

    public void setPixelSize(boolean _s) {
        this.pixelSize = _s;
    }

    public boolean getPixelSize() {
        return this.pixelSize;
    }

    protected double[] getPixelOrigin() {
        return this.pixelOrigin;
    }

    public void setSensitivity(int _s) {
        this.actualSensitivity = _s;
    }

    public Interactive findInteractive(DrawingPanel _panel, int _xpix, int _ypix) {
        if (!this.visible) {
            return null;
        }
        if (this.hasChanged || _panel != this.panelWithValidProjection) {
            this.projectPoints(_panel);
        }
        if (this.positionEnabled) {
            if (this.actualSensitivity <= 0) {
                double xI = this.pixelOrigin[0] - (double)_xpix;
                double yI = this.pixelOrigin[1] - (double)_ypix;
                if (this.style.angle != 0.0) {
                    double aux = xI * this.style.cosAngle - yI * this.style.sinAngle;
                    yI = xI * this.style.sinAngle + yI * this.style.cosAngle;
                    xI = aux;
                }
                if (this.shapeType == 1 || this.shapeType == 4 ? xI * xI / (this.pixelOrigin[2] * this.pixelOrigin[2]) + yI * yI / (this.pixelOrigin[3] * this.pixelOrigin[3]) < 0.25 : Math.abs(xI) < this.pixelOrigin[2] / 2.0 && Math.abs(yI) < this.pixelOrigin[3] / 2.0) {
                    return new InteractionTargetElementPosition(this);
                }
            } else if (Math.abs(this.pixelOrigin[0] - (double)_xpix) < (double)this.actualSensitivity && Math.abs(this.pixelOrigin[1] - (double)_ypix) < (double)this.actualSensitivity) {
                return new InteractionTargetElementPosition(this);
            }
        }
        return null;
    }

    public Object3D[] getObjects3D(DrawingPanel3D _panel) {
        if (!this.visible) {
            return null;
        }
        if (this.hasChanged || _panel != this.panelWithValidProjection) {
            this.projectPoints(_panel);
        }
        return this.objects;
    }

    public void draw(DrawingPanel3D _panel, Graphics2D _g2, int _index) {
        Color theColor = _panel.projectColor(this.style.edgeColor, this.objects[0].distance);
        Paint theFillPattern = this.style.fillPattern;
        if (theFillPattern instanceof Color) {
            theFillPattern = _panel.projectColor((Color)theFillPattern, this.objects[0].distance);
        }
        this.drawIt(_g2, theColor, theFillPattern);
    }

    public void drawQuickly(DrawingPanel3D _panel, Graphics2D _g2) {
        if (!this.visible) {
            return;
        }
        if (this.hasChanged || _panel != this.panelWithValidProjection) {
            this.projectPoints(_panel);
        }
        this.drawIt(_g2, this.style.edgeColor, this.style.fillPattern);
    }

    public void draw(DrawingPanel _panel, Graphics _g) {
        if (!this.visible) {
            return;
        }
        this.projectPoints(_panel);
        this.drawIt((Graphics2D)_g, this.style.edgeColor, this.style.fillPattern);
    }

    protected void projectPoints(DrawingPanel _panel) {
        double dy;
        double dx;
        if (this.group != null) {
            this.coordinates[0] = this.group.x + this.x * this.group.sizex;
            this.coordinates[1] = this.group.y + this.y * this.group.sizey;
            this.coordinates[2] = this.group.z + this.z * this.group.sizez;
            this.coordinates[3] = this.sizex * this.group.sizex;
            this.coordinates[4] = this.sizey * this.group.sizey;
            this.coordinates[5] = this.sizez * this.group.sizez;
        } else {
            this.coordinates[0] = this.x;
            this.coordinates[1] = this.y;
            this.coordinates[2] = this.z;
            this.coordinates[3] = this.sizex;
            this.coordinates[4] = this.sizey;
            this.coordinates[5] = this.sizez;
        }
        _panel.project(this.coordinates, this.pixelOrigin);
        if (this.pixelSize) {
            this.pixelOrigin[2] = this.sizex;
            this.pixelOrigin[3] = this.sizey;
        }
        this.objects[0].distance = this.pixelOrigin[4];
        switch (this.style.position) {
            default: {
                dx = this.pixelOrigin[2] / 2.0;
                dy = this.pixelOrigin[3] / 2.0;
                break;
            }
            case 1: {
                dx = this.pixelOrigin[2] / 2.0;
                dy = 0.0;
                break;
            }
            case 2: {
                dx = this.pixelOrigin[2] / 2.0;
                dy = this.pixelOrigin[3];
                break;
            }
            case 3: {
                dx = this.pixelOrigin[2];
                dy = this.pixelOrigin[3] / 2.0;
                break;
            }
            case 7: {
                dx = this.pixelOrigin[2];
                dy = this.pixelOrigin[3];
                break;
            }
            case 5: {
                dx = this.pixelOrigin[2];
                dy = 0.0;
                break;
            }
            case 4: {
                dx = 0.0;
                dy = this.pixelOrigin[3] / 2.0;
                break;
            }
            case 8: {
                dx = 0.0;
                dy = this.pixelOrigin[3];
                break;
            }
            case 6: {
                dx = 0.0;
                dy = 0.0;
            }
        }
        this.a1 = this.pixelOrigin[0] - dx;
        this.b1 = this.pixelOrigin[1] - dy;
        this.hasChanged = false;
        this.panelWithValidProjection = _panel;
    }

    private void drawIt(Graphics2D _g2, Color _color, Paint _fill) {
        if (!(this.style.displayObject instanceof RectangularShape)) {
            _g2.setColor(_color);
            _g2.drawOval((int)this.pixelOrigin[0], (int)this.pixelOrigin[1], 1, 1);
            return;
        }
        RectangularShape shape = (RectangularShape)this.style.displayObject;
        AffineTransform originalTransform = _g2.getTransform();
        this.transform.setTransform(originalTransform);
        this.transform.rotate(-this.style.angle, this.pixelOrigin[0], this.pixelOrigin[1]);
        _g2.setTransform(this.transform);
        shape.setFrame(this.a1, this.b1, this.pixelOrigin[2], this.pixelOrigin[3]);
        if (_fill != null) {
            _g2.setPaint(_fill);
            _g2.fill(shape);
        }
        _g2.setColor(_color);
        _g2.setStroke(this.style.edgeStroke);
        if (this.shapeType == 4) {
            int c = (int)(this.b1 + this.pixelOrigin[3] / 2.0);
            _g2.drawLine((int)this.a1, c, (int)(this.a1 + this.pixelOrigin[2]), c);
            c = (int)(this.a1 + this.pixelOrigin[2] / 2.0);
            _g2.drawLine(c, (int)this.b1, c, (int)(this.b1 + this.pixelOrigin[3]));
        }
        _g2.draw(shape);
        _g2.setTransform(originalTransform);
    }

    public double getXMin() {
        if (!this.pixelSize) {
            return super.getXMin();
        }
        if (this.group == null) {
            return this.x;
        }
        return this.group.x + this.x;
    }

    public double getXMax() {
        if (!this.pixelSize) {
            return super.getXMax();
        }
        if (this.group == null) {
            return this.x;
        }
        return this.group.x + this.x;
    }

    public double getYMin() {
        if (!this.pixelSize) {
            return super.getYMin();
        }
        if (this.group == null) {
            return this.y;
        }
        return this.group.y + this.y;
    }

    public double getYMax() {
        if (!this.pixelSize) {
            return super.getYMax();
        }
        if (this.group == null) {
            return this.y;
        }
        return this.group.y + this.y;
    }

    public double getZMin() {
        if (!this.pixelSize) {
            return super.getZMin();
        }
        if (this.group == null) {
            return this.z;
        }
        return this.group.z + this.z;
    }

    public double getZMax() {
        if (!this.pixelSize) {
            return super.getZMax();
        }
        if (this.group == null) {
            return this.z;
        }
        return this.group.z + this.z;
    }
}

