/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import org.colos.ejs.library.Simulation;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.LogMeasurable;
import org.opensourcephysics.displayejs.AbstractInteractiveElement;
import org.opensourcephysics.displayejs.Drawable3D;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.InteractionTargetTracePoint;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.InteractivePoligon;
import org.opensourcephysics.displayejs.Object3D;
import org.opensourcephysics.displayejs.Point3D;
import org.opensourcephysics.displayejs.Style;
import org.opensourcephysics.displayejs.TraceSet;
import org.opensourcephysics.frames.TableFrame;
import org.opensourcephysics.tools.DataTool;

public class InteractiveTrace
extends AbstractInteractiveElement
implements Data,
LogMeasurable {
    public static final int SHOW_ALL = 0;
    public static final int ORDER_OF_APPEARANCE = 1;
    public static final int X_COORDINATE = 2;
    public static final int Y_COORDINATE = 3;
    public static final int Z_COORDINATE = 4;
    private static final int MAX_POINTS = 100000;
    protected boolean connected = true;
    protected boolean ignore = false;
    protected boolean active = true;
    protected int maxPoints = 100000;
    protected int skip = 0;
    protected int shapeSize;
    protected int drivenBy = 0;
    protected int memorySets = 1;
    private int shapeType = -1;
    protected Color memoryColor = null;
    protected String name = "trace";
    private int counter = 0;
    private int pointsAdded = 0;
    private int pointsNotProjected = 0;
    private double[] point = new double[3];
    protected ArrayList list;
    protected ArrayList displayList;
    private OnePoint nullPoint;
    private OnePoint lastPoint = this.nullPoint = new OnePoint(this, Double.NaN, Double.NaN, Double.NaN, false, this.style);
    private OnePoint flushPoint = this.nullPoint;
    private Object3D[] minimalObjects = new Object3D[1];
    private AffineTransform transform = new AffineTransform();
    private ArrayList memoryLists = new ArrayList();
    protected double xmaxLogscale;
    protected double ymaxLogscale;
    protected double xminLogscale;
    protected double yminLogscale;
    private boolean showZ = false;
    private boolean allowTable = false;

    public InteractiveTrace() {
        this.list = new ArrayList();
        this.setXYZ(0.0, 0.0, 0.0);
        this.setSizeXYZ(1.0, 1.0, 1.0);
    }

    public void setName(String _name) {
        this.name = _name;
    }

    public String getName() {
        return this.name;
    }

    public void copyFrom(InteractiveElement _element) {
        super.copyFrom(_element);
        if (_element instanceof InteractiveTrace) {
            this.setMaximumPoints(((InteractiveTrace)_element).getMaximumPoints());
            this.setConnected(((InteractiveTrace)_element).isConnected());
            this.setIgnoreEqualPoints(((InteractiveTrace)_element).isIgnoreEqualPoints());
            this.setActive(((InteractiveTrace)_element).isActive());
            this.setSkip(((InteractiveTrace)_element).getSkip());
            this.setMemorySets(((InteractiveTrace)_element).getMemorySets());
            this.setMemoryColor(((InteractiveTrace)_element).getMemoryColor());
            this.setName(((InteractiveTrace)_element).getName());
            this.setAllowTable(((InteractiveTrace)_element).allowTable);
        }
    }

    public void setMaximumPoints(int _n) {
        if (_n < 0 || _n == this.maxPoints) {
            return;
        }
        this.maxPoints = _n == 0 ? 100000 : _n;
        this.counter = 0;
        this.initialize();
    }

    public int getMaximumPoints() {
        return this.maxPoints;
    }

    public void setConnected(boolean connect) {
        this.connected = connect;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setIgnoreEqualPoints(boolean ignoreEqual) {
        this.ignore = ignoreEqual;
    }

    public boolean isIgnoreEqualPoints() {
        return this.ignore;
    }

    public void setActive(boolean acceptInput) {
        this.active = acceptInput;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setSkip(int howMany) {
        if (howMany == this.skip) {
            return;
        }
        this.skip = howMany;
        this.counter = 0;
    }

    public int getSkip() {
        return this.skip;
    }

    public void setMemorySets(int howMany) {
        if (howMany == this.memorySets || howMany < 0) {
            return;
        }
        this.memoryLists.clear();
        this.memorySets = howMany;
    }

    public int getMemorySets() {
        return this.memorySets;
    }

    public void setMemoryDrivenBy(int driving) {
        this.drivenBy = driving;
    }

    public int getMemoryDrivenBy() {
        return this.drivenBy;
    }

    public void setMemoryColor(Color _color) {
        this.memoryColor = _color;
    }

    public Color getMemoryColor() {
        return this.memoryColor;
    }

    public void setAllowTable(boolean _allow) {
        this.allowTable = _allow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.list.clear();
        }
        arrayList = this.memoryLists;
        synchronized (arrayList) {
            this.memoryLists.clear();
        }
        this.pointsNotProjected = 0;
        this.pointsAdded = 0;
        this.lastPoint = this.nullPoint;
        this.flushPoint = this.nullPoint;
        this.counter = 0;
        this.showZ = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (this.flushPoint == this.nullPoint) {
            return;
        }
        if (this.ignore && this.flushPoint.coordinates[0] == this.lastPoint.coordinates[0] && this.flushPoint.coordinates[1] == this.lastPoint.coordinates[1] && this.flushPoint.coordinates[2] == this.lastPoint.coordinates[2]) {
            return;
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            if (this.maxPoints > 0 && this.list.size() >= this.maxPoints) {
                this.list.remove(0);
                if (this.list.size() > 0) {
                    ((OnePoint)this.list.get((int)0)).connected = false;
                }
            }
            this.lastPoint = new OnePoint(this, this.flushPoint.coordinates[0], this.flushPoint.coordinates[1], this.flushPoint.coordinates[2], this.flushPoint.connected && this.pointsAdded != 0, this.style);
            this.list.add(this.lastPoint);
        }
        ++this.pointsAdded;
        ++this.pointsNotProjected;
    }

    public synchronized void initialize() {
        if (this.memorySets == 1) {
            return;
        }
        this.pointsNotProjected = 0;
        this.pointsAdded = 0;
        this.lastPoint = this.nullPoint;
        this.flushPoint = this.nullPoint;
        if (this.list.size() <= 0) {
            return;
        }
        switch (this.memorySets) {
            default: {
                if (this.memoryLists.size() < this.memorySets - 1) break;
                this.memoryLists.remove(0);
            }
            case 0: 
        }
        if (this.memoryColor != null) {
            Iterator it = this.list.iterator();
            while (it.hasNext()) {
                ((OnePoint)it.next()).style.setEdgeColor(this.memoryColor);
            }
        }
        this.memoryLists.add(this.list);
        this.list = new ArrayList();
    }

    public void addPoint(double xInput, double yInput) {
        this.addThePoint(xInput, yInput, 0.0);
    }

    public void addPoints(double[] xInput, double[] yInput) {
        int n = Math.min(xInput.length, yInput.length);
        int i = 0;
        while (i < n) {
            this.addThePoint(xInput[i], yInput[i], 0.0);
            ++i;
        }
    }

    public void addPoint(double xInput, double yInput, double zInput) {
        this.showZ = true;
        this.addThePoint(xInput, yInput, zInput);
    }

    public void addPoints(double[] xInput, double[] yInput, double[] zInput) {
        int n = Math.min(Math.min(xInput.length, yInput.length), zInput.length);
        int i = 0;
        while (i < n) {
            this.addThePoint(xInput[i], yInput[i], zInput[i]);
            ++i;
        }
    }

    public void moveToPoint(double xInput, double yInput) {
        boolean was_connected = this.connected;
        this.connected = false;
        this.addThePoint(xInput, yInput, 0.0);
        this.connected = was_connected;
    }

    public void moveToPoint(double xInput, double yInput, double zInput) {
        this.showZ = true;
        boolean was_connected = this.connected;
        this.connected = false;
        this.addThePoint(xInput, yInput, zInput);
        this.connected = was_connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addThePoint(double xInput, double yInput, double zInput) {
        if (!this.active) {
            return;
        }
        if (this.skip > 0) {
            if (this.counter > 0) {
                ++this.counter;
                if (this.counter >= this.skip) {
                    this.counter = 0;
                }
                this.flushPoint = new OnePoint(this, xInput, yInput, zInput, this.connected && this.pointsAdded != 0, this.style);
                return;
            }
            ++this.counter;
        }
        this.flushPoint = this.nullPoint;
        if (this.ignore && xInput == this.lastPoint.coordinates[0] && yInput == this.lastPoint.coordinates[1] && zInput == this.lastPoint.coordinates[2]) {
            return;
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            if (this.maxPoints > 0 && this.list.size() >= this.maxPoints) {
                this.list.remove(0);
                if (this.list.size() > 0) {
                    ((OnePoint)this.list.get((int)0)).connected = false;
                }
            }
            this.lastPoint = new OnePoint(this, xInput, yInput, zInput, this.connected && this.pointsAdded != 0, this.style);
            this.list.add(this.lastPoint);
        }
        ++this.pointsAdded;
        ++this.pointsNotProjected;
    }

    public void setShapeType(int _type) {
        if (this.shapeType == _type) {
            return;
        }
        this.shapeType = _type;
        switch (this.shapeType) {
            default: {
                this.style.displayObject = null;
                break;
            }
            case 1: {
                this.style.displayObject = new Ellipse2D.Float();
                break;
            }
            case 2: {
                this.style.displayObject = new Rectangle2D.Float();
                break;
            }
            case 3: {
                this.style.displayObject = new RoundRectangle2D.Float();
            }
        }
    }

    public void setShapeSize(int _size) {
        this.shapeSize = _size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[][] getData2D() {
        ArrayList arrayList = this.displayList;
        synchronized (arrayList) {
            double[][] data = new double[this.displayList.size()][];
            int i = 0;
            int n = this.displayList.size();
            while (i < n) {
                OnePoint point = (OnePoint)this.displayList.get(i);
                data[i] = (double[])point.coordinates.clone();
                ++i;
            }
            return data;
        }
    }

    public double[][][] getData3D() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getDatasets() {
        Dataset dataset = new Dataset();
        dataset.setName(this.getName());
        dataset.setConnected(true);
        dataset.setLineColor(this.getStyle().getEdgeColor());
        dataset.setMarkerShape(2);
        Color fillColor = new Color(125, 125, 125);
        if (this.getStyle().getFillPattern() instanceof Color) {
            fillColor = (Color)this.getStyle().getFillPattern();
        }
        dataset.setMarkerColor(fillColor, this.getStyle().getEdgeColor());
        ArrayList arrayList = this.displayList;
        synchronized (arrayList) {
            double[][] cfr_ignored_0 = new double[this.displayList.size()][];
            int i = 0;
            int n = this.displayList.size();
            while (i < n) {
                OnePoint point = (OnePoint)this.displayList.get(i);
                dataset.append(point.coordinates[0], point.coordinates[1]);
                ++i;
            }
        }
        ArrayList<Dataset> list = new ArrayList<Dataset>();
        list.add(dataset);
        return list;
    }

    public ArrayList getComplexDatasets() {
        return null;
    }

    public void showPopup(final Component component, int x, int y) {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new AbstractAction(Simulation.getEjsString("InteractiveTrace.ShowDataTable")){

            public void actionPerformed(ActionEvent e) {
                InteractiveTrace.this.showTable(component);
            }
        });
        popupMenu.add(new AbstractAction(Simulation.getEjsString("InteractiveTrace.ShowDatasetTool")){

            public void actionPerformed(ActionEvent e) {
                InteractiveTrace.this.showDataTool();
            }
        });
        popupMenu.add(new AbstractAction(Simulation.getEjsString("InteractiveTrace.ShowDatasetManager")){

            public void actionPerformed(ActionEvent e) {
                InteractiveTrace.showDatasetManagerTool(component);
            }
        });
        popupMenu.show(component, x, y);
    }

    public static Dataset createDataset(InteractiveTrace _trace) {
        Dataset dataset = new Dataset();
        dataset.setName(_trace.getName());
        dataset.setConnected(true);
        dataset.setLineColor(_trace.getStyle().getEdgeColor());
        dataset.setMarkerShape(2);
        dataset.setMarkerColor(new Color(255, 128, 128, 128), _trace.getStyle().getEdgeColor());
        for (OnePoint point : _trace.displayList) {
            dataset.append(point.coordinates[0], point.coordinates[1]);
        }
        return dataset;
    }

    public DataTool showDataTool() {
        DataTool tool = new DataTool(InteractiveTrace.createDataset(this), this.name);
        tool.setVisible(true);
        return tool;
    }

    public static DataTool showDatasetManagerTool(Component component) {
        if (!(component instanceof DrawingPanel)) {
            return null;
        }
        DataTool tool = new DataTool();
        DrawingPanel panel = (DrawingPanel)component;
        ArrayList list = panel.getDrawables(InteractiveTrace.class);
        for (InteractiveTrace trace : list) {
            tool.addTab(InteractiveTrace.createDataset(trace), trace.name);
        }
        list = panel.getDrawables(TraceSet.class);
        for (TraceSet set : list) {
            int i = 0;
            int n = set.getNumberOfElements();
            while (i < n) {
                InteractiveTrace trace = set.traceAt(i);
                tool.addTab(InteractiveTrace.createDataset(trace), trace.name);
                ++i;
            }
        }
        list = panel.getDrawables(InteractivePoligon.class);
        for (InteractivePoligon polygon : list) {
            tool.addTab(InteractivePoligon.createDataset(polygon), polygon.name);
        }
        tool.setVisible(true);
        return tool;
    }

    public TableFrame showTable(Component component) {
        TableFrame frame = new TableFrame("Trace Data");
        frame.setRowNumberVisible(false);
        frame.setColumnNames(0, "x");
        frame.setColumnNames(1, "y");
        if (this.showZ) {
            frame.setColumnNames(2, "z");
        }
        for (OnePoint point : this.list) {
            if (this.showZ) {
                frame.appendRow(point.coordinates);
                continue;
            }
            frame.appendRow(new double[]{point.coordinates[0], point.coordinates[1]});
        }
        frame.setDefaultCloseOperation(2);
        frame.setLocationRelativeTo(component);
        frame.setVisible(true);
        return frame;
    }

    public Interactive findInteractive(DrawingPanel _panel, int _xpix, int _ypix) {
        if (!this.visible) {
            return null;
        }
        if (_panel instanceof DrawingPanel3D) {
            if (this.hasChanged || _panel != this.panelWithValidProjection) {
                this.projectPoints(_panel, true);
            } else if (this.pointsNotProjected > 0) {
                this.projectPoints(_panel, false);
            }
        } else {
            this.projectPoints(_panel, true);
        }
        if (this.positionEnabled && Math.abs(this.lastPoint.pixel[0] - (double)_xpix) < (double)SENSIBILITY && Math.abs(this.lastPoint.pixel[1] - (double)_ypix) < (double)SENSIBILITY) {
            return new InteractionTargetTracePoint(this, new Point3D(this.lastPoint.coordinates[0], this.lastPoint.coordinates[1], this.lastPoint.coordinates[2]));
        }
        if (this.allowTable) {
            for (OnePoint point : this.displayList) {
                if (!(Math.abs(point.pixel[0] - (double)_xpix) < (double)SENSIBILITY) || !(Math.abs(point.pixel[1] - (double)_ypix) < (double)SENSIBILITY)) continue;
                return this;
            }
        }
        return null;
    }

    public Object3D[] getObjects3D(DrawingPanel3D _panel) {
        if (this.list.size() <= 0 || !this.visible) {
            return null;
        }
        if (this.hasChanged || _panel != this.panelWithValidProjection) {
            this.projectPoints(_panel, true);
        } else if (this.pointsNotProjected > 0) {
            this.projectPoints(_panel, false);
        }
        return this.displayList.toArray(this.minimalObjects);
    }

    public void draw(DrawingPanel3D _panel, Graphics2D _g, int _index) {
        try {
            Graphics2D g2 = _g;
            OnePoint point = (OnePoint)this.displayList.get(_index);
            Color theColor = _panel.projectColor(point.style.edgeColor, point.distance);
            if (point.connected) {
                g2.setColor(theColor);
                g2.setStroke(point.style.edgeStroke);
                OnePoint pointPrev = (OnePoint)this.displayList.get(_index - 1);
                g2.drawLine((int)point.pixel[0], (int)point.pixel[1], (int)pointPrev.pixel[0], (int)pointPrev.pixel[1]);
            }
            if (point.style.displayObject != null) {
                Paint theFillPattern = point.style.fillPattern;
                if (theFillPattern instanceof Color) {
                    theFillPattern = _panel.projectColor((Color)theFillPattern, point.distance);
                }
                this.drawMarker(g2, point, theColor, theFillPattern);
            }
        }
        catch (Exception exception) {}
    }

    public void draw(DrawingPanel _panel, Graphics _g) {
        if (this.list.size() <= 0 || !this.visible) {
            return;
        }
        this.projectPoints(_panel, true);
        int aprev = 0;
        int bprev = 0;
        Graphics2D g2 = (Graphics2D)_g;
        for (OnePoint point : this.displayList) {
            if (point.style.edgeColor != null) {
                g2.setColor(point.style.edgeColor);
                g2.setStroke(point.style.edgeStroke);
                if (point.connected) {
                    g2.drawLine((int)point.pixel[0], (int)point.pixel[1], aprev, bprev);
                }
                if (point.style.displayObject != null) {
                    this.drawMarker(g2, point, point.style.edgeColor, point.style.fillPattern);
                }
            }
            aprev = (int)point.pixel[0];
            bprev = (int)point.pixel[1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void projectPoints(DrawingPanel _panel, boolean forceProjection) {
        Iterator it;
        this.displayList = new ArrayList();
        if (this.memorySets != 1) {
            switch (this.drivenBy) {
                default: {
                    it = this.memoryLists.iterator();
                    while (it.hasNext()) {
                        this.displayList.addAll((ArrayList)it.next());
                    }
                    break;
                }
                case 1: {
                    int n;
                    int i;
                    for (ArrayList memory : this.memoryLists) {
                        i = 0;
                        n = Math.min(this.pointsAdded, memory.size());
                        while (i < n) {
                            this.displayList.add(memory.get(i));
                            ++i;
                        }
                    }
                    break;
                }
                case 2: {
                    OnePoint aPoint;
                    int n;
                    int i;
                    block12: for (ArrayList memory : this.memoryLists) {
                        i = 0;
                        n = memory.size();
                        while (i < n) {
                            aPoint = (OnePoint)memory.get(i);
                            if (!(aPoint.coordinates[0] <= this.lastPoint.coordinates[0])) continue block12;
                            this.displayList.add(aPoint);
                            ++i;
                        }
                    }
                    break;
                }
                case 3: {
                    OnePoint aPoint;
                    int n;
                    int i;
                    block14: for (ArrayList memory : this.memoryLists) {
                        i = 0;
                        n = memory.size();
                        while (i < n) {
                            aPoint = (OnePoint)memory.get(i);
                            if (!(aPoint.coordinates[1] <= this.lastPoint.coordinates[1])) continue block14;
                            this.displayList.add(aPoint);
                            ++i;
                        }
                    }
                    break;
                }
                case 4: {
                    OnePoint aPoint;
                    int n;
                    int i;
                    block16: for (ArrayList memory : this.memoryLists) {
                        i = 0;
                        n = memory.size();
                        while (i < n) {
                            aPoint = (OnePoint)memory.get(i);
                            if (!(aPoint.coordinates[2] <= this.lastPoint.coordinates[2])) continue block16;
                            this.displayList.add(aPoint);
                            ++i;
                        }
                    }
                }
            }
        }
        it = this.list;
        synchronized (it) {
            this.displayList.addAll((ArrayList)this.list.clone());
        }
        int i = 0;
        int n = this.displayList.size();
        while (i < n) {
            ((OnePoint)this.displayList.get(i)).project(_panel, i, forceProjection);
            ++i;
        }
        this.hasChanged = false;
        this.panelWithValidProjection = _panel;
        this.pointsNotProjected = 0;
    }

    private void drawMarker(Graphics2D _g2, OnePoint _point, Color _color, Paint _fill) {
        if (!(_point.style.displayObject instanceof RectangularShape)) {
            _g2.setColor(_color);
            _g2.drawOval((int)_point.pixel[0], (int)_point.pixel[1], 1, 1);
            return;
        }
        RectangularShape shape = (RectangularShape)_point.style.displayObject;
        AffineTransform originalTransform = _g2.getTransform();
        this.transform.setTransform(originalTransform);
        this.transform.rotate(-_point.style.angle, _point.pixel[0], _point.pixel[1]);
        _g2.setTransform(this.transform);
        shape.setFrame(_point.a1, _point.b1, this.shapeSize, this.shapeSize);
        if (_fill != null) {
            _g2.setPaint(_fill);
            _g2.fill(shape);
        }
        _g2.setColor(_color);
        _g2.setStroke(_point.style.edgeStroke);
        _g2.draw(shape);
        _g2.setTransform(originalTransform);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getXMinLogscale() {
        double min = Double.MAX_VALUE;
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Iterator it = this.list.iterator();
            while (it.hasNext()) {
                double xp = ((OnePoint)it.next()).coordinates[0];
                if (!(xp > 0.0)) continue;
                min = Math.min(min, xp);
            }
        }
        if (this.memorySets != 1) {
            for (ArrayList memory : this.memoryLists) {
                Iterator it2 = memory.iterator();
                while (it2.hasNext()) {
                    double xp = ((OnePoint)it2.next()).coordinates[0];
                    if (!(xp > 0.0)) continue;
                    min = Math.min(min, xp);
                }
            }
        }
        if (this.group == null) {
            return this.x + min * this.sizex;
        }
        return this.group.x + (this.x + min * this.sizex) * this.group.sizex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getXMaxLogscale() {
        double max = -1.7976931348623157E308;
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Iterator it = this.list.iterator();
            while (it.hasNext()) {
                double xp = ((OnePoint)it.next()).coordinates[0];
                if (!(xp > 0.0)) continue;
                max = Math.max(max, xp);
            }
        }
        if (this.memorySets != 1) {
            for (ArrayList memory : this.memoryLists) {
                Iterator it2 = memory.iterator();
                while (it2.hasNext()) {
                    double xp = ((OnePoint)it2.next()).coordinates[0];
                    if (!(xp > 0.0)) continue;
                    max = Math.max(max, xp);
                }
            }
        }
        if (this.group == null) {
            return this.x + max * this.sizex;
        }
        return this.group.x + (this.x + max * this.sizex) * this.group.sizex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getYMinLogscale() {
        double min = Double.MAX_VALUE;
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Iterator it = this.list.iterator();
            while (it.hasNext()) {
                double yp = ((OnePoint)it.next()).coordinates[1];
                if (!(yp > 0.0)) continue;
                min = Math.min(min, yp);
            }
        }
        if (this.memorySets != 1) {
            for (ArrayList memory : this.memoryLists) {
                Iterator it2 = memory.iterator();
                while (it2.hasNext()) {
                    double yp = ((OnePoint)it2.next()).coordinates[1];
                    if (!(yp > 0.0)) continue;
                    min = Math.min(min, yp);
                }
            }
        }
        if (this.group == null) {
            return this.y + min * this.sizey;
        }
        return this.group.y + (this.y + min * this.sizey) * this.group.sizey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getYMaxLogscale() {
        double max = -1.7976931348623157E308;
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Iterator it = this.list.iterator();
            while (it.hasNext()) {
                double yp = ((OnePoint)it.next()).coordinates[1];
                if (!(yp > 0.0)) continue;
                max = Math.max(max, yp);
            }
        }
        if (this.memorySets != 1) {
            for (ArrayList memory : this.memoryLists) {
                Iterator it2 = memory.iterator();
                while (it2.hasNext()) {
                    double yp = ((OnePoint)it2.next()).coordinates[1];
                    if (!(yp > 0.0)) continue;
                    max = Math.max(max, yp);
                }
            }
        }
        if (this.group == null) {
            return this.y + max * this.sizey;
        }
        return this.group.y + (this.y + max * this.sizey) * this.group.sizey;
    }

    public boolean isMeasured() {
        return this.canBeMeasured && this.list.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getXMin() {
        double min = Double.MAX_VALUE;
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Iterator it = this.list.iterator();
            while (it.hasNext()) {
                min = Math.min(min, ((OnePoint)it.next()).coordinates[0]);
            }
        }
        if (this.memorySets != 1) {
            for (ArrayList memory : this.memoryLists) {
                Iterator it2 = memory.iterator();
                while (it2.hasNext()) {
                    min = Math.min(min, ((OnePoint)it2.next()).coordinates[0]);
                }
            }
        }
        if (this.group == null) {
            return this.x + min * this.sizex;
        }
        return this.group.x + (this.x + min * this.sizex) * this.group.sizex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getXMax() {
        double max = -1.7976931348623157E308;
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Iterator it = this.list.iterator();
            while (it.hasNext()) {
                max = Math.max(max, ((OnePoint)it.next()).coordinates[0]);
            }
        }
        if (this.memorySets != 1) {
            for (ArrayList memory : this.memoryLists) {
                Iterator it2 = memory.iterator();
                while (it2.hasNext()) {
                    max = Math.max(max, ((OnePoint)it2.next()).coordinates[0]);
                }
            }
        }
        if (this.group == null) {
            return this.x + max * this.sizex;
        }
        return this.group.x + (this.x + max * this.sizex) * this.group.sizex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getYMin() {
        double min = Double.MAX_VALUE;
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Iterator it = this.list.iterator();
            while (it.hasNext()) {
                min = Math.min(min, ((OnePoint)it.next()).coordinates[1]);
            }
        }
        if (this.memorySets != 1) {
            for (ArrayList memory : this.memoryLists) {
                Iterator it2 = memory.iterator();
                while (it2.hasNext()) {
                    min = Math.min(min, ((OnePoint)it2.next()).coordinates[1]);
                }
            }
        }
        if (this.group == null) {
            return this.y + min * this.sizey;
        }
        return this.group.y + (this.y + min * this.sizey) * this.group.sizey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getYMax() {
        double max = -1.7976931348623157E308;
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Iterator it = this.list.iterator();
            while (it.hasNext()) {
                max = Math.max(max, ((OnePoint)it.next()).coordinates[1]);
            }
        }
        if (this.memorySets != 1) {
            for (ArrayList memory : this.memoryLists) {
                Iterator it2 = memory.iterator();
                while (it2.hasNext()) {
                    max = Math.max(max, ((OnePoint)it2.next()).coordinates[1]);
                }
            }
        }
        if (this.group == null) {
            return this.y + max * this.sizey;
        }
        return this.group.y + (this.y + max * this.sizey) * this.group.sizey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getZMin() {
        double min = Double.MAX_VALUE;
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Iterator it = this.list.iterator();
            while (it.hasNext()) {
                min = Math.min(min, ((OnePoint)it.next()).coordinates[2]);
            }
        }
        if (this.memorySets != 1) {
            for (ArrayList memory : this.memoryLists) {
                Iterator it2 = memory.iterator();
                while (it2.hasNext()) {
                    min = Math.min(min, ((OnePoint)it2.next()).coordinates[2]);
                }
            }
        }
        if (this.group == null) {
            return this.z + min * this.sizez;
        }
        return this.group.z + (this.z + min * this.sizez) * this.group.sizez;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getZMax() {
        double max = -1.7976931348623157E308;
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Iterator it = this.list.iterator();
            while (it.hasNext()) {
                max = Math.max(max, ((OnePoint)it.next()).coordinates[2]);
            }
        }
        if (this.memorySets != 1) {
            for (ArrayList memory : this.memoryLists) {
                Iterator it2 = memory.iterator();
                while (it2.hasNext()) {
                    max = Math.max(max, ((OnePoint)it2.next()).coordinates[2]);
                }
            }
        }
        if (this.group == null) {
            return this.z + max * this.sizez;
        }
        return this.group.z + (this.z + max * this.sizez) * this.group.sizez;
    }

    private class OnePoint
    extends Object3D {
        boolean connected;
        boolean alreadyProjected;
        double[] coordinates;
        double[] pixel;
        int a1;
        int b1;
        Style style;

        OnePoint(Drawable3D _drawable, double _x, double _y, double _z, boolean _c, Style _style) {
            super(_drawable, -1);
            this.coordinates = new double[3];
            this.pixel = new double[3];
            this.style = null;
            this.coordinates[0] = _x;
            this.coordinates[1] = _y;
            this.coordinates[2] = _z;
            this.connected = _c;
            if (_style != null) {
                this.style = new Style(_style);
            }
            this.alreadyProjected = false;
        }

        protected void project(DrawingPanel _panel, int _index, boolean forceProjection) {
            this.index = _index;
            if (!forceProjection && this.alreadyProjected) {
                return;
            }
            if (InteractiveTrace.this.group == null) {
                ((InteractiveTrace)InteractiveTrace.this).point[0] = InteractiveTrace.this.x + this.coordinates[0] * InteractiveTrace.this.sizex;
                ((InteractiveTrace)InteractiveTrace.this).point[1] = InteractiveTrace.this.y + this.coordinates[1] * InteractiveTrace.this.sizey;
                ((InteractiveTrace)InteractiveTrace.this).point[2] = InteractiveTrace.this.z + this.coordinates[2] * InteractiveTrace.this.sizez;
            } else {
                ((InteractiveTrace)InteractiveTrace.this).point[0] = InteractiveTrace.this.group.x + (InteractiveTrace.this.x + this.coordinates[0] * InteractiveTrace.this.sizex) * InteractiveTrace.this.group.sizex;
                ((InteractiveTrace)InteractiveTrace.this).point[1] = InteractiveTrace.this.group.y + (InteractiveTrace.this.y + this.coordinates[1] * InteractiveTrace.this.sizey) * InteractiveTrace.this.group.sizey;
                ((InteractiveTrace)InteractiveTrace.this).point[2] = InteractiveTrace.this.group.z + (InteractiveTrace.this.z + this.coordinates[2] * InteractiveTrace.this.sizez) * InteractiveTrace.this.group.sizez;
            }
            _panel.project(InteractiveTrace.this.point, this.pixel);
            this.alreadyProjected = true;
            this.distance = this.pixel[2];
            if (this.style.displayObject instanceof RectangularShape) {
                double dy;
                double dx;
                RectangularShape shape = (RectangularShape)this.style.displayObject;
                switch (this.style.position) {
                    default: {
                        dx = shape.getWidth() / 2.0;
                        dy = shape.getHeight() / 2.0;
                        break;
                    }
                    case 1: {
                        dx = shape.getWidth() / 2.0;
                        dy = 0.0;
                        break;
                    }
                    case 2: {
                        dx = shape.getWidth() / 2.0;
                        dy = shape.getHeight();
                        break;
                    }
                    case 3: {
                        dx = shape.getWidth();
                        dy = shape.getHeight() / 2.0;
                        break;
                    }
                    case 7: {
                        dx = shape.getWidth();
                        dy = shape.getHeight();
                        break;
                    }
                    case 5: {
                        dx = shape.getWidth();
                        dy = 0.0;
                        break;
                    }
                    case 4: {
                        dx = 0.0;
                        dy = shape.getHeight() / 2.0;
                        break;
                    }
                    case 8: {
                        dx = 0.0;
                        dy = shape.getHeight();
                        break;
                    }
                    case 6: {
                        dx = 0.0;
                        dy = 0.0;
                    }
                }
                this.a1 = (int)(this.pixel[0] - dx);
                this.b1 = (int)(this.pixel[1] - dy);
            }
        }
    }
}

