/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.util.ArrayList;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.displayejs.ElementSet;
import org.opensourcephysics.displayejs.InteractiveTrace;

public class TraceSet
extends ElementSet
implements Data {
    public TraceSet(int _n) {
        super(_n, InteractiveTrace.class);
    }

    public InteractiveTrace traceAt(int i) {
        return (InteractiveTrace)this.elements[i];
    }

    public void clear() {
        int i = 0;
        while (i < this.numElements) {
            ((InteractiveTrace)this.elements[i]).clear();
            ++i;
        }
    }

    public void setName(String _name) {
        super.setName(_name);
        int i = 0;
        while (i < this.numElements) {
            ((InteractiveTrace)this.elements[i]).setName(String.valueOf(_name) + "_" + i);
            ++i;
        }
    }

    public void addPoints(double[] _x, double[] _y, double[] _z) {
        int n = this.numElements;
        if (n > _x.length) {
            n = _x.length;
        }
        if (n > _y.length) {
            n = _y.length;
        }
        if (_z == null) {
            int i = 0;
            while (i < n) {
                ((InteractiveTrace)this.elements[i]).addPoint(_x[i], _y[i], 0.0);
                ++i;
            }
        } else {
            if (n > _z.length) {
                n = _z.length;
            }
            int i = 0;
            while (i < n) {
                ((InteractiveTrace)this.elements[i]).addPoint(_x[i], _y[i], _z[i]);
                ++i;
            }
        }
    }

    public double[][] getData2D() {
        return null;
    }

    public double[][][] getData3D() {
        return null;
    }

    public ArrayList getDatasets() {
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < this.numElements) {
            list.addAll(((InteractiveTrace)this.elements[i]).getDatasets());
            ++i;
        }
        return list;
    }

    public ArrayList getComplexDatasets() {
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < this.numElements) {
            list.addAll(((InteractiveTrace)this.elements[i]).getComplexDatasets());
            ++i;
        }
        return list;
    }
}

