/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing.basic;

import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.drawing.basic.Group;
import org.opensourcephysics.drawing.basic.InteractionTarget;
import org.opensourcephysics.drawing.basic.Style;
import org.opensourcephysics.drawing.core.DrawingPanel;
import org.opensourcephysics.drawing.core.interaction.InteractionEvent;
import org.opensourcephysics.drawing.core.interaction.InteractionListener;
import org.opensourcephysics.numerics.Matrix2DTransformation;

public abstract class Element
implements org.opensourcephysics.drawing.core.Element,
Interactive {
    protected static final double[] STD_ORIGIN = new double[]{0.0, 0.0};
    protected static final double[] STD_END = new double[]{1.0, 1.0};
    private boolean visible = true;
    private double x = 0.0;
    private double y = 0.0;
    private double sizeX = 1.0;
    private double sizeY = 1.0;
    private String name = "unnamed";
    private Style style = new Style(this);
    private Group group = null;
    private Object dataObject = null;
    private AffineTransform transformation = new AffineTransform();
    private boolean elementChanged = true;
    private boolean needsToProject = true;
    private DrawingPanel panel;
    private double[] minima = new double[2];
    private double[] maxima = new double[2];
    private AffineTransform totalTransformation = new AffineTransform();
    private List<InteractionListener> listeners = new ArrayList<InteractionListener>();
    protected final InteractionTarget targetPosition = new InteractionTarget(this, 0);
    protected final InteractionTarget targetSize = new InteractionTarget(this, 1);

    public final void setDataObject(Object _object) {
        this.dataObject = _object;
    }

    public final Object getDataObject() {
        return this.dataObject;
    }

    public final void setPanel(DrawingPanel _panel) {
        this.panel = _panel;
        this.needsToProject = true;
    }

    public final DrawingPanel getPanel() {
        Element el = this;
        while (el.group != null) {
            el = el.group;
        }
        return el.panel;
    }

    protected final void setGroup(Group _group) {
        this.group = _group;
        this.elementChanged = true;
    }

    protected final Group getGroup() {
        return this.group;
    }

    public final void setName(String _aName) {
        this.name = _aName;
    }

    public final String getName() {
        return this.name;
    }

    public final void setX(double _x) {
        this.x = _x;
        this.elementChanged = true;
    }

    public final double getX() {
        return this.x;
    }

    public final void setY(double _y) {
        this.y = _y;
        this.elementChanged = true;
    }

    public final double getY() {
        return this.y;
    }

    public final void setZ(double z) {
    }

    public final double getZ() {
        return 0.0;
    }

    public final void setXY(double _x, double _y) {
        this.x = _x;
        this.y = _y;
        this.elementChanged = true;
    }

    public final void setPosition(double[] _pos) {
        this.x = _pos[0];
        this.y = _pos[1];
        this.elementChanged = true;
    }

    public final double[] getPosition() {
        return new double[]{this.x, this.y};
    }

    public void setSizeX(double _sizeX) {
        this.sizeX = _sizeX;
        this.elementChanged = true;
    }

    public final double getSizeX() {
        return this.sizeX;
    }

    public void setSizeY(double _sizeY) {
        this.sizeY = _sizeY;
        this.elementChanged = true;
    }

    public final double getSizeY() {
        return this.sizeY;
    }

    public final void setSizeZ(double sizeZ) {
    }

    public final double getSizeZ() {
        return 0.0;
    }

    public void setSizeXY(double _sizeX, double _sizeY) {
        this.sizeX = _sizeX;
        this.sizeY = _sizeY;
        this.elementChanged = true;
    }

    public void setSize(double[] _size) {
        this.sizeX = _size[0];
        this.sizeY = _size[1];
        this.elementChanged = true;
    }

    public final double[] getSize() {
        return new double[]{this.sizeX, this.sizeY};
    }

    protected void getExtrema(double[] min, double[] max) {
        min[1] = 0.0;
        min[0] = 0.0;
        max[1] = 1.0;
        max[0] = 1.0;
        this.getTotalTransform().transform(min, 0, min, 0, 1);
        this.getTotalTransform().transform(max, 0, max, 0, 1);
    }

    protected final double getDiagonalSize() {
        return Math.sqrt(this.sizeX * this.sizeX + this.sizeY * this.sizeY);
    }

    public final double getXMin() {
        this.updateExtrema();
        return this.minima[0];
    }

    public final double getXMax() {
        this.updateExtrema();
        return this.maxima[0];
    }

    public final double getYMin() {
        this.updateExtrema();
        return this.minima[1];
    }

    public final double getYMax() {
        this.updateExtrema();
        return this.maxima[1];
    }

    protected final void updateExtrema() {
        if (this.hasChanged()) {
            this.getExtrema(this.minima, this.maxima);
        }
    }

    public boolean isMeasured() {
        return true;
    }

    public final void setVisible(boolean _visible) {
        this.visible = _visible;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    protected final boolean isReallyVisible() {
        Group el = this.group;
        while (el != null) {
            if (!el.visible) {
                return false;
            }
            el = el.group;
        }
        return this.visible;
    }

    public final org.opensourcephysics.drawing.core.Style getStyle() {
        return this.style;
    }

    final Style getRealStyle() {
        return this.style;
    }

    protected void styleChanged(int styleThatChanged) {
    }

    public boolean hasChanged() {
        Element el = this;
        while (el != null) {
            if (el.elementChanged) {
                return true;
            }
            el = el.group;
        }
        return false;
    }

    public final void setElementChanged() {
        this.elementChanged = true;
    }

    public final void setTransformation(Object _transform) throws ClassCastException {
        if (_transform == null) {
            this.transformation.setToIdentity();
        } else if (_transform instanceof Matrix2DTransformation) {
            this.transformation.setTransform(((Matrix2DTransformation)_transform).getTotalTransform());
        } else {
            this.transformation.setTransform((AffineTransform)_transform);
        }
        this.elementChanged = true;
    }

    public final Object getTransformation() {
        return new AffineTransform(this.transformation);
    }

    protected final AffineTransform getTheTransformation() {
        return this.transformation;
    }

    protected final AffineTransform getTotalTransform() {
        if (this.elementChanged) {
            this.totalTransformation = AffineTransform.getTranslateInstance(this.x, this.y);
            this.totalTransformation.concatenate(this.transformation);
            this.totalTransformation.scale(this.sizeX, this.sizeY);
            this.elementChanged = false;
            this.setNeedToProject(true);
        }
        if (this.group == null) {
            return this.totalTransformation;
        }
        AffineTransform tr = new AffineTransform(this.group.getTotalTransform());
        tr.concatenate(this.totalTransformation);
        return tr;
    }

    protected final AffineTransform getPixelTransform(org.opensourcephysics.display.DrawingPanel _panel) {
        AffineTransform transform = new AffineTransform(_panel.getPixelTransform());
        transform.concatenate(this.getTotalTransform());
        return transform;
    }

    public final double[] toSpaceFrame(double[] vector) {
        this.transformation.transform(vector, 0, vector, 0, 1);
        vector[0] = vector[0] + this.x;
        vector[1] = vector[1] + this.y;
        Group el = this.group;
        while (el != null) {
            vector[0] = vector[0] * el.sizeX;
            vector[1] = vector[1] * el.sizeY;
            el.transformation.transform(vector, 0, vector, 0, 1);
            vector[0] = vector[0] + el.x;
            vector[1] = vector[1] + el.y;
            el = el.group;
        }
        return vector;
    }

    public final double[] toBodyFrame(double[] vector) throws NoninvertibleTransformException {
        ArrayList<Element> elList = new ArrayList<Element>();
        Element el = this;
        do {
            elList.add(el);
        } while ((el = el.group) != null);
        int k = elList.size() - 1;
        while (k >= 0) {
            el = (Element)elList.get(k);
            vector[0] = vector[0] - el.x;
            vector[1] = vector[1] - el.y;
            el.transformation.inverseTransform(vector, 0, vector, 0, 1);
            if (el != this) {
                if (el.sizeX != 0.0) {
                    vector[0] = vector[0] / el.sizeX;
                }
                if (el.sizeY != 0.0) {
                    vector[1] = vector[1] / el.sizeY;
                }
            }
            --k;
        }
        return vector;
    }

    public abstract void draw(org.opensourcephysics.display.DrawingPanel var1, Graphics var2);

    public void setNeedToProject(boolean _need) {
        this.needsToProject = _need;
    }

    protected final boolean needsToProject() {
        return this.needsToProject;
    }

    public void setEnabled(boolean _enabled) {
        this.targetPosition.setEnabled(_enabled);
        this.targetSize.setEnabled(_enabled);
    }

    public boolean isEnabled() {
        return this.targetPosition.isEnabled() || this.targetSize.isEnabled();
    }

    public final org.opensourcephysics.drawing.core.interaction.InteractionTarget getInteractionTarget(int target) {
        switch (target) {
            case 0: {
                return this.targetPosition;
            }
            case 1: {
                return this.targetSize;
            }
        }
        return null;
    }

    public final void addInteractionListener(InteractionListener listener) {
        if (listener == null || this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public final void removeInteractionListener(InteractionListener listener) {
        this.listeners.remove(listener);
    }

    public final void invokeActions(InteractionEvent event) {
        Iterator<InteractionListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().interactionPerformed(event);
        }
    }

    public abstract Interactive findInteractive(org.opensourcephysics.display.DrawingPanel var1, int var2, int var3);

    private final double[] getHotSpotBodyCoordinates(InteractionTarget target) {
        if (target == this.targetPosition) {
            return new double[]{0.0, 0.0};
        }
        if (target == this.targetSize) {
            return new double[]{this.sizeX != 0.0 ? 1 : 0, this.sizeY != 0.0 ? 1 : 0};
        }
        return null;
    }

    private final double[] getHotSpot(InteractionTarget target) {
        double[] coordinates = this.getHotSpotBodyCoordinates(target);
        if (coordinates != null) {
            this.getTotalTransform().transform(coordinates, 0, coordinates, 0, 1);
        }
        return coordinates;
    }

    public void updateHotSpot(InteractionTarget target, double[] point) {
        Group gr = this.group;
        switch (target.getType()) {
            case 0: {
                if (gr != null && target.getAffectsGroup()) {
                    double[] origin = this.getHotSpot(target);
                    gr.setXY(gr.x + point[0] - origin[0], gr.y + point[1] - origin[1]);
                    break;
                }
                double[] coordinates = (double[])point.clone();
                this.groupInverseTransformations(coordinates);
                double[] origin = this.getHotSpotBodyCoordinates(target);
                origin[0] = origin[0] * this.sizeX;
                origin[1] = origin[1] * this.sizeY;
                this.transformation.transform(origin, 0, origin, 0, 1);
                this.setXY(coordinates[0] - origin[0], coordinates[1] - origin[1]);
                break;
            }
            case 1: {
                if (gr != null && target.getAffectsGroup()) {
                    double[] coordinates = (double[])point.clone();
                    coordinates[0] = coordinates[0] - gr.x;
                    coordinates[1] = coordinates[1] - gr.y;
                    try {
                        gr.transformation.inverseTransform(coordinates, 0, coordinates, 0, 1);
                    }
                    catch (Exception exception) {}
                    double[] origin = this.getHotSpotBodyCoordinates(target);
                    this.elementDirectTransformations(origin);
                    coordinates[0] = origin[0] != 0.0 ? coordinates[0] / origin[0] : gr.x;
                    coordinates[1] = origin[1] != 0.0 ? coordinates[1] / origin[1] : gr.y;
                    gr.setSize(coordinates);
                    break;
                }
                double[] coordinates = (double[])point.clone();
                this.groupInverseTransformations(coordinates);
                coordinates[0] = coordinates[0] - this.x;
                coordinates[1] = coordinates[1] - this.y;
                try {
                    this.transformation.inverseTransform(coordinates, 0, coordinates, 0, 1);
                }
                catch (Exception exception) {}
                double[] origin = this.getHotSpotBodyCoordinates(target);
                if (origin[0] != 0.0) {
                    coordinates[0] = coordinates[0] / origin[0];
                }
                if (origin[1] != 0.0) {
                    coordinates[1] = coordinates[1] / origin[1];
                }
                this.setSize(coordinates);
            }
        }
    }

    protected final void groupInverseTransformations(double[] vector) throws UnsupportedOperationException {
        ArrayList<Group> elList = new ArrayList<Group>();
        Element el = this.group;
        while (el != null) {
            elList.add((Group)el);
            el = el.group;
        }
        int k = elList.size() - 1;
        while (k >= 0) {
            el = (Element)elList.get(k);
            vector[0] = vector[0] - el.x;
            vector[1] = vector[1] - el.y;
            try {
                el.transformation.inverseTransform(vector, 0, vector, 0, 1);
            }
            catch (Exception exception) {}
            if (el.sizeX != 0.0) {
                vector[0] = vector[0] / el.sizeX;
            }
            if (el.sizeY != 0.0) {
                vector[1] = vector[1] / el.sizeY;
            }
            --k;
        }
    }

    protected final void elementDirectTransformations(double[] vector) {
        Element el = this;
        do {
            if (el.sizeX != 0.0) {
                vector[0] = vector[0] * el.sizeX;
            }
            if (el.sizeY != 0.0) {
                vector[1] = vector[1] * el.sizeY;
            }
            if (el.transformation != null) {
                el.transformation.transform(vector, 0, vector, 0, 1);
            }
            vector[0] = vector[0] + this.x;
            vector[1] = vector[1] + this.y;
        } while ((el = el.group) != null && el.group != null);
    }
}

