/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing.basic;

import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.drawing.basic.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group
extends Element
implements org.opensourcephysics.drawing.core.Group {
    private ArrayList<org.opensourcephysics.drawing.core.Element> elementList = new ArrayList();
    private ArrayList<org.opensourcephysics.drawing.core.Element> elementReversedList = new ArrayList();

    @Override
    public void addElement(org.opensourcephysics.drawing.core.Element element) {
        if (!(element instanceof Element)) {
            throw new UnsupportedOperationException("Can't add element to group (incorrect implementation)");
        }
        if (!this.elementList.contains(element)) {
            this.elementList.add(element);
            this.elementReversedList.add(0, element);
        }
        ((Element)element).setGroup(this);
    }

    public void addElements(Collection<org.opensourcephysics.drawing.core.Element> elements) {
        if (elements != null) {
            for (org.opensourcephysics.drawing.core.Element el : elements) {
                this.addElement(el);
            }
        }
    }

    @Override
    public void removeElement(org.opensourcephysics.drawing.core.Element element) {
        this.elementList.remove(element);
        this.elementReversedList.remove(element);
        ((Element)element).setGroup(null);
    }

    @Override
    public void removeAllElements() {
        for (org.opensourcephysics.drawing.core.Element element : this.elementList) {
            ((Element)element).setGroup(null);
        }
        this.elementList.clear();
        this.elementReversedList.clear();
    }

    @Override
    public synchronized List<org.opensourcephysics.drawing.core.Element> getElements() {
        return (List)this.elementList.clone();
    }

    private synchronized List<Element> getTheElements() {
        return (List)this.elementList.clone();
    }

    private synchronized List<Element> getReversedElements() {
        return (List)this.elementReversedList.clone();
    }

    @Override
    public org.opensourcephysics.drawing.core.Element getElement(int index) {
        try {
            return this.elementList.get(index);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public double[][] getData2D() {
        return null;
    }

    @Override
    public double[][][] getData3D() {
        return null;
    }

    @Override
    public ArrayList getDatasets() {
        ArrayList list = new ArrayList();
        for (Element el : this.getTheElements()) {
            if (!(el instanceof Data)) continue;
            list.addAll(((Data)((Object)el)).getDatasets());
        }
        return list;
    }

    @Override
    public ArrayList getComplexDatasets() {
        ArrayList list = new ArrayList();
        for (Element el : this.getTheElements()) {
            if (!(el instanceof Data)) continue;
            list.addAll(((Data)((Object)el)).getComplexDatasets());
        }
        return list;
    }

    @Override
    public boolean hasChanged() {
        if (super.hasChanged()) {
            return true;
        }
        for (Element el : this.getTheElements()) {
            if (!el.hasChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void draw(DrawingPanel _panel, Graphics _g) {
        for (Element el : this.getTheElements()) {
            el.draw(_panel, _g);
        }
    }

    @Override
    public void setNeedToProject(boolean _need) {
        for (Element el : this.getTheElements()) {
            el.setNeedToProject(_need);
        }
    }

    @Override
    public void getExtrema(double[] min, double[] max) {
        min[1] = Double.POSITIVE_INFINITY;
        min[0] = Double.POSITIVE_INFINITY;
        max[1] = Double.NEGATIVE_INFINITY;
        max[0] = Double.NEGATIVE_INFINITY;
        double[] elMin = new double[2];
        double[] elMax = new double[2];
        for (Element el : this.getTheElements()) {
            el.getExtrema(elMin, elMax);
            if (min[0] > elMin[0]) {
                min[0] = elMin[0];
            }
            if (max[0] < elMax[0]) {
                max[0] = elMax[0];
            }
            if (min[1] > elMin[1]) {
                min[1] = elMin[1];
            }
            if (!(max[1] < elMax[1])) continue;
            max[1] = elMax[1];
        }
    }

    @Override
    public Interactive findInteractive(DrawingPanel _panel, int _xpix, int _ypix) {
        if (!this.isReallyVisible()) {
            return null;
        }
        for (Element el : this.getReversedElements()) {
            Interactive target = el.findInteractive(_panel, _xpix, _ypix);
            if (target == null) continue;
            return target;
        }
        return null;
    }
}

