/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing.drawing2d;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.drawing.basic.Element;
import org.opensourcephysics.drawing.core.DrawingPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlottingPanel2D
extends PlottingPanel
implements DrawingPanel {
    public PlottingPanel2D(String xLabel, String yLabel, String title) {
        super(xLabel, yLabel, title);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public double[] projectPosition(double[] p, double[] pixel) {
        pixel[0] = super.xToPix(p[0]);
        pixel[1] = super.yToPix(p[1]);
        return pixel;
    }

    @Override
    public double[] projectSize(double[] p, double[] size, double[] pixelSize) {
        pixelSize[0] = this.xPixPerUnit * size[0];
        pixelSize[1] = this.yPixPerUnit * size[1];
        return pixelSize;
    }

    @Override
    public void addDrawable(Drawable drawable) {
        if (drawable instanceof Element) {
            ((Element)drawable).setPanel(this);
        }
        super.addDrawable(drawable);
    }

    @Override
    public void invalidateImage() {
        super.invalidateImage();
        for (Element el : this.getElements()) {
            el.setNeedToProject(true);
        }
    }

    @Override
    protected boolean isValidImage() {
        if (!super.isValidImage()) {
            return false;
        }
        for (Element el : this.getElements()) {
            if (!el.hasChanged()) continue;
            return false;
        }
        return true;
    }

    private List<Element> getElements() {
        ArrayList<Element> tempList = new ArrayList<Element>();
        for (Object drawable : super.getDrawables()) {
            if (!(drawable instanceof Element)) continue;
            tempList.add((Element)drawable);
        }
        return tempList;
    }
}

