/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.specialfunctions;

import java.util.ArrayList;
import org.opensourcephysics.numerics.Polynomial;

public class Hermite {
    static final ArrayList hermiteList;
    static final Polynomial twoX;

    static {
        twoX = new Polynomial(new double[]{0.0, 2.0});
        hermiteList = new ArrayList();
        Polynomial polynomial = new Polynomial(new double[]{1.0});
        hermiteList.add(polynomial);
        polynomial = new Polynomial(new double[]{0.0, 2.0});
        hermiteList.add(polynomial);
    }

    private Hermite() {
    }

    public static synchronized Polynomial getPolynomial(int n) {
        if (n < hermiteList.size()) {
            return (Polynomial)hermiteList.get(n);
        }
        Polynomial polynomial = Hermite.getPolynomial(n - 1).multiply(twoX);
        Polynomial polynomial2 = Hermite.getPolynomial(n - 2).multiply(2 * (n - 1));
        Polynomial polynomial3 = polynomial.subtract(polynomial2);
        hermiteList.add(polynomial3);
        return polynomial3;
    }

    public static double evaluate(int n, double d) {
        return Hermite.getPolynomial(n).evaluate(d);
    }
}

