/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ode;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.ode.ExplicitRKSolver;
import org.opensourcephysics.ode.ODEInterpolator;

public class Dopri5
extends ExplicitRKSolver
implements ODEInterpolator {
    static final double[][] a = new double[][]{{0.2}, {0.075, 0.225}, {0.9777777777777777, -3.7333333333333334, 3.5555555555555554}, {2.9525986892242035, -11.595793324188385, 9.822892851699436, -0.2908093278463649}, {2.8462752525252526, -10.757575757575758, 8.906422717743473, 0.2784090909090909, -0.2735313036020583}};
    static final double[] b = new double[]{0.09114583333333333, 0.0, 0.44923629829290207, 0.6510416666666666, -0.322376179245283, 0.13095238095238096};
    static final double[] er = new double[]{0.0012326388888888888, 0.0, -0.0042527702905061394, 0.03697916666666667, -0.05086379716981132, 0.0419047619047619, -0.025};
    static final double[] dense = new double[]{-1.1270175653862835, 0.0, 2.675424484351598, -5.685526961588504, 3.5219323679207912, -1.7672812570757455, 2.382468931778144};
    private double[][] coeffs;

    public Dopri5(ODE ode) {
        super(ode, a, b, 5, 6, 1);
        this.coeffs = new double[5][this.numEqn];
        this.initialize(this.stepSize);
    }

    protected double estimateError() {
        double truncErr = 0.0;
        double err = 0.0;
        double sk = 0.0;
        double atol = this.tolerance;
        double rtol = this.tolerance;
        this.ode.getRate(this.state, this.intermidiateStages[6]);
        int i = 0;
        while (i < this.numEqn) {
            sk = atol + rtol * Math.max(Math.abs(this.state[i]), Math.abs(this.initialState[i]));
            truncErr = 0.0;
            int s = 0;
            while (s < this.nStages + 1) {
                truncErr += er[s] * this.intermidiateStages[s][i];
                ++s;
            }
            err += Math.pow(truncErr / sk, 2.0);
            ++i;
        }
        err = Math.sqrt(err / (double)this.numEqn);
        return err;
    }

    public void doInterpolation(double remainder, double[] result) {
        if (!this.interpolationIsValid) {
            this.interpolationIsValid = true;
            int i = 0;
            while (i < this.numEqn) {
                this.coeffs[0][i] = this.initialState[i];
                this.coeffs[1][i] = this.state[i] - this.initialState[i];
                this.coeffs[2][i] = this.takenStepSize * this.intermidiateStages[0][i] - this.coeffs[1][i];
                this.coeffs[3][i] = this.coeffs[1][i] - this.takenStepSize * this.intermidiateStages[6][i] - this.coeffs[2][i];
                this.coeffs[4][i] = 0.0;
                int s = 0;
                while (s < 7) {
                    double[] dArray = this.coeffs[4];
                    int n = i;
                    dArray[n] = dArray[n] + this.takenStepSize * dense[s] * this.intermidiateStages[s][i];
                    ++s;
                }
                ++i;
            }
        }
        double theta = remainder / this.takenStepSize;
        double theta1 = 1.0 - theta;
        if (result != this.state) {
            int i = 0;
            while (i < this.numEqn) {
                result[i] = this.coeffs[0][i] + theta * (this.coeffs[1][i] + theta1 * (this.coeffs[2][i] + theta * (this.coeffs[3][i] + theta1 * this.coeffs[4][i])));
                ++i;
            }
        } else {
            System.err.println("Can't interpolate to the internal state vector. Please call initialize(double, double []) method");
        }
    }
}

