/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ode;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.ode.ExplicitRKSolver;
import org.opensourcephysics.ode.ODEInterpolator;

public class Dopri853
extends ExplicitRKSolver
implements ODEInterpolator {
    static final double[][] a = new double[][]{{0.05260015195876773}, {0.0197250569845379, 0.0591751709536137}, {0.02958758547680685, 0.0, 0.08876275643042054}, {0.2413651341592667, 0.0, -0.8845494793282861, 0.924834003261792}, {0.037037037037037035, 0.0, 0.0, 0.17082860872947386, 0.12546768756682242}, {0.037109375, 0.0, 0.0, 0.17025221101954405, 0.06021653898045596, -0.017578125}, {0.03709200011850479, 0.0, 0.0, 0.17038392571223998, 0.10726203044637328, -0.015319437748624402, 0.008273789163814023}, {0.6241109587160757, 0.0, 0.0, -3.3608926294469414, -0.868219346841726, 27.59209969944671, 20.154067550477894, -43.48988418106996}, {0.47766253643826434, 0.0, 0.0, -2.4881146199716677, -0.590290826836843, 21.230051448181193, 15.279233632882423, -33.28821096898486, -0.020331201708508627}, {-0.9371424300859873, 0.0, 0.0, 5.186372428844064, 1.0914373489967295, -8.149787010746927, -18.52006565999696, 22.739487099350505, 2.4936055526796523, -3.0467644718982196}, {2.273310147516538, 0.0, 0.0, -10.53449546673725, -2.0008720582248625, -17.9589318631188, 27.94888452941996, -2.8589982771350235, -8.87285693353063, 12.360567175794303, 0.6433927460157636}};
    static final double[] b = new double[]{0.054293734116568765, 0.0, 0.0, 0.0, 0.0, 4.450312892752409, 1.8915178993145003, -5.801203960010585, 0.3111643669578199, -0.1521609496625161, 0.20136540080403034, 0.04471061572777259};
    static final double[] er3 = new double[]{-0.18980075407240762, 0.0, 0.0, 0.0, 0.0, 4.450312892752409, 1.8915178993145003, -5.801203960010585, -0.42268232132379197, -0.1521609496625161, 0.20136540080403034, 0.022651792198360825};
    static final double[] er5 = new double[]{0.01312004499419488, 0.0, 0.0, 0.0, 0.0, -1.2251564463762044, -0.4957589496572502, 1.6643771824549864, -0.35032884874997366, 0.3341791187130175, 0.08192320648511571, -0.022355307863886294};
    static final double[][] aDense = new double[][]{{0.056167502283047954, 0.0, 0.0, 0.0, 0.0, 0.0, 0.25350021021662483, -0.2462390374708025, -0.12419142326381637, 0.15329179827876568, 0.00820105229563469, 0.007567897660545699, -0.008298}, {0.03183464816350214, 0.0, 0.0, 0.0, 0.0, 0.028300909672366776, 0.053541988307438566, -0.05492374857139099, 0.0, 0.0, -1.0834732869724932E-4, 3.825710908356584E-4, -3.4046500868740456E-4, 0.1413124436746325}, {-0.42889630158379194, 0.0, 0.0, 0.0, 0.0, -4.697621415361164, 7.683421196062599, 4.06898981839711, 0.3567271874552811, 0.0, 0.0, 0.0, -0.0013990241651590145, 2.9475147891527724, -9.15095847217987}};
    static final double[][] dense = new double[][]{{-8.428938276109013, 0.0, 0.0, 0.0, 0.0, 0.5667149535193777, -3.0689499459498917, 2.38466765651207, 2.117034582445028, -0.871391583777973, 2.2404374302607883, 0.6315787787694688, -0.08899033645133331, 18.148505520854727, -9.194632392478356, -4.436036387594894}, {10.427508642579134, 0.0, 0.0, 0.0, 0.0, 242.28349177525817, 165.20045171727028, -374.5467547226902, -22.113666853125306, 7.733432668472264, -30.674084731089398, -9.332130526430229, 15.697238121770845, -31.139403219565178, -9.35292435884448, 35.81684148639408}, {19.985053242002433, 0.0, 0.0, 0.0, 0.0, -387.0373087493518, -189.17813819516758, 527.8081592054236, -11.57390253995963, 6.8812326946963, -1.0006050966910838, 0.7777137798053443, -2.778205752353508, -60.19669523126412, 84.32040550667716, 11.99229113618279}, {-25.69393346270375, 0.0, 0.0, 0.0, 0.0, -154.18974869023643, -231.5293791760455, 357.6391179106141, 93.40532418362432, -37.45832313645163, 104.0996495089623, 29.8402934266605, -43.53345659001114, 96.32455395918828, -39.17726167561544, -149.72683625798564}};
    private double[][] coeffs;

    public Dopri853(ODE ode) {
        super(ode, a, b, 8, 12, 4);
        this.coeffs = new double[8][this.numEqn];
        this.initialize(this.stepSize);
    }

    protected double estimateError() {
        double truncErr = 0.0;
        double normErr3 = 0.0;
        double normErr5 = 0.0;
        double sk = 0.0;
        double atol = this.tolerance;
        double rtol = this.tolerance;
        double err = 0.0;
        int i = 0;
        while (i < this.numEqn) {
            sk = atol + rtol * Math.max(Math.abs(this.state[i]), Math.abs(this.initialState[i]));
            truncErr = 0.0;
            int s = 0;
            while (s < this.nStages) {
                truncErr += er3[s] * this.intermidiateStages[s][i];
                ++s;
            }
            normErr3 += Math.pow(truncErr / sk, 2.0);
            truncErr = 0.0;
            s = 0;
            while (s < this.nStages) {
                truncErr += er5[s] * this.intermidiateStages[s][i];
                ++s;
            }
            normErr5 += Math.pow(truncErr / sk, 2.0);
            ++i;
        }
        double deno = normErr5 + 0.01 * normErr3;
        if (deno <= 0.0) {
            deno = 1.0;
        }
        err = Math.abs(this.stepSize) * normErr5 * Math.sqrt(1.0 / ((double)this.numEqn * deno));
        return err;
    }

    public void doInterpolation(double remainder, double[] result) {
        if (!this.interpolationIsValid) {
            this.interpolationIsValid = true;
            double[] st = new double[this.numEqn];
            this.ode.getRate(this.state, this.intermidiateStages[12]);
            int s = 13;
            while (s < 16) {
                int i = 0;
                while (i < this.numEqn) {
                    st[i] = this.initialState[i];
                    int j = 0;
                    while (j < s) {
                        int n = i;
                        st[n] = st[n] + this.takenStepSize * aDense[s - 13][j] * this.intermidiateStages[j][i];
                        ++j;
                    }
                    ++i;
                }
                this.ode.getRate(st, this.intermidiateStages[s]);
                ++s;
            }
            int i = 0;
            while (i < this.numEqn) {
                this.coeffs[0][i] = this.initialState[i];
                this.coeffs[1][i] = this.state[i] - this.initialState[i];
                this.coeffs[2][i] = this.takenStepSize * this.intermidiateStages[0][i] - this.coeffs[1][i];
                this.coeffs[3][i] = this.coeffs[1][i] - this.takenStepSize * this.intermidiateStages[12][i] - this.coeffs[2][i];
                int k = 4;
                while (k < 8) {
                    this.coeffs[k][i] = 0.0;
                    int s2 = 0;
                    while (s2 < 16) {
                        double[] dArray = this.coeffs[k];
                        int n = i;
                        dArray[n] = dArray[n] + this.takenStepSize * dense[k - 4][s2] * this.intermidiateStages[s2][i];
                        ++s2;
                    }
                    ++k;
                }
                ++i;
            }
        }
        double theta = remainder / this.takenStepSize;
        double theta1 = 1.0 - theta;
        if (result != this.state) {
            int i = 0;
            while (i < this.numEqn) {
                result[i] = this.coeffs[0][i] + theta * (this.coeffs[1][i] + theta1 * (this.coeffs[2][i] + theta * (this.coeffs[3][i] + theta1 * (this.coeffs[4][i] + theta * (this.coeffs[5][i] + theta1 * (this.coeffs[6][i] + theta * this.coeffs[7][i]))))));
                ++i;
            }
        } else {
            System.err.println("Cann't interpolate to the internal state vector. Please call initialize(double, double []) method");
        }
    }
}

